/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

  	/* ------------------------------------------------------------
 	*        AUTO_CQ
 	*
 	*--------------------------------------------------------------*/

#include "autocq.h"
	
	void  auto_cq  (void){

	extern int use_rxvt;
	extern char mode[];
	extern char message[15][80];
	extern char ph_message[14][40];
	extern char buffer[];
	extern int cqdelay;
	extern int cqmode;
	extern int trxmode;
	extern char hiscall[];
	
	
	int inchar, i;
					
					if (trxmode != CWMODE) {		// Phone
						strcpy (mode,  "AUTO_CQ ");
    					clear_display();
						nodelay(stdscr,  TRUE);
				    	while (1){
							mvprintw(12, 29,"sleeping...  ");
							refresh();
							play_file(ph_message[11]);
							inchar = getch();
							if (inchar != ERR){
								if  (cqmode  == CQ )
 									strcpy (mode, "Log     ");
 								else
 									strcpy(mode , "S&P     ");

    							clear_display();

								if (use_rxvt == 0) attron(COLOR_PAIR(NORMCOLOR) | A_BOLD  );
								else     attron(COLOR_PAIR(NORMCOLOR)   );

								mvprintw(12, 29,"             ");
								printcall();
								nodelay(stdscr, FALSE);

								break;
							}

							sleep(cqdelay);

							inchar = getch();
							if (inchar != ERR){
								if  (cqmode  == CQ )
 									strcpy (mode, "Log     ");
 								else
 									strcpy(mode , "S&P     ");

    							clear_display();

								if (use_rxvt == 0) attron(COLOR_PAIR(NORMCOLOR) | A_BOLD  );
								else     attron(COLOR_PAIR(NORMCOLOR)   );

								mvprintw(12, 29,"             ");
								printcall();
								nodelay(stdscr, FALSE);
								break;
							}
						}

					}else {
						strcpy (mode,  "AUTO_CQ ");
    					clear_display();
						nodelay(stdscr,  TRUE);
				    	while (1){
				        	strcat(buffer, message[11]);
							sendbuf();
							mvprintw(12, 29 +  strlen(hiscall), "");
							inchar =  getch();
							if  (inchar  != ERR){
								mvprintw(12, 29,"             ");
								break;
							}
							if(use_rxvt == 0) attron(COLOR_PAIR(NORMCOLOR) | A_BOLD );
							else   attron(COLOR_PAIR(NORMCOLOR)  );

							mvprintw(12, 29," sleeping... ");
							refresh();
							sleep(1);
							printcall();
							inchar =  getch();
							if  (inchar  != ERR){
								mvprintw(12, 29,"             ");
								break;
							}
							sleep(cqdelay);
							inchar =  getch();
							if  (inchar  != ERR){
								mvprintw(12, 29,"             ");
								break;
							}
							mvprintw(12, 29,  "            ");
							mvprintw(12,29,  "");
							refresh();
						}
						if  (cqmode  == CQ )
 							strcpy (mode, "Log     ");
 						else
 							strcpy(mode , "S&P     ");

    					clear_display();

						if (use_rxvt == 0) attron(COLOR_PAIR(NORMCOLOR) | A_BOLD  );
						else     attron(COLOR_PAIR(NORMCOLOR)   );

						mvprintw(12, 29,"             ");
						printcall();
						nodelay(stdscr, FALSE);
					}
	}
