#!/bin/sh

set -e

DESTDIR=${DESTDIR:-../tarballs}
MODULE=CGI-Application-Plugin-Authentication
PACKAGE=libcgi-application-plugin-authentication-perl
VERSION=0.21
DBIC_VERS=0.02
CDBI_VERS=0.03
FD=--force-download
NS=--no-symlink
RE=--rename
DD="--destdir ${DESTDIR}"
RS=--report-status
DC=-"-watch debian/components"
US=--upstream-version

if [ $1 ]
then
    echo update;
    rm -f ${DESTDIR}/${MODULE}*.tar.gz
    uscan ${FD} ${RE} ${DD} && true;
    uscan ${DC}/driver-dbic/watch ${FD} ${NS} ${DD} ${US} ${DBIC_VERS} && true;
    uscan ${DC}/driver-cdbi/watch ${FD} ${NS} ${DD} ${US} ${CDBI_VERS} && true;
    cd ${DESTDIR}
    DBIC=`ls ${MODULE}-Driver-DBIC*.tar.gz`
    mv ${DBIC} ${PACKAGE}_${VERSION}.orig-driver-dbic.tar.gz
    CDBI=`ls ${MODULE}-Driver-CDBI*.tar.gz`
    mv ${CDBI} ${PACKAGE}_${VERSION}.orig-driver-cdbi.tar.gz
    cd -
else
    echo report;
    uscan ${RS} && true;
    uscan ${DC}/driver-dbic/watch ${RS} ${DD} ${US} ${DBIC_VERS} && true;
    uscan ${DC}/driver-cdbi/watch ${RS} ${DD} ${US} ${CDBI_VERS} && true;
fi
