package aQute.bnd.plugin.popup.actions.repo;

import java.util.*;
import java.util.jar.*;

import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

import aQute.bnd.service.*;
import aQute.lib.osgi.*;

public class RepoDialog extends Dialog {
    private Text                             bsn;
    private Text                             version;
    private Label                            lblRepository;
    private Combo                            repositories;
    private Jar                              jar;
    private java.util.List<RepositoryPlugin> repos;
    private Button                           wrap;

    /**
     * Create the dialog.
     * 
     * @param parentShell
     */
    public RepoDialog(Shell parentShell, Jar jar,
            java.util.List<RepositoryPlugin> repos) {
        super(parentShell);
        setShellStyle(SWT.DIALOG_TRIM);
        this.jar = jar;
        this.repos = repos;
    }

    /**
     * Create contents of the dialog.
     * 
     * @param parent
     */
    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite) super.createDialogArea(parent);
        container.setLayout(null);
        {
            lblRepository = new Label(container, SWT.NONE);
            lblRepository.setBounds(8, 8, 160, 24);
            lblRepository.setText("Repository");
        }
        {
            repositories = new Combo(container, SWT.READ_ONLY);
            repositories.setBounds(168, 3, 272, 30);
        }
        {
            bsn = new Text(container, SWT.BORDER);
            bsn.setBounds(168, 35, 272, 28);
        }
        {
            version = new Text(container, SWT.BORDER);
            version.setBounds(168, 67, 272, 28);
        }
        {
            Label lblBundleSymbolicName = new Label(container, SWT.NONE);
            lblBundleSymbolicName.setBounds(8, 40, 160, 24);
            lblBundleSymbolicName.setText("Bundle Symbolic Name");
        }
        {
            Label lblVersion = new Label(container, SWT.NONE);
            lblVersion.setBounds(8, 72, 160, 24);
            lblVersion.setText("Bundle Version");
        }

        {
            wrap = new Button(container, SWT.NONE);
            wrap.setBounds(338, 105, 102, 28);
            wrap.setText("Wrap");
        }
        
        setup();
        return container;
    }

    private void setup() {
        try {
            String bsn = null;
            String version = null;

            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                bsn = jar.getManifest().getMainAttributes().getValue(
                        Constants.BUNDLE_SYMBOLICNAME);
                if (bsn != null)
                    this.bsn.setText(bsn);
                version = jar.getManifest().getMainAttributes().getValue(
                        Constants.BUNDLE_VERSION);
                if (version != null)
                    this.version.setText(version);

            }

            for (Iterator<RepositoryPlugin> i = repos.iterator(); i.hasNext();) {
                RepositoryPlugin plugin = i.next();
                if (plugin.canWrite())
                    repositories.add(plugin.getName());
                else
                    i.remove();

            }
            repositories.select(0);
            
            wrap.setEnabled(bsn != null );
            this.bsn.setEnabled(bsn !=null);
            this.version.setEnabled(bsn !=null);
                
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Create contents of the button bar.
     * 
     * @param parent
     */
    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
                true);
        createButton(parent, IDialogConstants.CANCEL_ID,
                IDialogConstants.CANCEL_LABEL, false);
    }

    /**
     * Return the initial size of the dialog.
     */
    @Override
    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public RepositoryPlugin getRepository() {
        int n = repositories.getSelectionIndex();

        return repos.get(n);
    }
}
