#!/bin/sh

set -e

man -u "please let there never be a man page with this name" > /dev/null 2>&1 \
    || true

echo <<EOF
<!-- File automatically generated by $0

        Debian Manual Page DocBook Reference Entities

     Use &man.<name>.<section>; to refer to these.  Should be valid in
     SGML or XML.

     This file is normally generated by the sgml-data postinst but you can
     re-run it at any time.
  -->
EOF

# take all man pages, the part before the dash, ignore any lines not
# starting with a letter and constituted of a word, space(s), and a
# word in parens

# FIXME: use the actual SGML/XML character limits
# FIXME: do it all in sed

whatis -w '*' |                  \
  sed -e 's/-.*$//; s/\[.*//;' | \
  grep '^[a-zA-Z0-9:]* ([a-zA-Z0-9:]\+)' | \
  sed -e 's/^\([^( ]*\) (\(.*\)).*$/<!ENTITY man.\1.\2 "<citerefentry><refentrytitle>\1<\/refentrytitle><manvolnum>\2<\/manvolnum><\/citerefentry>">/;'


