.TH GROFFER @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groffer \- display groff files and man\~pages on X and tty
.
.SH "SYNOPSIS"
.\" The .SH was moved to this place in order to appease `apropos'.
.
.\" --------------------------------------------------------------------
.\" Legalize
.\" --------------------------------------------------------------------
.
.ig
groffer.1 - man page for groffer (section 1).

Source file position:  <groff_source_top>/contrib/groffer/groffer.man
Installed position:    $prefix/share/man/man1/groffer.1

Version     : groffer 0.9.7
Last update : 03 May 2004

Source file position: <groff-source>/contrib/groffer/groffer.man

Copyright (C) 2001,2002,2004 Free Software Foundation, Inc.
Written by Bernd Warken

This file is part of groff version @VERSION@.

groff is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

groff is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
License for more details.

You should have received a copy of the GNU General Public License
along with groff; see the files COPYING and LICENSE in the top
directory of the groff source.  If not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
..
.
.\" --------------------------------------------------------------------
.\" Setup
.\" --------------------------------------------------------------------
.
.mso www.tmac
.
.if n \{\
.  mso tty-char.tmac
.  ftr CR R
.  ftr CI I
.  ftr CB B
.\}
.
.if '\*[.T]'dvi' \{\
.  ftr CB CW
.\}
.
.ds @- "\-\""
.ds @-- "\-\^\-\""
.
.ds @b- "\f[CB]-\f[]\""
.ds @b-- "\f[CB]--\f[]\""
.
.ds @i- "\f[CI]-\f[]\""
.ds @i-- "\f[CI]--\f[]\""
.
.ds Ellipsis ".\|.\|.\""
.
.\" --------------------------------------------------------------------
.\" setup for the macro definitions below
.\"
.\" naming:  namespace:cathegory_macro.variable_name  (experimental)
.
.\" --------------------------------------------------------------------
.\" configuration of prompt for `.Shell_cmd'* macros
.ds groffer:Shell_cmd.prompt_text sh#\"    prompt for shell commands
.ds groffer:Shell_cmd+.prompt_text >\"     prompt on continuation lines
.ds groffer:Shell_cmd_base.prompt_font I\" font for prompts
.
.\" automatically determine setup from the configuration above
.als @f groffer:Shell_cmd_base.prompt_font\"
.als @t groffer:Shell_cmd.prompt_text\"
.als @t+ groffer:Shell_cmd+.prompt_text\"
.ds groffer:Shell_cmd.prompt \f[\*[@f]]\*[@t]\f[]\"            needed
.ds groffer:Shell_cmd+.prompt \f[\*[@f]]\*[@t+]\f[]\"          needed
.nr @w \w'\*[groffer:Shell_cmd.prompt]'\"
.nr @w+ \w'\*[groffer:Shell_cmd+.prompt]'\"
.ft \*[@f]
.\" Full prompt width is maximum of texts plus 1m
.nr groffer:Shell_cmd_base.prompt_width (\n[@w]>?\n[@w+]+1m)\" needed
.ft
.rm @f
.rm @f+
.rm @t
.rm @t+
.rr @w
.rr @w+
.
.\" --------------------------------------------------------------------
.\" static register for inter-macro communication in `.Synopsis'*
.nr groffer:Synopsis.level 0
.
.\" --------------------------------------------------------------------
.\" static registers for inter-macro communication in `.TP'*
.nr groffer:TP.level 0
.rr groffer:TP_header.flag
.rr groffer:TP_body.flag
.rr groffer:TP.indent
.
.
.\" --------------------------------------------------------------------
.\" Macro definitions
.
.\" Ignore all arguments like a comment, even after a .eo call.
.de c
..
.c --------------------------------------------------------------------
.c .CB  (<text>...)
.c
.c Print in constant-width bold font.
.c
.de CB
.  ft CB
.  Text \\$*
.  ft
..
.c --------------------------------------------------------------------
.c .CI  (<text>...)
.c
.c Print in constant-width italic font.
.c
.de CI
.  ft CI
.  Text \\$*
.  ft
..
.c --------------------------------------------------------------------
.c .CR  (<text>...)
.c
.c Print in constant-width roman font.
.c
.de CR
.  ft CR
.  Text \\$*
.  ft
..
.c --------------------------------------------------------------------
.c .Error  (<text>...)
.c
.c Print error message to terminal and abort.
.c
.de Error
.  tm \\$*
.  ab
..
.c --------------------------------------------------------------------
.c .Env_var  (<env_var_name> [<punct>])
.c
.c Display an environment variable, with optional punctuation.
.c
.de Env_var
.  nh
.  SM
.  Text \f[CB]\\$1\f[]\\$2
.  hy
..
.c --------------------------------------------------------------------
.c .File_name  (<path_name>)
.c
.c Display a file or directory name in CB font.
.c
.de File_name
.  Header_CB \\$@
..
.c --------------------------------------------------------------------
.c .Header_CB  (<path_name>)
.c
.c Display a line in CB font, for example after .TP
.c
.de Header_CB
.  nh
.  Text \f[CB]\\$1\f[]\\$2
.  hy
..
.c --------------------------------------------------------------------
.c .Opt_-  ([<punct>])
.c
.c Print `-' (minus sign); optional punctuation. 
.c
.de Opt_-
.  ie (\\n[.$] == 0) \
.    Opt_alt - ""
.  el \
.    Opt_alt - "" "\\$1"
..
.c --------------------------------------------------------------------
.c .Opt_[-]  ([<punct>])
.c
.c Print `Opt_[-]' (minus sign in brackets); optional punctuation. 
.c
.de Opt_[-]
.  ie (\\n[.$] == 0) \
.    Opt_[alt] - ""
.  el \
.    Opt_[alt] - "" "\\$1"
..
.c --------------------------------------------------------------------
.c .Opt_--  ([<punct>])
.c
.c Print `--' (double minus); optional punctuation. 
.c
.de Opt_--
.  ie (\\n[.$] == 0) \
.    Opt_alt -- ""
.  el \
.    Opt_alt -- "" "\\$1"
..
.c --------------------------------------------------------------------
.c .Opt_[--]  ([<punct>])
.c
.c Print `Opt_[--]' (double minus in brackets); optional punctuation. 
.c
.de Opt_[--]
.  ie (\\n[.$] == 0) \
.    Opt_[alt] -- ""
.  el \
.    Opt_[alt] -- "" "\\$1"
..
.c --------------------------------------------------------------------
.c .Opt_alt  ([<minus> <opt>]... [<arg> [<punct>]])
.c
.c Alternate options separated by a vertical bar.
.c
.c Arguments:
.c   minus: either `-' or `--' (font CB).
.c   opt: a name for an option, empty allowed (font CB).
.c   arg: optionally, the argument to the option (font I).
.c   punct: optional punctuation (in the starting font).
.c Result:
.c   The minus/opt argument pairs, each
.c   separated by a vertical bar `|', optionally add 'arg', separated
.c   a space character ` '.
.c
.c Example:
.c  .Opt_alt - T -- device -- device-troff device .
.c  results in
.c  -T|--device|--device-troff device.
.c
.de Opt_alt
.  Opt_alt_base "" | "" \\$@
..
.c --------------------------------------------------------------------
.c .Opt_[alt]  ([<minus> <opt>]... [<arg> [<punct>]])
.c
.c Alternate options in brackets for section SYNOPSIS.
.c
.c Arguments:
.c   minus: either `-' or `--' (font CB).
.c   opt: a name for an option, empty allowed (font CB).
.c   arg: optionally, the argument to the option (font I).
.c   punct: optional punctuation (in the starting font).
.c Global strings written to:
.c   `@oa_prefix': left enclosing character (`[')
.c   `@oa_sep': separator (`|')
.c   `@oa_postfix': right enclosing character (`]')
.c Result:
.c   The minus/opt argument pairs, each separated by a vertical
.c   bar `|', optionally add 'arg', separated by a space character ` '.
.c
.c Example:
.c  .Opt_[alt] - T -- device -- device-troff device .
.c  results in
.c  [-T|--device|--device-troff device].
.c
.de Opt_[alt]
.  Opt_alt_base [ | ] \\$@
..
.c --------------------------------------------------------------------
.c .Opt_alt_base  (<pre> <sep> <post> [<minus> <opt>]... [arg [punct]])
.c
.c Alternating options; base macro for many others; do not use directly.
.c
.c Arguments:
.c   <pre>: prefix, resulted is preceded by this.
.c   <sep>: separator between minus/opt pairs.
.c   <post>: postfix, is appended to the result.
.c   <minus>: either `-' or `--' (font CB).
.c   <opt>: a name for an option, empty allowed (font CB).
.c   <arg>: optionally, the argument to the option (font I).
.c   <punct>: optional punctuation (in the starting font).
.c Result:
.c   String `<pre>' followed by the <minus>/<opt> argument pairs, each
.c   separated by string `<sep>', optionally add '<arg>', separated by
.c   a single space ` ', followed by the string `<post>'.
.c
.de Opt_alt_base
.  nr @font \\n[.f]\"
.  if (\\n[.$] < 3) \
.    Error .\\0: not enough arguments.
.  ds @pre \)\\$1\)\"                   prefix
.  ds @sep \)\\$2\)\"                   separator
.  ds @post \)\\$3\)\"                  postfix
.  shift 3
.  nr @count 0
.  ds @res \f[CR]\\*[@pre]\"
.  while (\\n[.$] >= 2) \{\
.    c                                  do the pairs, break on no `-'
.    if !'\\$1'-' \{\
.      if !'\\$1'--' \
.        break
.    \}
.    c                                  separator
.    if (\\n[@count] > 0) \
.      as @res \f[CR]\\*[@sep]\"
.    nr @count +1
.    as @res \f[CB]\\$1\\$2\:\"         combine minus with option name
.    shift 2
.  \}
.  if (\\n[.$] >= 3) \
.    Error .\\0: wrong arguments: \\$@
.  c                                    all pairs are done
.  ie (\\n[.$] == 0) \
.    as @res \f[CR]\\*[@post]\"
.  el \{\
.    c                                  optional option argument
.    if !'\\$1'' \
.      as @res \f[CR] \,\f[I]\\$1\"
.    shift
.    c                                  postfix
.    as @res \\f[CR]\\*[@post]\"
.    if (\\n[.$] >= 1) \{\
.      c                                add punctuation
.      as @res \f[\\n[@font]]\\$1\"
.    \}
.  \}
.  nh
.  Text \\*[@res]
.  hy
.  ft \\n[@font]
.  rr @count
.  rr @font
.  rm @pre
.  rm @post
.  rm @sep
.  rm @res
..
.c --------------------------------------------------------------------
.c .Opt_def  ([<minus> <opt>]... [<arg> [<punct>]])
.c
.c Definitions of options in section OPTIONS.
.c
.c Arguments:
.c   minus: either `-' or `--' (font CB).
.c   opt: a name for an option, empty allowed (font CB).
.c   arg: optionally, the argument to the option (font I).
.c   punct: optional punctuation (in the starting font).
.c Result:
.c   The header for an indented paragraph, consisting of
.c   minus/opt argument pairs, each, separated by a space
.c   character ` ', optionally add 'arg', separated a space
.c   character ` '.
.c
.c Example:
.c  .Opt_def - T -- device -- device-troff device .
.c  results in
.c  -T --device --device-troff device.
.c  as the header of for indented paragraph.
.c
.de Opt_def
.  TP
.    Opt_alt_base "" "\~|\~" "" \\$@
..
.c --------------------------------------------------------------------
.c .Opt_element  ([<minus> <opt>]... [<arg> [<punct>]])
.c
.c Definitions of options in section OPTIONS.
.c
.c Arguments:
.c   minus: either `-' or `--' (font CB).
.c   opt: a name for an option, empty allowed (font CB).
.c   arg: optionally, the argument to the option (font I).
.c   punct: optional punctuation (in the starting font).
.c Result:
.c   The minus/opt argument pairs, each, separated by a space
.c   character ` ', optionally add 'arg', separated a space
.c   character ` '.
.c
.c Example:
.c  .Opt_element - T -- device -- device-troff device .
.c  results in
.c  -T --device --device-troff device.
.c
.de Opt_element
.  Opt_alt_base "" "\~" "" \\$@
..
.c --------------------------------------------------------------------
.als Opt_list Opt_element
.
.c --------------------------------------------------------------------
.c .Opt_long  ([<name> [<punct>]])
.c
.c Print `--name' somewhere in the text; optional punctuation.
.c
.de Opt_long
.  Opt_alt -- "\\$1" "" "\\$2"
..
.c --------------------------------------------------------------------
.c .Opt_long_arg  ([<name> <arg> [<punct>]])
.c
.c Print `--name=arg' somewhere in the text; optional punctuation.
.c
.de Opt_long_arg
.  Opt_alt -- "\\$1=\\$2" "" "\\$3"
..
.c --------------------------------------------------------------------
.c .Opt_[long]  ([<name> [<punct>]])
.c
.c Print `--name' somewhere in the text; optional punctuation.
.c
.de Opt_[long]
.  Opt_[alt] -- "\\$1" "" "\\$2"
..
.c --------------------------------------------------------------------
.c .Opt_short  ([<name> [<punct>]])
.c
.c Print `-name' somewhere in the Text; optional punctuation.
.c
.de Opt_short
.  Opt_alt - "\\$1" "" "\\$2"
..
.c --------------------------------------------------------------------
.c .Opt_[short]  ([name [punct]])
.c
.c Print `[-name]' somewhere in the Text; optional punctuation.
.c
.de Opt_[short]
.  Opt_[alt] - "\\$1" "" "\\$2"
..
.c --------------------------------------------------------------------
.c .Shell_cmd  (<CR> [<CI>] ...)
.c
.c A shell command line; display args alternating in fonts CR and CI.
.c
.c Examples:
.c   .Shell_cmd "groffer --dpi 100 file"
.c     result: `sh#  groffer --dpi 100 file'
.c             with 'sh#' in font I, the rest in CR
.c
.c   .Shell_cmd groffer\~--dpi\~100\~file
.c     result: the same as above
.c
.c   .Shell_cmd "groffer --dpi=" value " file"
.c     result: sh#  groffer --dpi=value file
.c             with `groffer --dpi=' and `file' in CR; `value' in CI
.c
.c   .Shell_cmd groffer\~--dpi= value \~file
.c     result: the same as the previous example
.c
.de Shell_cmd
.  groffer:Shell_cmd_base "\*[groffer:Shell_cmd.prompt]" \\$@
..
.c --------------------------------------------------------------------
.c .Shell_cmd+  (<CR> [<CI>] ...)
.c
.c A continuation line for .Shell_cmd.
.c
.de Shell_cmd+
.  groffer:Shell_cmd_base "\*[groffer:Shell_cmd+.prompt]" \\$@
..
.c --------------------------------------------------------------------
.c .Shell_cmd_base  (<prompt> [<CR> [<CI>] ...])
.c
.c A shell command line; display args alternating in fonts CR and CI.
.c Internal, do not use directly.
.c
.c Globals: read-only register @.Shell_cmd_width
.c
.de groffer:Shell_cmd_base
.  if (\\n[.$] <= 0) \
.    return
.  nr @+font \\n[.f]\"
.  ds @prompt \\$1\"
.  ft CR
.  c gap between prompt and command
.  nr @+gap \\n[groffer:Shell_cmd_base.prompt_width]-\\w'\\*[@prompt]'\"
.  ds @res \\*[@prompt]\h'\\n[@+gap]u'\"
.  shift
.  ds @cf CR\"
.  while (\\n[.$] > 0) \{\
.    as @res \\f[\\*[@cf]]\\$1\"
.    shift
.    ie '\\*[@cf]'CR' \
.      ds @cf I\"
.    el \
.      ds @cf CR\"
.  \}
.  br
.  ad l
.  nh
.  nf
.  Text \\*[@res]\"
.  fi
.  hy
.  ad
.  br
.  ft \\n[@+font]
.  rr @+font
.  rr @+gap
.  rm @cf
.  rm @res
..
.c --------------------------------------------------------------------
.c .Synopsis  ()
.c
.c Begin a synopsis section, to be ended by a ./Synopsis macro.
.c
.de Synopsis
.  if (\\n[groffer:Synopsis.level] > 0) \
.    Error .\\$0: previous .Synopsis was not closed by ./Synopsis.
.  nh
.  ds @1 \\$1\"
.  nr @old_indent \\n(.i
.  ad l
.  in +\w'\fB\\*[@1]\0'u
.  ti \\n[@old_indent]u
.  B \\*[@1]\0\c
.  rr @old_indent
.  rm @1
.  nr groffer:Synopsis.level +1\"        marker for ./Synopsis
..
.c  --------------------------------------------------------------------
.c ./Synopsis  ()
.c
.c Close a synopsis section opened by the previous .Synopsis macro.
.c
.de /Synopsis
.  if (\\n[groffer:Synopsis.level] <= 0) \
.    Error .\\$0: no previous call of .Synopsis
.  br
.  ad
.  in
.  hy
.  nr groffer:Synopsis.level -1
..
.c  --------------------------------------------------------------------
.c .Text  (<text>...)
.c
.c Treat the arguments as text, no matter how they look.
.c
.de Text
.  if (\\n[.$] == 0) \
.    return
.  nop \)\\$*\)
..
.c --------------------------------------------------------------------
.c .Topic  ([<indent>])
.c
.c A bulleted paragraph
.c
.de Topic
.  ie (\\n[.$] = 0) \
.    ds @indent 2m\"
.  el \
.    ds @indent \\$1\"
.  TP \\*[@indent]
.  Text \[bu]
.  rm @indent
..
.c --------------------------------------------------------------------
.c .TP+  ()
.c
.c Continuation line for .TP header.
.c
.de TP+
.  br
.  ns
.  TP \\$1
..
.c --------------------------------------------------------------------
.c .TP_header  ([<indent>])
.c
.c Start a multi-line header for a .TP-like paragraph
.c
.de TP_header
.  if (\\n[groffer:TP.level] < 0) \
.    Error .\\$0: wrong level.
.  nr groffer:TP.level +1
.  P
.  ie (\\n[.$] == 0) \
.    rr groffer:TP.indent
.  el \
.    nr groffer:TP.indent \\$1
.  nr groffer:TP_header.flag 1
..
.c --------------------------------------------------------------------
.c .TP_body  ([<indent>])
.c
.c End a previous .TP-header and beging the body of the paragraph.
.c
.de TP_body
.  if !rgroffer:TP_header.flag \
.    Error .\\$0: no previous call of .TP_header
.  if (\\n[groffer:TP.level] <= 0) \
.    Error .\\$0: wrong level.
.  br
.  ie (\\n[.$] == 0) \{\
.    ie rgroffer:TP.indent \{\
.      RS \\n[groffer:TP.indent]u
.    \}
.    el \
.      RS
.  \}
.  el \
.    RS \\$1u
.  rr groffer:TP.indent
.  rr groffer:TP_header.flag
.  nr groffer:TP_body.flag 1
..
.c --------------------------------------------------------------------
.c TP_end  ()
.c
.c End of former .TP_body paragraph.
.c
.de TP_end
.  if !rgroffer:TP_body.flag \
.    Error .\\$0: no previous .TP_body.
.  if (\\n[groffer:TP.level] <= 0) \
.    Error TP_end: wrong level.
.  nr groffer:TP.level -1
.  rr grogger:TP.indent
.  rr groffer:TP_header.flag
.  rr groffer:TP_body.flag
.  br
.  RE
..
.
.\" End of macro definitions
.
.
.\" --------------------------------------------------------------------
.\" SH "SYNOPSIS"
.\" --------------------------------------------------------------------
.
.ad l
.Synopsis groffer
.RI [ option...\& ]
.Opt_[--]
.RI [ "filespec" "\*[Ellipsis]]"
./Synopsis
.
.Synopsis groffer
.Opt_alt -- apropos -- apropos-data -- apropos-devel -- apropos-progs name
./Synopsis
.
.Synopsis groffer
.Opt_alt - h -- help
./Synopsis
.
.Synopsis groffer
.Opt_alt - v -- version
./Synopsis
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
The
.I groffer
program is the easiest way to use
.BR groff (@MAN1EXT@).
It can display arbitrary documents written in the
.BR groff (@MAN7EXT@)
language or other
.BR roff (@MAN7EXT@)
languages that are compatible to the original troff language.
.
The
.I groffer
program also includes many of the features for finding and displaying
the UNIX manual pages
.RI ( man\~pages ),
such that it can be used as a replacement for a
.BR man (1)
program.
.
Moreover, compressed files that can be handled by
.BR gzip (1)
or
.BR bzip2 (1)
are decompressed on-the-fly.
.
.
.P
The normal usage is quite simple by supplying a file name or name of a
man\~page without further options.
.
But the option handling has many possibilities for creating special
behaviors.
.
This can be done in configuration files, with the shell environment
variable
.BR $GROFFER_OPT ,
or on the command line.
.
.
.P
The output can be generated and viewed in several different ways
available for
.IR groff .
.
This includes the groff native X viewer
.BR gxditview (@MAN1EXT@),
each Postcript or dvi display program, a web browser by generating
html in www-mode, or several text modes in text terminals.
.
.
.P
Most of the options that must be named when running
.I groff
directly are determined automatically for
.IR groffer ,
due to the internal usage of the
.BR grog (@MAN1EXT@)
program.
.
But all parts can also be controlled manually by arguments.
.
.
.P
Several file names can be specified on the command line arguments.
.
They are transformed into a single document in the normal way of
.IR groff .
.
.
.\" --------------------------------------------------------------------
.SH "OPTION OVERVIEW"
.\" --------------------------------------------------------------------
.
.TP
.I breaking options
.RS
.P
.Opt_[alt] -- apropos name
.Opt_[alt] -- apropos-data name
.Opt_[alt] -- apropos-devel name
.Opt_[alt] -- apropos-progs name
.Opt_[alt] - h -- help
.Opt_[alt] - v -- version
.RE
.
.
.TP
.I groffer mode options
.RS
.P
.Opt_[alt] -- auto
.Opt_[alt] -- default
.Opt_[alt] -- default-modes mode1,mode2,\*[Ellipsis]
.Opt_[alt] -- dvi
.Opt_[alt] -- dvi-viewer prog
.Opt_[alt] -- groff
.Opt_[alt] -- html
.Opt_[alt] -- html-viewer prog
.Opt_[alt] -- man
.Opt_[alt] -- mode display_mode
.Opt_[alt] -- no-man
.Opt_[alt] -- pdf
.Opt_[alt] -- pdf-viewer prog
.Opt_[alt] -- ps
.Opt_[alt] -- ps-viewer prog
.Opt_[alt] -- text
.Opt_[alt] -- tty
.Opt_[alt] -- tty-viewer prog
.Opt_[alt] -- www
.Opt_[alt] -- www-viewer prog
.Opt_[alt] -- x -- X
.Opt_[alt] -- x-viewer -- X-viewer prog
.RE
.
.
.TP
.I development options
.RS
.P
.Opt_[alt] -- debug
.Opt_[alt] -- shell
.RE
.
.
.TP
.I options related to groff
.RS
.P
.Opt_[alt] - P -- postproc-arg opt_or_arg
.Opt_[alt] - Q -- source
.Opt_[alt] - T -- device device
.Opt_[alt] - Z -- intermediate-output -- ditroff
.P
All further
.I groff
short options are accepted.
.RE
.
.
.TP
.I X Window toolkit options
.RS
.P
.Opt_[alt] -- bd pixels
.Opt_[alt] -- bg -- background color
.Opt_[alt] -- bw pixels
.Opt_[alt] -- display X-display
.Opt_[alt] -- fg -- foreground color
.Opt_[alt] -- ft -- font font_name
.Opt_[alt] -- geometry size_pos
.Opt_[alt] -- resolution value
.Opt_[alt] -- rv
.Opt_[alt] -- title string
.Opt_[alt] -- xrm X_resource
.RE
.
.
.TP
.I options from man
.RS
.P
.Opt_[alt] -- all
.Opt_[alt] -- ascii
.Opt_[alt] -- ditroff
.Opt_[alt] -- extension suffix
.Opt_[alt] -- locale language
.Opt_[alt] -- local-file
.Opt_[alt] -- manpath dir1:dir2:\*[Ellipsis]
.Opt_[alt] -- pager program
.Opt_[alt] -- sections sec1:sec2:\*[Ellipsis]
.Opt_[alt] -- systems sys1,sys2,\*[Ellipsis]
.Opt_[alt] -- troff-device device
.Opt_[alt] -- whatis
.P
Further long options of GNU
.I man
are accepted as well.
.RE
.
.
.TP
.I filespec argument
.RS
.P
No
.I filespec
parameters means standard input.
.
.
.TP 10m
.Opt_short ""
stands for standard input (can occur several times).
.
.
.TP
.I filename
the path name of an existing file.
.
.
.TP
.BI man: name ( section )
.TP+
.IB name ( section )
search the man\~page
.I name
in man\~section\~\c
.IR section .
.
.
.TP
.BI man: name . s
.TP+
.IB name . s
if
.I s
is a character in
.BR [1-9on] ,
search for a man\~page
.I name
in man\~section
.IR s .
.
.
.TP
.BI man: name
man\~page in the lowest man\~section that has
.IR name .
.
.
.TP
.I "s name"
if
.I s
is a character in
.BR [1-9on] ,
search for a man\~page
.I name
in man\~section
.IR s .
.
.
.TP
.I name
if 
.I name
is not an existing file search for the man\~page
.I name
in the lowest man\~section.
.
.RE
.
.
.\" --------------------------------------------------------------------
.SH "OPTION DETAILS"
.\" --------------------------------------------------------------------
.
The
.I groffer
program can usually be run with very few options.
.
But for special purposes, it supports many options.
.
These can be classified in 5 option classes.
.
.
.P
All short options of
.I groffer
are compatible with the short options of
.BR groff (@MAN1EXT@).
.
All long options of
.I groffer
are compatible with the long options of
.BR man (1).
.
.
.\" --------------------------------------------------------------------
.SS "groffer breaking Options"
.\" --------------------------------------------------------------------
.
As soon as one of these options is found on the command line it is
executed, printed to standard output, and the running
.I groffer
is terminated thereafter.
.
All other arguments are ignored.
.
.
.Opt_def -- apropos name
Start the
.BR apropos (1)
command for searching within man page
descriptions.
.
That slightly differs from the strange behavior of the
.Opt_long apropos
program of
.BR man (1),
which has no argument of its own, but takes the file arguments
instead.
.
Practically both concepts are compatible.
.
.
.Opt_def -- apropos-data name
Show only the
.BR apropos (1)
descriptions for data documents, in the
.BR man (7)
sections 4, 5, and 7.
.
.
.Opt_def -- apropos-devel name
Show only the
.BR apropos (1)
descriptions for development documents, in the
.BR man (7)
sections 2, 3, and 9.
.
.
.Opt_def -- apropos-progs name
Show only the
.BR apropos (1)
descriptions for documents on programs, in the
.BR man (7)
sections 1, 6, and 8.
.
.
.Opt_def - h -- help
Print a helping information with a short explanation of option sto
standard output.
.
.
.Opt_def - v -- version
Print version information to standard output.
.
.
.\" --------------------------------------------------------------------
.SS "groffer Mode Options"
.\" --------------------------------------------------------------------
.
The display mode and the viewer programs are determined by these
options.
.
If none of these mode and viewer options is specified
.I groffer
tries to find a suitable display mode automatically.
.
.
.Opt_def -- auto
Equivalent to
.Opt_long_arg mode auto .
.
.
.Opt_def -- default
Reset all configuration from previously processed command line options
to the default values.
.
This is useful to wipe out all former options of the configuration, in
.Env_var $GROFFER_OPT ,
and restart option processing using only the rest of the command line.
.
.
.Opt_def -- default-modes mode1,mode2,\*[Ellipsis]
Set the sequence of modes for
.I auto mode
to the comma separated list given in the argument.
.
See
.Opt_long mode
for details on modes.  Display in the default manner; actually, this
means to try the modes
.IR x ,
.IR ps ,
and
.I tty
in this sequence.
.
.
.
.Opt_def -- dvi
Equivalent to
.Opt_long_arg mode dvi .
.
.
.Opt_def -- dvi-viewer prog
Set the viewer program for dvi mode.
.
This can be a file name or a program to be searched in
.Env_var $PATH .
.
Known dvi viewers inlude
.BR xdvi (1)
and
.BR dvilx (1)
.
In each case, arguments can be provided additionally.
.
.
.Opt_def -- groff
Equivalent to
.Opt_long_arg mode groff .
.
.
.Opt_def -- html
Equivalent to
.Opt_long_arg mode html .
.
.
.Opt_def -- html-viewer
Equivalent to
.Opt_long www-viewer .
.
.
.Opt_def -- mode value
.
Set the display mode.
.
The following mode values are recognized:
.
.RS
.
.TP
.Header_CB auto
Select the automatic determination of the display mode.
.
The sequence of modes that are tried can be set with the
.Opt_long default-modes
option.
.
Useful for restoring the default mode when a different mode was
specified before.
.
.
.TP
.Header_CB dvi
Display formatted input in a
.I dvi
viewer program.
.
By default, the formatted input is displayed with the
.BR xdvi (1)
program.
.Opt_long dvi .
.
.
.TP
.Header_CB groff
After the file determination, switch
.I groffer
to process the input like
.BR groff (@MAN1EXT@)
would do .
.
This disables the
.I groffer
viewing features.
.
.
.TP
.Header_CB html
Translate the input into html format and display the result in a web
browser program.
.
By default, the existence of a sequence of standard web browsers is
tested, starting with
.BR konqueror (1)
and
.BR mozilla (1).
The text html viewer is
.BR lynx (1).
.
.
.TP
.Header_CB pdf
Display formatted input in a
.I PDF
(Portable Document Format) viewer
program.
.
By default, the input is formatted by groff using the Postscript
device, then it is transformed into the PDF file format using
.BR gs (1),
and finally displayed either with the
.BR xpdf (1)
or the
.BR acroread (1)
program.
.
PDF has a big advantage because the text is displayed graphically and
is searchable as well.
.
But as the transformation takes a considerable amount of time, this
mode is not suitable as a default device for the auto mode.
.
.
.TP
.Header_CB ps
Display formatted input in a Postscript viewer program.
.
By default, the formatted input is displayed with the
.BR ghostview (@MAN1EXT@)
program.
.
.
.TP
.Header_CB text
Format in a
.I groff
text mode and write the result to standard output without a pager or
viewer program.
.
The text device,
.I latin1
by default, can be chosen with option
.Opt_short T .
.
.
.TP
.Header_CB tty
Format in a
.I groff
text mode and write the result to standard output using a text pager
program, even when in X Window.
.
.
.TP
.Header_CB www
Equivalent to
.Opt_long www .
.
.
.TP
.Header_CB X
Display formatted input in a native roff viewer.
.
By default, the formatted input is displayed with the
.BR gxditview (@MAN1EXT@)
program, being distributed together with groff, or with
.BR xditview (1),
which is distributed as a standard X tool.
.
.
.TP
.Header_CB x
Equivalent to
.Opt_long_arg mode X .
.
.
.P
The following modes do not use the
.I groffer
viewing features.
.
They are only interesting for advanced applications.
.
.
.TP
.Header_CB groff
Generate device output with plain
.I groff
without using the special viewing features of
.IR groffer .
If no device was specified by option
.Opt_short T
the
.I groff
default
.B ps
is assumed.
.
.
.TP
.Header_CB source
Display the source code of the input without formatting; equivalent to
.Opt_short Q .
.
.
.RE
.
.
.Opt_def -- pdf
Equivalent to
.Opt_long_arg mode pdf .
.
.
.Opt_def -- pdf-viewer prog
Set the viewer program for
.I pdf
mode.
.
This can be a file name or a program to be searched in
.Env_var $PATH .
.
In each case, arguments can be provided additionally.
.
.
.Opt_def -- ps
Equivalent to
.Opt_long_arg mode ps .
.
.
.Opt_def -- ps-viewer prog
Set the viewer program for
.I ps
mode.
.
This can be a file name or a program to be searched in
.Env_var $PATH .
.
Common Postscript viewers inlude
.BR gv (1),
.BR ghostview (1),
and
.BR gs (1),
.
In each case, arguments can be provided additionally.
.
.
.Opt_def -- text
Equivalent to
.Opt_long_arg mode text .
.
.
.Opt_def -- tty
Equivalent to
.Opt_long_arg mode tty .
.
.
.Opt_def -- tty-viewer
Choose tty display mode, that means displaying in a text pager even
when in X; eqivalent to
.Opt_long_arg mode tty .
.
.
.Opt_def -- www
Equivalent to
.Opt_long_arg mode www .
.
.
.Opt_def -- www-viewer prog
Set the web browser program for viewing in
.I www
mode.
.
Each program that accepts html input and allows the
.BI file://localhost/ dir / file
syntax on the command line is suitable as viewer program; it can be
the path name of an executable file or a program in
.Env_var $PATH .
.
In each case, arguments can be provided additionally.
.
.
.Opt_def - X -- X -- x
Equivalent to
.Opt_long_arg mode X .
.
.
.Opt_def -- X-viewer -- x-viewer prog
Set the viewer program for
.I x
mode.
.
Suitable viewer programs are
.BR gxditview (@MAN1EXT@)
and
.BR xditview (1).
.
But the argument can be any executable file or a program in
.Env_var $PATH .
.
In each case, arguments can be provided additionally.
.
.
.TP
.Opt_--
Signals the end of option processing; all remaining arguments are
interpreted as
.I filespec
parameters.
.
.
.P
Besides these,
.I groffer
accepts all arguments that are valid for the
.BR groff (@MAN1EXT@)
program.
.
All non-groffer options are sent unmodified via
.I grog
to
.IR groff .
.
Postprocessors, macro packages, compatibility with classical
.IR troff ,
and much more can be manually specified.
.
.
.\" --------------------------------------------------------------------
.SH "Options for Development"
.\" --------------------------------------------------------------------
.
.Opt_def -- debug
Print debugging information for development only.
.
Actually, a function call stack is printed if an error occurs.
.
.
.Opt_def -- shell "shell_program"
Specify the shell under which the groffer script should be run.
.
The script first tests whether this option is set (either by
configuration, within
.Env_var $GROFF_OPT
or as a command line option); if so, the script is rerun under the
shell program specified with the option argument.
.
.
.Opt_def - Q -- source
Output the roff source code of the input files without further
processing.
.
This is the equivalent
.Opt_long_arg mode source .
.
.
.P
Other useful debugging options are the
.I groff
options
.Opt_short V
and
.Opt_short Z
and option
.Opt_long_arg mode groff .
.
.
.\" --------------------------------------------------------------------
.SH "Options related to groff"
.\" --------------------------------------------------------------------
.
All short options of
.I groffer
are compatible with the short options of
.BR groff (@MAN1EXT@).
.
The following of
.I groff
options have either an additional special meaning within
.I groffer
or make sense for normal usage.
.
.
.P
Because of the special outputting behavior of the
.I groff
options
.Opt_short V
and
.Opt_short Z
.I groffer
was designed to be switched into
.I groff
mode by these; the
.I groffer
viewing features are disabled there.
.
The other
.I groff
options do not switch the mode, but allow to customize the formatting
process.
.
.
.Opt_def - a
This generates an ascii approximation of output in text modes.
.
That could be important when the text pager has problems with control
sequences.
.
.
.Opt_def - m file
Add
.I file
as a
.I groff
macro file.
.
This is useful in case it cannot be recognized automatically.
.
.
.Opt_def - P opt_or_arg
Send the argument
.I opt_or_arg
as an option or option argument to the actual
.I groff
postprocessor.
.
.
.Opt_def - T -- device devname
.
This option determines
.IR groff 's
output device.
.
The most important devices are the text output devices for referring
to the different character sets, such as
.BR ascii ,
.BR utf8 ,
.BR latin1 ,
and others.
.
Each of these arguments switches
.I groffer
into a text mode using this device, to
.I mode tty
if the actual mode is not a text mode.
.
The following
.I devname
arguments are mapped to the corresponding
.I groffer
.Opt_long_arg mode \fIdevname\fR
option:
.BR dvi ,
.BR html ,
and
.BR ps .
All
.B X*
arguments are mapped to mode
.BR X .
Each other
.I devname
argument switches to
.I mode groff
using this device.
.
.
.Opt_def - V
Switch into
.I groff
mode and show only the
.I groff
calling pipe without formatting the input.
.
This an advanced option from
.BR groff (@MAN1EXT@) ,
only useful for debugging.
.
.
.Opt_def - X
was made equivalent to
.Opt_long_arg mode x ;
this slightly enhances the facility of
.IR groff 's
option.
.
.
.Opt_def - Z -- intermediate-output -- ditroff
Switch into
.I groff
mode and format the input with
.I groff
intermediate output without postprocessing; see
.BR groff_out (@MAN1EXT@).
This is equivalent to option
.Opt_long ditroff
of
.IR man ,
which can be used as well.
.
.
.P
All other
.I groff
options are supported by
.IR groffer ,
but they are just transparently transferred to
.I groff
without any intervention.
.
The options that are not explicitly handled by
.I groffer
are transparently passed to
.IR groff .
.
Therefore these transparent options are not documented here, but in
.BR groff (@MAN1EXT@).
Due to the automatism in
.IR groffer ,
none of these
.I groff
options should be needed, except for advanced usage.
.
.
.\" --------------------------------------------------------------------
.SS "X Window toolkit Options"
.\" --------------------------------------------------------------------
.
The following long options were adapted from the corresponding X
Toolkit options.
.
.I groffer
will pass them to the actual viewer program if it is an X Window
program.
.
Otherwise these options are ignored.
.
.
.P
Unfortunately these options use the old style of a single minus for
long options.
.
For
.I groffer
that was changed to the standard with using a double minus for long
options, for example,
.I groffer
uses the option
.Opt_long font
for the
.I X
option
.Opt_short font .
.
.
.P
See
.BR X (1),
.BR X (7),
and the documentation on the X toolkit options for more details on
these options and their arguments.
.
.
.Opt_def -- background color
Set the background color of the viewer window.
.
.
.Opt_def -- bd pixels
Specifies the color of the border surrounding the viewer window.
.
.
.Opt_def -- bg color
This is equivalent to
.Opt_long background .
.
.
.Opt_def -- bw pixels
Specifies the width in pixels of the border surrounding the viewer
window.
.
.
.Opt_def -- display X-display
Set the X display on which the viewer program shall be started, see the
.I X Window
documentation for the syntax of the argument.
.
.
.Opt_def -- foreground color
Set the foreground color of the viewer window.
.
.
.Opt_def -- fg color
This is equivalent to
.Opt_short foreground .
.
.
.Opt_def -- font font_name
Set the font used by the viewer window.
.
The argument is an X font name.
.
.
.Opt_def -- ft font_name
This is equivalent to
.Opt_long ft .
.
.
.Opt_def -- geometry size_pos
Set the geometry of the display window, that means its size and its
starting position.
.
See
.BR X (7)
for the syntax of the argument.
.
.
.Opt_def -- resolution value
Set X resolution in dpi (dots per inch) in some viewer programs.
.
The only supported dpi values are
.B 75
and
.BR 100 .
.
Actually, the default resolution for
.I groffer
is set to
.BR 75 .
.
.
.Opt_def -- rv
Reverse foreground and background color of the viewer window.
.
.
.Opt_def -- title "'some text'"
Set the title for the viewer window.
.
.
.Opt_def -- xrm "'resource'"
Set X resource.
.
.
.\" --------------------------------------------------------------------
.SS "Options from man"
.\" --------------------------------------------------------------------
.
The long options of
.I groffer
were synchronized with the long options of
.IR GNU man .
.
All long options of
.I GNU man
are recognized, but not all of these options are important to
.IR groffer ,
so most of them are just ignored.
.
.
.P
The following two options were added by
.I groffer
for choosing whether the file name arguments are interpreted as names
for local files or as a search pattern for man pages.
.
The default is looking up for local files.
.
.
.Opt_def -- man
Check the non-option command line arguments (filespecs) first on being
man\~pages, then whether they represent an existing file.
.
By default, a filespec is first tested whether it is an existing file.
.
.
.Opt_def -- no-man -- local-file
Do not check for man\~pages.
.
.Opt_long local-file
is the corresponding
.I man
option.
.
.
.P
In the following, the
.I man
options that have a special meaning for
.I groffer
are documented.
.
.
.P
The full set of long and short options of the
.I GNU man
program can be passed via the environment variable
.Env_var $MANOPT ;
see
.BR man (1)
if your system has
.I GNU man
installed.
.
.
.Opt_def -- all
In searching man\~pages, retrieve all suitable documents instead of
only one.
.
.
.Opt_def - 7 -- ascii
In text modes, display ASCII translation of special characters.
.
.
.Opt_def -- ditroff
Eqivalent to
.I groffer
.Opt_short Z .
.
.
.Opt_def -- extension suffix
Restrict man\~page search to file names that have
.I suffix
appended to their section element.
.
For example, in the file name
.I /usr/share/man/man3/terminfo.3ncurses.gz
the man\~page extension is
.IR ncurses .
.
.
.Opt_def -- locale language
.
Set the language for man pages.
.
This has the same effect, but overwrites
.Env_var $LANG
.
.
.Opt_def -- location
Print the location of the retrieved files to standard error.
.
.
.Opt_def -- no-location
Do not display the location of retrieved files; this resets a former
call to
.Opt_long location .
.
This was added by
.IR groffer .
.
.
.Opt_def -- manpath "'dir1:dir2:\*[Ellipsis]'"
Use the specified search path for retrieving man\~pages instead of the
program defaults.
.
If the argument is set to the empty string "" the search for man\~page
is disabled.
.
.
.Opt_def -- pager
Set the pager program in tty mode; default is
.IR less .
This is equivalent to
.Opt_long tty-viewer .
.
.
.Opt_def -- sections "'sec1:sec2:\*[Ellipsis]'"
Restrict searching for man\~pages to the given
.IR sections ,
a colon-separated list.
.
.
.Opt_def -- systems "'sys1,sys2,\*[Ellipsis]'"
Search for man pages for the given operating systems; the argument
.I systems
is a comma-separated list.
.
.
.Opt_def -- whatis
Instead of displaying the content, get the one-liner description from
the retrieved man\~page files \[em] or say that it is not a man\~page.
.
.
.Opt_def -- where
Eqivalent to
.Opt_long location .
.
.
.P
Additionally, the following short option of
.I man
is supported as well.
.
.
.\" --------------------------------------------------------------------
.SS "Filespec Arguments"
.\" --------------------------------------------------------------------
.
A
.I filespec
parameter is an argument meaning an input source, such as a file name
or template for searching man\~pages.
.
These input sources are collected and composed into a single output
file.
.
Each of these
.I filespec
parameters can have one of the following forms.
.
.
.P
No
.I filespec
parameters means that
.I groffer
waits for standard input.
.
The minus option
.Opt_short ""
stands for standard input, too, but can occur several times.
.
Next
.I filespec
is tested whether it is the path name of an existing file.
.
Otherwise it is assumed as a searching pattern for a man\~page.
.
.
.P
On each system, the man pages are sorted according to their content
into several sections.
.
The
.I classical man sections
have a single-character name, either are a digit from
.B 1
to
.B 9
or one of the characters
.B n
or
.BR o .
.
In the following, a stand-alone character
.I s
means this scheme.
.
.
.P
The internal precedence of
.I man
for searching man pages with the same name within several sections
goes according to the classical single-character sequence.
.
On some systems, this single character can be extended by a following
string.
.
But the special
.I groffer
man page facility is based on the classical single character sections.
.
.
.P
.BI man: name ( section )
and
.IB name ( section )
search the man\~page
.I name
in man\~section\~\c
.IR section ,
where
.I section
can be any string, but it must exist in the
.I man
system.
.
.
.P
Next some patterns based on the
.I classical man sections
were constructed.
.
.BI man: name . s
and
.IB name . s
search for a man\~page
.I name
in man\~section
.I s
if
.I s
is a
.I classical man section
mentioned above.
.
Otherwise search for a man\~page named
.IR name.s
in the lowest
.I man
section.
.
.
.P
Now
.BI man: name
searches for a man\~page in the lowest man\~section that has a
document called
.IR name .
.
.
.P
The pattern
.I "s name"
originates from a strange argument parsing of the
.I man
program.
.
If
.I s
is a
.I classical man section
interpret it as a search for a man\~page called
.I name
in man\~section
.IR s ,
otherwise interpret
.I s
as a file argument and
.I name
as another
.I filespec
argument.
.
.
.P
We are left with the argument
.I name
which is not an existing file.
.
So this searches for the man\~page called
.I name
in the lowest man\~section that has a document for this name.
.
.
.P
Several file name arguments can be supplied.
.
They are mixed by
.I groff
into a single document.
.
Note that the set of option arguments must fit to all of these file
arguments.
.
So they should have at least the same style of the
.I groff
language.
.
.
.\" --------------------------------------------------------------------
.SH "OUTPUT MODES"
.\" --------------------------------------------------------------------
.
By default, the
.I groffer
program collects all input into a single file, formats it with the
.I groff
program for a certain device, and then chooses a suitable viewer
program.
.
The device and viewer process in
.I groffer
is called a
.IR mode .
.
The mode and viewer of a running
.I groffer
program is selected automatically, but the user can also choose it
with options.
.
.
The modes are selected by option the arguments of
.Opt_long_arg mode \fIanymode .
Additionally, each of this argument can be specified as an option of
its own, such as
.Opt_long \fIanymode .
Most of these modes have a viewer program, which can be chosen by an
option that is constructed like
.Opt_long \fIanymode\fR-viewer .
.
.
.P
Several different modes are offered, graphical X modes, text modes,
and some direct
.I groff
modes for debugging and development.
.
.
.P
By default,
.I groffer
first tries whether
.B x
mode is possible, then
.B ps
mode, and finally
.B tty
mode.
.
This mode testing sequence for
.B auto
mode can be changed by specifying a comma separated list of modes
with the option
.Opt_long default\-modes.
.
.
.P
The searching for man\~pages and the decompression of the input are
active in every mode.
.
.
.\" --------------------------------------------------------------------
.SS "Graphical Display Modes"
.\" --------------------------------------------------------------------
.
The graphical display modes work only in the X Window environment (or
similar implementations within other windowing environments).
.
The environment variable
.Env_var $DISPLAY
and the option
.Opt_long display
are used for specifying the X display to be used.
.
If neither is given,
.I groffer
assumes that no X and changes to one text mode.
.
You can change this automatic behavior by the option
.Opt_long default\-modes .
.
.
.P
Known viewers for the graphical display modes and their standard X
Window viewer progams are
.
.Topic
X Window roff viewers such as
.BR gxditview (@MAN1EXT@)
or
.BR xditview (1)
.RI (in x
or
.I X
mode),
.
.Topic
in a Postscript viewer
.RI ( ps
mode),
.
.Topic
in a dvi viewer program
.RI ( dvi
mode),
.
.Topic
in a PDF viewer
.RI ( pdf
mode),
.
.Topic
in a web browser
.RI ( html
or
.I www
mode),
.RE
.
.
.P
The
.I pdf
mode has a major advantage \[em] it is the only graphical diplay mode
that allows to search for text within the viewer; this can be a really
important feature.
.
Unfortunately, it takes some time to transform the input into the PDF
format, so it was not chosen as the major mode.
.
.
.P
These graphical viewers can be customized by options of the X Window
Toolkit.
.
But the
.I groffer
options use a leading double minus instead of the single minus used by
the X Window Toolkit.
.
.
.\" --------------------------------------------------------------------
.SS "Text mode"
.\" --------------------------------------------------------------------
.
There are to modes for text output, mode
.I text
for plain output without a pager and mode
.I tty
for a text output on a text terminal using some pager program.
.
.
.P
If the variable
.Env_var $DISPLAY
is not set or empty, groffer assumes that it should use
.I tty
mode.
.
.
.P
In the actual implementation, the groff output device
.I latin1
is chosen for text modes.
.
This can be changed by specifying option
.Opt_short T
or
.Opt_long device .
.
.
.P
The pager to be used can be specified by one of the options
.Opt_long pager
and
.Opt_long tty-viewer ,
or by the environment variable
.Env_var $PAGER .
If all of this is not used the
.BR less (1)
program with the option
.Opt_short r
for correctly displaying control sequences is used as the default
pager.
.
.
.\" --------------------------------------------------------------------
.SS "Special Modes for Debugging and Development"
.\" --------------------------------------------------------------------
.
These modes use the
.I groffer
file determination and decompression.
.
This is combined into a single input file that is fed directly into
.I groff
with different strategy without the
.I groffer
viewing facilities.
.
These modes are regarded as advanced, they are useful for debugging
and development purposes.
.
.
.P
The
.I source
mode with just displays the generated input.
.
The
.I groff
mode passes the input to
.I groff
using only some suitable options provided to
.IR groffer .
.
This enables the user to save the generated output into a file or pipe
it into another program.
.
.
.P
In
.I groff
mode, the option
.Opt_short Z
disables post-processing, thus producing the
.I groff intermediate
.IR output .
.
In this mode, the input is formatted, but not postprocessed; see
.BR groff_out (@MAN5EXT@)
for details.
.
.
.P
All
.I groff
short options are supported by
.IR groffer .
.
.
.\" --------------------------------------------------------------------
.SH "MAN\~PAGE\~SEARCHING"
.\" --------------------------------------------------------------------
.
The default behavior of groffer is to first test whether a file
parameter represents a local file; if it is not an existing file name,
it is assumed to represent a name of a man\~page.
.
This behavior can be modified by the following options.
.
.
.TP
.Opt_long man
forces to interpret all file parameters as filespecs for searching
man\~pages.
.
.TP
.Opt_long no\-man
.TP+
.Opt_long local\-file
disable the man searching; so only local files are displayed.
.
.
.P
If neither a local file nor a man\~page was retrieved for some file
parameter a warning is issued on standard error, but processing is
continued.
.
.
.P
The groffer program provides a search facility for man\~pages.
.
All long options, all environment variables, and most of the
functionality of the GNU
.BR man (1)
program were implemented.
.
This inludes the extended file names of man\~pages, for example,
the man\~page of
.I groff
in man\~section 7 may be stored under
.File_name /usr/share/man/man7/groff.7.gz ,
where
.File_name /usr/share/man/
is part of the man\~path, the subdirectory
.I man7
and the file extension
.I .7
refer to the man\~section 7;
.I .gz
shows the compression of the file.
.
.
.P
The
.I cat\~pages
(preformatted man\~pages) are intentionally excluded from the search
because groffer is a roff program that wants to format by its own.
.
With the excellent performance of the actual computers, the
preformatted man\~pages aren't necessary any longer.
.
.
.P
The algorithm for retrieving man\~pages uses five search methods.
.
They are successively tried until a method works.
.
.
.Topic
The search path can be manually specified by using the option
.Opt_long manpath .
An empty argument disables the man\~page searching.
.
This overwrites the other methods.
.
.
.Topic
If this is not available the environment variable
.Env_var $MANPATH
is searched.
.
.
.Topic
If this is empty, the program tries to read it from the environment
variable
.Env_var $MANOPT .
.
.
.Topic
If this does not work a reasonable default path from
.Env_var $PATH
is searched for man\~pages.
.
.
.Topic
If this does not work, the
.BR manpath (1)
program for determining a path of man directories is tried.
.
.
.P
After this, the path elements for the language (locale) and operating
system specific man\~pages are added to the man\~path; their sequence
is determined automatically.
.
For example, both
.I /usr/share/man/linux/fr
and
.I /usr/share/man/fr/linux
for french linux man\~pages are found.
.
The language and operating system names are determined from both
environment variables and command line options.
.
.
.P
The locale (language) is determined like in GNU man, that is from
highest to lowest precedence:
.Topic
.Opt_long locale
.
.Topic
.Env_var $GROFFER_OPT
.
.Topic
.Env_var $MANOPT
.
.Topic
.Env_var $LCALL
.
.Topic
.Env_var $LC_MESSAGES
.
.Topic
.Env_var $LANG .
.
.
.P
The language locale is usually specified in the POSIX 1003.1 based
format:
.P
\f[I]<language>\f[][\f[CB]_\f[]\f[I]<territory>\f[][\f[CB].\f[]\
\f[I]<character-set>\f[][\f[CB],\f[]\f[I]<version>\f[]]]],
.P
but the two-letter code in
.I <language>
is sufficient for most purposes.
.
.
.P
If no man\~pages for a complicated locale are found the country part
consisting of the first two characters (without the `\f[CB]_\f[]',
`\f[CB].\f[]', and `\f[CB],\f[]', parts) of the locale is searched as
well.
.
.
.P
If still not found the corresponding man\~page in the default language
is used instead.
.
As usual, this default can be specified by one of \f[CR]C\f[] or
\f[CR]POSIX\f[].
.
The man\~pages in the default language are usually in English.
.
.
.P
Several operating systems can be given by appending their names,
separated by a comma.
.
This is then specified by the environment variable
.Env_var $SYSTEM
or by the command line option
.Opt_long systems .
The precedence is similar to the locale case above from highest to
lowest precedence:
.
Topic
.Opt_long systems
.
.Topic
.Env_var $GROFFER_OPT
.
.Topic
.Env_var $MANOPT
.
.Topic
.Env_var $SYSTEM .
.
.
.P
When searching for man\~pages this man\~path with the additional
language and system specific directories is used.
.
.
.P
The search can further be restricted by limiting it to certain
sections.
.
A single section can be specified within each filespec argument,
several sections as a colon-separated list in command line option
.Opt_long sections
or environment variable
.Env_var $MANSECT .
.
When no section was specified a set of standard sections is searched
until a suitable man\~page was found.
.
.
.P
Finally, the search can be restricted to a so-called
.IR extension .
This is a postfix that acts like a subsection.
.
It can be specified by
.Opt_long extension
or environment variable
.Env_var $EXTENSION .
.
.
.P
For further details on man\~page searching, see
.BR man (1).
.
.
.\" --------------------------------------------------------------------
.SH DECOMPRESSION
.\" --------------------------------------------------------------------
.
The program has a decompression facility.
.
If standard input or a file that was retrieved from the command line
parameters is compressed with a format that is supported by either
.BR gzip (1)
or
.BR bzip2 (1)
it is decompressed on-the-fly.
.
This includes the GNU
.BR .gz ,
.BR .bz2 ,
and the traditional
.B .Z
compression.
.
The program displays the concatenation of all decompressed input in
the sequence that was specified on the command line.
.
.
.\" --------------------------------------------------------------------
.SH "ENVIRONMENT"
.\" --------------------------------------------------------------------
.
The groffer programs supports many system variables, most of them by
courtesy of other programs.
.
All environment variables of
.BR groff (@MAN1EXT@)
and GNU
.BR man (1)
and some standard system variables are honored.
.
.
.\" --------------------------------------------------------------------
.SS "Native groffer Variables"
.\" --------------------------------------------------------------------
.
.TP
.Env_var $GROFFER_OPT
Store options for a run of groffer.
.
The options specified in this variable are overridden by the options
given on the command line.
.
The content of this variable is run through the shell builtin `eval';
so arguments containing white-space or special shell characters should
be quoted.
.
.
.\" --------------------------------------------------------------------
.SS "System Variables"
.\" --------------------------------------------------------------------
.
The groffer program is a shell script that is run through
.BR /bin/sh ,
which can be internally linked to programs like
.BR bash (1).
The corresponding system environment is automatically effective.
.
The following variables have a special meaning for groffer.
.
.
.TP
.Env_var $DISPLAY
If this variable is set this indicates that the X Window system is
running.
.
Testing this variable decides on whether graphical or text output is
generated.
.
This variable should not be changed by the user carelessly, but it can
be used to start the graphical groffer on a remote X terminal.
.
For example, depending on your system, groffer can be started on the
second monitor by the command
.Shell_cmd DISPLAY=:0.1\~groffer\~ what.ever &
.
.
.TP
.Env_var $LC_ALL
.TP+
.Env_var $LC_MESSAGES
.TP+
.Env_var $LANG
If one of these variables is set (in the above sequence), its content
is interpreted as the locale, the language to be used, especially when
retrieving man\~pages.
.
A locale name is typically of the form
.IR language [\c
.B _\c
.IR territory [\c
.B .\c
.IR codeset [\c
.B @\c
.IR modifier ]]],
where
.I language
is an ISO 639 language code,
.I territory
is an ISO 3166 country code, and
.I codeset
is a character set or encoding identifier like ISO-8859-1 or UTF-8;
see
.BR setlocale (3).
.
The locale values\~\c
.B C
and
.B POSIX
stand for the default, i.e. the man\~page directories without a
language prefix.
.
This is the same behavior as when all 3\~variables are unset.
.
.
.TP
.Env_var $PAGER
This variable can be used to set the pager for the tty output.
.
For example, to disable the use of a pager completely set this
variable to the
.BR cat (1)
program
.Shell_cmd PAGER=cat\~groffer\~ anything
.
.
.TP
.Env_var $PATH
All programs within the groffer shell script are called without a
fixed path.
.
Thus this environment variable determines the set of programs used
within the run of groffer.
.
.
.TP
.Env_var $POSIXLY_CORRECT
If set to a non-empty value this chooses the POSIX mode for option
processing, that means that option processing will be finished as soon
as a non-option argument is found.
.
Usually, you do not want to set this environment variable.
.
.
.\" --------------------------------------------------------------------
.SS "Groff Variables"
.\" --------------------------------------------------------------------
.
The groffer program internally calls groff, so all environment
variables documented in
.BR groff (@MAN1EXT@)
are internally used within groffer as well.
.
The following variables have a direct meaning for the groffer program.
.
.TP
.Env_var $GROFF_TMPDIR
If the value of this variable is an existing, writable directory,
groffer uses it for storing its temporary files, just as groff does.
.
.
.\" --------------------------------------------------------------------
.SS "Man Variables"
.\" --------------------------------------------------------------------
.
Parts of the functionality of the man\~program were implemented in
groffer; support for all environment variables documented in
.BR man (1)
was added to groffer, but the meaning was slightly modified due to the
different approach in groffer; but the user interface is the same.
.
The man environment variables can be overwritten by options provided
with
.Env_var $MANOPT ,
which in turn is overwritten by the command line.
.
.
.TP
.Env_var $EXTENSION
Restrict the search for man\~pages to files having this extension.
.
This is overridden by option
.Opt_long extension ;
see there for details.
.
.
.TP
.Env_var $MANOPT
This variable contains options as a preset for
.BR man (1).
As not all of these are relevant for groffer only the essential parts
of its value are extracted.
.
The options specified in this variable overwrite the values of the
other environment variables taht are specific to man.
.
All options specified in this variable are overridden by the options
given on the command line.
.
.
.TP
.Env_var $MANPATH
If set, this variable contains the directories in which the man\~page
trees are stored.
.
This is overridden by option
.Opt_long manpath .
.
.
.TP
.Env_var $MANSECT
If this is a colon separated list of section names, the search for
man\~pages is restricted to those manual sections in that order.
.
This is overridden by option
.Opt_long sections .
.
.
.TP
.Env_var $SYSTEM
If this is set to a comma separated list of names these are interpreted
as man\~page trees for different operating systems.
.
This variable can be overwritten by option
.Opt_long systems ;
see there for details.
.
.
.P
The environment variable
.Env_var $MANROFFSEQ
is ignored by groffer because the necessary preprocessors are
determined automatically.
.
.
.\" --------------------------------------------------------------------
.SH "CONFIGURATION FILES"
.\" --------------------------------------------------------------------
.
The
.I groffer
program can be preconfigured by two configuration files.
.
This configuration can be overridden at each program start by command
line options or by the environment variable
.Env_var $GROFFER_OPT .
.
.
.TP
.File_name /etc/groff/groffer.conf
System-wide configuration file for groffer.
.
.
.TP
.File_name $HOME/.groff/groffer.conf
User-specific configuration file for groffer, where
.Env_var $HOME
denotes the user's home directory.
.
This script is called after the system-wide configuration file to
enable overriding by the user.
.
.
.P
Their lines either start with a minus character or are shell commands.
.
Arbitrary spaces are allowed at the beginning, they are just ignored.
.
The lines with the beginning minus are appended to the existing value
of $GROFFER_OPT.
.
This easily allows to set general
.I groffer
options that are used with any call of
.IR groffer .
.
.
.P
After the transformation of the minus lines the emerging shell scripts
that are called by
.I groffer
using the `\c
.CB .\~\c
.IR filename '
syntax.
.
.
.P
It makes sense to use these configuration files for the following
tasks:
.
.Topic
Preset command line options by writing them into lines starting with a
minus sign.
.
.Topic
Preset environment variables recognized by groffer.
.
.Topic
Write a function for calling a viewer program for a special
.I mode
and feed this name into its corresponding
.Opt_long \f[I]mode\f[]\-viewer
option.
.
Note that the name of such a function must coincide with some existing
program in the system path
.Env_var $PATH
in order to be recognized by groffer.
.
.
.P
As an example, consider the following configuration file in
~/.groff/groffer.conf, say.
.
.P
.ft CR
.nh
.nf
# groffer configuration file
#
# groffer options that are used in each call of groffer
--resolution=100
--foreground=DarkBlue
--x-viewer 'gxditview -geometry 850x800'
#
# some shell commands
if test "$DISPLAY" = ""; then
  DISPLAY='localhost:0.0'
fi
date >>~/mygroffer.log
.fi
.hy
.ft
.
.
.P
This configuration sets three
.I groffer
options and runs two shell commands.
.
This has the following effects:
.
.
.Topic
Lines starting with a 
.B #
character
are 
.
.
.Topic
Use a resolution of
.B 100 dpi
and a text color of
.B DarkBlue
in all viewers that support this.
.
.
.Topic
Force
.BR gxditview (@MAN1EXT@)
as the X-mode viewer using the geometry option for setting the width
to
.B 850 dpi
and the height to
.B 800
.BR dpi .
.
.
.Topic
The variable
.Env_var $DISPLAY
is set to
.IR localhost:0.0
which allows to start
.I groffer
in the standard X display, even when the program is called from a text
console.
.
.
.Topic
Just for fun, the date of each
.I groffer
start is written to the file
.B mygroffer.log
in the home directory.
.
.
.\" --------------------------------------------------------------------
.SH "EXAMPLES"
.\" --------------------------------------------------------------------
.
The usage of groffer is very easy.
.
Usually, it is just called with a file name or man\~page.
.
The following examples, however, show that groffer has much more fancy
capabilities.
.
.
.TP
.Shell_cmd "groffer\~/usr/local/share/doc/groff/meintro.ms.gz"
Decompress, format and display the compressed file
.I meintro.ms.gz
in the directory
.IR /usr/local/share/doc/groff ,
using
.I gxditview
as graphical viewer when in X Window, or the
.BR less (1)
pager program when not in X.
.
.
.TP
.Shell_cmd "groffer\~groff"
If the file
.I ./groff
exists use it as input.
.
Otherwise interpret the argument as a search for the man\~page named
.I groff
in the smallest possible man\~section, being secion 1 in this case.
.
.
.TP
.Shell_cmd "groffer\~man:groff"
search for the man\~page of
.I groff
even when the file
.I ./groff
exists.
.
.
.TP
.Shell_cmd "groffer\~groff.7"
.TP+
.Shell_cmd "groffer\~7\~groff"
search the man\~page of
.I groff
in man\~section
.BR 7 .
This section search works only for a digit or a single character from
a small set.
.
.
.TP
.Shell_cmd "groffer\~fb.modes"
If the file
.I ./fb.modes
does not exist interpret this as a search for the man\~page of
.IR fb.modes .
As the extension
.I modes
is not a single character in classical section style the argument is
not split to a search for
.IR fb .
.
.
.TP
.Shell_cmd "groffer\~groff\~\[cq]troff(1)\[cq]\~man:roff"
.
The arguments that are not existing files are looked-up as the
following man\~pages:
.I groff
(automatic search, should be found in man\~section\~1),
.I troff
(in section\~1),
and
.I roff
(in the section with the lowest number, being\~7 in this case).
.
The quotes around
.I \[cq]troff(1)\[cq]
are necessary because the paranthesis are special shell characters;
escaping them with a backslash character
.I \[rs](
and
.I \[rs])
would be possible, too.
.
The formatted files are concatenated and displayed in one piece.
.
.
.TP
.Shell_cmd "LANG=de\~groffer\~--man\~--www\~--www-viever=mozilla\~ls"
.
Retrieve the German man\~page (language
.IR de )
for the
.B ls
program, decompress it, format it to
.I html
format
.RI ( www
mode) and view the result in the web browser
.I galeon .
The option
.Opt_long man
guarantees that the man\~page is retrieved, even when a local file
.I ls
exists in the actual directory.
.
.
.TP
.Shell_cmd "groffer\~--source\~'man:roff(7)'"
.
Get the man\~page called
.I roff
in man\~section 7, decompress it, and print its unformatted content,
its source code.
.
.
.TP
.Shell_cmd "cat\~file.gz\~|\~groffer\~-Z\~-mfoo"
.
Decompress the standard input, send this to
.I groff
intermediate mode without post-processing (groff option
.Opt_short Z ),
using macro package by
.I foo
(groff option
.Opt_short m ) .
.
.
.TP
.Shell_cmd "echo\~'\[rs]f[CB]WOW!'\~|"
.TP+
.Shell_cmd+ "groffer --x --bg red --fg yellow --geometry 200x100 -"
.
Display the word \f[CB]WOW!\f[] in a small window in constant-width
bold font, using color yellow on red background.
.
.
.\" --------------------------------------------------------------------
.SH "COMPATIBILITY"
.\" --------------------------------------------------------------------
.
The
.B groffer
shell script is compatible with both GNU and POSIX.
.
POSIX compatibility refers to
.B IEEE P1003.2/D11.2
of September 1991, a very early version of the POSIX standard that is
still freely available in the internet.
.
Unfortunately, this version of the standard has `local' for shell
function variables removed.
.
As `local' is needed for serious programming this temporary POSIX
deprecation was ignored.
.
.
.P
Most GNU shells are compatible with this interpretation of POSIX, but
provide much more facilities.
.
Nevertheless this script uses only a restricted set of shell language
elements and shell builtins, such that it can be run on `ash', a GNU
shell that is quite fast, but has a slightly limited shell language.
.
The groffer script should work on most actual free and commercial
operating systems.
.
.
.P
The groffer program provides its own parser for command line options;
it can handle option arguments and file names containing white space
and a large set of special characters.
.
.
.P
The groffer shell script was tested with the following common
implementations of the GNU shells:
.BR ash (1),
POSIX
.BR sh (1),
.BR bash (1),
and others.
.
Free POSIX compatible shells and shell utilities for most operating
systems are available at the
.URL http://\:www.gnu.org/software/ "GNU software archive" .
.
.
.P
The best performance was obtained with the
.I ash
shell; so
.I groffer
tries to run under
.I ash
whenever possible.
.
If
.I ash
is not available the shell under which the script was started in the
first place is used instead.
.
This can be modified by the option
.Opt_long shell .
.
.
.P
The groffer program provides its own parser for command line arguments
that is compatible to both POSIX
.BR getopts (1)
and GNU
.BR getopt (1)
except for shortcuts of long options.
.
The following standard types of options are supported.
.
.
.Topic
A single minus always refers to single character option or a
combination thereof, for example, the
.I groffer
short option combination
.Opt_short Qmfoo
is equivalent to
.Opt_short Q\~\-m\~foo .
.
.
.Topic
Long options are options with names longer than one character; they
are always prededed by a double minus.
.
An option argument can either go to the next command line argument or
be appended with an equal sign to the argument; for example,
.Opt_alt -- long=arg
is equivalent to
.Opt_alt -- long\~arg .
.
.
.Topic
An argument of
.Opt_--
ends option parsing; all further command line arguments are
interpreted as file name arguments.
.
.
.Topic
By default, all command line arguments that are neither options nor
option arguments are interpreted as filespec parameters and stored
until option parsing has finished.
.
For example, the command line
.Shell_cmd "groffer file1 -a -o arg file2"
is, by default, equivalent to
.Shell_cmd "groffer -a -o arg -- file1 file2"
.
.
.P
This behavior can be changed by setting the environment variable
.Env_var $POSIXLY_CORRECT
to a non-empty value.
.
Then the strange POSIX non-option behavior is adopted, i. e. option
processing is stopped as soon as the first non-option argument is
found and each following argument is taken as a file name.
.
For example, in posixly correct mode, the command line
.Shell_cmd "groffer file1 -a -o arg file 2"
is equivalent to
.Shell_cmd "groffer -- file1 -a -o arg file 2"
As this leads to unwanted behavior in most cases, most people do not
want to set
.Env_var $POSIXLY_CORRECT .
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
.TP
.BR groff (@MAN1EXT@)
.TP+
.BR troff (@MAN1EXT@)
Details on the options and environment variables available in
.IR groff ;
all of them can be used with groffer.
.
.
.TP
.BR man (1)
The standard program to diplay man\~pages.
.
The information there is only useful if it is the man\~page for
.IR "GNU\~man" .
Then it documents the options and environment variables that are
supported by groffer.
.
.
.TP
.BR gxditview (@MAN1EXT@)
.TP+
.BR xditview (1x)
Viewers for groffer's
.I x
mode.
.
.
.TP
.BR gv (1)
.TP+
.BR ghostview (1)
Viewers for groffer's
.I ps
mode.
.
.
.TP+
.BR gs (1)
Transformer from
.I ps
to
.IR pdf ;
and a
.I ps
viewer.
.
.
.TP
.BR xpdf (1)
Viewers for
.I pdf
files.
.
.
.TP
.BR xdvi (1)
.TP+
.BR dvilx (1)
Viewers for groffer's
.I dvi
mode.
.
.
.TP
.BR less (1)
Standard pager program for the
.I tty
.IR mode .
.
.
.TP
.BR gzip (1)
.TP+
.BR bzip2 (1)
The decompression programs supported by groffer.
.
.
.TP
.BR groff (@MAN7EXT@)
Documentation of the
.I groff
language.
.
.
.TP
.BR grog (@MAN1EXT@)
Internally, groffer tries to guess the groff command line options from
the input using this program.
.
.
.TP
.BR groff_out (@MAN5EXT@)
Documentation on the groff intermediate output (ditroff output).
.
.
.\" --------------------------------------------------------------------
.SH "AUTHOR"
.\" --------------------------------------------------------------------
.
Copyright (C) 2001,2002,2004 Free Software Foundation, Inc.
.
.P
This document is distributed under the terms of the FDL (GNU Free
Documentation License) version 1.1 or later.
.
You should have received a copy of the FDL on your system, it is also
available on-line at the
.URL http://\:www.gnu.org/\:copyleft/\:fdl.html "GNU copyleft site" .
.
.P
This document is part of
.IR groff ,
the GNU roff distribution.
.
It was written by Bernd Warken.
.
.
\" --------------------------------------------------------------------
.\" Emacs settings
.\" --------------------------------------------------------------------
.
.\" Local Variables:
.\" mode: nroff
.\" End:
