#############################################################
#
# zebra
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
ZEBRA_SOURCE:=zebra.tar.gz
ZEBRA_SITE:=ftp://ftp.gnu.org/gnu/zebra
ZEBRA_CAT:=zcat
endif

ZEBRA_DIR:=$(BUILD_DIR)/zebra
ZEBRA_BINARY:=zebra
ZEBRA_TARGET_BINARY:=usr/sbin/zebra

ifneq ($(USE_CVS),true)
zebra-fetch:
	 $(WGET) -P $(DL_DIR) $(ZEBRA_SITE)/$(ZEBRA_SOURCE)

zebra-source: $(DL_DIR)/$(ZEBRA_SOURCE)
else
zebra-source:
endif

ZEBRA_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d zebra $(CVS_TAG) $(CVS_PREFIX)zebra

zebra-checkout:
	@$(ZEBRA_CVSCO)

$(ZEBRA_DIR)/.unpacked: $(DL_DIR)/$(ZEBRA_SOURCE)
ifneq ($(USE_CVS),true)
	$(ZEBRA_CAT) $(DL_DIR)/$(ZEBRA_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(ZEBRA_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(ZEBRA_DIR)/
	touch $(ZEBRA_DIR)/.unpacked

$(ZEBRA_DIR)/.configured: $(ZEBRA_DIR)/.unpacked
	(cd $(ZEBRA_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--enable-ipv6 \
	);
	touch  $(ZEBRA_DIR)/.configured

$(ZEBRA_DIR)/$(ZEBRA_BINARY): $(ZEBRA_DIR)/.configured
	$(MAKE) -C $(ZEBRA_DIR)

$(TARGET_DIR)/$(ZEBRA_TARGET_BINARY): $(ZEBRA_DIR)/$(ZEBRA_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(ZEBRA_DIR) install
	$(STRIP) $(TARGET_DIR)/$(ZEBRA_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/bgpd \
		$(TARGET_DIR)/usr/sbin/ripd \
		$(TARGET_DIR)/usr/sbin/ospfd 
	for f in $(ZEBRA_DIR)/init/redhat/*.init ; do \
		install -m0755 $$f $(TARGET_DIR)/etc/rc.d/init.d/`basename $$f .init` ;\
	done
	install -d $(DOC_DIR)/doc/zebra
	@for f in COPYING COPYING.LIB README REPORTING-BUGS SERVICES ; do \
		install -m0644 $(ZEBRA_DIR)/$$f $(DOC_DIR)/doc/zebra/$$f ;\
	done

zebra: uclibc initscripts $(TARGET_DIR)/$(ZEBRA_TARGET_BINARY)

zebra-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(ZEBRA_DIR) uninstall
	-rm -f $(TARGET_DIR)/etc/rc.d/init.d/zebra \
		$(TARGET_DIR)/etc/rc.d/init.d/bgpd \
		$(TARGET_DIR)/etc/rc.d/init.d/ospfd \
		$(TARGET_DIR)/etc/rc.d/init.d/ospf6d \
		$(TARGET_DIR)/etc/rc.d/init.d/ripd \
		$(TARGET_DIR)/etc/rc.d/init.d/ripngd
	-rm -rf $(DOC_DIR)/doc/zebra
	-$(MAKE) -C $(ZEBRA_DIR) clean

zebra-dirclean:
	rm -rf $(ZEBRA_DIR)
endif

