#############################################################
#
# ipgrab
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
IPGRAB_SOURCE:=ipgrab.tar.gz
IPGRAB_SITE:=ftp://ftp.gnu.org/gnu/ipgrab
IPGRAB_CAT:=zcat
endif

IPGRAB_DIR:=$(BUILD_DIR)/ipgrab
IPGRAB_BINARY:=ipgrab
IPGRAB_TARGET_BINARY:=bin/ipgrab

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(IPGRAB_SOURCE):
	 $(WGET) -P $(DL_DIR) $(IPGRAB_SITE)/$(IPGRAB_SOURCE)

ipgrab-source: $(DL_DIR)/$(IPGRAB_SOURCE)
else
ipgrab-source:
endif

IPGRAB_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d ipgrab $(CVS_TAG) $(CVS_PREFIX)ipgrab

ipgrab-checkout:
	@$(IPGRAB_CVSCO)

$(IPGRAB_DIR)/.unpacked: $(DL_DIR)/$(IPGRAB_SOURCE)
ifneq ($(USE_CVS),true)
	$(IPGRAB_CAT) $(DL_DIR)/$(IPGRAB_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(IPGRAB_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(IPGRAB_DIR)/
	sed -i -e 's,\(/usr/include\),$(STAGING_DIR)\1,g' $(IPGRAB_DIR)/configure.in
	for f in `find $(IPGRAB_DIR) -name Makefile.in` ; do \
		touch $$f ; \
	done
	touch $(IPGRAB_DIR)/.unpacked

$(IPGRAB_DIR)/.configured: $(IPGRAB_DIR)/.unpacked
	(cd $(IPGRAB_DIR); rm -rf config.cache; \
		aclocal ; autoconf ; \
		$(TARGET_CONFIGURE_OPTS)  \
		ac_cv_func_setvbuf_reversed=no \
		CFLAGS="$(TARGET_CFLAGS) -DUCD_COMPATIBLE" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=$(STAGING_DIR)/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(IPGRAB_DIR)/.configured

$(IPGRAB_DIR)/$(IPGRAB_BINARY): $(IPGRAB_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(IPGRAB_DIR)

$(TARGET_DIR)/$(IPGRAB_TARGET_BINARY): $(IPGRAB_DIR)/$(IPGRAB_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(IPGRAB_DIR) install
	install -d $(DOC_DIR)/doc/ipgrab
	@for f in AUTHORS COPYING NEWS README ; do \
		install -m0644 $(IPGRAB_DIR)/$$f $(DOC_DIR)/doc/ipgrab/$$f ;\
	done

ipgrab: uclibc $(TARGET_DIR)/$(IPGRAB_TARGET_BINARY)

ipgrab-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(IPGRAB_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/ipgrab
	-$(MAKE) -C $(IPGRAB_DIR) clean

ipgrab-dirclean:
	rm -rf $(IPGRAB_DIR)
endif

