/* gdb-stub.h: FRV GDB stub
 *
 * Copyright (C) 2003 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 * - Derived from asm-mips/gdb-stub.h (c) 1995 Andreas Busse
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef __ASM_GDB_STUB_H
#define __ASM_GDB_STUB_H

#undef GDBSTUB_DEBUG_PROTOCOL

#include <asm/ptrace.h>

/*
 * important register numbers in GDB protocol
 * - GR0,  GR1,  GR2,  GR3,  GR4,  GR5,  GR6,  GR7,
 * - GR8,  GR9,  GR10, GR11, GR12, GR13, GR14, GR15,
 * - GR16, GR17, GR18, GR19, GR20, GR21, GR22, GR23,
 * - GR24, GR25, GR26, GR27, GR28, GR29, GR30, GR31,
 * - GR32, GR33, GR34, GR35, GR36, GR37, GR38, GR39,
 * - GR40, GR41, GR42, GR43, GR44, GR45, GR46, GR47,
 * - GR48, GR49, GR50, GR51, GR52, GR53, GR54, GR55,
 * - GR56, GR57, GR58, GR59, GR60, GR61, GR62, GR63,
 * - FP0,  FP1,  FP2,  FP3,  FP4,  FP5,  FP6,  FP7,
 * - FP8,  FP9,  FP10, FP11, FP12, FP13, FP14, FP15,
 * - FP16, FP17, FP18, FP19, FP20, FP21, FP22, FP23,
 * - FP24, FP25, FP26, FP27, FP28, FP29, FP30, FP31,
 * - FP32, FP33, FP34, FP35, FP36, FP37, FP38, FP39,
 * - FP40, FP41, FP42, FP43, FP44, FP45, FP46, FP47,
 * - FP48, FP49, FP50, FP51, FP52, FP53, FP54, FP55,
 * - FP56, FP57, FP58, FP59, FP60, FP61, FP62, FP63,
 * - PC, PSR, CCR, CCCR,
 * - _X132, _X133, _X134
 * - TBR, BRR, DBAR0, DBAR1, DBAR2, DBAR3,
 * - _X141, _X142, _X143, _X144,
 * - LR, LCR
 */
#define GDB_REG_GR(N)	(N)
#define GDB_REG_FR(N)	(64+(N))
#define GDB_REG_PC	128
#define GDB_REG_PSR	129
#define GDB_REG_CCR	130
#define GDB_REG_CCCR	131
#define GDB_REG_TBR	135
#define GDB_REG_BRR	136
#define GDB_REG_DBAR(N)	(137+(N))
#define GDB_REG_LR	145
#define GDB_REG_LCR	146

#define GDB_REG_SP	GDB_REG_GR(1)
#define GDB_REG_FP	GDB_REG_GR(2)

#ifndef _LANGUAGE_ASSEMBLY

/*
 * This is the same as above, but for the high-level
 * part of the GDB stub.
 */

struct gdb_regs {
	/*
	 * saved main processor registers
	 */
	uint32_t	gr[64];
	uint32_t	fr[64];
	uint32_t	pc;
	uint32_t	psr;
	uint32_t	ccr;
	uint32_t	cccr;
	uint32_t	tbr;
	uint32_t	brr;
	uint32_t	dbar0;
	uint32_t	dbar1;
	uint32_t	dbar2;
	uint32_t	dbar3;
	uint32_t	lr;
	uint32_t	lcr;
	uint32_t	last_spr;
};

/*
 * Prototypes
 */
extern void show_registers_only(struct pt_regs *regs);

extern void gdbstub_init(void);
extern void gdbstub(int type);
extern void gdbstub_exit(int status);

extern void gdbstub_io_init(void);
extern void gdbstub_set_baud(unsigned baud);
extern int gdbstub_rx_char(unsigned char *_ch, int nonblock);
extern void gdbstub_tx_char(unsigned char ch);
extern void gdbstub_tx_flush(void);
extern void gdbstub_do_rx(void);

extern asmlinkage void __debug_stub_pause(void);
extern asmlinkage void start_kernel(void);

extern asmlinkage void gdbstub_rx_handler(void);
extern asmlinkage void gdbstub_rx_irq(void);
extern asmlinkage void gdbstub_intercept(void);

extern uint32_t __entry_usertrap_table[];
extern uint32_t __entry_kerneltrap_table[];

extern volatile u8	gdbstub_rx_buffer[PAGE_SIZE];
extern volatile u32	gdbstub_rx_inp;
extern volatile u32	gdbstub_rx_outp;
extern volatile u8	gdbstub_rx_overflow;
extern u8		gdbstub_rx_unget;

extern void gdbstub_printk(const char *fmt, ...);
extern void debug_to_serial(const char *p, int n);
extern void console_set_baud(unsigned baud);

#ifdef GDBSTUB_DEBUG_PROTOCOL
#define gdbstub_proto(FMT,...) gdbstub_printk(FMT,##__VA_ARGS__)
#else
#define gdbstub_proto(FMT,...) ({ 0; })
#endif

#endif /* _LANGUAGE_ASSEMBLY */
#endif /* __ASM_GDB_STUB_H */
