Name: MAKEDEV-static
Version: 3.3.13
Release: 1.gnupro.1
Group: System Environment/Base
License: GPL
Source: MAKEDEV-%{version}.tar.gz
Summary: A program used for creating device files in /dev.
BuildRoot: %{_tmppath}/%{name}-root
BuildConflicts: rpm < 4.0.3-0.71, rpm-build < 4.0.3-0.71
URL: http://www.lanana.org/docs/device-list/
ExcludeArch: s390 s390xc
# do this to satisfy the kernel's udev requirement
Provides: udev

%description
This package contains the MAKEDEV program, which makes it easier to create
and maintain the files in the /dev directory.  /dev directory files
correspond to a particular device supported by Linux (serial or printer
ports, scanners, sound cards, tape drives, CD-ROM drives, hard drives,
etc.) and interface with the drivers in the kernel.

You should install the MAKEDEV package because the MAKEDEV utility makes
it easy to manage the /dev directory device files.

%package -n dev
Group: System Environment/Base
Summary: The most commonly-used entries in the /dev directory.
Prereq: /usr/sbin/groupadd, /usr/sbin/useradd
%if "%{_arch}" == %{_build_arch}
Prereq: /bin/mkdir, sed, textutils, fileutils, mktemp
%endif

%description -n dev
The Red Hat Linux operating system uses file system entries to represent
devices (CD-ROMs, floppy drives, etc.) attached to the machine. All of
these entries are in the /dev tree (although they don't have to be).
This package contains the most commonly used /dev entries.

The dev package is a basic part of your Red Hat Linux system and it needs
to be installed.

%prep
%setup -q -n MAKEDEV-%{version}

%build
%ifarch s390 s390x
export S390=1
%endif
%if "%{_arch}" == %{_build_arch}
make OPTFLAGS="$RPM_OPT_FLAGS"
%else
make OPTFLAGS="$RPM_OPT_FLAGS" MAKEDEV
mv MAKEDEV host-MAKEDEV
make clean
make CC=%{__cc} OPTFLAGS="$RPM_OPT_FLAGS"
%endif

%install
%ifarch s390 s390x
export S390=1
%endif
makedev() {
	# Note that we need RPM 4.0.3-0.71 or higher for this to be of any use,
	# but otherwise we could screw up ownerships if the destination account
	# doesn't exist when we run MAKEDEV.
%if "%{_arch}" == %{_build_arch}
	$RPM_BUILD_ROOT/dev/MAKEDEV \
%else
	$RPM_BUILD_ROOT/dev/host-MAKEDEV \
%endif
	-c $RPM_BUILD_ROOT%{_sysconfdir}/makedev.d \
	-d $RPM_BUILD_ROOT/dev -M $@ | sed "s|$RPM_BUILD_ROOT||g" >> manifest
}
rm -fr $RPM_BUILD_ROOT
rm -f  manifest

%ifnarch s390 s390x
%makeinstall devdir=$RPM_BUILD_ROOT/dev
%if "%{_arch}" != %{_build_arch}
cp host-MAKEDEV $RPM_BUILD_ROOT/dev
%endif
%if "%{_arch}" == %{_build_arch}
makedev agpgart
makedev apm_bios
makedev beep
makedev capi20
makedev cdrom
makedev cfs
makedev compaq
makedev -m 32 console
makedev cpu
makedev -m 4 cua
makedev -m 16 cui
makedev dri
makedev enskip
makedev fb
makedev fd0
makedev fd1
makedev ftape
makedev -m 2 ht
makedev -m 2 i2c
makedev i2o
makedev ibcs
makedev -m 33 ide
makedev initrd
makedev -m 32 input
makedev -m 16 ip
makedev -m 16 ipfilter
makedev ir
makedev -m 2 iscc
makedev -m 16 isdn
makedev -m 4 js
makedev kpoll
makedev -m 32 loop
makedev -m 1 log
makedev -m 8 lp
makedev md
makedev mouse
makedev -m 32 nb
makedev net/tun
makedev netlink
makedev -m 2 nht
makedev -m 4 nosst
makedev -m 16 nst
makedev -m 4 osst
makedev -m 8 par
makedev -m 4 pcd
makedev pd
makedev -m 4 pf
makedev -m 4 pg
makedev -m 4 ppp
makedev pt
makedev ptmx
makedev pty
makedev qng
makedev -m 20 ram
makedev random
makedev raid
makedev raw
makedev rmt
makedev rtc
makedev -m 8 scd
makedev -m 16 scramdisk
makedev sd
makedev -m 32 sg
makedev smpt
makedev sound
makedev -m 16 st
makedev systty
makedev -m 4 staliomem
makedev std
makedev tlk
makedev -m 32 tty
makedev urandom
makedev -m 32 usb
makedev -m 4 v4l
makedev vcs
makedev video1394
makedev vmmon
makedev -m 4 vnet
makedev vsys
makedev -m 4 winradio
makedev xda
makedev xdb
%else
makedev cdrom
makedev -m 8 console
makedev cpu
makedev -m 4 cua
makedev -m 16 cui
makedev fb
makedev fd0
makedev fd1
makedev -m 2 i2c
makedev i2o
makedev -m 4 ide
makedev initrd
makedev -m 4 input
makedev -m 4 ip
makedev -m 4 ipfilter
makedev kpoll
makedev -m 32 loop
makedev -m 1 log
makedev -m 8 lp
makedev mouse
makedev -m 4 nb
makedev net/tun
makedev netlink
makedev -m 4 ppp
makedev ptmx
makedev pty
makedev -m 8 ram
makedev random
makedev raw
makedev rmt
makedev sound
makedev systty
makedev std
makedev -m 4 tty
makedev urandom
makedev -m 8 usb
%endif
%endif

# Create architecture-specific devices.
%ifarch s390 s390x
export S390=1
%makeinstall devdir=$RPM_BUILD_ROOT/dev
makedev console
makedev initrd
makedev -m 16 ipfilter
makedev -m 32 loop
makedev -m 1 log
makedev md
makedev -m 32 nb
makedev ptmx
makedev pty
makedev -m 20 ram
makedev random
makedev raw
makedev systty
makedev std
makedev -m 32 tty
makedev urandom
makedev dasd
makedev mnd
makedev xpram
makedev btibm
makedev rtibm
makedev ntibm
rm -f $RPM_BUILD_ROOT/dev/fd[0-7]*
rm -f $RPM_BUILD_ROOT/dev/vcs*
if [ -f manifest ] ; then
        grep -v '/dev/fd[0-7]' manifest > manifest.tmp && mv manifest.tmp manifest
        grep -v '/dev/vcs'     manifest > manifest.tmp && mv manifest.tmp manifest
fi
%endif

%ifarch ia64
makedev efirtc
%endif

%ifarch sparc sparc64
makedev audioctl
makedev kbd
makedev openprom
ln -s sunmouse $RPM_BUILD_ROOT/dev/mouse
for dev in aztcd cdu31a cdu535 cm205cd cm206cd gscd hitcd mcd mcdx \
	sbpcd1 sbpcd2 scd3 sjcd sbpcd3 sonycd sbpcd sbpcd0 \
	atibm inportbm logibm ; do
	rm -f $RPM_BUILD_ROOT/dev/${dev}
	grep -v "/dev/${dev}" manifest > manifest.tmp && mv manifest.tmp manifest
done
%endif

%ifarch ppc ppc64
makedev iseries
makedev nvram
makedev hvc0
%endif

# Skip /dev/log for the sake of upgrades to really old dev packages.
grep -v '/dev/log$' manifest | sort -u > mdmanifest

# Make subdirectories we otherwise would have nothing to do with.
install -d -m 755 $RPM_BUILD_ROOT/dev/pts
install -d -m 755 $RPM_BUILD_ROOT/dev/shm

%if "%{_arch}" != %{_build_arch}
rm -f $RPM_BUILD_ROOT/dev/host-MAKEDEV
%endif

%clean
rm -fr $RPM_BUILD_ROOT

%if "%{_arch}" == %{_build_arch}
%pre
if [ -r /proc/mounts ] ; then
	(while read source mountpoint rest ; do
		if [ "$mountpoint" = /dev ] ; then
			exit 1
		fi
	 done
	 exit 0 ) < /proc/mounts
	MOUNTED=$?
	if [ "$MOUNTED" -ne 0 ] ; then
		echo $"Cannot install the %{name} package: mounted devfs detected."
		exit $MOUNTED
	fi
fi
%endif

%pre -n dev
%if "%{_arch}" == %{_build_arch}
if [ -r /proc/mounts ] ; then
	(while read source mountpoint rest ; do
		if [ "$mountpoint" = /dev ] ; then
			exit 1
		fi
	 done
	 exit 0 ) < /proc/mounts
	MOUNTED=$?
	if [ "$MOUNTED" -ne 0 ] ; then
		echo $"Cannot install the dev package: mounted devfs detected."
		exit $MOUNTED
	fi
fi
%endif

[ -d /dev ] || /bin/mkdir /dev
/usr/sbin/groupadd -g 19 -r -f floppy > /dev/null 2>/dev/null
/usr/sbin/useradd -c "virtual console memory owner" -u 69 \
	-s /sbin/nologin -r -d /dev vcsa 2> /dev/null
exit 0

%post -n dev
%ifnarch s390 s390x
if [ -f /etc/fstab ] ; then
  # add /dev/pts to fstab if fstab exists (install2 does it during install)
  if grep 'devpts' /etc/fstab >/dev/null 2>&1 ; then 
      # correct permissions from broken dev packages
      TMP=$(mktemp /tmp/fstab.XXXXXX)
      sed 's/devpts.*mode=0622/devpts  gid=5,mode=620/g' < /etc/fstab > $TMP && cat $TMP > /etc/fstab || { echo "failed to correct devpts permissions in /etc/fstab" 1>&2 ; exit 1 ; }
      rm -f $TMP
  else
    # note that we do not disallow comments; we wish to allow people
    # to comment it out if they so desire.
    if [ $(grep '/proc' /dev/fstab 2>/dev/null | wc -l) -gt 1 ] ; then
      # ugly but robust
      echo '
none                    /dev/pts                devpts  gid=5,mode=620        0 0' \
        >> /etc/fstab || { echo "failed to add devpts filesystem to /etc/fstab" 1>&2 ; exit 1 ; }
    else
      # beautiful in the common case
      TMP=$(mktemp /tmp/fstab.XXXXXX)
      sed '/\/proc/a\
none                    /dev/pts                devpts  gid=5,mode=620        0 0
          ' < /etc/fstab > $TMP && cat $TMP > /etc/fstab || { echo "failed to add devpts filesystem to /etc/fstab" 1>&2 ; exit 1 ; }
      rm -f $TMP
    fi
  fi
  # add /dev/shm to fstab if fstab exists (install2 does it during install)
  if ! grep 'tmpfs' /etc/fstab >/dev/null 2>&1 ; then 
    # note that we do not disallow comments; we wish to allow people
    # to comment it out if they so desire.
    if [ $(grep '/proc' /dev/fstab 2>/dev/null | wc -l) -gt 1 ] ; then
      # ugly but robust
      echo '
none                    /dev/shm                tmpfs   defaults        0 0' \
        >> /etc/fstab || { echo "failed to add tmpfs filesystem to /etc/fstab" 1>&2 ; exit 1 ; }
    else
      # beautiful in the common case
      TMP=$(mktemp /tmp/fstab.XXXXXX)
      sed '/\/proc/a\
none                    /dev/shm                tmpfs   defaults        0 0
          ' < /etc/fstab > $TMP && cat $TMP > /etc/fstab || { echo "failed to add tmpfs filesystem to /etc/fstab" 1>&2 ; exit 1 ; }
      rm -f $TMP
    fi
  fi
fi
%endif
if [ -x /sbin/pam_console_apply ] ; then
  /sbin/pam_console_apply
fi

%files
%defattr(-,root,root)
%doc COPYING devices.txt
/dev/MAKEDEV
%{_mandir}/man8/*
%{_sbindir}/mksock
%config %{_sysconfdir}/makedev.d

%files -n dev -f mdmanifest
%defattr(-,root,root)
%dir /dev
%ghost /dev/log
%dir /dev/pts
%dir /dev/shm

%changelog
* Mon Feb 23 2004 Nalin Dahyabhai <nalin@redhat.com> 3.3.13-1
- Make MAKEDEV use ":" to separate user and group names in output created when
  invoked with the -S flag (patch by Tim Waugh).

* Wed Jan 21 2004 Phil Knirsch <pknirsch@redhat.com> 3.3.12-1
- Added missing scsi devices for s390(x).

* Wed Jan 21 2004 Phil Knirsch <pknirsch@redhat.com> 3.3.12-1
- Added missing scsi devices for s390(x).

* Tue Jan 20 2004 Phil Knirsch <pknirsch@redhat.com> 3.3.11-1
- Added back the /dev/tty* files on s390(x), needed for expect.

* Mon Jan 12 2004 Nalin Dahyabhai <nalin@redhat.com> 3.3.10-1
- raise the default number of sg devices from 32 to 256 (kernel has no
  hard-coded limit) (#104816)

* Thu Dec 18 2003 Than Ngo <than@redhat.com> 3.3.9-2
- add the correct alsa device name 

* Fri Dec 12 2003 Bill Nottingham <notting@redhat.com> 3.3.9-1
- ALSA device nodes

* Mon Sep 15 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.8-2
- rebuild

* Mon Sep 15 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.8-1
- apply patch from Matt Wilson to raise the number of raw devices from 128
  to 255

* Fri Aug 22 2003 Bill Nottingham <notting@redhat.com> 3.3.7-1
- make /dev/hvc0 a real file

* Fri Aug 15 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.6-2
- rebuild

* Fri Aug 15 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.6-1
- apply patch from Matt Wilson to make /dev/hvc0 a link to iseries/vtty0
- include the nvram and hvc0 devices on ppc/ppc64

* Tue Jun  3 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.5-2
- rebuild

* Tue Jun  3 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.5-1
- finish update to latest devices.txt
  moves /dev/3270/tty* from major 228 to 227
  moves /dev/3270/tub* from major 227 to 228

* Tue May 13 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.4-1
- update to latest devices.txt (renames smapi to thinkpad/thinkpad, adds
  systrace, tpm, pps, etherd/, spi/, usb/usblcd, usb/cpad0)

* Mon Apr 28 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.3-1
- replace libraw1394 config file with newer information from
  www.linux1394.org (#88170)

* Sat Feb 01 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- sanitize dev rpm scripts

* Thu Jan 30 2003 Phil Knirsch <pknirsch@redhat.com>  3.3.2-5
- Removed too many tty devices for s390(x). Fixed.
- Removed mdsp* and logicalco devices for s390(x).

* Wed Jan 29 2003 Phil Knirsch <pknirsch@redhat.com> 3.3.2-3
- Updated number of dasd devices we create for s390(x) (64 now).
- Removed all unecessary /dev/tty?.? entries for s390(x).

* Mon Jan 27 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.2-2
- rebuild

* Wed Jan  8 2003 Nalin Dahyabhai <nalin@redhat.com> 3.3.2-1
- update to latest devices.txt (renames intel_rng to hwrng and adds ttyB*)

* Tue Sep 17 2002 Guy Streeter <streeter@redhat.com>
- include the /dev/iseries devices on ppc64

* Fri Aug 30 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3.1-2
- build nosst devices (#72914)

* Tue Jul 09 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3.1-1
- build the tunnelling device (/dev/net/tun)
- add configuration for libraw1394 (#67203)

* Tue Jul 09 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- fix SPARC build, patch from Jakub Jelinek <jakub@redhat.com>

* Tue May 28 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3-7
- rebuild

* Thu May 16 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3-6
- build 32 scsi generic devices
- add cfs device used by coda

* Thu May  9 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3-5
- resync with current LANANA updates, remove ibcs config file
- resync with usb device list

* Tue Apr 23 2002 Nalin Dahyabhai <nalin@redhat.com>
- resync with current LANANA updates, heads-up from John Cagle
- create kpoll and 16 scramdisk devices

* Thu Apr 11 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3-4
- build the package the same way for the superuser as we did before,
  preventing problems when building as root when some of the device
  owners don't exist on the build host

* Thu Mar 28 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3-3
- set the /dev/vcs* devices to be owned by the vcsa user, and create the
  vcsa user

* Tue Mar 19 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3-2
- rebuild

* Tue Mar 19 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3-1
- handle a step of 0 when creating multiple nodes
- add /dev/cpu/*/microcode (perms 0600) to the dev package

* Thu Feb 21 2002 Nalin Dahyabhai <nalin@redhat.com> 3.2-12
- rebuild

* Thu Jan 31 2002 Nalin Dahyabhai <nalin@redhat.com> 3.2-11
- up the limit on ide devices (hda through hdt) back up from 17 to 33 -- I'm
  told it works now

* Mon Jan 21 2002 Nalin Dahyabhai <nalin@redhat.com> 3.2-10
- build for Raw Hide

* Mon Jan 21 2002 Nalin Dahyabhai <nalin@redhat.com> 3.2-9
- actually create the vsys device

* Mon Jan 21 2002 Nalin Dahyabhai <nalin@redhat.com> 3.2-8
- build for Raw Hide

* Mon Jan 21 2002 Nalin Dahyabhai <nalin@redhat.com> 3.2-7
- aio/vsys rename courtesy of Ben LaHaise

* Thu Aug 30 2001 Nalin Dahyabhai <nalin@redhat.com> 3.2-6
- fix markup errors in the man page (no bug ID, reported by
  esr@snark.thyrsus.com)

* Thu Aug 30 2001 Nalin Dahyabhai <nalin@redhat.com> 3.2-5
- char 10/208 is cpqphpc, not cpqphpcp (#52910)
- add compaq/ devices (#52898)
- add information about raw1394 and video1394 devices (#52736)

* Fri Aug 17 2001 Karsten Hopp <karsten@redhat.de>
- add tape390 devices

* Tue Aug 14 2001 Karsten Hopp <karsten@redhat.de>
- clean up all those ifnarch s390 clauses

* Thu Aug  2 2001 Nalin Dahyabhai <nalin@redhat.com>
- bring in line with devices.txt from 3 June 2001
- create dri devices

* Wed Jul 18 2001 Tim Powers <timp@redhat.com>
- rebuilt using new rpm that actually does %%dev correctly

* Mon Jul 16 2001 Nalin Dahyabhai <nalin@redhat.com>
- tweak the manifest handling to also build when RPM doesn't know
  about them
- add a -S option to spit out shell script snippets
- only claim that we need to create a particular directory once
- fix descriptions for i2o/hdd[i-p], which were wrong
- break generic and architecture-specific sections apart in %%install

* Sun Jul 15 2001 Jeff Johnson <jbj@redhat.com>
- generate device manifest with MAKEDEV -M to build as non-root.

* Wed Jul 11 2001 Bill Nottingham <notting@redhat.com>
- add proper prereqs to dev package for %post (#48769)

* Thu Jul 05 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- disable unneeded parts of post for s390,s390x

* Sun Jul 01 2001 Karsten Hopp <karsten@redhat.de>
- S390-only changes -- added missing devices

* Fri Jun 29 2001 Karsten Hopp <karsten@redhat.de>
- added missing /dev/null on S390

* Wed Jun 27 2001 Nalin Dahyabhai <nalin@redhat.com>
- back out some changes, move documentation for dasd device numbers elsewhere

* Wed Jun 27 2001 Karsten Hopp <karsten@redhat.de>
- move 2 S390 patches into CVS, console-patch has to stay or it
  would break other archs

* Tue Jun 26 2001 Nalin Dahyabhai <nalin@redhat.com>
- create the first four /dev/osst devices (#35833)
- only 7 partitions for DAC960 disks, not 8 (#31484)
- add ataraid device nodes (#44807)
- add a "raid" alias for all raid devices (#33117)
- update the man page

* Tue Jun 26 2001 Bill Nottingham <notting@redhat.com>
- add /dev/shm to fstab too

* Thu Jun 22 2001 Nalin Dahyabhai <nalin@redhat.com>
- own %{_sysconfdir}/makedev.d in addition to files it contains

* Wed Jun 21 2001 Karsten Hopp <karsten@redhat.de>
- correct device naming and major/minor numbers on S390

* Fri Jun  8 2001 Nalin Dahyabhai <nalin@redhat.com>
- fix a bug in creation of leading directories when a format specifier is
  included in the directory's name
- zero-fill the buffer before we pass it to readlink()
- don't try to create /dev/ixj*; the device isn't present in 2.4
- limit number of each device in /dev/input to 32

* Thu May 31 2001 Nalin Dahyabhai <nalin@redhat.com>
- increase the number of lp and parport devices from 3 to 8

* Thu May 24 2001 Nalin Dahyabhai <nalin@redhat.com>
- make apm devices (apm_bios)
- make fancy beeper device (beep)

* Wed Apr 25 2001 Nalin Dahyabhai <nalin@redhat.com>
- only make devices for two floppy drives instead of eight
- limit the number of cui devices to 16 instead of 64
- limit the number isdn and ippp devices to 16
- limit the number of nb devices to 32 (matches md)
- limit the number of st and nst devices to 16

* Fri Mar 23 2001 Nalin Dahyabhai <nalin@redhat.com> 
- make all devices for all RAID controllers again

* Mon Mar 12 2001 Nalin Dahyabhai <nalin@redhat.com> 
- make aliases for ide5 through ide9
- limit the number of console and console-related devices to 32
- run pam_console_apply in the post, if it exists

* Mon Mar  5 2001 Nalin Dahyabhai <nalin@redhat.com> 
- use a file manifest

* Sat Mar  3 2001 Nalin Dahyabhai <nalin@redhat.com> 
- drop the number of hdX devices from 33 to 17, on advice from Andre Hedrick

* Thu Mar  1 2001 Nalin Dahyabhai <nalin@redhat.com> 
- make js0, js1, js2, js3 symlinks into /dev/input so that all programs use
  the new input-core joystick driver instead of the old one

* Mon Feb 26 2001 Nalin Dahyabhai <nalin@redhat.com> 
- detect devfs in the MAKEDEV %%pre, too (#26110)
- fix message in the dev %%pre (#26110)

* Fri Feb 16 2001 Nalin Dahyabhai <nalin@redhat.com> 
- build the netlink device (#15785)

* Sun Feb 11 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- merge in s390 s390x support

* Tue Feb  6 2001 Nalin Dahyabhai <nalin@redhat.com>
- fail to install if %%pre detects devfs

* Thu Jan 25 2001 Nalin Dahyabhai <nalin@redhat.com>
- create /dev in the %%pre script; installing the dev package should fixup
  the permissions, and we can't redirect to /dev/null without it (#24392)

* Thu Jan 18 2001 Nalin Dahyabhai <nalin@redhat.com>
- make /dev/aio world-writable (info from Ben LeHaise)

* Wed Jan 17 2001 Nalin Dahyabhai <nalin@redhat.com>
- add device nodes using the new devices.txt for Linux 2.4.0, and check that
  file into the source tree to make tracking further changes simpler
- change Copyright: GPL to License: GPL
- add a very simple substitution macro facility for specifying ownership and
  permissions in a single place
- add code for creating sockets natively
- remove conflicting data for where /dev/ftape should point to
- remove all raid controller device nodes for second and additional controllers
  (they can be created with MAKEDEV)

* Tue Jan  9 2001 Nalin Dahyabhai <nalin@redhat.com>
- make 32 partition devices for IDE disks instead of 16

* Tue Dec 12 2000 Nalin Dahyabhai <nalin@redhat.com>
- make some ppp devices

* Thu Oct 19 2000 Nalin Dahyabhai <nalin@redhat.com>
- change vcs0 to vcs (ditto for vcsa0)

* Tue Sep 12 2000 Bill Nottingham <notting@redhat.com>
- fixes for some sparc devices that fell out

* Thu Aug 24 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- change some devices that could be used for dialing to root:uucp/0660 perms

* Wed Aug 23 2000 Nalin Dahyabhai <nalin@redhat.com>
- up the number of SCSI CD-ROM devices we know about from 8 to 32, but only
  create 8 at build-time

* Wed Aug 16 2000 Nalin Dahyabhai <nalin@redhat.com>
- remove both temp files generated in the %%post (#16325)

* Mon Aug 14 2000 Nalin Dahyabhai <nalin@redhat.com>
- change the sense of sga/sg0 node/symlink stuff to match kernel docs (#16056)

* Wed Aug  9 2000 Nalin Dahyabhai <nalin@redhat.com>
- add the netlink device, and mark it as undocumented (#15785)
- add /dev/log socket as a ghost using Erik's mksocket
- add in devices that start with "m"
- change /dev/i20 to /dev/i2o
- fix a parser bug

* Tue Aug  8 2000 Nalin Dahyabhai <nalin@redhat.com>
- add cciss device nodes (#14878)

* Mon Aug  7 2000 Crutcher Dunnavant <crutcher@redhat.com>
- make the usb lp? devices group-owned by 'lp'

* Fri Jul 21 2000 Nalin Dahyabhai <nalin@redhat.com>
- make floppy disk devices group-accessible by the floppy group

* Wed Jul 19 2000 Nalin Dahyabhai <nalin@redhat.com>
- stop making bogus symlinks (#14225)
- add "console" alias for tty devices to match man page
- add "qic" alias for tape devices to match man page

* Mon Jul 17 2000 Nalin Dahyabhai <nalin@redhat.com>
- change group of the "lp" devices to "lp"
- comment out the ACSI disks, which probably shouldn't have those names
- incorporate the release number into the tarball file name

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Mon Jul 10 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix symlink creation where both the link and a target are in a subdirectory
- add efirtc in its own "ia64" control file

* Wed Jul  5 2000 Nalin Dahyabhai <nalin@redhat.com>
- add a -i flag so that I can test in a CVS checkout
- use correct IBCS compatibility device entries
- fix symlink creation so that it works as intended

* Tue Jul  4 2000 Matt Wilson <msw@redhat.com>
- moved the Prereq: /usr/sbin/groupadd from the MAKEDEV package to the
  dev package
- added the %%post script to the dev package to add devpts mounting

* Sat Jul  1 2000 Nalin Dahyabhai <nalin@redhat.com>
- make the man page 644, not 755

* Mon Jun 26 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- update from 8 to 16 loop devices

* Mon Jun 26 2000 Nalin Dahyabhai <nalin@redhat.com>
- add input/mice and md devices to the dev package
- limit loop devices to 16 in config files (this is a hard-coded kernel limit)

* Mon Jun 19 2000 Nalin Dahyabhai <nalin@redhat.com>
- add the "floppy" group to the system in the dev package's pre-install

* Mon Jun 11 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix a typo in the devices list
- move non-standard names from linux-2.2 list to redhat list

* Sat Jun 10 2000 Nalin Dahyabhai <nalin@redhat.com>
- FHS packaging for a shiny new version
