/* leds.h: unit-specific leds
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * Modified by Noboru Asai (asai.noboru@jp.panasonic.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef _ASM_UNIT_LEDS_H
#define _ASM_UNIT_LEDS_H

#include <asm/cpu/pio-regs.h>
#include <asm/cpu/cpu-regs.h>
#include <asm/exceptions.h>

#define ASB2303_7SEGLEDS	__SYSREG(0xA6F90000,u32)

/*
 * use the 7-segment LEDs to indicate states
 */

/* flip the 7-segment LEDs between "G" and "-" */
#define mn10300_set_gdbleds(ONOFF)			\
do {							\
	ASB2303_7SEGLEDS = (ONOFF) ? 0x85 : 0x7f;	\
} while(0)

/* indicate double-fault by displaying "d" on the LEDs */
#define mn10300_set_dbfleds			\
	mov	0x43,d0			;	\
	movbu	d0,(ASB2303_7SEGLEDS)

#ifndef __ASSEMBLY__
extern void peripheral_leds_display_exception(exception_code_t code);
extern void peripheral_leds_led_chase(void);
extern void debug_to_serial(const char *p, int n);
#endif /* __ASSEMBLY__ */

#endif /* _ASM_UNIT_LEDS_H */
