/* current.h: current task structure accessor
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_CURRENT_H
#define _ASM_CURRENT_H

#include <linux/thread_info.h>

extern struct task_struct *current, *__current;

static inline struct task_struct *get_current(void) __attribute__((const));

static inline struct task_struct *get_current(void)
{
	return current_thread_info()->task;
}
 
#define current get_current()

#endif /* _ASM_CURRENT_H */
