
#line 1 "hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb-private.hh"


#line 36 "hb-ot-shape-complex-indic-machine.hh"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
	8u, 8u, 1u, 16u, 8u, 13u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 
	7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 
	6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 8u, 8u, 1u, 16u, 8u, 13u, 
	5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 
	7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 
	6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 8u, 8u, 1u, 16u, 8u, 13u, 5u, 8u, 5u, 7u, 7u, 7u, 
	5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 
	7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 
	6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 8u, 8u, 1u, 16u, 
	8u, 13u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 
	16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 5u, 8u, 4u, 14u, 4u, 14u, 5u, 8u, 
	5u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 8u, 8u, 1u, 16u, 8u, 13u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 
	16u, 16u, 8u, 8u, 1u, 19u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 
	3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 
	3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 5u, 14u, 5u, 14u, 
	5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 
	3u, 10u, 5u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	5u, 14u, 3u, 14u, 1u, 16u, 4u, 14u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 17u, 3u, 17u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 
	4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 
	4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 5u, 14u, 5u, 14u, 5u, 10u, 
	9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 3u, 10u, 
	5u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 
	4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 1u, 16u, 4u, 14u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 14u, 1u, 16u, 
	3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 
	3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 
	3u, 17u, 3u, 17u, 4u, 17u, 5u, 14u, 5u, 14u, 5u, 10u, 9u, 10u, 9u, 9u, 
	9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 3u, 10u, 5u, 10u, 3u, 10u, 
	3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 1u, 16u, 
	4u, 14u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 
	3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 14u, 3u, 17u, 4u, 14u, 
	3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 
	3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 
	3u, 17u, 3u, 17u, 4u, 17u, 5u, 14u, 5u, 14u, 5u, 10u, 9u, 10u, 9u, 9u, 
	9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 3u, 10u, 5u, 10u, 3u, 10u, 
	3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 1u, 16u, 
	4u, 14u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 
	3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 1u, 17u, 3u, 17u, 
	1u, 17u, 4u, 14u, 5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 
	5u, 10u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 3u, 17u, 3u, 17u, 1u, 16u, 
	3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 
	5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 13u, 3u, 10u, 5u, 10u, 3u, 10u, 
	3u, 13u, 1u, 16u, 3u, 10u, 5u, 10u, 5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 
	9u, 10u, 9u, 9u, 5u, 10u, 1u, 16u, 0
};

static const char _indic_syllable_machine_key_spans[] = {
	1, 16, 6, 4, 3, 1, 4, 3, 
	1, 4, 3, 1, 4, 3, 1, 5, 
	1, 1, 5, 1, 1, 5, 1, 1, 
	5, 1, 1, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 1, 16, 6, 
	4, 3, 1, 4, 3, 1, 4, 3, 
	1, 4, 3, 1, 5, 1, 1, 5, 
	1, 1, 5, 1, 1, 5, 1, 1, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 1, 16, 6, 4, 3, 1, 
	4, 3, 1, 4, 3, 1, 4, 3, 
	1, 5, 1, 1, 5, 1, 1, 5, 
	1, 1, 5, 1, 1, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 1, 16, 
	6, 4, 3, 1, 4, 3, 1, 4, 
	3, 1, 4, 3, 1, 5, 1, 1, 
	5, 1, 1, 5, 1, 1, 5, 1, 
	1, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 4, 11, 11, 4, 
	3, 4, 3, 1, 4, 3, 1, 4, 
	3, 1, 1, 16, 6, 5, 1, 1, 
	5, 1, 1, 5, 1, 1, 5, 1, 
	1, 1, 19, 15, 15, 14, 16, 15, 
	15, 14, 16, 15, 15, 14, 16, 15, 
	15, 14, 16, 15, 15, 14, 10, 10, 
	6, 2, 1, 2, 2, 1, 6, 11, 
	8, 6, 8, 11, 12, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	10, 12, 16, 11, 15, 15, 16, 16, 
	16, 16, 16, 15, 15, 16, 16, 16, 
	16, 16, 15, 15, 16, 16, 16, 16, 
	16, 15, 15, 16, 16, 16, 16, 16, 
	15, 15, 15, 15, 14, 16, 15, 15, 
	14, 16, 15, 15, 14, 16, 15, 15, 
	14, 16, 15, 15, 14, 10, 10, 6, 
	2, 1, 2, 2, 1, 6, 11, 8, 
	6, 8, 11, 12, 12, 11, 10, 12, 
	11, 10, 12, 11, 10, 12, 11, 10, 
	12, 16, 11, 15, 15, 16, 16, 16, 
	16, 16, 15, 15, 16, 16, 16, 16, 
	16, 15, 15, 16, 16, 16, 16, 16, 
	15, 15, 16, 16, 16, 16, 11, 16, 
	15, 15, 14, 16, 15, 15, 14, 16, 
	15, 15, 14, 16, 15, 15, 14, 16, 
	15, 15, 14, 10, 10, 6, 2, 1, 
	2, 2, 1, 6, 11, 8, 6, 8, 
	11, 12, 12, 11, 10, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 16, 
	11, 15, 15, 16, 16, 16, 16, 16, 
	15, 15, 16, 16, 16, 16, 16, 15, 
	15, 16, 16, 16, 16, 16, 15, 15, 
	16, 16, 16, 16, 16, 11, 15, 11, 
	15, 15, 14, 16, 15, 15, 14, 16, 
	15, 15, 14, 16, 15, 15, 14, 16, 
	15, 15, 14, 10, 10, 6, 2, 1, 
	2, 2, 1, 6, 11, 8, 6, 8, 
	11, 12, 12, 11, 10, 12, 11, 10, 
	12, 11, 10, 12, 11, 10, 12, 16, 
	11, 15, 15, 16, 16, 16, 16, 16, 
	15, 15, 16, 16, 16, 16, 16, 15, 
	15, 16, 16, 16, 16, 16, 15, 15, 
	16, 16, 16, 16, 16, 15, 17, 15, 
	17, 11, 6, 2, 1, 2, 2, 1, 
	6, 16, 15, 15, 14, 15, 15, 16, 
	12, 11, 10, 12, 11, 10, 12, 11, 
	10, 12, 11, 10, 11, 8, 6, 8, 
	11, 16, 8, 6, 6, 2, 1, 2, 
	2, 1, 6, 16
};

static const short _indic_syllable_machine_index_offsets[] = {
	0, 2, 19, 26, 31, 35, 37, 42, 
	46, 48, 53, 57, 59, 64, 68, 70, 
	76, 78, 80, 86, 88, 90, 96, 98, 
	100, 106, 108, 110, 122, 134, 146, 158, 
	170, 182, 194, 206, 218, 230, 232, 249, 
	256, 261, 265, 267, 272, 276, 278, 283, 
	287, 289, 294, 298, 300, 306, 308, 310, 
	316, 318, 320, 326, 328, 330, 336, 338, 
	340, 352, 364, 376, 388, 400, 412, 424, 
	436, 448, 460, 462, 479, 486, 491, 495, 
	497, 502, 506, 508, 513, 517, 519, 524, 
	528, 530, 536, 538, 540, 546, 548, 550, 
	556, 558, 560, 566, 568, 570, 582, 594, 
	606, 618, 630, 642, 654, 666, 678, 680, 
	697, 704, 709, 713, 715, 720, 724, 726, 
	731, 735, 737, 742, 746, 748, 754, 756, 
	758, 764, 766, 768, 774, 776, 778, 784, 
	786, 788, 800, 812, 824, 836, 848, 860, 
	872, 884, 896, 908, 920, 925, 937, 949, 
	954, 958, 963, 967, 969, 974, 978, 980, 
	985, 989, 991, 993, 1010, 1017, 1023, 1025, 
	1027, 1033, 1035, 1037, 1043, 1045, 1047, 1053, 
	1055, 1057, 1059, 1079, 1095, 1111, 1126, 1143, 
	1159, 1175, 1190, 1207, 1223, 1239, 1254, 1271, 
	1287, 1303, 1318, 1335, 1351, 1367, 1382, 1393, 
	1404, 1411, 1414, 1416, 1419, 1422, 1424, 1431, 
	1443, 1452, 1459, 1468, 1480, 1493, 1506, 1518, 
	1529, 1542, 1554, 1565, 1578, 1590, 1601, 1614, 
	1626, 1637, 1650, 1667, 1679, 1695, 1711, 1728, 
	1745, 1762, 1779, 1796, 1812, 1828, 1845, 1862, 
	1879, 1896, 1913, 1929, 1945, 1962, 1979, 1996, 
	2013, 2030, 2046, 2062, 2079, 2096, 2113, 2130, 
	2147, 2163, 2179, 2195, 2211, 2226, 2243, 2259, 
	2275, 2290, 2307, 2323, 2339, 2354, 2371, 2387, 
	2403, 2418, 2435, 2451, 2467, 2482, 2493, 2504, 
	2511, 2514, 2516, 2519, 2522, 2524, 2531, 2543, 
	2552, 2559, 2568, 2580, 2593, 2606, 2618, 2629, 
	2642, 2654, 2665, 2678, 2690, 2701, 2714, 2726, 
	2737, 2750, 2767, 2779, 2795, 2811, 2828, 2845, 
	2862, 2879, 2896, 2912, 2928, 2945, 2962, 2979, 
	2996, 3013, 3029, 3045, 3062, 3079, 3096, 3113, 
	3130, 3146, 3162, 3179, 3196, 3213, 3230, 3242, 
	3259, 3275, 3291, 3306, 3323, 3339, 3355, 3370, 
	3387, 3403, 3419, 3434, 3451, 3467, 3483, 3498, 
	3515, 3531, 3547, 3562, 3573, 3584, 3591, 3594, 
	3596, 3599, 3602, 3604, 3611, 3623, 3632, 3639, 
	3648, 3660, 3673, 3686, 3698, 3709, 3722, 3734, 
	3745, 3758, 3770, 3781, 3794, 3806, 3817, 3830, 
	3847, 3859, 3875, 3891, 3908, 3925, 3942, 3959, 
	3976, 3992, 4008, 4025, 4042, 4059, 4076, 4093, 
	4109, 4125, 4142, 4159, 4176, 4193, 4210, 4226, 
	4242, 4259, 4276, 4293, 4310, 4327, 4339, 4355, 
	4367, 4383, 4399, 4414, 4431, 4447, 4463, 4478, 
	4495, 4511, 4527, 4542, 4559, 4575, 4591, 4606, 
	4623, 4639, 4655, 4670, 4681, 4692, 4699, 4702, 
	4704, 4707, 4710, 4712, 4719, 4731, 4740, 4747, 
	4756, 4768, 4781, 4794, 4806, 4817, 4830, 4842, 
	4853, 4866, 4878, 4889, 4902, 4914, 4925, 4938, 
	4955, 4967, 4983, 4999, 5016, 5033, 5050, 5067, 
	5084, 5100, 5116, 5133, 5150, 5167, 5184, 5201, 
	5217, 5233, 5250, 5267, 5284, 5301, 5318, 5334, 
	5350, 5367, 5384, 5401, 5418, 5435, 5451, 5469, 
	5485, 5503, 5515, 5522, 5525, 5527, 5530, 5533, 
	5535, 5542, 5559, 5575, 5591, 5606, 5622, 5638, 
	5655, 5668, 5680, 5691, 5704, 5716, 5727, 5740, 
	5752, 5763, 5776, 5788, 5799, 5811, 5820, 5827, 
	5836, 5848, 5865, 5874, 5881, 5888, 5891, 5893, 
	5896, 5899, 5901, 5908
};

static const short _indic_syllable_machine_indicies[] = {
	1, 0, 2, 3, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 0, 1, 0, 0, 0, 0, 
	4, 0, 5, 5, 6, 1, 0, 7, 
	7, 6, 0, 6, 0, 8, 8, 9, 
	1, 0, 10, 10, 9, 0, 9, 0, 
	11, 11, 12, 1, 0, 13, 13, 12, 
	0, 12, 0, 14, 14, 15, 1, 0, 
	16, 16, 15, 0, 15, 0, 17, 0, 
	0, 0, 1, 0, 18, 0, 19, 0, 
	20, 14, 14, 15, 1, 0, 21, 0, 
	22, 0, 23, 11, 11, 12, 1, 0, 
	24, 0, 25, 0, 26, 8, 8, 9, 
	1, 0, 27, 0, 28, 0, 29, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	29, 0, 29, 5, 5, 6, 1, 0, 
	0, 0, 0, 30, 29, 0, 31, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	31, 0, 31, 5, 5, 6, 1, 0, 
	0, 0, 0, 32, 31, 0, 33, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	33, 0, 33, 5, 5, 6, 1, 0, 
	0, 0, 0, 34, 33, 0, 35, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	35, 0, 35, 5, 5, 6, 1, 0, 
	0, 0, 0, 36, 35, 0, 37, 5, 
	5, 6, 1, 0, 0, 0, 0, 0, 
	37, 0, 37, 5, 5, 6, 1, 0, 
	0, 0, 0, 38, 37, 0, 40, 39, 
	41, 42, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 41, 
	39, 40, 39, 39, 39, 39, 43, 39, 
	44, 44, 45, 40, 39, 46, 46, 45, 
	39, 45, 39, 47, 47, 48, 40, 39, 
	49, 49, 48, 39, 48, 39, 50, 50, 
	51, 40, 39, 52, 52, 51, 39, 51, 
	39, 53, 53, 54, 40, 39, 55, 55, 
	54, 39, 54, 39, 56, 39, 39, 39, 
	40, 39, 57, 39, 58, 39, 59, 53, 
	53, 54, 40, 39, 60, 39, 61, 39, 
	62, 50, 50, 51, 40, 39, 63, 39, 
	64, 39, 65, 47, 47, 48, 40, 39, 
	66, 39, 67, 39, 68, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 68, 39, 
	68, 44, 44, 45, 40, 39, 39, 39, 
	39, 69, 68, 39, 70, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 70, 39, 
	70, 44, 44, 45, 40, 39, 39, 39, 
	39, 71, 70, 39, 72, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 72, 39, 
	72, 44, 44, 45, 40, 39, 39, 39, 
	39, 73, 72, 39, 74, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 74, 39, 
	74, 44, 44, 45, 40, 39, 39, 39, 
	39, 75, 74, 39, 76, 44, 44, 45, 
	40, 39, 39, 39, 39, 39, 76, 39, 
	76, 44, 44, 45, 40, 39, 39, 39, 
	39, 77, 76, 39, 79, 78, 80, 81, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 78, 80, 78, 79, 
	78, 78, 78, 78, 82, 78, 83, 83, 
	84, 79, 78, 86, 86, 84, 85, 84, 
	85, 87, 87, 88, 79, 78, 89, 89, 
	88, 78, 88, 78, 90, 90, 91, 79, 
	78, 92, 92, 91, 78, 91, 78, 93, 
	93, 94, 79, 78, 95, 95, 94, 78, 
	94, 78, 96, 78, 78, 78, 79, 78, 
	97, 78, 98, 78, 99, 93, 93, 94, 
	79, 78, 100, 78, 101, 78, 102, 90, 
	90, 91, 79, 78, 103, 78, 104, 78, 
	105, 87, 87, 88, 79, 78, 106, 78, 
	107, 78, 108, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 108, 78, 108, 83, 
	83, 84, 79, 78, 78, 78, 78, 109, 
	108, 78, 110, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 110, 78, 110, 83, 
	83, 84, 79, 78, 78, 78, 78, 111, 
	110, 78, 112, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 112, 78, 112, 83, 
	83, 84, 79, 78, 78, 78, 78, 113, 
	112, 78, 114, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 114, 78, 114, 83, 
	83, 84, 79, 78, 78, 78, 78, 115, 
	114, 78, 116, 83, 83, 84, 79, 78, 
	78, 78, 78, 78, 116, 78, 118, 117, 
	119, 120, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 119, 
	117, 118, 117, 117, 117, 117, 121, 117, 
	122, 122, 123, 118, 117, 124, 124, 123, 
	117, 123, 117, 125, 125, 126, 118, 117, 
	127, 127, 126, 117, 126, 117, 128, 128, 
	129, 118, 117, 130, 130, 129, 117, 129, 
	117, 131, 131, 132, 118, 117, 133, 133, 
	132, 117, 132, 117, 134, 117, 117, 117, 
	118, 117, 135, 117, 136, 117, 137, 131, 
	131, 132, 118, 117, 138, 117, 139, 117, 
	140, 128, 128, 129, 118, 117, 141, 117, 
	142, 117, 143, 125, 125, 126, 118, 117, 
	144, 117, 145, 117, 146, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 146, 117, 
	146, 122, 122, 123, 118, 117, 117, 117, 
	117, 147, 146, 117, 148, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 148, 117, 
	148, 122, 122, 123, 118, 117, 117, 117, 
	117, 149, 148, 117, 150, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 150, 117, 
	150, 122, 122, 123, 118, 117, 117, 117, 
	117, 151, 150, 117, 152, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 152, 117, 
	152, 122, 122, 123, 118, 117, 117, 117, 
	117, 153, 152, 117, 154, 122, 122, 123, 
	118, 117, 117, 117, 117, 117, 154, 117, 
	154, 122, 122, 123, 118, 117, 117, 117, 
	117, 155, 154, 117, 116, 83, 83, 84, 
	79, 78, 78, 78, 78, 156, 116, 78, 
	86, 86, 84, 1, 0, 114, 83, 83, 
	84, 157, 0, 0, 0, 0, 0, 114, 
	0, 114, 83, 83, 84, 157, 0, 0, 
	0, 0, 158, 114, 0, 159, 159, 160, 
	1, 0, 7, 7, 160, 0, 161, 161, 
	162, 157, 0, 163, 163, 162, 0, 162, 
	0, 164, 164, 165, 157, 0, 166, 166, 
	165, 0, 165, 0, 167, 167, 168, 157, 
	0, 169, 169, 168, 0, 168, 0, 157, 
	0, 170, 171, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	170, 0, 157, 0, 0, 0, 0, 172, 
	0, 173, 0, 0, 0, 157, 0, 174, 
	0, 175, 0, 176, 167, 167, 168, 157, 
	0, 177, 0, 178, 0, 179, 164, 164, 
	165, 157, 0, 180, 0, 181, 0, 182, 
	161, 161, 162, 157, 0, 183, 0, 184, 
	0, 186, 185, 188, 189, 190, 191, 192, 
	193, 84, 79, 194, 195, 196, 196, 156, 
	197, 198, 199, 200, 201, 202, 187, 204, 
	205, 206, 207, 6, 1, 208, 209, 203, 
	203, 38, 210, 203, 203, 211, 203, 212, 
	205, 213, 213, 6, 1, 208, 209, 203, 
	203, 203, 210, 203, 203, 211, 203, 205, 
	213, 213, 6, 1, 208, 209, 203, 203, 
	203, 210, 203, 203, 211, 203, 214, 203, 
	203, 203, 19, 215, 203, 1, 208, 209, 
	203, 203, 203, 216, 203, 214, 203, 217, 
	218, 219, 220, 6, 1, 208, 209, 203, 
	203, 36, 221, 203, 203, 211, 203, 222, 
	218, 223, 223, 6, 1, 208, 209, 203, 
	203, 203, 221, 203, 203, 211, 203, 218, 
	223, 223, 6, 1, 208, 209, 203, 203, 
	203, 221, 203, 203, 211, 203, 224, 203, 
	203, 203, 19, 225, 203, 1, 208, 209, 
	203, 203, 203, 216, 203, 224, 203, 226, 
	227, 228, 229, 6, 1, 208, 209, 203, 
	203, 34, 230, 203, 203, 211, 203, 231, 
	227, 232, 232, 6, 1, 208, 209, 203, 
	203, 203, 230, 203, 203, 211, 203, 227, 
	232, 232, 6, 1, 208, 209, 203, 203, 
	203, 230, 203, 203, 211, 203, 233, 203, 
	203, 203, 19, 234, 203, 1, 208, 209, 
	203, 203, 203, 216, 203, 233, 203, 235, 
	236, 237, 238, 6, 1, 208, 209, 203, 
	203, 32, 239, 203, 203, 211, 203, 240, 
	236, 241, 241, 6, 1, 208, 209, 203, 
	203, 203, 239, 203, 203, 211, 203, 236, 
	241, 241, 6, 1, 208, 209, 203, 203, 
	203, 239, 203, 203, 211, 203, 242, 203, 
	203, 203, 19, 243, 203, 1, 208, 209, 
	203, 203, 203, 216, 203, 242, 203, 244, 
	245, 246, 247, 6, 1, 208, 209, 203, 
	203, 30, 248, 203, 203, 211, 203, 249, 
	245, 250, 250, 6, 1, 208, 209, 203, 
	203, 203, 248, 203, 203, 211, 203, 245, 
	250, 250, 6, 1, 208, 209, 203, 203, 
	203, 248, 203, 203, 211, 203, 19, 251, 
	203, 1, 208, 209, 203, 203, 203, 216, 
	203, 252, 252, 203, 1, 208, 209, 203, 
	203, 203, 216, 203, 253, 203, 203, 254, 
	208, 209, 203, 208, 209, 203, 255, 203, 
	208, 256, 203, 208, 257, 203, 208, 203, 
	253, 203, 203, 203, 208, 209, 203, 258, 
	203, 259, 260, 203, 1, 208, 209, 203, 
	203, 4, 203, 3, 203, 252, 252, 203, 
	1, 208, 209, 203, 252, 252, 203, 1, 
	208, 209, 203, 258, 203, 252, 252, 203, 
	1, 208, 209, 203, 258, 203, 259, 252, 
	203, 1, 208, 209, 203, 203, 4, 203, 
	19, 203, 261, 261, 6, 1, 208, 209, 
	203, 203, 203, 216, 203, 262, 28, 263, 
	264, 9, 1, 208, 209, 203, 203, 203, 
	216, 203, 28, 263, 264, 9, 1, 208, 
	209, 203, 203, 203, 216, 203, 263, 263, 
	9, 1, 208, 209, 203, 203, 203, 216, 
	203, 265, 25, 266, 267, 12, 1, 208, 
	209, 203, 203, 203, 216, 203, 25, 266, 
	267, 12, 1, 208, 209, 203, 203, 203, 
	216, 203, 266, 266, 12, 1, 208, 209, 
	203, 203, 203, 216, 203, 268, 22, 269, 
	270, 15, 1, 208, 209, 203, 203, 203, 
	216, 203, 22, 269, 270, 15, 1, 208, 
	209, 203, 203, 203, 216, 203, 269, 269, 
	15, 1, 208, 209, 203, 203, 203, 216, 
	203, 271, 19, 252, 272, 203, 1, 208, 
	209, 203, 203, 203, 216, 203, 19, 252, 
	272, 203, 1, 208, 209, 203, 203, 203, 
	216, 203, 252, 273, 203, 1, 208, 209, 
	203, 203, 203, 216, 203, 19, 203, 252, 
	252, 203, 1, 208, 209, 203, 203, 203, 
	216, 203, 2, 3, 203, 203, 19, 251, 
	203, 1, 208, 209, 203, 203, 203, 216, 
	203, 2, 203, 245, 250, 250, 6, 1, 
	208, 209, 203, 203, 203, 248, 203, 244, 
	245, 250, 250, 6, 1, 208, 209, 203, 
	203, 203, 248, 203, 203, 211, 203, 244, 
	245, 246, 250, 6, 1, 208, 209, 203, 
	203, 30, 248, 203, 203, 211, 203, 242, 
	203, 274, 203, 261, 261, 6, 1, 208, 
	209, 203, 203, 203, 216, 203, 242, 203, 
	242, 203, 203, 203, 252, 252, 203, 1, 
	208, 209, 203, 203, 203, 216, 203, 242, 
	203, 242, 203, 203, 203, 252, 275, 203, 
	1, 208, 209, 203, 203, 203, 216, 203, 
	242, 203, 242, 203, 274, 203, 252, 252, 
	203, 1, 208, 209, 203, 203, 203, 216, 
	203, 242, 203, 242, 3, 203, 203, 19, 
	243, 203, 1, 208, 209, 203, 203, 203, 
	216, 203, 242, 203, 235, 236, 241, 241, 
	6, 1, 208, 209, 203, 203, 203, 239, 
	203, 203, 211, 203, 235, 236, 237, 241, 
	6, 1, 208, 209, 203, 203, 32, 239, 
	203, 203, 211, 203, 233, 203, 276, 203, 
	261, 261, 6, 1, 208, 209, 203, 203, 
	203, 216, 203, 233, 203, 233, 203, 203, 
	203, 252, 252, 203, 1, 208, 209, 203, 
	203, 203, 216, 203, 233, 203, 233, 203, 
	203, 203, 252, 277, 203, 1, 208, 209, 
	203, 203, 203, 216, 203, 233, 203, 233, 
	203, 276, 203, 252, 252, 203, 1, 208, 
	209, 203, 203, 203, 216, 203, 233, 203, 
	233, 3, 203, 203, 19, 234, 203, 1, 
	208, 209, 203, 203, 203, 216, 203, 233, 
	203, 226, 227, 232, 232, 6, 1, 208, 
	209, 203, 203, 203, 230, 203, 203, 211, 
	203, 226, 227, 228, 232, 6, 1, 208, 
	209, 203, 203, 34, 230, 203, 203, 211, 
	203, 224, 203, 278, 203, 261, 261, 6, 
	1, 208, 209, 203, 203, 203, 216, 203, 
	224, 203, 224, 203, 203, 203, 252, 252, 
	203, 1, 208, 209, 203, 203, 203, 216, 
	203, 224, 203, 224, 203, 203, 203, 252, 
	279, 203, 1, 208, 209, 203, 203, 203, 
	216, 203, 224, 203, 224, 203, 278, 203, 
	252, 252, 203, 1, 208, 209, 203, 203, 
	203, 216, 203, 224, 203, 224, 3, 203, 
	203, 19, 225, 203, 1, 208, 209, 203, 
	203, 203, 216, 203, 224, 203, 217, 218, 
	223, 223, 6, 1, 208, 209, 203, 203, 
	203, 221, 203, 203, 211, 203, 217, 218, 
	219, 223, 6, 1, 208, 209, 203, 203, 
	36, 221, 203, 203, 211, 203, 214, 203, 
	280, 203, 261, 261, 6, 1, 208, 209, 
	203, 203, 203, 216, 203, 214, 203, 214, 
	203, 203, 203, 252, 252, 203, 1, 208, 
	209, 203, 203, 203, 216, 203, 214, 203, 
	214, 203, 203, 203, 252, 281, 203, 1, 
	208, 209, 203, 203, 203, 216, 203, 214, 
	203, 214, 203, 280, 203, 252, 252, 203, 
	1, 208, 209, 203, 203, 203, 216, 203, 
	214, 203, 214, 3, 203, 203, 19, 215, 
	203, 1, 208, 209, 203, 203, 203, 216, 
	203, 214, 203, 204, 205, 213, 213, 6, 
	1, 208, 209, 203, 203, 203, 210, 203, 
	203, 211, 203, 204, 205, 206, 213, 6, 
	1, 208, 209, 203, 203, 38, 210, 203, 
	203, 211, 203, 283, 284, 285, 286, 45, 
	40, 287, 288, 282, 282, 77, 289, 282, 
	282, 290, 282, 291, 284, 292, 286, 45, 
	40, 287, 288, 282, 282, 282, 289, 282, 
	282, 290, 282, 284, 292, 286, 45, 40, 
	287, 288, 282, 282, 282, 289, 282, 282, 
	290, 282, 293, 282, 282, 282, 58, 294, 
	282, 40, 287, 288, 282, 282, 282, 295, 
	282, 293, 282, 296, 297, 298, 299, 45, 
	40, 287, 288, 282, 282, 75, 300, 282, 
	282, 290, 282, 301, 297, 302, 302, 45, 
	40, 287, 288, 282, 282, 282, 300, 282, 
	282, 290, 282, 297, 302, 302, 45, 40, 
	287, 288, 282, 282, 282, 300, 282, 282, 
	290, 282, 303, 282, 282, 282, 58, 304, 
	282, 40, 287, 288, 282, 282, 282, 295, 
	282, 303, 282, 305, 306, 307, 308, 45, 
	40, 287, 288, 282, 282, 73, 309, 282, 
	282, 290, 282, 310, 306, 311, 311, 45, 
	40, 287, 288, 282, 282, 282, 309, 282, 
	282, 290, 282, 306, 311, 311, 45, 40, 
	287, 288, 282, 282, 282, 309, 282, 282, 
	290, 282, 312, 282, 282, 282, 58, 313, 
	282, 40, 287, 288, 282, 282, 282, 295, 
	282, 312, 282, 314, 315, 316, 317, 45, 
	40, 287, 288, 282, 282, 71, 318, 282, 
	282, 290, 282, 319, 315, 320, 320, 45, 
	40, 287, 288, 282, 282, 282, 318, 282, 
	282, 290, 282, 315, 320, 320, 45, 40, 
	287, 288, 282, 282, 282, 318, 282, 282, 
	290, 282, 321, 282, 282, 282, 58, 322, 
	282, 40, 287, 288, 282, 282, 282, 295, 
	282, 321, 282, 323, 324, 325, 326, 45, 
	40, 287, 288, 282, 282, 69, 327, 282, 
	282, 290, 282, 328, 324, 329, 329, 45, 
	40, 287, 288, 282, 282, 282, 327, 282, 
	282, 290, 282, 324, 329, 329, 45, 40, 
	287, 288, 282, 282, 282, 327, 282, 282, 
	290, 282, 58, 330, 282, 40, 287, 288, 
	282, 282, 282, 295, 282, 331, 331, 282, 
	40, 287, 288, 282, 282, 282, 295, 282, 
	332, 282, 282, 333, 287, 288, 282, 287, 
	288, 282, 334, 282, 287, 335, 282, 287, 
	336, 282, 287, 282, 332, 282, 282, 282, 
	287, 288, 282, 337, 282, 338, 339, 282, 
	40, 287, 288, 282, 282, 43, 282, 42, 
	282, 331, 331, 282, 40, 287, 288, 282, 
	331, 331, 282, 40, 287, 288, 282, 337, 
	282, 331, 331, 282, 40, 287, 288, 282, 
	337, 282, 338, 331, 282, 40, 287, 288, 
	282, 282, 43, 282, 58, 282, 340, 340, 
	45, 40, 287, 288, 282, 282, 282, 295, 
	282, 341, 67, 342, 343, 48, 40, 287, 
	288, 282, 282, 282, 295, 282, 67, 342, 
	343, 48, 40, 287, 288, 282, 282, 282, 
	295, 282, 342, 342, 48, 40, 287, 288, 
	282, 282, 282, 295, 282, 344, 64, 345, 
	346, 51, 40, 287, 288, 282, 282, 282, 
	295, 282, 64, 345, 346, 51, 40, 287, 
	288, 282, 282, 282, 295, 282, 345, 345, 
	51, 40, 287, 288, 282, 282, 282, 295, 
	282, 347, 61, 348, 349, 54, 40, 287, 
	288, 282, 282, 282, 295, 282, 61, 348, 
	349, 54, 40, 287, 288, 282, 282, 282, 
	295, 282, 348, 348, 54, 40, 287, 288, 
	282, 282, 282, 295, 282, 350, 58, 331, 
	351, 282, 40, 287, 288, 282, 282, 282, 
	295, 282, 58, 331, 351, 282, 40, 287, 
	288, 282, 282, 282, 295, 282, 331, 352, 
	282, 40, 287, 288, 282, 282, 282, 295, 
	282, 58, 282, 331, 331, 282, 40, 287, 
	288, 282, 282, 282, 295, 282, 41, 42, 
	282, 282, 58, 330, 282, 40, 287, 288, 
	282, 282, 282, 295, 282, 41, 282, 324, 
	329, 329, 45, 40, 287, 288, 282, 282, 
	282, 327, 282, 323, 324, 329, 329, 45, 
	40, 287, 288, 282, 282, 282, 327, 282, 
	282, 290, 282, 323, 324, 325, 329, 45, 
	40, 287, 288, 282, 282, 69, 327, 282, 
	282, 290, 282, 321, 282, 353, 282, 340, 
	340, 45, 40, 287, 288, 282, 282, 282, 
	295, 282, 321, 282, 321, 282, 282, 282, 
	331, 331, 282, 40, 287, 288, 282, 282, 
	282, 295, 282, 321, 282, 321, 282, 282, 
	282, 331, 354, 282, 40, 287, 288, 282, 
	282, 282, 295, 282, 321, 282, 321, 282, 
	353, 282, 331, 331, 282, 40, 287, 288, 
	282, 282, 282, 295, 282, 321, 282, 321, 
	42, 282, 282, 58, 322, 282, 40, 287, 
	288, 282, 282, 282, 295, 282, 321, 282, 
	314, 315, 320, 320, 45, 40, 287, 288, 
	282, 282, 282, 318, 282, 282, 290, 282, 
	314, 315, 316, 320, 45, 40, 287, 288, 
	282, 282, 71, 318, 282, 282, 290, 282, 
	312, 282, 355, 282, 340, 340, 45, 40, 
	287, 288, 282, 282, 282, 295, 282, 312, 
	282, 312, 282, 282, 282, 331, 331, 282, 
	40, 287, 288, 282, 282, 282, 295, 282, 
	312, 282, 312, 282, 282, 282, 331, 356, 
	282, 40, 287, 288, 282, 282, 282, 295, 
	282, 312, 282, 312, 282, 355, 282, 331, 
	331, 282, 40, 287, 288, 282, 282, 282, 
	295, 282, 312, 282, 312, 42, 282, 282, 
	58, 313, 282, 40, 287, 288, 282, 282, 
	282, 295, 282, 312, 282, 305, 306, 311, 
	311, 45, 40, 287, 288, 282, 282, 282, 
	309, 282, 282, 290, 282, 305, 306, 307, 
	311, 45, 40, 287, 288, 282, 282, 73, 
	309, 282, 282, 290, 282, 303, 282, 357, 
	282, 340, 340, 45, 40, 287, 288, 282, 
	282, 282, 295, 282, 303, 282, 303, 282, 
	282, 282, 331, 331, 282, 40, 287, 288, 
	282, 282, 282, 295, 282, 303, 282, 303, 
	282, 282, 282, 331, 358, 282, 40, 287, 
	288, 282, 282, 282, 295, 282, 303, 282, 
	303, 282, 357, 282, 331, 331, 282, 40, 
	287, 288, 282, 282, 282, 295, 282, 303, 
	282, 303, 42, 282, 282, 58, 304, 282, 
	40, 287, 288, 282, 282, 282, 295, 282, 
	303, 282, 296, 297, 302, 302, 45, 40, 
	287, 288, 282, 282, 282, 300, 282, 282, 
	290, 282, 296, 297, 298, 302, 45, 40, 
	287, 288, 282, 282, 75, 300, 282, 282, 
	290, 282, 293, 282, 359, 282, 340, 340, 
	45, 40, 287, 288, 282, 282, 282, 295, 
	282, 293, 282, 293, 282, 282, 282, 331, 
	331, 282, 40, 287, 288, 282, 282, 282, 
	295, 282, 293, 282, 293, 282, 282, 282, 
	331, 360, 282, 40, 287, 288, 282, 282, 
	282, 295, 282, 293, 282, 293, 282, 359, 
	282, 331, 331, 282, 40, 287, 288, 282, 
	282, 282, 295, 282, 293, 282, 76, 44, 
	44, 45, 40, 282, 282, 282, 282, 282, 
	76, 282, 293, 42, 282, 282, 58, 294, 
	282, 40, 287, 288, 282, 282, 282, 295, 
	282, 293, 282, 283, 284, 292, 286, 45, 
	40, 287, 288, 282, 282, 282, 289, 282, 
	282, 290, 282, 362, 191, 363, 363, 84, 
	79, 194, 195, 361, 361, 361, 197, 361, 
	361, 200, 361, 191, 363, 363, 84, 79, 
	194, 195, 361, 361, 361, 197, 361, 361, 
	200, 361, 364, 361, 361, 361, 98, 365, 
	361, 79, 194, 195, 361, 361, 361, 366, 
	361, 364, 361, 367, 368, 369, 370, 84, 
	79, 194, 195, 361, 361, 115, 371, 361, 
	361, 200, 361, 372, 368, 373, 373, 84, 
	79, 194, 195, 361, 361, 361, 371, 361, 
	361, 200, 361, 368, 373, 373, 84, 79, 
	194, 195, 361, 361, 361, 371, 361, 361, 
	200, 361, 374, 361, 361, 361, 98, 375, 
	361, 79, 194, 195, 361, 361, 361, 366, 
	361, 374, 361, 376, 377, 378, 379, 84, 
	79, 194, 195, 361, 361, 113, 380, 361, 
	361, 200, 361, 381, 377, 382, 382, 84, 
	79, 194, 195, 361, 361, 361, 380, 361, 
	361, 200, 361, 377, 382, 382, 84, 79, 
	194, 195, 361, 361, 361, 380, 361, 361, 
	200, 361, 383, 361, 361, 361, 98, 384, 
	361, 79, 194, 195, 361, 361, 361, 366, 
	361, 383, 361, 385, 386, 387, 388, 84, 
	79, 194, 195, 361, 361, 111, 389, 361, 
	361, 200, 361, 390, 386, 391, 391, 84, 
	79, 194, 195, 361, 361, 361, 389, 361, 
	361, 200, 361, 386, 391, 391, 84, 79, 
	194, 195, 361, 361, 361, 389, 361, 361, 
	200, 361, 392, 361, 361, 361, 98, 393, 
	361, 79, 194, 195, 361, 361, 361, 366, 
	361, 392, 361, 394, 395, 396, 397, 84, 
	79, 194, 195, 361, 361, 109, 398, 361, 
	361, 200, 361, 399, 395, 400, 400, 84, 
	79, 194, 195, 361, 361, 361, 398, 361, 
	361, 200, 361, 395, 400, 400, 84, 79, 
	194, 195, 361, 361, 361, 398, 361, 361, 
	200, 361, 98, 401, 361, 79, 194, 195, 
	361, 361, 361, 366, 361, 402, 402, 361, 
	79, 194, 195, 361, 361, 361, 366, 361, 
	403, 361, 361, 404, 194, 195, 361, 194, 
	195, 361, 405, 361, 194, 406, 361, 194, 
	407, 361, 194, 361, 403, 361, 361, 361, 
	194, 195, 361, 408, 361, 409, 410, 361, 
	79, 194, 195, 361, 361, 82, 361, 81, 
	361, 402, 402, 361, 79, 194, 195, 361, 
	402, 402, 361, 79, 194, 195, 361, 408, 
	361, 402, 402, 361, 79, 194, 195, 361, 
	408, 361, 409, 402, 361, 79, 194, 195, 
	361, 361, 82, 361, 98, 361, 411, 411, 
	84, 79, 194, 195, 361, 361, 361, 366, 
	361, 412, 107, 413, 414, 88, 79, 194, 
	195, 361, 361, 361, 366, 361, 107, 413, 
	414, 88, 79, 194, 195, 361, 361, 361, 
	366, 361, 413, 413, 88, 79, 194, 195, 
	361, 361, 361, 366, 361, 415, 104, 416, 
	417, 91, 79, 194, 195, 361, 361, 361, 
	366, 361, 104, 416, 417, 91, 79, 194, 
	195, 361, 361, 361, 366, 361, 416, 416, 
	91, 79, 194, 195, 361, 361, 361, 366, 
	361, 418, 101, 419, 420, 94, 79, 194, 
	195, 361, 361, 361, 366, 361, 101, 419, 
	420, 94, 79, 194, 195, 361, 361, 361, 
	366, 361, 419, 419, 94, 79, 194, 195, 
	361, 361, 361, 366, 361, 421, 98, 402, 
	422, 361, 79, 194, 195, 361, 361, 361, 
	366, 361, 98, 402, 422, 361, 79, 194, 
	195, 361, 361, 361, 366, 361, 402, 423, 
	361, 79, 194, 195, 361, 361, 361, 366, 
	361, 98, 361, 402, 402, 361, 79, 194, 
	195, 361, 361, 361, 366, 361, 80, 81, 
	361, 361, 98, 401, 361, 79, 194, 195, 
	361, 361, 361, 366, 361, 80, 361, 395, 
	400, 400, 84, 79, 194, 195, 361, 361, 
	361, 398, 361, 394, 395, 400, 400, 84, 
	79, 194, 195, 361, 361, 361, 398, 361, 
	361, 200, 361, 394, 395, 396, 400, 84, 
	79, 194, 195, 361, 361, 109, 398, 361, 
	361, 200, 361, 392, 361, 424, 361, 411, 
	411, 84, 79, 194, 195, 361, 361, 361, 
	366, 361, 392, 361, 392, 361, 361, 361, 
	402, 402, 361, 79, 194, 195, 361, 361, 
	361, 366, 361, 392, 361, 392, 361, 361, 
	361, 402, 425, 361, 79, 194, 195, 361, 
	361, 361, 366, 361, 392, 361, 392, 361, 
	424, 361, 402, 402, 361, 79, 194, 195, 
	361, 361, 361, 366, 361, 392, 361, 392, 
	81, 361, 361, 98, 393, 361, 79, 194, 
	195, 361, 361, 361, 366, 361, 392, 361, 
	385, 386, 391, 391, 84, 79, 194, 195, 
	361, 361, 361, 389, 361, 361, 200, 361, 
	385, 386, 387, 391, 84, 79, 194, 195, 
	361, 361, 111, 389, 361, 361, 200, 361, 
	383, 361, 426, 361, 411, 411, 84, 79, 
	194, 195, 361, 361, 361, 366, 361, 383, 
	361, 383, 361, 361, 361, 402, 402, 361, 
	79, 194, 195, 361, 361, 361, 366, 361, 
	383, 361, 383, 361, 361, 361, 402, 427, 
	361, 79, 194, 195, 361, 361, 361, 366, 
	361, 383, 361, 383, 361, 426, 361, 402, 
	402, 361, 79, 194, 195, 361, 361, 361, 
	366, 361, 383, 361, 383, 81, 361, 361, 
	98, 384, 361, 79, 194, 195, 361, 361, 
	361, 366, 361, 383, 361, 376, 377, 382, 
	382, 84, 79, 194, 195, 361, 361, 361, 
	380, 361, 361, 200, 361, 376, 377, 378, 
	382, 84, 79, 194, 195, 361, 361, 113, 
	380, 361, 361, 200, 361, 374, 361, 428, 
	361, 411, 411, 84, 79, 194, 195, 361, 
	361, 361, 366, 361, 374, 361, 374, 361, 
	361, 361, 402, 402, 361, 79, 194, 195, 
	361, 361, 361, 366, 361, 374, 361, 374, 
	361, 361, 361, 402, 429, 361, 79, 194, 
	195, 361, 361, 361, 366, 361, 374, 361, 
	374, 361, 428, 361, 402, 402, 361, 79, 
	194, 195, 361, 361, 361, 366, 361, 374, 
	361, 374, 81, 361, 361, 98, 375, 361, 
	79, 194, 195, 361, 361, 361, 366, 361, 
	374, 361, 367, 368, 373, 373, 84, 79, 
	194, 195, 361, 361, 361, 371, 361, 361, 
	200, 361, 367, 368, 369, 373, 84, 79, 
	194, 195, 361, 361, 115, 371, 361, 361, 
	200, 361, 364, 361, 430, 361, 411, 411, 
	84, 79, 194, 195, 361, 361, 361, 366, 
	361, 364, 361, 364, 361, 361, 361, 402, 
	402, 361, 79, 194, 195, 361, 361, 361, 
	366, 361, 364, 361, 364, 361, 361, 361, 
	402, 431, 361, 79, 194, 195, 361, 361, 
	361, 366, 361, 364, 361, 364, 361, 430, 
	361, 402, 402, 361, 79, 194, 195, 361, 
	361, 361, 366, 361, 364, 361, 364, 81, 
	361, 361, 98, 365, 361, 79, 194, 195, 
	361, 361, 361, 366, 361, 364, 361, 116, 
	83, 83, 84, 79, 432, 432, 432, 432, 
	156, 116, 432, 190, 191, 363, 363, 84, 
	79, 194, 195, 361, 361, 361, 197, 361, 
	361, 200, 361, 116, 83, 83, 84, 79, 
	432, 432, 432, 432, 432, 116, 432, 434, 
	435, 436, 437, 123, 118, 438, 439, 433, 
	433, 155, 440, 433, 433, 441, 433, 442, 
	435, 437, 437, 123, 118, 438, 439, 433, 
	433, 433, 440, 433, 433, 441, 433, 435, 
	437, 437, 123, 118, 438, 439, 433, 433, 
	433, 440, 433, 433, 441, 433, 443, 433, 
	433, 433, 136, 444, 433, 118, 438, 439, 
	433, 433, 433, 445, 433, 443, 433, 446, 
	447, 448, 449, 123, 118, 438, 439, 433, 
	433, 153, 450, 433, 433, 441, 433, 451, 
	447, 452, 452, 123, 118, 438, 439, 433, 
	433, 433, 450, 433, 433, 441, 433, 447, 
	452, 452, 123, 118, 438, 439, 433, 433, 
	433, 450, 433, 433, 441, 433, 453, 433, 
	433, 433, 136, 454, 433, 118, 438, 439, 
	433, 433, 433, 445, 433, 453, 433, 455, 
	456, 457, 458, 123, 118, 438, 439, 433, 
	433, 151, 459, 433, 433, 441, 433, 460, 
	456, 461, 461, 123, 118, 438, 439, 433, 
	433, 433, 459, 433, 433, 441, 433, 456, 
	461, 461, 123, 118, 438, 439, 433, 433, 
	433, 459, 433, 433, 441, 433, 462, 433, 
	433, 433, 136, 463, 433, 118, 438, 439, 
	433, 433, 433, 445, 433, 462, 433, 464, 
	465, 466, 467, 123, 118, 438, 439, 433, 
	433, 149, 468, 433, 433, 441, 433, 469, 
	465, 470, 470, 123, 118, 438, 439, 433, 
	433, 433, 468, 433, 433, 441, 433, 465, 
	470, 470, 123, 118, 438, 439, 433, 433, 
	433, 468, 433, 433, 441, 433, 471, 433, 
	433, 433, 136, 472, 433, 118, 438, 439, 
	433, 433, 433, 445, 433, 471, 433, 473, 
	474, 475, 476, 123, 118, 438, 439, 433, 
	433, 147, 477, 433, 433, 441, 433, 478, 
	474, 479, 479, 123, 118, 438, 439, 433, 
	433, 433, 477, 433, 433, 441, 433, 474, 
	479, 479, 123, 118, 438, 439, 433, 433, 
	433, 477, 433, 433, 441, 433, 136, 480, 
	433, 118, 438, 439, 433, 433, 433, 445, 
	433, 481, 481, 433, 118, 438, 439, 433, 
	433, 433, 445, 433, 482, 433, 433, 483, 
	438, 439, 433, 438, 439, 433, 484, 433, 
	438, 485, 433, 438, 486, 433, 438, 433, 
	482, 433, 433, 433, 438, 439, 433, 487, 
	433, 488, 489, 433, 118, 438, 439, 433, 
	433, 121, 433, 120, 433, 481, 481, 433, 
	118, 438, 439, 433, 481, 481, 433, 118, 
	438, 439, 433, 487, 433, 481, 481, 433, 
	118, 438, 439, 433, 487, 433, 488, 481, 
	433, 118, 438, 439, 433, 433, 121, 433, 
	136, 433, 490, 490, 123, 118, 438, 439, 
	433, 433, 433, 445, 433, 491, 145, 492, 
	493, 126, 118, 438, 439, 433, 433, 433, 
	445, 433, 145, 492, 493, 126, 118, 438, 
	439, 433, 433, 433, 445, 433, 492, 492, 
	126, 118, 438, 439, 433, 433, 433, 445, 
	433, 494, 142, 495, 496, 129, 118, 438, 
	439, 433, 433, 433, 445, 433, 142, 495, 
	496, 129, 118, 438, 439, 433, 433, 433, 
	445, 433, 495, 495, 129, 118, 438, 439, 
	433, 433, 433, 445, 433, 497, 139, 498, 
	499, 132, 118, 438, 439, 433, 433, 433, 
	445, 433, 139, 498, 499, 132, 118, 438, 
	439, 433, 433, 433, 445, 433, 498, 498, 
	132, 118, 438, 439, 433, 433, 433, 445, 
	433, 500, 136, 481, 501, 433, 118, 438, 
	439, 433, 433, 433, 445, 433, 136, 481, 
	501, 433, 118, 438, 439, 433, 433, 433, 
	445, 433, 481, 502, 433, 118, 438, 439, 
	433, 433, 433, 445, 433, 136, 433, 481, 
	481, 433, 118, 438, 439, 433, 433, 433, 
	445, 433, 119, 120, 433, 433, 136, 480, 
	433, 118, 438, 439, 433, 433, 433, 445, 
	433, 119, 433, 474, 479, 479, 123, 118, 
	438, 439, 433, 433, 433, 477, 433, 473, 
	474, 479, 479, 123, 118, 438, 439, 433, 
	433, 433, 477, 433, 433, 441, 433, 473, 
	474, 475, 479, 123, 118, 438, 439, 433, 
	433, 147, 477, 433, 433, 441, 433, 471, 
	433, 503, 433, 490, 490, 123, 118, 438, 
	439, 433, 433, 433, 445, 433, 471, 433, 
	471, 433, 433, 433, 481, 481, 433, 118, 
	438, 439, 433, 433, 433, 445, 433, 471, 
	433, 471, 433, 433, 433, 481, 504, 433, 
	118, 438, 439, 433, 433, 433, 445, 433, 
	471, 433, 471, 433, 503, 433, 481, 481, 
	433, 118, 438, 439, 433, 433, 433, 445, 
	433, 471, 433, 471, 120, 433, 433, 136, 
	472, 433, 118, 438, 439, 433, 433, 433, 
	445, 433, 471, 433, 464, 465, 470, 470, 
	123, 118, 438, 439, 433, 433, 433, 468, 
	433, 433, 441, 433, 464, 465, 466, 470, 
	123, 118, 438, 439, 433, 433, 149, 468, 
	433, 433, 441, 433, 462, 433, 505, 433, 
	490, 490, 123, 118, 438, 439, 433, 433, 
	433, 445, 433, 462, 433, 462, 433, 433, 
	433, 481, 481, 433, 118, 438, 439, 433, 
	433, 433, 445, 433, 462, 433, 462, 433, 
	433, 433, 481, 506, 433, 118, 438, 439, 
	433, 433, 433, 445, 433, 462, 433, 462, 
	433, 505, 433, 481, 481, 433, 118, 438, 
	439, 433, 433, 433, 445, 433, 462, 433, 
	462, 120, 433, 433, 136, 463, 433, 118, 
	438, 439, 433, 433, 433, 445, 433, 462, 
	433, 455, 456, 461, 461, 123, 118, 438, 
	439, 433, 433, 433, 459, 433, 433, 441, 
	433, 455, 456, 457, 461, 123, 118, 438, 
	439, 433, 433, 151, 459, 433, 433, 441, 
	433, 453, 433, 507, 433, 490, 490, 123, 
	118, 438, 439, 433, 433, 433, 445, 433, 
	453, 433, 453, 433, 433, 433, 481, 481, 
	433, 118, 438, 439, 433, 433, 433, 445, 
	433, 453, 433, 453, 433, 433, 433, 481, 
	508, 433, 118, 438, 439, 433, 433, 433, 
	445, 433, 453, 433, 453, 433, 507, 433, 
	481, 481, 433, 118, 438, 439, 433, 433, 
	433, 445, 433, 453, 433, 453, 120, 433, 
	433, 136, 454, 433, 118, 438, 439, 433, 
	433, 433, 445, 433, 453, 433, 446, 447, 
	452, 452, 123, 118, 438, 439, 433, 433, 
	433, 450, 433, 433, 441, 433, 446, 447, 
	448, 452, 123, 118, 438, 439, 433, 433, 
	153, 450, 433, 433, 441, 433, 443, 433, 
	509, 433, 490, 490, 123, 118, 438, 439, 
	433, 433, 433, 445, 433, 443, 433, 443, 
	433, 433, 433, 481, 481, 433, 118, 438, 
	439, 433, 433, 433, 445, 433, 443, 433, 
	443, 433, 433, 433, 481, 510, 433, 118, 
	438, 439, 433, 433, 433, 445, 433, 443, 
	433, 443, 433, 509, 433, 481, 481, 433, 
	118, 438, 439, 433, 433, 433, 445, 433, 
	443, 433, 443, 120, 433, 433, 136, 444, 
	433, 118, 438, 439, 433, 433, 433, 445, 
	433, 443, 433, 434, 435, 437, 437, 123, 
	118, 438, 439, 433, 433, 433, 440, 433, 
	433, 441, 433, 188, 189, 190, 191, 511, 
	363, 84, 79, 194, 195, 196, 196, 156, 
	197, 361, 188, 200, 361, 204, 512, 206, 
	207, 6, 1, 208, 209, 203, 203, 38, 
	210, 203, 203, 211, 203, 214, 189, 190, 
	191, 513, 514, 84, 157, 515, 516, 203, 
	196, 156, 517, 203, 214, 200, 203, 116, 
	518, 518, 84, 157, 208, 209, 203, 203, 
	156, 519, 203, 520, 203, 203, 521, 515, 
	516, 203, 515, 516, 203, 255, 203, 515, 
	522, 203, 515, 523, 203, 515, 203, 520, 
	203, 203, 203, 515, 516, 203, 524, 3, 
	361, 361, 402, 431, 361, 79, 194, 195, 
	361, 361, 361, 366, 361, 524, 361, 525, 
	368, 526, 527, 84, 157, 515, 516, 203, 
	203, 158, 371, 203, 203, 200, 203, 528, 
	368, 529, 529, 84, 157, 515, 516, 203, 
	203, 203, 371, 203, 203, 200, 203, 368, 
	529, 529, 84, 157, 515, 516, 203, 203, 
	203, 371, 203, 203, 200, 203, 525, 368, 
	529, 529, 84, 157, 515, 516, 203, 203, 
	203, 371, 203, 203, 200, 203, 525, 368, 
	526, 529, 84, 157, 515, 516, 203, 203, 
	158, 371, 203, 203, 200, 203, 214, 203, 
	280, 116, 530, 530, 160, 157, 208, 209, 
	203, 203, 203, 519, 203, 214, 203, 531, 
	184, 532, 533, 162, 157, 515, 516, 203, 
	203, 203, 534, 203, 184, 532, 533, 162, 
	157, 515, 516, 203, 203, 203, 534, 203, 
	532, 532, 162, 157, 515, 516, 203, 203, 
	203, 534, 203, 535, 181, 536, 537, 165, 
	157, 515, 516, 203, 203, 203, 534, 203, 
	181, 536, 537, 165, 157, 515, 516, 203, 
	203, 203, 534, 203, 536, 536, 165, 157, 
	515, 516, 203, 203, 203, 534, 203, 538, 
	178, 539, 540, 168, 157, 515, 516, 203, 
	203, 203, 534, 203, 178, 539, 540, 168, 
	157, 515, 516, 203, 203, 203, 534, 203, 
	539, 539, 168, 157, 515, 516, 203, 203, 
	203, 534, 203, 541, 175, 542, 543, 203, 
	157, 515, 516, 203, 203, 203, 534, 203, 
	175, 542, 543, 203, 157, 515, 516, 203, 
	203, 203, 534, 203, 542, 542, 203, 157, 
	515, 516, 203, 203, 203, 534, 203, 544, 
	203, 545, 546, 203, 157, 515, 516, 203, 
	203, 172, 203, 171, 203, 542, 542, 203, 
	157, 515, 516, 203, 542, 542, 203, 157, 
	515, 516, 203, 544, 203, 542, 542, 203, 
	157, 515, 516, 203, 544, 203, 545, 542, 
	203, 157, 515, 516, 203, 203, 172, 203, 
	524, 171, 361, 361, 98, 365, 361, 79, 
	194, 195, 361, 361, 361, 366, 361, 524, 
	361, 548, 547, 549, 549, 547, 186, 550, 
	551, 547, 549, 549, 547, 186, 550, 551, 
	547, 552, 547, 547, 553, 550, 551, 547, 
	550, 551, 547, 554, 547, 550, 555, 547, 
	550, 556, 547, 550, 547, 552, 547, 547, 
	547, 550, 551, 547, 188, 432, 432, 432, 
	432, 432, 432, 432, 432, 432, 196, 432, 
	432, 432, 432, 188, 432, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
	178, 200, 207, 209, 210, 4, 213, 5, 
	7, 216, 8, 10, 219, 11, 13, 222, 
	14, 16, 17, 199, 19, 20, 221, 22, 
	23, 218, 25, 26, 215, 224, 228, 232, 
	235, 239, 242, 246, 249, 253, 256, 178, 
	279, 286, 288, 289, 41, 292, 42, 44, 
	295, 45, 47, 298, 48, 50, 301, 51, 
	53, 54, 278, 56, 57, 300, 59, 60, 
	297, 62, 63, 294, 303, 307, 311, 314, 
	318, 321, 325, 328, 332, 336, 178, 357, 
	364, 366, 367, 78, 370, 178, 79, 81, 
	373, 82, 84, 376, 85, 87, 379, 88, 
	90, 91, 356, 93, 94, 378, 96, 97, 
	375, 99, 100, 372, 381, 385, 389, 392, 
	396, 399, 403, 406, 410, 178, 437, 444, 
	446, 447, 114, 450, 115, 117, 453, 118, 
	120, 456, 121, 123, 459, 124, 126, 127, 
	436, 129, 130, 458, 132, 133, 455, 135, 
	136, 452, 461, 465, 469, 472, 476, 479, 
	483, 486, 490, 493, 414, 498, 509, 152, 
	512, 154, 515, 155, 157, 518, 158, 160, 
	521, 161, 524, 526, 527, 166, 167, 523, 
	169, 170, 520, 172, 173, 517, 175, 176, 
	514, 178, 532, 178, 179, 258, 337, 339, 
	413, 415, 359, 360, 416, 412, 494, 495, 
	384, 530, 539, 178, 180, 182, 36, 257, 
	202, 203, 255, 227, 181, 35, 183, 251, 
	1, 184, 186, 34, 250, 248, 185, 33, 
	187, 244, 188, 190, 32, 243, 241, 189, 
	31, 191, 237, 192, 194, 30, 236, 234, 
	193, 29, 195, 230, 196, 198, 28, 229, 
	226, 197, 27, 212, 0, 201, 206, 178, 
	204, 205, 208, 2, 211, 3, 214, 6, 
	24, 217, 9, 21, 220, 12, 18, 223, 
	15, 225, 231, 233, 238, 240, 245, 247, 
	252, 254, 178, 259, 261, 73, 334, 281, 
	282, 335, 306, 260, 72, 262, 330, 38, 
	263, 265, 71, 329, 327, 264, 70, 266, 
	323, 267, 269, 69, 322, 320, 268, 68, 
	270, 316, 271, 273, 67, 315, 313, 272, 
	66, 274, 309, 275, 277, 65, 308, 305, 
	276, 64, 291, 37, 280, 285, 178, 283, 
	284, 287, 39, 290, 40, 293, 43, 61, 
	296, 46, 58, 299, 49, 55, 302, 52, 
	304, 310, 312, 317, 319, 324, 326, 331, 
	333, 178, 338, 109, 340, 408, 75, 341, 
	343, 108, 407, 405, 342, 107, 344, 401, 
	345, 347, 106, 400, 398, 346, 105, 348, 
	394, 349, 351, 104, 393, 391, 350, 103, 
	352, 387, 353, 355, 102, 386, 383, 354, 
	101, 369, 74, 358, 363, 178, 361, 362, 
	365, 76, 368, 77, 371, 80, 98, 374, 
	83, 95, 377, 86, 92, 380, 89, 382, 
	388, 390, 395, 397, 402, 404, 409, 411, 
	178, 178, 417, 419, 146, 145, 439, 440, 
	492, 464, 418, 420, 488, 111, 421, 423, 
	144, 487, 485, 422, 143, 424, 481, 425, 
	427, 142, 480, 478, 426, 141, 428, 474, 
	429, 431, 140, 473, 471, 430, 139, 432, 
	467, 433, 435, 138, 466, 463, 434, 137, 
	449, 110, 438, 443, 178, 441, 442, 445, 
	112, 448, 113, 451, 116, 134, 454, 119, 
	131, 457, 122, 128, 460, 125, 462, 468, 
	470, 475, 477, 482, 484, 489, 491, 147, 
	496, 497, 511, 500, 501, 529, 148, 505, 
	499, 504, 502, 503, 506, 507, 150, 510, 
	508, 149, 151, 513, 153, 174, 163, 516, 
	156, 171, 519, 159, 168, 522, 162, 165, 
	525, 164, 528, 178, 531, 177, 534, 535, 
	533, 538, 178, 536, 537
};

static const char _indic_syllable_machine_trans_actions[] = {
	1, 0, 2, 2, 2, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	0, 2, 2, 2, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 4, 0, 
	2, 2, 2, 0, 2, 5, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 2, 6, 2, 6, 
	2, 6, 2, 6, 2, 7, 0, 2, 
	2, 2, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 6, 0, 8, 0, 
	2, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 9, 0, 12, 2, 2, 6, 2, 
	13, 13, 0, 0, 2, 2, 6, 2, 
	6, 2, 0, 14, 2, 2, 0, 2, 
	0, 0, 2, 2, 2, 0, 2, 2, 
	0, 2, 2, 0, 2, 2, 2, 0, 
	2, 2, 2, 2, 0, 2, 2, 2, 
	0, 2, 2, 2, 2, 0, 2, 2, 
	2, 0, 2, 2, 2, 2, 0, 2, 
	2, 2, 0, 2, 0, 0, 0, 15, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 16, 2, 2, 0, 2, 0, 
	0, 2, 2, 2, 0, 2, 2, 0, 
	2, 2, 0, 2, 2, 2, 0, 2, 
	2, 2, 2, 0, 2, 2, 2, 0, 
	2, 2, 2, 2, 0, 2, 2, 2, 
	0, 2, 2, 2, 2, 0, 2, 2, 
	2, 0, 2, 0, 0, 0, 17, 0, 
	0, 2, 0, 2, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 18, 6, 0, 6, 6, 0, 6, 
	2, 0, 6, 2, 6, 0, 6, 6, 
	6, 2, 0, 6, 2, 6, 0, 6, 
	6, 6, 2, 0, 6, 2, 6, 0, 
	6, 6, 6, 2, 0, 6, 2, 6, 
	0, 6, 0, 0, 0, 19, 0, 0, 
	2, 0, 2, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	20, 21, 2, 2, 0, 0, 0, 0, 
	2, 2, 2, 2, 2, 0, 2, 2, 
	0, 2, 2, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 2, 2, 
	2, 2, 0, 2, 2, 2, 0, 2, 
	2, 2, 2, 0, 2, 2, 2, 0, 
	2, 0, 0, 0, 22, 0, 0, 2, 
	0, 2, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 0, 
	0, 8, 2, 0, 0, 2, 0, 2, 
	0, 0, 0, 0, 8, 8, 0, 8, 
	8, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 23, 2, 0, 0, 0, 
	0, 0, 24, 0, 0
};

static const char _indic_syllable_machine_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 10, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 11, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 79, 79, 79, 79, 86, 86, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 79, 79, 79, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 79, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 186, 0, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 362, 362, 362, 362, 362, 362, 362, 
	362, 362, 362, 362, 362, 362, 362, 362, 
	362, 362, 362, 362, 362, 362, 362, 362, 
	362, 362, 362, 362, 362, 362, 362, 362, 
	362, 362, 362, 362, 362, 362, 362, 362, 
	362, 362, 362, 362, 362, 362, 362, 362, 
	362, 362, 362, 362, 362, 362, 362, 362, 
	362, 362, 362, 362, 362, 362, 362, 362, 
	362, 362, 362, 362, 362, 362, 362, 362, 
	362, 362, 362, 362, 362, 433, 362, 433, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 434, 434, 
	434, 434, 434, 434, 434, 434, 362, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 362, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 362, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 433
};

static const int indic_syllable_machine_start = 178;
static const int indic_syllable_machine_first_final = 178;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 178;


#line 36 "hb-ot-shape-complex-indic-machine.rl"



#line 97 "hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", last, p+1, #syllable_type); \
    for (unsigned int i = last; i < p+1; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    last = p+1; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts HB_UNUSED, te HB_UNUSED, act HB_UNUSED;
  int cs;
  hb_glyph_info_t *info = buffer->info;
  
#line 1384 "hb-ot-shape-complex-indic-machine.hh"
	{
	cs = indic_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 118 "hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int last = 0;
  unsigned int syllable_serial = 1;
  
#line 1401 "hb-ot-shape-complex-indic-machine.hh"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const short *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _indic_syllable_machine_from_state_actions[cs] ) {
	case 11:
#line 1 "NONE"
	{ts = p;}
	break;
#line 1415 "hb-ot-shape-complex-indic-machine.hh"
	}

	_keys = _indic_syllable_machine_trans_keys + (cs<<1);
	_inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

	_slen = _indic_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
		( info[p].indic_category()) <= _keys[1] ?
		( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _indic_syllable_machine_trans_targs[_trans];

	if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _indic_syllable_machine_trans_actions[_trans] ) {
	case 2:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 15:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (consonant_syllable); }}
	break;
	case 17:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (vowel_syllable); }}
	break;
	case 22:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (standalone_cluster); }}
	break;
	case 24:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (symbol_cluster); }}
	break;
	case 19:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (broken_cluster); }}
	break;
	case 12:
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (non_indic_cluster); }}
	break;
	case 14:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (consonant_syllable); }}
	break;
	case 16:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (vowel_syllable); }}
	break;
	case 21:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (standalone_cluster); }}
	break;
	case 23:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (symbol_cluster); }}
	break;
	case 18:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (broken_cluster); }}
	break;
	case 20:
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (non_indic_cluster); }}
	break;
	case 1:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
	break;
	case 3:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
	break;
	case 7:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
	break;
	case 9:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (symbol_cluster); }}
	break;
	case 4:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (broken_cluster); }}
	break;
	case 5:
#line 1 "NONE"
	{	switch( act ) {
	case 1:
	{{p = ((te))-1;} found_syllable (consonant_syllable); }
	break;
	case 5:
	{{p = ((te))-1;} found_syllable (broken_cluster); }
	break;
	case 6:
	{{p = ((te))-1;} found_syllable (non_indic_cluster); }
	break;
	}
	}
	break;
	case 8:
#line 1 "NONE"
	{te = p+1;}
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{act = 1;}
	break;
	case 6:
#line 1 "NONE"
	{te = p+1;}
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{act = 5;}
	break;
	case 13:
#line 1 "NONE"
	{te = p+1;}
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{act = 6;}
	break;
#line 1538 "hb-ot-shape-complex-indic-machine.hh"
	}

_again:
	switch ( _indic_syllable_machine_to_state_actions[cs] ) {
	case 10:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 1547 "hb-ot-shape-complex-indic-machine.hh"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _indic_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 127 "hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
