
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <TopBas_ListIteratorOfListOfTestInterference.hxx>
#include <TopBas_ListOfTestInterference.hxx>
#include <TopBas_TestInterference.hxx>

// template related includes

// ./opencascade/TopBas_ListOfTestInterference.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/TopBas_ListOfTestInterference.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_TopBas(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("TopBas"));
py::object klass;

//Python trampoline classes

// classes

    // Class TopBas_TestInterference from ./opencascade/TopBas_TestInterference.hxx
    klass = m.attr("TopBas_TestInterference");


    // nested enums

    static_cast<py::class_<TopBas_TestInterference , shared_ptr<TopBas_TestInterference>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const Standard_Real &, const Standard_Integer &, const TopAbs_Orientation, const TopAbs_Orientation, const TopAbs_Orientation >()  , py::arg("Inters"),  py::arg("Bound"),  py::arg("Orient"),  py::arg("Trans"),  py::arg("BTrans") )
    // custom constructors
    // methods
        .def("Intersection",
             (void (TopBas_TestInterference::*)(  const Standard_Real &  ) ) static_cast<void (TopBas_TestInterference::*)(  const Standard_Real &  ) >(&TopBas_TestInterference::Intersection),
             R"#()#"  , py::arg("I")
          )
        .def("Boundary",
             (void (TopBas_TestInterference::*)(  const Standard_Integer &  ) ) static_cast<void (TopBas_TestInterference::*)(  const Standard_Integer &  ) >(&TopBas_TestInterference::Boundary),
             R"#()#"  , py::arg("B")
          )
        .def("Orientation",
             (void (TopBas_TestInterference::*)(  const TopAbs_Orientation  ) ) static_cast<void (TopBas_TestInterference::*)(  const TopAbs_Orientation  ) >(&TopBas_TestInterference::Orientation),
             R"#()#"  , py::arg("O")
          )
        .def("Transition",
             (void (TopBas_TestInterference::*)(  const TopAbs_Orientation  ) ) static_cast<void (TopBas_TestInterference::*)(  const TopAbs_Orientation  ) >(&TopBas_TestInterference::Transition),
             R"#()#"  , py::arg("Tr")
          )
        .def("BoundaryTransition",
             (void (TopBas_TestInterference::*)(  const TopAbs_Orientation  ) ) static_cast<void (TopBas_TestInterference::*)(  const TopAbs_Orientation  ) >(&TopBas_TestInterference::BoundaryTransition),
             R"#()#"  , py::arg("BTr")
          )
        .def("Orientation",
             (TopAbs_Orientation (TopBas_TestInterference::*)() const) static_cast<TopAbs_Orientation (TopBas_TestInterference::*)() const>(&TopBas_TestInterference::Orientation),
             R"#()#" 
          )
        .def("Transition",
             (TopAbs_Orientation (TopBas_TestInterference::*)() const) static_cast<TopAbs_Orientation (TopBas_TestInterference::*)() const>(&TopBas_TestInterference::Transition),
             R"#()#" 
          )
        .def("BoundaryTransition",
             (TopAbs_Orientation (TopBas_TestInterference::*)() const) static_cast<TopAbs_Orientation (TopBas_TestInterference::*)() const>(&TopBas_TestInterference::BoundaryTransition),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Intersection",
             ( const Standard_Real & (TopBas_TestInterference::*)() const) static_cast< const Standard_Real & (TopBas_TestInterference::*)() const>(&TopBas_TestInterference::Intersection),
             R"#()#"
             
         )
       .def_property("ChangeIntersection",
                     [](TopBas_TestInterference& self){return self.ChangeIntersection();} ,
                     [](TopBas_TestInterference& self, Standard_Real  val){self.ChangeIntersection() = val;},                      R"#()#"
         )
       .def("Boundary",
             ( const Standard_Integer & (TopBas_TestInterference::*)() const) static_cast< const Standard_Integer & (TopBas_TestInterference::*)() const>(&TopBas_TestInterference::Boundary),
             R"#()#"
             
         )
       .def_property("ChangeBoundary",
                     [](TopBas_TestInterference& self){return self.ChangeBoundary();} ,
                     [](TopBas_TestInterference& self, Standard_Integer  val){self.ChangeBoundary() = val;},                      R"#()#"
         )
;

// functions

// ./opencascade/TopBas_ListIteratorOfListOfTestInterference.hxx
// ./opencascade/TopBas_ListOfTestInterference.hxx
// ./opencascade/TopBas_TestInterference.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_List<TopBas_TestInterference>(m,"TopBas_ListOfTestInterference");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
