
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <Prs3d_Drawer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <HLRBRep_Data.hxx>
#include <TopoDS_Shape.hxx>
#include <HLRAlgo_Projector.hxx>
#include <BRepAdaptor_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Graphic3d_ArrayOfSegments.hxx>
#include <Graphic3d_ArrayOfTriangles.hxx>
#include <TopoDS_Shape.hxx>
#include <BRep_Builder.hxx>
#include <TopoDS_Compound.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Bnd_Box.hxx>
#include <Poly_Triangulation.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Poly_Polygon3D.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Point.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <Prs3d_Drawer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Vertex.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Graphic3d_ArrayOfPoints.hxx>
#include <Adaptor2d_Curve2d.hxx>

// module includes
#include <StdPrs_BndBox.hxx>
#include <StdPrs_BRepFont.hxx>
#include <StdPrs_BRepTextBuilder.hxx>
#include <StdPrs_Curve.hxx>
#include <StdPrs_DeflectionCurve.hxx>
#include <StdPrs_HLRPolyShape.hxx>
#include <StdPrs_HLRShape.hxx>
#include <StdPrs_HLRShapeI.hxx>
#include <StdPrs_HLRToolShape.hxx>
#include <StdPrs_Isolines.hxx>
#include <StdPrs_Plane.hxx>
#include <StdPrs_Point.hxx>
#include <StdPrs_PoleCurve.hxx>
#include <StdPrs_ShadedShape.hxx>
#include <StdPrs_ShadedSurface.hxx>
#include <StdPrs_ShapeTool.hxx>
#include <StdPrs_ToolPoint.hxx>
#include <StdPrs_ToolRFace.hxx>
#include <StdPrs_ToolTriangulatedShape.hxx>
#include <StdPrs_ToolVertex.hxx>
#include <StdPrs_Vertex.hxx>
#include <StdPrs_Volume.hxx>
#include <StdPrs_WFDeflectionRestrictedFace.hxx>
#include <StdPrs_WFDeflectionSurface.hxx>
#include <StdPrs_WFPoleSurface.hxx>
#include <StdPrs_WFRestrictedFace.hxx>
#include <StdPrs_WFShape.hxx>
#include <StdPrs_WFSurface.hxx>

// template related includes

#include "Prs3d_tmpl.hxx"

#include "Prs3d_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_StdPrs_enums(py::module &main_module) {


py::module m = main_module.def_submodule("StdPrs", R"#()#");

// user-defined inclusion per module in the body

// enums
    py::enum_<StdPrs_Volume>(m, "StdPrs_Volume",R"#(defines the way how to interpret input shapes Volume_Autodetection to perform Autodetection (would split input shape into two groups) Volume_Closed as Closed volumes (to activate back-face culling and capping plane algorithms) Volume_Opened as Open volumes (shells or solids with holes))#")
        .value("StdPrs_Volume_Autodetection",StdPrs_Volume::StdPrs_Volume_Autodetection)
        .value("StdPrs_Volume_Closed",StdPrs_Volume::StdPrs_Volume_Closed)
        .value("StdPrs_Volume_Opened",StdPrs_Volume::StdPrs_Volume_Opened).export_values();

//Python trampoline classes
    class Py_StdPrs_HLRShapeI : public StdPrs_HLRShapeI{
    public:
        using StdPrs_HLRShapeI::StdPrs_HLRShapeI;


        // public pure virtual
        void ComputeHLR(const opencascade::handle<Prs3d_Presentation> & thePrs,const TopoDS_Shape & theShape,const opencascade::handle<Prs3d_Drawer> & theDrawer,const opencascade::handle<Graphic3d_Camera> & theProjector) const  override { PYBIND11_OVERLOAD_PURE(void,StdPrs_HLRShapeI,ComputeHLR,thePrs,theShape,theDrawer,theProjector) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<StdPrs_BRepTextBuilder , shared_ptr<StdPrs_BRepTextBuilder>  >(m,"StdPrs_BRepTextBuilder",R"#(Represents class for applying text formatting.)#");
    py::class_<StdPrs_HLRToolShape , shared_ptr<StdPrs_HLRToolShape>  >(m,"StdPrs_HLRToolShape",R"#(None)#");
    py::class_<StdPrs_ShapeTool , shared_ptr<StdPrs_ShapeTool>  >(m,"StdPrs_ShapeTool",R"#(Describes the behaviour requested for a wireframe shape presentation.)#");
    py::class_<StdPrs_ToolPoint , shared_ptr<StdPrs_ToolPoint>  >(m,"StdPrs_ToolPoint",R"#(None)#");
    py::class_<StdPrs_ToolRFace , shared_ptr<StdPrs_ToolRFace>  >(m,"StdPrs_ToolRFace",R"#(Iterator over 2D curves restricting a face (skipping internal/external edges). In addition, the algorithm skips NULL curves - IsInvalidGeometry() can be checked if this should be handled within algorithm.)#");
    py::class_<StdPrs_ToolVertex , shared_ptr<StdPrs_ToolVertex>  >(m,"StdPrs_ToolVertex",R"#(None)#");
    py::class_<StdPrs_BRepFont ,opencascade::handle<StdPrs_BRepFont>  , Standard_Transient >(m,"StdPrs_BRepFont",R"#(This tool provides basic services for rendering of vectorized text glyphs as BRep shapes. Single instance initialize single font for sequential glyphs rendering with implicit caching of already rendered glyphs. Thus position of each glyph in the text is specified by shape location.This tool provides basic services for rendering of vectorized text glyphs as BRep shapes. Single instance initialize single font for sequential glyphs rendering with implicit caching of already rendered glyphs. Thus position of each glyph in the text is specified by shape location.)#");
    py::class_<StdPrs_Curve , shared_ptr<StdPrs_Curve>  , Prs3d_Root >(m,"StdPrs_Curve",R"#(A framework to define display of lines, arcs of circles and conic sections. This is done with a fixed number of points, which can be modified.)#");
    py::class_<StdPrs_DeflectionCurve , shared_ptr<StdPrs_DeflectionCurve>  , Prs3d_Root >(m,"StdPrs_DeflectionCurve",R"#(A framework to provide display of any curve with respect to the maximal chordal deviation defined in the Prs3d_Drawer attributes manager.)#");
    py::class_<StdPrs_HLRShapeI ,opencascade::handle<StdPrs_HLRShapeI> ,Py_StdPrs_HLRShapeI , Standard_Transient >(m,"StdPrs_HLRShapeI",R"#(Computes the presentation of objects with removal of their hidden lines for a specific projector.)#");
    py::class_<StdPrs_Isolines , shared_ptr<StdPrs_Isolines>  , Prs3d_Root >(m,"StdPrs_Isolines",R"#(Tool for computing isoline representation for a face or surface. Depending on a flags set to the given Prs3d_Drawer instance, on-surface (is used by default) or on-triangulation isoline builder algorithm will be used. If the given shape is not triangulated, on-surface isoline builder will be applied regardless of Prs3d_Drawer flags.)#");
    py::class_<StdPrs_Plane , shared_ptr<StdPrs_Plane>  , Prs3d_Root >(m,"StdPrs_Plane",R"#(A framework to display infinite planes.)#");
    preregister_template_Prs3d_Point<opencascade::handle<Geom_Point>, StdPrs_ToolPoint>(m,"StdPrs_Point");
    py::class_<StdPrs_PoleCurve , shared_ptr<StdPrs_PoleCurve>  , Prs3d_Root >(m,"StdPrs_PoleCurve",R"#(A framework to provide display of Bezier or BSpline curves (by drawing a broken line linking the poles of the curve).)#");
    py::class_<StdPrs_ShadedShape , shared_ptr<StdPrs_ShadedShape>  , Prs3d_Root >(m,"StdPrs_ShadedShape",R"#(Auxiliary procedures to prepare Shaded presentation of specified shape.)#");
    py::class_<StdPrs_ShadedSurface , shared_ptr<StdPrs_ShadedSurface>  , Prs3d_Root >(m,"StdPrs_ShadedSurface",R"#(Computes the shading presentation of surfaces. Draws a surface by drawing the isoparametric curves with respect to a maximal chordial deviation. The number of isoparametric curves to be drawn and their color are controlled by the furnished Drawer.)#");
    py::class_<StdPrs_ToolTriangulatedShape , shared_ptr<StdPrs_ToolTriangulatedShape>  , BRepLib_ToolTriangulatedShape >(m,"StdPrs_ToolTriangulatedShape",R"#(None)#");
    preregister_template_Prs3d_Point<TopoDS_Vertex, StdPrs_ToolVertex>(m,"StdPrs_Vertex");
    py::class_<StdPrs_WFDeflectionRestrictedFace , shared_ptr<StdPrs_WFDeflectionRestrictedFace>  , Prs3d_Root >(m,"StdPrs_WFDeflectionRestrictedFace",R"#(A framework to provide display of U and V isoparameters of faces, while allowing you to impose a deflection on them. Computes the wireframe presentation of faces with restrictions by displaying a given number of U and/or V isoparametric curves. The isoparametric curves are drawn with respect to a maximal chordial deviation. The presentation includes the restriction curves.)#");
    py::class_<StdPrs_WFDeflectionSurface , shared_ptr<StdPrs_WFDeflectionSurface>  , Prs3d_Root >(m,"StdPrs_WFDeflectionSurface",R"#(Draws a surface by drawing the isoparametric curves with respect to a maximal chordial deviation. The number of isoparametric curves to be drawn and their color are controlled by the furnished Drawer.)#");
    py::class_<StdPrs_WFPoleSurface , shared_ptr<StdPrs_WFPoleSurface>  , Prs3d_Root >(m,"StdPrs_WFPoleSurface",R"#(Computes the presentation of surfaces by drawing a double network of lines linking the poles of the surface in the two parametric direction. The number of lines to be drawn is controlled by the NetworkNumber of the given Drawer.)#");
    py::class_<StdPrs_WFRestrictedFace , shared_ptr<StdPrs_WFRestrictedFace>  , Prs3d_Root >(m,"StdPrs_WFRestrictedFace",R"#(None)#");
    py::class_<StdPrs_WFShape , shared_ptr<StdPrs_WFShape>  , Prs3d_Root >(m,"StdPrs_WFShape",R"#(Tool for computing wireframe presentation of a TopoDS_Shape.)#");
    py::class_<StdPrs_WFSurface , shared_ptr<StdPrs_WFSurface>  , Prs3d_Root >(m,"StdPrs_WFSurface",R"#(Computes the wireframe presentation of surfaces by displaying a given number of U and/or V isoparametric curves. The isoparametric curves are drawn with respect to a given number of points.)#");
    py::class_<StdPrs_HLRPolyShape ,opencascade::handle<StdPrs_HLRPolyShape>  , StdPrs_HLRShapeI >(m,"StdPrs_HLRPolyShape",R"#(Instantiates Prs3d_PolyHLRShape to define a display of a shape where hidden and visible lines are identified with respect to a given projection. StdPrs_HLRPolyShape works with a polyhedral simplification of the shape whereas StdPrs_HLRShape takes the shape itself into account. When you use StdPrs_HLRShape, you obtain an exact result, whereas, when you use StdPrs_HLRPolyShape, you reduce computation time but obtain polygonal segments. The polygonal algorithm is used.)#");
    py::class_<StdPrs_HLRShape ,opencascade::handle<StdPrs_HLRShape>  , StdPrs_HLRShapeI >(m,"StdPrs_HLRShape",R"#(Computes the presentation of objects with removal of their hidden lines for a specific projector. The exact algorithm is used.)#");

};

// user-defined post-inclusion per module

// user-defined post
