# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


class TemplateApply(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'dry_run': 'bool',
        'org_id': 'str',
        'stack_id': 'str',
        'template': 'TemplateApplyTemplate',
        'templates': 'list[TemplateApplyTemplate]',
        'env_refs': 'dict(str, object)',
        'secrets': 'dict(str, str)',
        'remotes': 'list[TemplateApplyRemotes]',
        'actions': 'list[object]'
    }

    attribute_map = {
        'dry_run': 'dryRun',
        'org_id': 'orgID',
        'stack_id': 'stackID',
        'template': 'template',
        'templates': 'templates',
        'env_refs': 'envRefs',
        'secrets': 'secrets',
        'remotes': 'remotes',
        'actions': 'actions'
    }

    def __init__(self, dry_run=None, org_id=None, stack_id=None, template=None, templates=None, env_refs=None, secrets=None, remotes=None, actions=None):  # noqa: E501,D401,D403
        """TemplateApply - a model defined in OpenAPI."""  # noqa: E501
        self._dry_run = None
        self._org_id = None
        self._stack_id = None
        self._template = None
        self._templates = None
        self._env_refs = None
        self._secrets = None
        self._remotes = None
        self._actions = None
        self.discriminator = None

        if dry_run is not None:
            self.dry_run = dry_run
        if org_id is not None:
            self.org_id = org_id
        if stack_id is not None:
            self.stack_id = stack_id
        if template is not None:
            self.template = template
        if templates is not None:
            self.templates = templates
        if env_refs is not None:
            self.env_refs = env_refs
        if secrets is not None:
            self.secrets = secrets
        if remotes is not None:
            self.remotes = remotes
        if actions is not None:
            self.actions = actions

    @property
    def dry_run(self):
        """Get the dry_run of this TemplateApply.

        Only applies a dry run of the templates passed in the request.  - Validates the template and generates a resource diff and summary. - Doesn't install templates or make changes to the InfluxDB instance.

        :return: The dry_run of this TemplateApply.
        :rtype: bool
        """  # noqa: E501
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """Set the dry_run of this TemplateApply.

        Only applies a dry run of the templates passed in the request.  - Validates the template and generates a resource diff and summary. - Doesn't install templates or make changes to the InfluxDB instance.

        :param dry_run: The dry_run of this TemplateApply.
        :type: bool
        """  # noqa: E501
        self._dry_run = dry_run

    @property
    def org_id(self):
        """Get the org_id of this TemplateApply.

        Organization ID. InfluxDB applies templates to this organization. The organization owns all resources created by the template.  To find your organization, see how to [view organizations](https://docs.influxdata.com/influxdb/latest/organizations/view-orgs/).

        :return: The org_id of this TemplateApply.
        :rtype: str
        """  # noqa: E501
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Set the org_id of this TemplateApply.

        Organization ID. InfluxDB applies templates to this organization. The organization owns all resources created by the template.  To find your organization, see how to [view organizations](https://docs.influxdata.com/influxdb/latest/organizations/view-orgs/).

        :param org_id: The org_id of this TemplateApply.
        :type: str
        """  # noqa: E501
        self._org_id = org_id

    @property
    def stack_id(self):
        """Get the stack_id of this TemplateApply.

        ID of the stack to update.  To apply templates to an existing stack in the organization, use the `stackID` parameter. If you apply templates without providing a stack ID, InfluxDB initializes a new stack with all new resources.  To find a stack ID, use the InfluxDB [`/api/v2/stacks` API endpoint](#operation/ListStacks) to list stacks.  #### Related guides  - [Stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/) - [View stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/view/)

        :return: The stack_id of this TemplateApply.
        :rtype: str
        """  # noqa: E501
        return self._stack_id

    @stack_id.setter
    def stack_id(self, stack_id):
        """Set the stack_id of this TemplateApply.

        ID of the stack to update.  To apply templates to an existing stack in the organization, use the `stackID` parameter. If you apply templates without providing a stack ID, InfluxDB initializes a new stack with all new resources.  To find a stack ID, use the InfluxDB [`/api/v2/stacks` API endpoint](#operation/ListStacks) to list stacks.  #### Related guides  - [Stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/) - [View stacks](https://docs.influxdata.com/influxdb/latest/influxdb-templates/stacks/view/)

        :param stack_id: The stack_id of this TemplateApply.
        :type: str
        """  # noqa: E501
        self._stack_id = stack_id

    @property
    def template(self):
        """Get the template of this TemplateApply.

        :return: The template of this TemplateApply.
        :rtype: TemplateApplyTemplate
        """  # noqa: E501
        return self._template

    @template.setter
    def template(self, template):
        """Set the template of this TemplateApply.

        :param template: The template of this TemplateApply.
        :type: TemplateApplyTemplate
        """  # noqa: E501
        self._template = template

    @property
    def templates(self):
        """Get the templates of this TemplateApply.

        A list of template objects to apply. A template object has a `contents` property with an array of InfluxDB resource configurations.  Use the `templates` parameter to apply multiple template objects. If you use `templates`, you can't use the `template` parameter.

        :return: The templates of this TemplateApply.
        :rtype: list[TemplateApplyTemplate]
        """  # noqa: E501
        return self._templates

    @templates.setter
    def templates(self, templates):
        """Set the templates of this TemplateApply.

        A list of template objects to apply. A template object has a `contents` property with an array of InfluxDB resource configurations.  Use the `templates` parameter to apply multiple template objects. If you use `templates`, you can't use the `template` parameter.

        :param templates: The templates of this TemplateApply.
        :type: list[TemplateApplyTemplate]
        """  # noqa: E501
        self._templates = templates

    @property
    def env_refs(self):
        """Get the env_refs of this TemplateApply.

        An object with key-value pairs that map to **environment references** in templates.  Environment references in templates are `envRef` objects with an `envRef.key` property. To substitute a custom environment reference value when applying templates, pass `envRefs` with the `envRef.key` and the value.  When you apply a template, InfluxDB replaces `envRef` objects in the template with the values that you provide in the `envRefs` parameter. For more examples, see how to [define environment references](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#define-environment-references).  The following template fields may use environment references:    - `metadata.name`   - `spec.endpointName`   - `spec.associations.name`  For more information about including environment references in template fields, see how to [include user-definable resource names](https://docs.influxdata.com/influxdb/latest/influxdb-templates/create/#include-user-definable-resource-names).

        :return: The env_refs of this TemplateApply.
        :rtype: dict(str, object)
        """  # noqa: E501
        return self._env_refs

    @env_refs.setter
    def env_refs(self, env_refs):
        """Set the env_refs of this TemplateApply.

        An object with key-value pairs that map to **environment references** in templates.  Environment references in templates are `envRef` objects with an `envRef.key` property. To substitute a custom environment reference value when applying templates, pass `envRefs` with the `envRef.key` and the value.  When you apply a template, InfluxDB replaces `envRef` objects in the template with the values that you provide in the `envRefs` parameter. For more examples, see how to [define environment references](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#define-environment-references).  The following template fields may use environment references:    - `metadata.name`   - `spec.endpointName`   - `spec.associations.name`  For more information about including environment references in template fields, see how to [include user-definable resource names](https://docs.influxdata.com/influxdb/latest/influxdb-templates/create/#include-user-definable-resource-names).

        :param env_refs: The env_refs of this TemplateApply.
        :type: dict(str, object)
        """  # noqa: E501
        self._env_refs = env_refs

    @property
    def secrets(self):
        """Get the secrets of this TemplateApply.

        An object with key-value pairs that map to **secrets** in queries.  Queries may reference secrets stored in InfluxDB--for example, the following Flux script retrieves `POSTGRES_USERNAME` and `POSTGRES_PASSWORD` secrets and then uses them to connect to a PostgreSQL database:  ```js import "sql" import "influxdata/influxdb/secrets"  username = secrets.get(key: "POSTGRES_USERNAME") password = secrets.get(key: "POSTGRES_PASSWORD")  sql.from(   driverName: "postgres",   dataSourceName: "postgresql://${username}:${password}@localhost:5432",   query: "SELECT * FROM example_table", ) ```  To define secret values in your `/api/v2/templates/apply` request, pass the `secrets` parameter with key-value pairs--for example:  ```json {   ...   "secrets": {     "POSTGRES_USERNAME": "pguser",     "POSTGRES_PASSWORD": "foo"   }   ... } ```  InfluxDB stores the key-value pairs as secrets that you can access with `secrets.get()`. Once stored, you can't view secret values in InfluxDB.  #### Related guides  - [How to pass secrets when installing a template](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#pass-secrets-when-installing-a-template)

        :return: The secrets of this TemplateApply.
        :rtype: dict(str, str)
        """  # noqa: E501
        return self._secrets

    @secrets.setter
    def secrets(self, secrets):
        """Set the secrets of this TemplateApply.

        An object with key-value pairs that map to **secrets** in queries.  Queries may reference secrets stored in InfluxDB--for example, the following Flux script retrieves `POSTGRES_USERNAME` and `POSTGRES_PASSWORD` secrets and then uses them to connect to a PostgreSQL database:  ```js import "sql" import "influxdata/influxdb/secrets"  username = secrets.get(key: "POSTGRES_USERNAME") password = secrets.get(key: "POSTGRES_PASSWORD")  sql.from(   driverName: "postgres",   dataSourceName: "postgresql://${username}:${password}@localhost:5432",   query: "SELECT * FROM example_table", ) ```  To define secret values in your `/api/v2/templates/apply` request, pass the `secrets` parameter with key-value pairs--for example:  ```json {   ...   "secrets": {     "POSTGRES_USERNAME": "pguser",     "POSTGRES_PASSWORD": "foo"   }   ... } ```  InfluxDB stores the key-value pairs as secrets that you can access with `secrets.get()`. Once stored, you can't view secret values in InfluxDB.  #### Related guides  - [How to pass secrets when installing a template](https://docs.influxdata.com/influxdb/latest/influxdb-templates/use/#pass-secrets-when-installing-a-template)

        :param secrets: The secrets of this TemplateApply.
        :type: dict(str, str)
        """  # noqa: E501
        self._secrets = secrets

    @property
    def remotes(self):
        """Get the remotes of this TemplateApply.

        A list of URLs for template files.  To apply a template manifest file located at a URL, pass `remotes` with an array that contains the URL.

        :return: The remotes of this TemplateApply.
        :rtype: list[TemplateApplyRemotes]
        """  # noqa: E501
        return self._remotes

    @remotes.setter
    def remotes(self, remotes):
        """Set the remotes of this TemplateApply.

        A list of URLs for template files.  To apply a template manifest file located at a URL, pass `remotes` with an array that contains the URL.

        :param remotes: The remotes of this TemplateApply.
        :type: list[TemplateApplyRemotes]
        """  # noqa: E501
        self._remotes = remotes

    @property
    def actions(self):
        """Get the actions of this TemplateApply.

        A list of `action` objects. Actions let you customize how InfluxDB applies templates in the request.  You can use the following actions to prevent creating or updating resources:  - A `skipKind` action skips template resources of a specified `kind`. - A `skipResource` action skips template resources with a specified `metadata.name`   and `kind`.

        :return: The actions of this TemplateApply.
        :rtype: list[object]
        """  # noqa: E501
        return self._actions

    @actions.setter
    def actions(self, actions):
        """Set the actions of this TemplateApply.

        A list of `action` objects. Actions let you customize how InfluxDB applies templates in the request.  You can use the following actions to prevent creating or updating resources:  - A `skipKind` action skips template resources of a specified `kind`. - A `skipResource` action skips template resources with a specified `metadata.name`   and `kind`.

        :param actions: The actions of this TemplateApply.
        :type: list[object]
        """  # noqa: E501
        self._actions = actions

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, TemplateApply):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
