# Release notes for cobrapy 0.25.0

## New features

* Add `knock_out_model_genes` to simulate knock-outs, setting
  reaction bounds of affected reactions to zero and returning a list
  of reactions that were knocked-out. Replaces `delete_model_genes`
  and `undelete_model_genes` since it is context sensitive.
* Improve reading of matlab models which will include metabolite
  and reaction annotations.

## Fixes

* `model.copy()` will now correctly copy GPRs.
* Fix an error where matlab models can not be read if their bounds exceed the
  configuration default in some cases.
* Fixed some bugs in `GPR().from_string()` where it was using the unmodified string,
  leading to errors with `GPR`s that should work. Made `GPR`s that have empty
  parenthesis fail more comprehensibly.

## Other

* Move tests to a different directory, from `src/cobra/test` to `tests` (#1191).
* Add two tests for `GPR` fixes:
    * `test_gpr_wrong_input()`
    * `test_gpr_that_needs_two_replacements()`
* Clean up Python syntax (#1152, #1153, #1171, #1173, #1182)

## Deprecated features

* Deprecate `delete_model_genes`, `undelete_model_genes`

## Backwards incompatible changes

* Remove `find_gene_knockout_reactions` from `delete.py`
* Remove `_find_gene_knockout_reactions_fast`,
  `_gene_knockout_computation`, `_get_removed `
  from `test_delete.py`
* Remove `pymatlib` direct transfer of models to matlab process.
  Please use `save_matlab_model()` and then read the model in matlab.

