# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.containerregistrytasks import ContainerRegistryTasksMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-containerregistrytasks
# USAGE
    python tasks_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerRegistryTasksMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.tasks.update(
        resource_group_name="myResourceGroup",
        registry_name="myRegistry",
        task_name="myTask",
        task_update_parameters={
            "properties": {
                "agentConfiguration": {"cpu": 3},
                "credentials": {
                    "customRegistries": {
                        "myregistry.azurecr.io": {
                            "identity": "[system]",
                            "password": {
                                "type": "Vaultsecret",
                                "value": "https://myacbvault.vault.azure.net/secrets/password",
                            },
                            "userName": {"type": "Opaque", "value": "username"},
                        }
                    }
                },
                "logTemplate": "acr/tasks:{{.Run.OS}}",
                "status": "Enabled",
                "step": {"dockerFilePath": "src/DockerFile", "imageNames": ["azurerest:testtag1"], "type": "Docker"},
                "trigger": {
                    "sourceTriggers": [
                        {
                            "name": "mySourceTrigger",
                            "sourceRepository": {"sourceControlAuthProperties": {"token": "xxxxx", "tokenType": "PAT"}},
                            "sourceTriggerEvents": ["commit"],
                        }
                    ]
                },
            },
            "tags": {"testkey": "value"},
        },
    )
    print(response)


# x-ms-original-file: 2025-03-01-preview/TasksUpdate.json
if __name__ == "__main__":
    main()
