# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Architecture(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The OS architecture."""

    AMD64 = "amd64"
    X86 = "x86"
    THREE_HUNDRED_EIGHTY_SIX = "386"
    ARM = "arm"
    ARM64 = "arm64"


class BaseImageDependencyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the base image dependency."""

    BUILD_TIME = "BuildTime"
    RUN_TIME = "RunTime"


class BaseImageTriggerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the auto trigger for base image dependency updates."""

    ALL = "All"
    RUNTIME = "Runtime"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class OS(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The OS of agent machine."""

    WINDOWS = "Windows"
    LINUX = "Linux"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of this agent pool."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class RunStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the run."""

    QUEUED = "Queued"
    STARTED = "Started"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    ERROR = "Error"
    TIMEOUT = "Timeout"


class RunType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of run."""

    QUICK_BUILD = "QuickBuild"
    QUICK_RUN = "QuickRun"
    AUTO_BUILD = "AutoBuild"
    AUTO_RUN = "AutoRun"


class SecretObjectType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the secret object which determines how the value of the secret object has to be
    interpreted.
    """

    OPAQUE = "Opaque"
    VAULTSECRET = "Vaultsecret"


class SourceControlType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of source control service."""

    GITHUB = "Github"
    VISUAL_STUDIO_TEAM_SERVICE = "VisualStudioTeamService"


class SourceRegistryLoginMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The authentication mode which determines the source registry login scope. The credentials for
    the source registry
    will be generated using the given scope. These credentials will be used to login to
    the source registry during the run.
    """

    NONE = "None"
    DEFAULT = "Default"


class SourceTriggerEvent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of SourceTriggerEvent."""

    COMMIT = "commit"
    PULLREQUEST = "pullrequest"


class StepType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the step."""

    DOCKER = "Docker"
    FILE_TASK = "FileTask"
    ENCODED_TASK = "EncodedTask"


class TaskStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of task."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class TokenType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of Auth token."""

    PAT = "PAT"
    O_AUTH = "OAuth"


class TriggerStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of trigger."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class UpdateTriggerPayloadType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Payload body for Base image update triggers."""

    DEFAULT = "Default"
    TOKEN = "Token"


class Variant(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Variant of the CPU."""

    V6 = "v6"
    V7 = "v7"
    V8 = "v8"
