/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.tests;

import gr.zeus.ui.OutLookToolBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class JToolBarTester
extends JFrame {
    private OutLookToolBar m_outLookToolBar = null;
    private JButton m_dummy = null;
    private JTextArea m_textArea;
    private JToolBar m_toolbar;

    public JToolBarTester() {
        this.initComponents();
        this.m_outLookToolBar = new OutLookToolBar(this.m_toolbar);
    }

    private void initComponents() {
        this.m_toolbar = new JToolBar();
        JButton button1 = new JButton();
        JButton button2 = new JButton();
        JButton button3 = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.m_textArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        button1.setText("Button1");
        button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JToolBarTester.this.button1ActionPerformed(evt);
            }
        });
        this.m_toolbar.add(button1);
        button2.setText("Button2");
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JToolBarTester.this.button2ActionPerformed(evt);
            }
        });
        this.m_toolbar.add(button2);
        button3.setText("Button3");
        button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JToolBarTester.this.button3ActionPerformed(evt);
            }
        });
        this.m_toolbar.add(button3);
        this.getContentPane().add((Component)this.m_toolbar, "North");
        jScrollPane1.setViewportView(this.m_textArea);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 300) / 2, 400, 300);
    }

    private void button3ActionPerformed(ActionEvent evt) {
        this.m_textArea.append("Button3 pressed\n");
    }

    private void button2ActionPerformed(ActionEvent evt) {
        this.m_textArea.append("Button2 pressed\n");
        if (this.m_dummy != null) {
            this.m_textArea.append("removing the dummy button\n");
            this.m_toolbar.remove(this.m_dummy);
            this.m_dummy = null;
        }
    }

    private void button1ActionPerformed(ActionEvent evt) {
        this.m_textArea.append("Button1 pressed\n");
        if (this.m_dummy == null) {
            this.m_textArea.append("adding new dummy button to demonstrate how this automatically inherits outlook like functionality\n");
            this.m_dummy = new JButton("dummy");
            this.m_toolbar.add(this.m_dummy);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JToolBarTester().setVisible(true);
            }
        });
    }
}

