/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.util;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class ShortDuration
implements Comparable<ShortDuration> {
    private static final Pattern PATTERN = Pattern.compile("^([0-9.eE+-]+) ?(\\S+)$");
    final long picos;
    private static ShortDuration ZERO = new ShortDuration(0L){

        @Override
        public long to(TimeUnit unit, RoundingMode roundingMode) {
            return 0L;
        }

        @Override
        public ShortDuration plus(ShortDuration addend) {
            return addend;
        }

        @Override
        public ShortDuration minus(ShortDuration subtrahend) {
            Preconditions.checkArgument((this == subtrahend ? 1 : 0) != 0);
            return this;
        }

        @Override
        public ShortDuration times(long multiplicand) {
            return this;
        }

        @Override
        public ShortDuration times(BigDecimal multiplicand, RoundingMode roundingMode) {
            return this;
        }

        @Override
        public ShortDuration dividedBy(long divisor, RoundingMode roundingMode) {
            return this.dividedBy(new BigDecimal(divisor), roundingMode);
        }

        @Override
        public ShortDuration dividedBy(BigDecimal divisor, RoundingMode roundingMode) {
            Preconditions.checkArgument((divisor.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
            return this;
        }

        @Override
        public int compareTo(ShortDuration that) {
            if (this == that) {
                return 0;
            }
            Preconditions.checkNotNull((Object)that);
            return -1;
        }

        public boolean equals(@Nullable Object that) {
            return this == that;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "0s";
        }
    };
    private static final ImmutableListMultimap<TimeUnit, String> ABBREVIATIONS = ShortDuration.createAbbreviations();
    private static final Map<String, TimeUnit> ABBREV_TO_UNIT = ShortDuration.createAbbrevToUnitMap();
    private static final Map<TimeUnit, BigDecimal> ONE_IN_PICOS = ShortDuration.createUnitToPicosMap();
    private static final Map<TimeUnit, Long> MAXES = ShortDuration.createMaxesMap();

    public static ShortDuration of(long duration, TimeUnit unit) {
        if (duration == 0L) {
            return ZERO;
        }
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (String)"negative duration: %s", (Object[])new Object[]{duration});
        Preconditions.checkArgument((duration <= MAXES.get((Object)unit) ? 1 : 0) != 0, (String)"ShortDuration cannot exceed 100 days: %s %s", (Object[])new Object[]{duration, unit});
        long nanos = TimeUnit.NANOSECONDS.convert(duration, unit);
        return new PositiveShortDuration(nanos * 1000L);
    }

    public static ShortDuration of(BigDecimal duration, TimeUnit unit) {
        BigDecimal picos = duration.multiply(ONE_IN_PICOS.get((Object)unit));
        return ShortDuration.ofPicos(ShortDuration.toLong(picos, RoundingMode.HALF_UP));
    }

    public static ShortDuration valueOf(String s) {
        Matcher matcher = PATTERN.matcher(s);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid ShortDuration: %s", (Object[])new Object[]{s});
        BigDecimal value = new BigDecimal(matcher.group(1));
        String abbrev = matcher.group(2);
        TimeUnit unit = ABBREV_TO_UNIT.get(abbrev);
        Preconditions.checkArgument((unit != null ? 1 : 0) != 0, (String)"Unrecognized time unit: %s", (Object[])new Object[]{abbrev});
        return ShortDuration.of(value, unit);
    }

    public static ShortDuration zero() {
        return ZERO;
    }

    private static ShortDuration ofPicos(long picos) {
        if (picos == 0L) {
            return ZERO;
        }
        Preconditions.checkArgument((picos > 0L ? 1 : 0) != 0);
        return new PositiveShortDuration(picos);
    }

    ShortDuration(long picos) {
        this.picos = picos;
    }

    public long to(TimeUnit unit) {
        return this.to(unit, RoundingMode.HALF_UP);
    }

    public abstract long to(TimeUnit var1, RoundingMode var2);

    public abstract ShortDuration plus(ShortDuration var1);

    public abstract ShortDuration minus(ShortDuration var1);

    public abstract ShortDuration times(long var1);

    public abstract ShortDuration times(BigDecimal var1, RoundingMode var2);

    public abstract ShortDuration dividedBy(long var1, RoundingMode var3);

    public abstract ShortDuration dividedBy(BigDecimal var1, RoundingMode var2);

    private static String preferredAbbrev(TimeUnit bestUnit) {
        return (String)ABBREVIATIONS.get((Object)bestUnit).get(0);
    }

    private static ImmutableListMultimap<TimeUnit, String> createAbbreviations() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.putAll((Object)TimeUnit.NANOSECONDS, (Object[])new String[]{"ns", "nanos"});
        builder.putAll((Object)TimeUnit.MICROSECONDS, (Object[])new String[]{"\u03bcs", "us", "micros"});
        builder.putAll((Object)TimeUnit.MILLISECONDS, (Object[])new String[]{"ms", "millis"});
        builder.putAll((Object)TimeUnit.SECONDS, (Object[])new String[]{"s", "sec"});
        TimeUnit[] allUnits = TimeUnit.values();
        if (allUnits.length >= 7) {
            builder.putAll((Object)allUnits[4], (Object[])new String[]{"m", "min"});
            builder.putAll((Object)allUnits[5], (Object[])new String[]{"h", "hr"});
            builder.putAll((Object)allUnits[6], (Object[])new String[]{"d"});
        }
        for (TimeUnit unit : TimeUnit.values()) {
            builder.put((Object)unit, (Object)Ascii.toLowerCase((String)unit.name()));
        }
        return builder.build();
    }

    private static Map<String, TimeUnit> createAbbrevToUnitMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : ABBREVIATIONS.entries()) {
            builder.put(entry.getValue(), entry.getKey());
        }
        return builder.build();
    }

    private static Map<TimeUnit, BigDecimal> createUnitToPicosMap() {
        EnumMap map = Maps.newEnumMap(TimeUnit.class);
        for (TimeUnit unit : TimeUnit.values()) {
            map.put(unit, new BigDecimal(ShortDuration.picosIn(unit)));
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<TimeUnit, Long> createMaxesMap() {
        EnumMap map = Maps.newEnumMap(TimeUnit.class);
        for (TimeUnit unit : TimeUnit.values()) {
            map.put(unit, unit.convert(8640000L, TimeUnit.SECONDS));
        }
        return Collections.unmodifiableMap(map);
    }

    private static long toLong(BigDecimal bd, RoundingMode roundingMode) {
        return bd.setScale(0, roundingMode).longValueExact();
    }

    private static long picosIn(TimeUnit unit) {
        return unit.toNanos(1000L);
    }

    private static class PositiveShortDuration
    extends ShortDuration {
        private static final MathContext ROUNDER = new MathContext(4);

        private PositiveShortDuration(long picos) {
            super(picos);
            Preconditions.checkArgument((picos > 0L ? 1 : 0) != 0);
        }

        @Override
        public long to(TimeUnit unit, RoundingMode roundingMode) {
            BigDecimal divisor = (BigDecimal)ONE_IN_PICOS.get((Object)unit);
            return ShortDuration.toLong(new BigDecimal(this.picos).divide(divisor), roundingMode);
        }

        @Override
        public ShortDuration plus(ShortDuration addend) {
            return new PositiveShortDuration(this.picos + addend.picos);
        }

        @Override
        public ShortDuration minus(ShortDuration subtrahend) {
            return ShortDuration.ofPicos(this.picos - subtrahend.picos);
        }

        @Override
        public ShortDuration times(long multiplicand) {
            if (multiplicand == 0L) {
                return ZERO;
            }
            Preconditions.checkArgument((multiplicand >= 0L ? 1 : 0) != 0, (String)"negative multiplicand: %s", (Object[])new Object[]{multiplicand});
            Preconditions.checkArgument((multiplicand <= Long.MAX_VALUE / this.picos ? 1 : 0) != 0, (String)"product of %s and %s would overflow", (Object[])new Object[]{this, multiplicand});
            return new PositiveShortDuration(this.picos * multiplicand);
        }

        @Override
        public ShortDuration times(BigDecimal multiplicand, RoundingMode roundingMode) {
            BigDecimal product = BigDecimal.valueOf(this.picos).multiply(multiplicand);
            return ShortDuration.ofPicos(ShortDuration.toLong(product, roundingMode));
        }

        @Override
        public ShortDuration dividedBy(long divisor, RoundingMode roundingMode) {
            return this.dividedBy(new BigDecimal(divisor), roundingMode);
        }

        @Override
        public ShortDuration dividedBy(BigDecimal divisor, RoundingMode roundingMode) {
            BigDecimal product = BigDecimal.valueOf(this.picos).divide(divisor, roundingMode);
            return ShortDuration.ofPicos(product.longValueExact());
        }

        @Override
        public int compareTo(ShortDuration that) {
            return Longs.compare((long)this.picos, (long)that.picos);
        }

        public boolean equals(Object object) {
            if (object instanceof PositiveShortDuration) {
                PositiveShortDuration that = (PositiveShortDuration)object;
                return this.picos == that.picos;
            }
            return false;
        }

        public int hashCode() {
            return Longs.hashCode((long)this.picos);
        }

        public String toString() {
            TimeUnit bestUnit = TimeUnit.NANOSECONDS;
            for (TimeUnit unit : TimeUnit.values()) {
                if (ShortDuration.picosIn(unit) > this.picos) break;
                bestUnit = unit;
            }
            BigDecimal divisor = (BigDecimal)ONE_IN_PICOS.get((Object)bestUnit);
            return new BigDecimal(this.picos).divide(divisor, ROUNDER) + ShortDuration.preferredAbbrev(bestUnit);
        }
    }
}

