/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.UtilString;
import com.sqlmagic.tinysql.tinySQLConnection;
import com.sqlmagic.tinysql.tinySQLResultSet;
import com.sqlmagic.tinysql.tinySQLTable;
import com.sqlmagic.tinysql.tsResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

public class tinySQLPreparedStatement
implements PreparedStatement {
    private String statementString;
    private Vector substitute = null;
    private Vector tableList = new Vector();
    private String invalidIndex = null;
    private tinySQLConnection connection;
    private tinySQLResultSet result;
    private Vector actions = null;
    private int max_field_size = 0;
    private int max_rows = 65536;
    private int timeout = 0;
    private int fetchsize = 4096;
    private static boolean debug = false;

    public tinySQLPreparedStatement(tinySQLConnection tinySQLConnection2, String string) {
        int n;
        this.connection = tinySQLConnection2;
        int n2 = 0;
        this.statementString = string;
        while ((n = this.statementString.indexOf("?", n2)) > -1) {
            if (this.substitute == (Vector)null) {
                this.substitute = new Vector();
            }
            this.substitute.addElement(new String(""));
            n2 = n + 1;
        }
        this.invalidIndex = " is not in the range 1 to " + Integer.toString(this.substitute.size());
        if (debug) {
            System.out.println("Prepare statement has " + this.substitute.size() + " parameters.");
        }
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        this.result = null;
        if (debug) {
            System.out.println("executeQuery conn is " + this.connection.toString());
        }
        return new tinySQLResultSet(this.connection.executetinySQL(this), this);
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.result = null;
        this.statementString = string;
        if (debug) {
            System.out.println("executeQuery conn is " + this.connection.toString());
        }
        return new tinySQLResultSet(this.connection.executetinySQL(this), this);
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        this.statementString = string;
        return this.connection.executetinyUpdate(this);
    }

    public synchronized int executeUpdate() throws SQLException {
        return this.connection.executetinyUpdate(this);
    }

    public boolean execute() throws SQLException {
        tsResultSet tsResultSet2 = this.connection.executetinySQL(this);
        this.result = tsResultSet2 == null ? null : new tinySQLResultSet(tsResultSet2, this);
        return this.result != null;
    }

    public boolean execute(String string) throws SQLException {
        this.statementString = string;
        tsResultSet tsResultSet2 = this.connection.executetinySQL(this);
        this.result = tsResultSet2 == null ? null : new tinySQLResultSet(tsResultSet2, this);
        return this.result != null;
    }

    public String getSQLString() {
        return this.statementString;
    }

    public void close() throws SQLException {
        int n = 0;
        while (n < this.tableList.size()) {
            tinySQLTable tinySQLTable2 = (tinySQLTable)this.tableList.elementAt(n);
            if (debug) {
                System.out.println("Closing " + tinySQLTable2.table);
            }
            tinySQLTable2.close();
            ++n;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        tinySQLResultSet tinySQLResultSet2 = this.result;
        this.result = null;
        return tinySQLResultSet2;
    }

    public int getUpdateCount() throws SQLException {
        return -1;
    }

    public boolean getMoreResults() throws SQLException {
        return this.result != null;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.max_field_size = n;
    }

    public int getMaxRows() throws SQLException {
        return this.max_rows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.max_rows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLException("The tinySQL Driver doesn't support escape processing.");
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.timeout = n;
    }

    public void cancel() {
    }

    public final SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String string) throws SQLException {
        throw new SQLException("tinySQL does not support cursors.");
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException("tinySQL does not support setFetchDirection.");
    }

    public int getFetchDirection() throws SQLException {
        throw new SQLException("tinySQL does not support getFetchDirection.");
    }

    public void setFetchSize(int n) throws SQLException {
        if (n <= 0 || n >= this.getMaxRows()) {
            throw new SQLException("Condition 0 <= rows <= this.getMaxRows() is not satisfied");
        }
        this.fetchsize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchsize;
    }

    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("tinySQL does not support ResultSet concurrency.");
    }

    public int getResultSetType() throws SQLException {
        throw new SQLException("tinySQL does not support getResultSetType.");
    }

    public void addBatch() throws SQLException {
        throw new SQLException("tinySQL does not support addBatch.");
    }

    public void addBatch(String string) throws SQLException {
        throw new SQLException("tinySQL does not support addBatch.");
    }

    public void clearBatch() throws SQLException {
        throw new SQLException("tinySQL does not support clearBatch.");
    }

    public int[] executeBatch() throws SQLException {
        throw new SQLException("tinySQL does not support executeBatch.");
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (bl) {
            this.setString(n, "TRUE");
        } else {
            this.setString(n, "FALSE");
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setString(n, Integer.toString(n2));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.setString(n, Double.toString(d));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setString(n, bigDecimal.toString());
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == (Date)null) {
            this.setString(n, null);
        } else if (date.toString().trim().length() < 8) {
            this.setString(n, null);
        } else {
            String string = date.toString().trim();
            string = UtilString.dateValue(string);
            this.setString(n, string);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        String string = UtilString.dateValue(date.toString());
        this.setString(n, string);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setString(n, time.toString());
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setString(n, time.toString());
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setString(n, timestamp.toString());
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setString(n, timestamp.toString());
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setString(n, inputStream.toString());
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setString(n, inputStream.toString());
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setString(n, inputStream.toString());
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setString(n, reader.toString());
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.setString(n, ref.toString());
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setString(n, blob.toString());
    }

    public void setArray(int n, Array array) throws SQLException {
        this.setString(n, array.toString());
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.setString(n, clob.toString());
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setString(n, Byte.toString(by));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setString(n, Byte.toString(byArray[0]));
    }

    public void setShort(int n, short s) throws SQLException {
        this.setString(n, Short.toString(s));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setString(n, Float.toString(f));
    }

    public void setLong(int n, long l) throws SQLException {
        this.setString(n, Long.toString(l));
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, 0, 0);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setString(n, object.toString());
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setNull(n, n2, null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        if (n > this.substitute.size()) {
            throw new SQLException("Parameter index " + n + this.invalidIndex);
        }
        this.substitute.setElementAt(null, n - 1);
    }

    public void setString(int n, String string) throws SQLException {
        if (n > this.substitute.size()) {
            throw new SQLException("Parameter index " + n + this.invalidIndex);
        }
        this.substitute.setElementAt(string, n - 1);
    }

    public void clearParameters() throws SQLException {
        this.substitute.removeAllElements();
    }

    public void updateActions(Vector vector) throws SQLException {
        if (this.actions == (Vector)null) {
            this.actions = vector;
        }
        if (this.actions == (Vector)null) {
            return;
        }
        int n = 0;
        while (n < this.actions.size()) {
            Hashtable hashtable = (Hashtable)this.actions.elementAt(n);
            String string = (String)hashtable.get("TYPE");
            if (string.equals("INSERT") | string.equals("UPDATE")) {
                Vector vector2 = (Vector)hashtable.get("ORIGINAL_VALUES");
                Vector vector3 = (Vector)hashtable.get("VALUES");
                if (vector2 == (Vector)null) {
                    vector2 = (Vector)vector3.clone();
                    hashtable.put("ORIGINAL_VALUES", vector2);
                }
                int n2 = 0;
                int n3 = 0;
                while (n3 < vector2.size()) {
                    String string2 = (String)vector2.elementAt(n3);
                    if (string2.equals("?")) {
                        if (n2 > this.substitute.size() - 1) {
                            throw new SQLException("Substitution index " + n2 + " not between 0 and " + Integer.toString(this.substitute.size() - 1));
                        }
                        vector3.setElementAt(this.substitute.elementAt(n2), n3);
                        ++n2;
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    public void addTable(tinySQLTable tinySQLTable2) {
        int n = 0;
        while (n < this.tableList.size()) {
            tinySQLTable tinySQLTable3 = (tinySQLTable)this.tableList.elementAt(n);
            if (tinySQLTable3.table.equals(tinySQLTable2.table)) {
                return;
            }
            ++n;
        }
        this.tableList.addElement(tinySQLTable2);
    }

    public Vector getActions() {
        return this.actions;
    }

    public ResultSetMetaData getMetaData() {
        return null;
    }
}

