---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# TRACE HTTP method enabled

## Description

The debug TRACE method was found to be enabled on the target web server. This
HTTP method reflects HTTP request data back to the user in a response. In some circumstances
this information may include sensitive data that is applied by intermediary proxies.

## Remediation

The TRACE HTTP method is for debugging only and should not be enabled on production
sites.

For Apache based web servers, ensure the `TraceEnable` directive is either removed or set to
`off`.

For Microsoft Servers, remove the registry parameter named "EnableTraceMethod" found in the below
registry key:

- `HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\W3SVC\Parameters`

For all other server types, consult your product's documentation on how to disable the TRACE method.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 16.11 | false | 16 | Active | high |

## Links

- [RFC](https://datatracker.ietf.org/doc/html/rfc9110.html#section-9.3.8)
- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [Apache TraceEnable](https://httpd.apache.org/docs/2.4/mod/core.html#traceenable)
