/* atmsvc.h - ATM signaling kernel-demon interface definitions */
 
/* Written 1995,1996 by Werner Almesberger, EPFL LRC */
 

#ifndef _LINUX_ATMSVC_H
#define _LINUX_ATMSVC_H

#include <linux/atm.h>
#include <linux/atmioc.h>


#define ATMSIGD_CTRL _IO('a',ATMIOC_SPECIAL)
				/* become ATM signaling demon control socket */

enum atmsvc_msg_type { as_catch_null,as_bind,as_connect,as_accept,as_listen,
  as_okay,as_error,as_indicate,as_close,as_itf_notify };

struct atmsvc_msg {
	enum atmsvc_msg_type type;
	unsigned long vcc;
	unsigned long listen_vcc;	/* indicate */
	int reply;			/* for okay and close:		   */
					/*   < 0: error before active	   */
					/*        (sigd has discarded ctx) */
					/*   ==0: success		   */
				        /*   > 0: error when active (still */
					/*        need to close)	   */
	unsigned char aal;		/* AAL */
	struct sockaddr_atmpvc pvc;	/* indicate, okay (connect) */
	struct sockaddr_atmsvc local;	/* local SVC address */
	struct atm_qos qos;		/* QOS parameters */
	struct sockaddr_atmsvc svc;	/* MUST BE BEFORE "blli", SVC address */
	struct atm_blli blli[1];	/* MUST BE LAST */
};

/*
 * Message contents:
 *
 * Message   Dir  vcc listen_vcc reply aal    pvc       --svc--    local
 *                                         addr *xtp addr sap *xtp addr
 * bind	     K->D  X      -        -    -   -    -    X    X   -    -
 * - okay    D->K  X      -        -    -   -    -    X    X   -    -
 * connect   K->D  X      -        -    X   -    -    X    X   X    X
 * - okay    D->K  X      -        -    -   X    X    -    -   -    X
 * listen    K->D  X      -        -    X   -    -    X    X   X    -
 * - okay    D->K  X      -        -    -   -    -    -    -   -    -
 * indicate  D->K  -      X        -    -   X    1    X    X   X    -
 * accept    K->D  X      X        -    -   -    -    -    -   -    -
 * - okay    D->K  X      -        -    -   -    -    -    -   -    X
 * close     K->D  X      -        -    -   -    -    -    -   -    -
 * close     D->K  X      -        X    -   -    -    -    -   -    -
 *
 *  1  same value as in svc.*xtp
 *
 * Note: we may have to get rid of the PVC part in indicate messages later,
 *       so it's a good idea not to depend on it too heavily.
 */

/*
 * In an as_itf_update message, only the fields type and pvc.sas_addr.itf are
 * valid.
 */

/*
 * Some policy stuff for atmsigd and for net/atm/svc.c. Both have to agree on
 * what PCR is used to request bandwidth from the device driver. net/atm/svc.c
 * tries to do better than that, but only if there's no routing decision (i.e.
 * if signaling only uses one ATM interface).
 */

#define SELECT_TOP_PCR(tp) ((tp).max_pcr && (tp).max_pcr != ATM_MAX_PCR ? \
  (tp).max_pcr : (tp).min_pcr)

#endif
