/* sig.h - signaling entity handling */

/* Written 1998 by Werner Almesberger, EPFL ICA */


#ifndef SIG_H
#define SIG_H

#include <linux/atmsvc.h>

#include "atm.h"


typedef struct _signaling_entity {
    int s;			/* socket */
    const char *command;	/* command to start sigd; NULL if none */
    const char *path;		/* path to the Unix domain socket */
    struct sockaddr_atmpvc pvc;	/* signaling VC; itf = -1 if not used */
    short itf;			/* interface we manage */
    struct _signaling_entity *next;
    struct _call *call;		/* used to route VCI 5 to signaling */
} SIGNALING_ENTITY;


SIGNALING_ENTITY *sig_vc(const char *command,const char *path,int itf);
void sig_send(SIGNALING_ENTITY *sig,struct atmsvc_msg *msg);
void sig_notify(int itf,int up);

#endif
