/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   codes.h
*   
* Abstract:
*   This module defines return and error codes.
*
* Authors:
*   DMW - Douglas M. Washabaugh
*
* Modification History:
*   Date       Name  Description 
*   08-Aug-94  DMW   Created.
*   28-Sep-94  TLR   Added _ATM_RESOURCES and _NO_PRIVILEGE
*   24-Oct-94  TLR   Added _PENDING
*   15-Dec-94  TLR   Added _CONGESTED
*   20-Feb-95  TLR   Added _NOT_IMPLEMENTED
*   21-Feb-95  TLR   Added _INSUFFICIENT_DATA and _SIGNALING_ERROR
*   07-Mar-95  DMW   Added _NOT_READY and _BUFFER_TOO_SMALL
*
* Description:
*   A collection of common return codes.
--*/

/* Define argument errors first, so that value matches argument number. */

#define STATUS_K_SUCCESS             0
#define STATUS_K_ARG_1_BAD           1
#define STATUS_K_ARG_2_BAD           2
#define STATUS_K_ARG_3_BAD           3
#define STATUS_K_ARG_4_BAD           4
#define STATUS_K_ARG_5_BAD           5
#define STATUS_K_ARG_6_BAD           6
#define STATUS_K_ARG_7_BAD           7
#define STATUS_K_ARG_8_BAD           8
#define STATUS_K_ARG_9_BAD           9
#define STATUS_K_ARG_10_BAD          10
#define STATUS_K_ARG_11_BAD          11
#define STATUS_K_ARG_12_BAD          12
#define STATUS_K_ARG_13_BAD          13
#define STATUS_K_ARG_14_BAD          14
#define STATUS_K_ARG_15_BAD          15

/* Leave undefined values for future expansion. Start at a round hex value. */

#define STATUS_K_FAILURE             32
#define STATUS_K_NOT_OPEN            33
#define STATUS_K_ALREADY_OPEN        34
#define STATUS_K_NOT_CLOSED          35
#define STATUS_K_ALREADY_CLOSED      36
#define STATUS_K_BUSY                37
#define STATUS_K_RESOURCES           38
#define STATUS_K_ATM_RESOURCES       39
#define STATUS_K_TIMEOUT             40
#define STATUS_K_ARGS_INCONSISTENT   41
#define STATUS_K_SW_FAULT            42
#define STATUS_K_HW_FAULT            43
#define STATUS_K_CONFIG_BAD          44
#define STATUS_K_NOT_FOUND           45
#define STATUS_K_NO_WORK_TO_DO       46
#define STATUS_K_NO_PRIVILEGE        47
#define STATUS_K_PENDING             48
#define STATUS_K_CONGESTED           49
#define STATUS_K_NOT_IMPLEMENTED     50
#define STATUS_K_INSUFFICIENT_DATA   51
#define STATUS_K_SIGNALING_ERROR     52
#define STATUS_K_NOT_READY           53
#define STATUS_K_BUFFER_TOO_SMALL    54
#define STATUS_K_MISMATCH            55
#define STATUS_K_REJECT              56


