
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Mon Sep 1 2003
 */

// own header
#include "cppcodecomment.h"

// qt/kde includes
#include <qregexp.h>

// Constructors/Destructors
//

CPPCodeComment::CPPCodeComment ( CodeDocument * doc, const QString & text )
        : CodeComment (doc, text)
{

}

CPPCodeComment::~CPPCodeComment ( ) { }

//
// Methods
//


// Accessor methods
//


// Public attribute accessor methods
//

// Other methods
//

/**
 * Save the XMI representation of this object
 */
void CPPCodeComment::saveToXMI ( QDomDocument & doc, QDomElement & root ) {
    QDomElement blockElement = doc.createElement( "cppcodecomment" );
    setAttributesOnNode(doc, blockElement); // as we added no additional fields to this class we may
    // just use parent TextBlock method
    root.appendChild( blockElement );
}

/**
 * @return      QString
 */
QString CPPCodeComment::toString ( )
{

    QString output = "";

    // simple output method
    if(getWriteOutText())
    {
        QString indent = getIndentationString();
        QString endLine = getNewLineEndingChars();
        output.append(formatMultiLineText (getText()+endLine, indent +"// ", endLine));
    }

    return output;
}

QString CPPCodeComment::getNewEditorLine ( int amount ) {
    QString line = getIndentationString(amount) + "// ";
    return line;
}

/** UnFormat a long text string. Typically, this means removing
 *  the indentaion (linePrefix) and/or newline chars from each line.
 */
QString CPPCodeComment::unformatText ( const QString & text , const QString & indent)
{

    // remove leading or trailing comment stuff
    QString mytext = TextBlock::unformatText(text, indent);

    // now leading slashes
    mytext.remove(QRegExp("^\\/\\/\\s*"));
    return mytext;
}

#include "cppcodecomment.moc"
