#!/usr/bin/env python

#****************************************************************************
#** $Id: bigtable.py 322023 2004-06-19 20:33:37Z sedwards $
#**
#** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
#**
#** This file is part of an example program for PyQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys
import os
from qt import *
from qttable import *

TRUE  = 1
FALSE = 0

numRows = 1000000
numCols = 1000000

class MyTable(QTable):
    def __init__(self, r, c):
        QTable.__init__(self, r, c)
        self.items = {}
        self.widgets = {}
        self.setCaption("This is a big table with 1.000.000x1.000.000 cells...")
        self.setLeftMargin(self.fontMetrics().width("W999999W"))

    def resizeData(self, v):
        return

    def item(self, r, c):
        try:
            return self.items[self.indexOf(r, c)]
        except KeyError:
            return None

    def setItem(self, r, c, i):
        self.items[self.indexOf(r, c)] = i

    def clearCell(self, r, c):
        try:
            del self.items[self.indexOf(r, c)]
        except KeyError:
            pass

    def insertWidget(self, r, c, w):
        self.widgets[self.indexOf(r, c)] = w

    def cellWidget(self, r, c):
        try:
            return self.widgets[self.indexOf(r, c)]
        except KeyError:
            return None

    def clearCellWidget(self, r, c):
        try:
            del self.widgets[self.indexOf(r, c)]
        except KeyError:
            pass


if __name__ == '__main__':
    app = QApplication(sys.argv)

    table = MyTable(numRows, numCols)
    app.setMainWidget(table)
    table.show()
    app.exec_loop()
