drop database testdb;
create database testdb;
use testdb;

create table people (id integer primary key auto_increment,
                     name char(40));

create table staff (id integer primary key auto_increment,
                    forename char(40),
                    surname char(40),
                    salary float(10,2),
                    statusid integer);

create table status (id integer primary key,
                     name char(30));

create table creditors (id integer primary key auto_increment,
                        forename char(40),
                        surname char(40),
                        city char(30));

create table prices (id integer primary key,
                     name char(40),
                     price float);

create table invoiceitem (id integer primary key auto_increment, 
                          pricesid integer,
                          quantity integer,
                          paiddate date);

insert into staff (forename, surname, salary, statusid) values
            ("Hugo", "Hurtig", 123450.50, 0),
            ("Alfred E.", "Neumann", 56780.90, 1),
            ("Agate", "Schnell-Fertig", 12340.56, 2),
            ("Emil", "Dotterschreck", -5670.23, 3),
            ("Eugen", "Nutzlos", -7833.56, 3),
            ("Harald", "Schmidt", -150000.0, 3),
            ("Urmel", "auf dem Eis", 7778.0, 2);

insert into status (id, name) values
            (0, 'Chief'),
            (1, 'Programmer'),
            (2, 'Secretary'),
            (3, 'Driver');

insert into prices (id, name, price) values
            (0, "Waschbecken", 150.25),
            (1, "Wellensittich", 27.95),
            (2, "Roter Papagei", 850.0),
            (3, "Spam & Eggs", -7.50),
            (4, "Renault Espace", 9000.0),
            (5, "Tux, der Pinguin", 65.35),
            (6, "Makroskop", 985000.0),
            (7, "Regenbaum", 1235.65),
            (8, "Blutergu", 23.95),
            (9, "Weltmeisterschaft", 2.95),
            (10, "Premiere Dekoder", -185.75);
