from qt import Qt, QFrame, QHBoxLayout, QVBoxLayout, QLabel, SIGNAL
from kdeui import KPassivePopup, KTextEdit, KPushButton
from kdecore import KGlobal, KIcon

iconName = 'popup'
labelText = 'KPassivePopup'
docParts = ('kdeui', 'KPassivePopup')
helpText = ('Examples of the KPassivePopup widget.')


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)
        self.button = KPushButton('Show Passive Popups', self)
        
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help, 10)
        buttonLayout = QHBoxLayout(layout, 4)
        buttonLayout.addWidget(self.button, 1)
        buttonLayout.addStretch(10)
        layout.addStretch(10)


        self.connect(self.button, SIGNAL('clicked()'), self.showPopups)


    def showPopups(self):
        ## no support for all of the 3.5 calls
        pop = KPassivePopup.message('Hello, <i>KPassivePopup</i>', self)
        pop.setTimeout(3000)
        pop.show()

        
        pos = pop.pos()
        pos.setY(pos.y() + pop.height() + 10)
        
        ico = KGlobal.instance().iconLoader().loadIcon('help', KIcon.NoGroup,
                                                       KIcon.SizeSmall)
        pop = KPassivePopup.message('<b>Hello</b>', 'With Icons', ico, self)
        pop.setTimeout(3000)
        pop.show()
        pop.move(pos)
