from qt import QFrame, QHBoxLayout, QVBoxLayout, SIGNAL, QColor, QSizePolicy, QLabel
from kdecore import i18n
from kdeui import KPushButton, KGradientSelector, KTextEdit, KDualColorButton, KColorPatch

iconName = 'colors'
labelText = 'KGradientSelector'
docParts = ('kdeui', 'KGradientSelector')
helpText = ("An example of the KGradientSelector widget."
            "\n"
            "Change the start and finish colors with the dual color button."
            )


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)
        self.selector = KGradientSelector(self)
        self.dualLabel = QLabel('Select Colors:', self)
        
        self.startColor = QColor('red')
        self.finishColor = QColor('blue')

        self.selector.setColors(self.startColor, self.finishColor)
        self.selector.setText('Start', 'Finish')
        
        self.dualButton = KDualColorButton(self.startColor, self.finishColor, self)
        self.dualButton.setSizePolicy(QSizePolicy(QSizePolicy.Maximum,
                                                  QSizePolicy.Maximum))

        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help, 20)

        buttonLayout = QHBoxLayout(layout, 4)
        buttonLayout.addWidget(self.dualLabel, 0)
        buttonLayout.addWidget(self.dualButton, 1)

        layout.addWidget(self.selector, 10)


        self.connect(self.dualButton, SIGNAL('fgChanged(const QColor &)'),
                     self.selector.setFirstColor)
        self.connect(self.dualButton, SIGNAL('bgChanged(const QColor &)'),
                     self.selector.setSecondColor)        
        self.connect(self.selector, SIGNAL('valueChanged(int)'),
                     self.updateValue)


    def updateValue(self, value):
        ## this should be extended to update a color swatch
        pass
