
from qt import QFrame, QHBoxLayout, QVBoxLayout, QTimer, SIGNAL, QFont, QString
from kdecore import i18n
from kdeui import KPushButton, KEdFind, KTextEdit

iconName = 'find'
labelText = 'KEdFind'
docParts = ('kdeui', 'KEdFind')
helpText = ("An example of the KEdFind dialog.")


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Edit Find Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showEdFind)


    def showEdFind(self):
        dlg = self.dlg = KEdFind(self)
        self.connect(dlg, SIGNAL('done()'),
                    self.doneClicked)
        self.connect(dlg, SIGNAL('search()'),
                    self.searchClicked)        
        dlg.exec_loop()


    def doneClicked(self):
        print 'done searching'

    def searchClicked(self):
        print 'searching: ', self.dlg.getText(),
        if self.dlg.get_direction():
            print '(backwards) ',
        else:
            print '(forwards) ',
        if self.dlg.case_sensitive():
            print '(case-sensitive)'
        else:
            print '(case-insensitive)'
        

        

