//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QDataStream;
import java.util.ArrayList;

/**

  KCmdLineArgs provides simple access to the command-line arguments
  for an application. It takes into account Qt-specific options,
  KDE-specific options and application specific options.
  This class is used in %main() via the static method
  init().
  A typical %KDE application using %KCmdLineArgs should look like this:
  <pre>
  int main(String[] args)
  {
     // Initialize command line args
     KCmdLineArgs.init(args, appName, programName, description, version);
     // Tell which options are supported
     KCmdLineArgs.addCmdLineOptions( options );
     // Add options from other components
     KUniqueApplication.addCmdLineOptions();
     ....
     // Create application object without passing 'argc' and 'argv' again.
     KUniqueApplication app;
     ....
     // Handle our own options/arguments
     // A KApplication will usually do this in main but this is not
     // necessary.
     // A KUniqueApplication might want to handle it in newInstance().
     KCmdLineArgs args = KCmdLineArgs.parsedArgs();
     // A binary option (on / off)
     if (args.isSet("some-option"))
        ....
     // An option which takes an additional argument
     String anotherOptionArg = args.getOption("another-option");
     // Arguments (e.g. files to open)
     for(int i = 0; i < args.count(); i++) // Counting start at 0!
     {
        // don't forget to convert to Unicode!
        openFile( QFile.decodeName( args.arg(i)));
        // Or more convenient:
        // openURL( args.url(i));
     }
     args.clear(); // Free up some memory.
     ....
  }
  </pre>
  The options that an application supports are configured using the
  String[][] class. An example is shown below:
  <pre>
  static String[][] options =
  {
     { "a", I18N_NOOP("A short binary option"), 0 },
     { "b \<file>", I18N_NOOP("A short option which takes an argument"), 0 },
     { "c \<speed>", I18N_NOOP("As above but with a default value"), "9600" },
     { "option1", I18N_NOOP("A long binary option, off by default"), 0 },
     { "nooption2", I18N_NOOP("A long binary option, on by default"), 0 },
     { ":", I18N_NOOP("Extra options:"), 0 },
     { "option3 \<file>", I18N_NOOP("A long option which takes an argument"), 0 },
     { "option4 \<speed>", I18N_NOOP("A long option which takes an argument, defaulting to 9600"), "9600" },
     { "d", 0, 0 },
     { "option5", I18N_NOOP("A long option which has a short option as alias"), 0 },
     { "e", 0, 0 },
     { "nooption6", I18N_NOOP("Another long option with an alias"), 0 },
     { "f", 0, 0 },
     { "option7 \<speed>", I18N_NOOP("'--option7 speed' is the same as '-f speed'"), 0 },
     { "!option8 \<cmd>", I18N_NOOP("All options following this one will be treated as arguments"), 0 },
     { "+file", I18N_NOOP("A required argument 'file'"), 0 },
     { "+[arg1]", I18N_NOOP("An optional argument 'arg1'"), 0 },
     { "!+command", I18N_NOOP("A required argument 'command', that can contain multiple words, even starting with '-'"), 0 },
     { "", I18N_NOOP("Additional help text not associated with any particular option") 0 },
      // End of options.
  }
  </pre>
  The I18N_NOOP macro is used to indicate that these strings should be
  marked for translation. The actual translation is done by KCmdLineArgs.
  You can't use i18n() here because we are setting up a static data
  structure and can't do translations at compile time.
  Note that a program should define the options before any arguments.
  When a long option has a short option as an alias, a program should
  only test for the long option.
  With the above options a command line could look like:
  <pre>
     myapp -a -c 4800 --display localhost:0.0 --nooption5 -d /tmp/file
  </pre>
  Long binary options can be in the form 'option' and 'nooption'.
  A command line may contain the same binary option multiple times,
  the last option determines the outcome:
  <pre>
     myapp --nooption4 --option4 --nooption4
  </pre>
  is the same as:
  <pre>
     myapp --nooption4
  </pre>
  If an option value is provided multiple times, normally only the last
  value is used:
  <pre>
     myapp -c 1200 -c 2400 -c 4800
  </pre>
  is usually the same as:
  <pre>
     myapp -c 4800
  </pre>
  However, an application can choose to use all values specified as well.
  As an example of this, consider that you may wish to specify a
  number of directories to use:
  <pre>
     myapp -I /usr/include -I /opt/kde/include -I /usr/X11/include
  </pre>
  When an application does this it should mention this in the description
  of the option. To access these options, use getOptionList()
  Tips for end-users:

	<li>
	Single char options like "-a -b -c" may be combined into "-abc"
	</li>
	
	<li>
	The option "--foo bar" may also be written "--foo=bar"
	</li>
	
	<li>
	The option "-P lp1" may also be written "-P=lp1" or "-Plp1"
	</li>
	
	<li>
	The option "--foo bar" may also be written "-foo bar"
	</li>
			@author Waldo Bastian

		@version 0.0.4
 
		@short A class for command-line argument handling.

*/
public class KCmdLineArgs implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KCmdLineArgs(Class dummy){}

	/**	
		  Read out a string option.
			  The option must have a corresponding String[][] entry
		  of the form:
		  <pre>
		    { "option \<argument>", I18N_NOOP("Description"), "default" }
		  </pre>
		  You cannot test for the presence of an alias - you must always
		  test for the full option.
			@param option The name of the option without '-'.
				@return The value of the option. If the option was not
          present on the command line the default is returned.
          If the option was present more than the value of the
          last occurrence is used.
   
		@short     Read out a string option.
	*/
	public native String getOption(String option);
	/**	
		  Read out all occurrences of a string option.
			  The option must have a corresponding String[][] entry
		  of the form:
		  <pre>
		    { "option \<argument>", I18N_NOOP("Description"), "default" }
		  </pre>
		  You cannot test for the presence of an alias - you must always
		  test for the full option.
			@param option The name of the option, without '-' or '-no'.
				@return A list of all option values. If no option was present
          on the command line, an empty list is returned.
   
		@short     Read out all occurrences of a string option.
	*/
	public native ArrayList getOptionList(String option);
	/**	
		  Read out a booleanean option or check for the presence of string option.
			@param option The name of the option without '-' or '-no'.
				@return The value of the option. It will be true if the option
  was specifically turned on in the command line, or if the option
  is turned on by default (in the String[][] list) and was
  not specifically turned off in the command line. Equivalently,
  it will be false if the option was specifically turned off in
  the command line, or if the option is turned off by default (in
  the KCmdLineOptions list) and was not specifically turned on in
  the command line.
   
		@short     Read out a boolean option or check for the presence of string option.
	*/
	public native boolean isSet(String option);
	/**	
		  Read the number of arguments that aren't options (but,
		  for example, filenames).
				@return The number of arguments that aren't options
   
		@short     Read the number of arguments that aren't options (but,   for example, filenames).
	*/
	public native int count();
	/**	
		  Read out an argument.
			@param n The argument to read. 0 is the first argument.
		 count()-1 is the last argument.
				@return A <code>const</code> <code>char</code> <code></code>* pointer to the n'th argument.
   
		@short     Read out an argument.
	*/
	public native String arg(int n);
	/**	
		  Read out an argument representing a URL.
			  The argument can be
		
			<li>
			an absolute filename
			</li>
			
			<li>
			a relative filename
			</li>
			
			<li>
			a URL
			</li>
				@param n The argument to read. 0 is the first argument.
		 count()-1 is the last argument.
				@return a URL representing the n'th argument.
   
		@short     Read out an argument representing a URL.
	*/
	public native KURL url(int n);
	/**	
		  Clear all options and arguments.
		   		@short     Clear all options and arguments.
	*/
	public native void clear();
	/**	
		 Initialize class.
			 This function should be called as the very first thing in
		  your application.
				@param _argv As passed to <code>main</code>(...).
			@param _appname The untranslated name of your application. This should
		                match with <code>argv</code>[0].
			@param programName A program name string to be used for display
		        purposes. This string should be marked for
		        translation. Example: I18N_NOOP("KEdit")
			@param _description A short description of what your application is about.
			@param _version A version.
			@param noKApp Set this true to not add commandline options for
		        QApplication / KApplication
				@short    Initialize class.
	*/
	public static native void init(String[] _argv, String _appname, String programName, String _description, String _version, boolean noKApp);
	public static native void init(String[] _argv, String _appname, String programName, String _description, String _version);
	/**	
		 Initialize class.
			 This function should be called as the very first thing in
		  your application. It uses KAboutData to replace some of the
		  arguments that would otherwise be required.
				@param _argv As passed to <code>main</code>(...).
			@param about A KAboutData object describing your program.
			@param noKApp Set this true to not add commandline options for
		        QApplication / KApplication
		   		@short    Initialize class.
	*/
	public static native void init(String[] _argv, KAboutData about, boolean noKApp);
	public static native void init(String[] _argv, KAboutData about);
	/**	
		 Initialize Class
			 This function should be called as the very first thing in your
		 application. This method will rarely be used, since it doesn't
		 provide any argument parsing. It does provide access to the
		 KAboutData information.
		 This method is exactly the same as calling
		 init(0,0, const KAboutData about, true).
			@param about the about data.
		 \see KAboutData
		   		@short    Initialize Class
	*/
	public static native void init(KAboutData about);
	/**	
		 Add options to your application.
			 You must make sure that all possible options have been added before
		 any class uses the command line arguments.
			 The list of options should look like this:
			 <pre>
		 static String[][] options =
		 {
		    { "option1 \<argument>", I18N_NOOP("Description 1"), "my_extra_arg" },
		    { "o", 0, 0 },
		    { "option2", I18N_NOOP("Description 2"), 0 },
		    { "nooption3", I18N_NOOP("Description 3"), 0 },
		    
		 }
		 </pre>
		
			<li>
			"option1" is an option that requires an additional argument,
			     but if one is not provided, it uses "my_extra_arg".
			</li>
			
			<li>
			"option2" is an option that can be turned on. The default is off.
			</li>
			
			<li>
			"option3" is an option that can be turned off. The default is on.
			</li>
			
			<li>
			"o" does not have a description. It is an alias for the option
			     that follows. In this case "option2".
			</li>
			
			<li>
			"+file" specifies an argument. The '+' is removed. If your program
			     doesn't specify that it can use arguments your program will abort
			     when an argument is passed to it. Note that the reverse is not
			     true. If required, you must check yourself the number of arguments
			     specified by the user:
			     <pre>
			       KCmdLineArgs args = KCmdLineArgs.parsedArgs();
			       if (args.count() == 0) KCmdLineArgs.usage(i18n("No file specified!"));
			     </pre>
			</li>
				 In BNF:
		 <pre>
		 cmd = myapp [options] file
		 options = (option)
		 option = --option1 \<argument> |
		          (-o | --option2 | --nooption2) |
		          ( --option3 | --nooption3 )
		 </pre>
			 Instead of "--option3" one may also use "-option3"
			 Usage examples:
		
			<li>
			"myapp --option1 test"
			</li>
			
			<li>
			"myapp" (same as "myapp --option1 my_extra_arg")
			</li>
			
			<li>
			"myapp --option2"
			</li>
			
			<li>
			"myapp --nooption2" (same as "myapp", since it is off by default)
			</li>
			
			<li>
			"myapp -o" (same as "myapp --option2")
			</li>
			
			<li>
			"myapp --nooption3"
			</li>
			
			<li>
			"myapp --option3 (same as "myapp", since it is on by default)
			</li>
			
			<li>
			"myapp --option2 --nooption2" (same as "myapp", because it
			     option2 is off by default, and the last usage applies)
			</li>
			
			<li>
			"myapp /tmp/file"
			</li>
				@param options A list of options that your code supplies.
			@param name the name of the option, can be 0.
			@param id A name with which these options can be identified, can be 0.
			@param afterId The options are inserted after this set of options, can be 0.
		   		@short    Add options to your application.
	*/
	public static native void addCmdLineOptions(String[][] options, String name, String id, String afterId);
	public static native void addCmdLineOptions(String[][] options, String name, String id);
	public static native void addCmdLineOptions(String[][] options, String name);
	public static native void addCmdLineOptions(String[][] options);
	/**	
		 Access parsed arguments.
			 This function returns all command line arguments that your code
		 handles. If unknown command-line arguments are encountered the program
		 is aborted and usage information is shown.
			@param id The name of the options you are interested in, can be 0.
		   		@short    Access parsed arguments.
	*/
	public static native KCmdLineArgs parsedArgs(String id);
	public static native KCmdLineArgs parsedArgs();
	/**	
		 Get the CWD (Current Working Directory) associated with the
		 current command line arguments.
			 Typically this is needed in KUniqueApplication.newInstance()
		 since the CWD of the process may be different from the CWD
		 where the user started a second instance.
				@return the current working directory

		@short    Get the CWD (Current Working Directory) associated with the  current command line arguments.
	*/
	public static native String cwd();
	/**	
		 Get the appname according to argv[0].
				@return the name of the application

		@short    Get the appname according to argv[0].
	*/
	public static native String appName();
	/**	
		 Print the usage help to stdout and exit.
			@param id if 0, print all options. If id is set, only print the
		        option specified by id. The id is the value set by
		        addCmdLineOptions().
				@short    Print the usage help to stdout and exit.
	*/
	public static native void usage(String id);
	public static native void usage();
	/**	
		 Enable i18n to be able to print a translated error message.
			 N.B.: This function leaks memory, therefore you are expected to exit
		 afterwards (e.g., by calling usage()).
				@short    Enable i18n to be able to print a translated error message.
	*/
	public static native void enable_i18n();
	/**	
		 Used by url().
		 Made public for apps that don't use KCmdLineArgs
			@param urlArg the argument
				@return the url.
   
		@short    Used by url().
	*/
	public static native KURL makeURL(String urlArg);
	/**	
		 Made public for apps that don't use KCmdLineArgs
		 To be done before makeURL, to set the current working
		 directory in case makeURL needs it.
			@param cwd the new working directory
		   		@short    Made public for apps that don't use KCmdLineArgs  To be done before makeURL, to set the current working  directory in case makeURL needs it.
	*/
	public static native void setCwd(String cwd);
	/**	
		  Reset all option definitions, i.e. cancel all addCmdLineOptions calls.
		  Note that KApplication's options are removed too, you might want to
		  call KApplication.addCmdLineOptions if you want them back.
			  You usually don't want to call this method.
		   		@short     Reset all option definitions, i.
	*/
	public static native void reset();
	/**	
		 Load arguments from a stream.
		   		@short    Load arguments from a stream.
	*/
	public static native void loadAppArgs(QDataStream arg1);
	/**	
		 Add standard option --tempfile
				@short    Add standard option --tempfile
	*/
	public static native void addTempFileOption();
	/**	
				@return true if --tempfile was set

		@short
	*/
	public static native boolean isTempFileSet();
	/**	
			  Constructor.
		   		@short
	*/
	public KCmdLineArgs(String[][] _options, String _name, String _id) {
		newKCmdLineArgs(_options,_name,_id);
	}
	private native void newKCmdLineArgs(String[][] _options, String _name, String _id);
}
