//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QIODevice;
import org.kde.qt.QIODeviceInterface;

/**

 KArchive is a base class for reading and writing archives.
		@author David Faure <faure@kde.org>
 
		@short generic class for reading/writing archives.

*/
public class KArchive implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KArchive(Class dummy){}

	public static final int VIRTUAL_WRITE_DATA = 1;
	public static final int VIRTUAL_WRITE_SYMLINK = 2;
	public static final int VIRTUAL_WRITE_DIR = 3;
	public static final int VIRTUAL_WRITE_FILE = 4;
	public static final int VIRTUAL_PREPARE_WRITING = 5;

	/**	
		 Opens the archive for reading or writing.
		 Inherited classes might want to reimplement openArchive instead.
			@param mode may be IO_ReadOnly or IO_WriteOnly
				@short    Opens the archive for reading or writing.
		@see #close
	*/
	public native boolean open(int mode);
	/**	
		 Closes the archive.
		 Inherited classes might want to reimplement closeArchive instead.
				@short    Closes the archive.
		@see #open
	*/
	public native void close();
	/**	
		 Use to check if close had any problem
				@return true if close succeded without problems

		@short    Use to check if close had any problem
	*/
	public native boolean closeSucceeded();
	/**	
		 Checks whether the archive is open.
				@return true if the archive is opened
     
		@short    Checks whether the archive is open.
	*/
	public native boolean isOpened();
	/**	
		 Returns the mode in which the archive was opened
				@return the mode in which the archive was opened (IO_ReadOnly or IO_WriteOnly)

		@short    Returns the mode in which the archive was opened 
		@see #open
	*/
	public native int mode();
	/**	
		 The underlying device.
				@return the underlying device.
     
		@short    The underlying device.
	*/
	public native QIODeviceInterface device();
	/**	
		 If an archive is opened for reading, then the contents
		 of the archive can be accessed via this function.
				@return the directory of the archive
     
		@short    If an archive is opened for reading, then the contents  of the archive can be accessed via this function.
	*/
	public native KArchiveDirectory directory();
	/**	
		 Writes a local file into the archive. The main difference with writeFile,
		 is that this method minimizes memory usage, by not loading the whole file
		 into memory in one go.
			 If <code>fileName</code> is a symbolic link, it will be written as is, i. e.
		 it will not be resolved before.
			@param fileName full path to an existing local file, to be added to the archive.
			@param destName the resulting name (or relative path) of the file in the archive.
		     		@short    Writes a local file into the archive.
	*/
	public native boolean addLocalFile(String fileName, String destName);
	/**	
		 Writes a local directory into the archive, including all its contents, recursively.
		 Calls addLocalFile for each file to be added.
			 Since KDE 3.2 it will also add a <code>path</code> that is a symbolic link to a
		 directory. The symbolic link will be dereferenced and the content of the
		 directory it is pointing to added recursively. However, symbolic links
		 under <code>path</code> will be stored as is.
			@param path full path to an existing local directory, to be added to the archive.
			@param destName the resulting name (or relative path) of the file in the archive.
		     		@short    Writes a local directory into the archive, including all its contents, recursively.
	*/
	public native boolean addLocalDirectory(String path, String destName);
	/**	
		 If an archive is opened for writing then you can add new directories
		 using this function. KArchive won't write one directory twice.
			@param name the name of the directory
			@param user the user that owns the directory
			@param group the group that owns the directory
			 @todo TODO(BIC): make this a thin wrapper around
		 writeDir(name,user,group,perm,atime,mtime,ctime)
		 or eliminate it
		     		@short    If an archive is opened for writing then you can add new directories  using this function.
	*/
	public native boolean writeDir(String name, String user, String group);
	/**	
		 If an archive is opened for writing then you can add new directories
		 using this function. KArchive won't write one directory twice.
			 This method also allows some file metadata to be
		 set. However, depending on the archive type not all metadata might be
		 regarded.
			@param name the name of the directory
			@param user the user that owns the directory
			@param group the group that owns the directory
			@param perm permissions of the directory
			@param atime time the file was last accessed
			@param mtime modification time of the file
			@param ctime creation time of the file
				@short    If an archive is opened for writing then you can add new directories  using this function.
	*/
	public native boolean writeDir(String name, String user, String group, long perm, int atime, int mtime, int ctime);
	/**	
		 Writes a symbolic link to the archive if the archive must be opened for
		 writing.
			@param name name of symbolic link
			@param target target of symbolic link
			@param user the user that owns the directory
			@param group the group that owns the directory
			@param perm permissions of the directory
			@param atime time the file was last accessed
			@param mtime modification time of the file
			@param ctime creation time of the file
				@short    Writes a symbolic link to the archive if the archive must be opened for  writing.
	*/
	public native boolean writeSymLink(String name, String target, String user, String group, long perm, int atime, int mtime, int ctime);
	/**	
		 If an archive is opened for writing then you can add a new file
		 using this function. If the file name is for example "mydir/test1" then
		 the directory "mydir" is automatically appended first if that did not
		 happen yet.
			@param name the name of the file
			@param user the user that owns the file
			@param group the group that owns the file
			@param size the size of the file
			@param data the data to write (<code>size</code> bytes)
		 @todo TODO(BIC): make this a thin non-wrapper around
		   writeFile(name,user,group,size,perm,atime,mtime,ctime,data)
		     		@short    If an archive is opened for writing then you can add a new file  using this function.
	*/
	public native boolean writeFile(String name, String user, String group, int size, String data);
	/**	
		 If an archive is opened for writing then you can add a new file
		 using this function. If the file name is for example "mydir/test1" then
		 the directory "mydir" is automatically appended first if that did not
		 happen yet.
			 This method also allows some file metadata to be
		 set. However, depending on the archive type not all metadata might be
		 regarded.
			@param name the name of the file
			@param user the user that owns the file
			@param group the group that owns the file
			@param size the size of the file
			@param perm permissions of the file
			@param atime time the file was last accessed
			@param mtime modification time of the file
			@param ctime creation time of the file
			@param data the data to write (<code>size</code> bytes)
				@short    If an archive is opened for writing then you can add a new file  using this function.
	*/
	public native boolean writeFile(String name, String user, String group, int size, long perm, int atime, int mtime, int ctime, String data);
	/**	
		 Here's another way of writing a file into an archive:
		 Call prepareWriting, then call writeData()
		 as many times as wanted then call doneWriting( totalSize ).
		 For tar.gz files, you need to know the size before hand, since it is needed in the header.
		 For zip files, size isn't used.
			@param name the name of the file
			@param user the user that owns the file
			@param group the group that owns the file
			@param size the size of the file
			 @todo TODO(BIC): make this a thin non-wrapper around
		 prepareWriting(name,user,group,size,perm,atime,mtime,ctime)
		 or eliminate it.
		     		@short    Here's another way of writing a file into an archive:  Call prepareWriting, then call writeData()  as many times as wanted then call doneWriting( totalSize ).
	*/
	public native boolean prepareWriting(String name, String user, String group, int size);
	/**	
		 Here's another way of writing a file into an archive:
		 Call prepareWriting, then call writeData()
		 as many times as wanted then call doneWriting( totalSize ).
		 For tar.gz files, you need to know the size before hand, it is needed in the header!
		 For zip files, size isn't used.
			 This method also allows some file metadata to be
		 set. However, depending on the archive type not all metadata might be
		 regarded.
			@param name the name of the file
			@param user the user that owns the file
			@param group the group that owns the file
			@param size the size of the file
			@param perm permissions of the file
			@param atime time the file was last accessed
			@param mtime modification time of the file
			@param ctime creation time of the file
				@short    Here's another way of writing a file into an archive:  Call prepareWriting, then call writeData()  as many times as wanted then call doneWriting( totalSize ).
	*/
	public native boolean prepareWriting(String name, String user, String group, int size, long perm, int atime, int mtime, int ctime);
	/**	
		 Write data into the current file - to be called after calling prepareWriting
		 @todo TODO(BIC) make virtual. For now virtual_hook allows reimplementing it.
		     		@short    Write data into the current file - to be called after calling prepareWriting  @todo TODO(BIC) make virtual.
	*/
	public native boolean writeData(String data, int size);
	/**	
		 Call doneWriting after writing the data.
			@param size the size of the file
				@short    Call doneWriting after writing the data.
		@see #prepareWriting
	*/
	public native boolean doneWriting(int size);
}
