#!/usr/bin/env python

# Qt tutorial 4.

import sys
import qt


class MyWidget(qt.QWidget):
    def __init__(self, parent=None, name=None):
        qt.QWidget.__init__(self, parent, name)

        self.setMinimumSize(200, 120)
        self.setMaximumSize(200, 120)

        quit = qt.QPushButton("Quit", self, "quit")
        quit.setGeometry(62, 40, 75, 30)
        quit.setFont(qt.QFont("Times", 18, qt.QFont.Bold))

        self.connect(quit, qt.SIGNAL("clicked()"), qt.qApp, qt.SLOT("quit()"))


a = qt.QApplication(sys.argv)

w = MyWidget()
w.setGeometry(100, 100, 200, 120)
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
