#!/usr/bin/env python
"""

"""
import sys

from qt import QIconSet, QProcess, QTimer, SIGNAL, SLOT

from kdecore import KAboutData, KApplication, KCmdLineArgs, KGlobal, KIcon
from kdecore import KWin, KWinModule
from kdeui import KComboBox, KMainWindow, KPushButton, QXEmbed


## add the missing items to the pyuic-generated module
import qxembedexample
qxembedexample.KComboBox = KComboBox
qxembedexample.KPushButton = KPushButton

from qxembedexample import QXEmbedExample


def getIcon(name, group=KIcon.NoGroup, size=KIcon.SizeSmall):
    """ returns a kde icon by name

    """
    return KGlobal.instance().iconLoader().loadIcon(name, group, size)

def getIconSet(name, group=KIcon.NoGroup, size=KIcon.SizeSmall):
    """ returns a kde icon set by name

    """
    return KGlobal.instance().iconLoader().loadIconSet(name, group, size)


def getWindow(pid):
    """ return a window info object for the process id (or None)

    """
    for winid in KWinModule().windows():
        info = KWin.info(winid)
        if pid == info.pid:
            return info


class ExampleForm(QXEmbedExample):
    """ wraps the pyuic generated form class with our behavior

    """
    def __init__(self, parent):
        QXEmbedExample.__init__(self, parent)
        combo = self.appNameCombo
        items = [(idx, '%s' % combo.text(idx)) for idx in range(combo.count())]
        for idx, name in items:
            combo.changeItem(getIcon(name), name, idx)
        self.mainTabs.setTabIconSet(self.tab, getIconSet('help'))
        self.launchButton.setIconSet(getIconSet('exec'))
        self.launchButton.setText('Launch and Embed')

    def launchApp(self):
        """ launch the process selected in the combo

        """
        name = self.appNameCombo.currentText()
        self.proc = proc = QProcess()
        proc.addArgument(name)
        code = proc.start()
        if code:
            pid = proc.processIdentifier()
            self.launchPid = pid ## cheap
            QTimer.singleShot(2000, self.embedLaunchedWindow)
        else:
            print 'failed to start %s' % name
            return

    def embedLaunchedWindow(self):
        """ embed the window of the last launched pid

        """
        pid = self.launchPid
        winobj = getWindow(pid)
        if winobj:
            tabs = self.mainTabs
            embedded = QXEmbed(self)
            caption = '%s (%s)' % (winobj.name, pid, )
            tabs.insertTab(embedded, caption)
            embedded.embed(winobj.win)
            tabs.showPage(embedded)
            pxm = KWin.icon(winobj.win)
            tabs.setTabIconSet(embedded, QIconSet(pxm))


class ExampleMain(KMainWindow):
    """ an example main window

    """
    def __init__ (self, *args):
        KMainWindow.__init__(self, *args)
        self.setGeometry(0, 0, 400, 400)
        self.embed = embed = ExampleForm(self)
        self.setCentralWidget(embed)


if __name__ == '__main__':
    aname = 'PyKDE QXEmbed Sample'
    desc = 'A Simple PyKDE QXEmbed Sample'
    ver = '1.0'
    lic = KAboutData.License_GPL
    author = 'Troy Melhase'
    authormail = 'troy@gci.net'

    about = KAboutData(aname, aname, ver, desc, lic, '%s (c) 2004' % authormail)
    about.addAuthor(author, 'hi, mom!', authormail)
    about.addAuthor ('Jim Bublitz', 'For PyKDE', 'jbublitz@nwinternet.com')
    KCmdLineArgs.init(sys.argv, about)
    app = KApplication()
    mainWindow = ExampleMain()
    mainWindow.show()
    app.connect(app, SIGNAL('lastWindowClosed()'), app, SLOT('quit()'))
    app.exec_loop()
