iconName = 'configure_shortcuts'
labelText = 'KKeyDialog'

from qt import QFrame, QHBoxLayout, QVBoxLayout, SIGNAL
from kdecore import i18n
from kdeui import KPushButton, KKeyDialog, KTextEdit


helpText = ("Configuring keystroke shortcuts is simple with KActions and the "
            "KKeyDialog type.  This sample starts the KKeyDialog for the "
            "sampler application.")


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Key Configuration Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showKeysDialog)

    def showKeysDialog(self):
        top = self.topLevelWidget()
        KKeyDialog.configure(top.actionCollection(), self)
