#!/usr/bin/env kjscmd

/* Classic space invaders.
	By Ian Reinhart Geiser
	
	Based off of the Web based JS by Sam Dodge (nancied@mac.com)
*/
var patno = 1;
var cr = "\r\n";
var spcf1 = "";
var spcf2 = "";
var spcf3 = "";
var hitflag = 0;
var score = 0;
var selec = 0;
var rsmiss = "";
var timer = new QTimer(this);
timer.connect(timer, "timeout()", this, "doTurn");

var win = new KMainWindow(this);
var box = new QVBox(win);
var view = new QLabel(box);
//view.setMouseTracking(true);

view.font = "courier,12,-1,5,75,0,0,0,0,0"
    view.paletteBackgroundColor = "black";
view.paletteForegroundColor = "green";

win.setCentralWidget(box);
win.show();
restarter();
view.focusPolicy = 1;
view.setFocus();


view.mousePressEvent = function(ev)
{
    fire();
}

view.keyPressEvent = function(ev)
{
    if (ev.key == 4116)
	gormax();
    if (ev.key == 4114)
	golmax();
    if (ev.key == 32)
	fire();
}

application.exec();

function gameBoard(arn)
{
    this.length = arn;
    for (var ar1 = 0; ar1 <= arn; ar1++) {
	this[ar1] = 1;
    }
    return this;
}

function init()
{
    blankx = new gameBoard(63);
    for (var makeblank = 0; makeblank < 63; makeblank++) {
	blankx[makeblank] = "";
	for (var addBlank = 0; addBlank < makeblank; addBlank++) {
	    blankx[makeblank] = blankx[makeblank] + " ";
	}
    }
    faker = new gameBoard(24);
    face = new gameBoard(2);
    face[1] = " <OvO> ";
    face[2] = " <oVo> ";
    mestotal = new gameBoard(4);
    doTurn();
}

function restarter()
{
    inplay = 0;
    blankno = 0;
    totalblank = "";
    lr = 1;
    lowerlf = "";
    downlf = "";
    downno = 0;
    missilex = 99;
    missiley = 99;
    mychrx = 1;
    myblank = "";
    mymove = 0;
    selec = 1;
    starter();
}

function starter()
{
    view.text = cr + cr + cr + cr + cr + cr + cr + cr + cr + cr
	+ "          Control the ship and stop the enemy invasion!" + cr +
	cr + cr + "                           Click to begin!";
    selec = 1;
}

function goleft()
{
    mymove = 0;
    mychrx = mychrx - 1;
    if (mychrx <= 0) {
	mychrx = 1;
    }
}

function goright()
{
    mymove = mychrx = mychrx + 1;
    if (mychrx >= 56) {
	mychrx = 55;
    }
}

function golmax()
{
    if (inplay == 1) {
	mymove = -1;
    }
}

function gormax()
{
    if (inplay == 1) {
	mymove = 1;
    }
}

function fire()
{
    if (inplay == 0) {
	if (selec == 1) {
	    selec = 9;
	    inplay = 1;
	    init();
	}
    } else {
	if (missiley == 99) {
	    missiley = 18;
	    missilex = mychrx + 3;
	}
    }
}

function gameover()
{
    score = 0;
    for (var enerme = 1; enerme < 25; enerme++) {
	if (faker[enerme] == 1) {
	    score = score + 1;
	}
    }
    if (score == 0) {
	view.text = cr + cr + cr + cr + cr + cr + cr + cr
	    + "                        Congratulations!" + cr + cr
	    + "                          YOU STOPPED THE ENEMY SQUAD!!";
    } else {
	view.text = cr + cr + cr + cr + cr + cr + cr + cr
	    + "                           GAME OVER" + cr + cr
	    + "                   " + score + " INVADERS GOT THROUGH";
    }
    inplay = 0;
}

function doTurn()
{
    if (missiley != 99) {
	missiley = missiley - 1;
    }
    if (missiley < 0) {
	missiley = 99;
    }
    mychrx = mychrx + mymove;
    if (mychrx <= 0) {
	mychrx = 1;
    }
    if (mychrx >= 56) {
	mychrx = 55;
    }
    blankno = blankno + lr;
    totalblank = blankx[blankno];
    if (blankno >= 20) {
	lr = -1;
	downno = downno + 1;
	blankno = 20;
    }
    if (blankno <= 0) {
	lr = 1;
	downno = downno + 1;
	blankno = 0;
    }
    if (downno >= 12) {
	gameover();
    }
    downlf = "";
    for (var upperspc = 0; upperspc < downno; upperspc++) {
	if (missiley == upperspc) {
	    downlf = downlf + blankx[missilex] + "^" + cr;
	} else {
	    downlf = downlf + cr;
	}
    }
    if (inplay == 1) {
	patno = patno + 1;
	if (patno >= 3) {
	    patno = 1;
	}
	for (var addline = 1; addline < 5; addline++) {
	    mestotal[addline] = totalblank;
	    rsmiss = "";
	    if (missiley == (downno + addline * 2 - 2)) {
		if (blankno <= missilex) {
		    hitflag = parseInt((missilex - blankno) / 7, 10);
		    if (hitflag < 6) {
			if ((missilex - blankno - (hitflag * 7)) >= 1) {
			    if ((missilex - blankno - (hitflag * 7)) <= 5) {
				if (faker[(addline * 6) + hitflag - 5] ==
				    1) {
				    faker[(addline * 6) + hitflag - 5] = 0;
				    missiley = 99;
				}
			    }
			}
		    } else {
			if (missilex > (blankno + 42)) {
			    rsmiss = blankx[missilex - blankno - 42] + "^";
			}
		    }
		} else {
		    mestotal[addline] = blankx[missilex] + "^";
		    if (missilex < (blankno - 1)) {
			mestotal[addline] =
			    mestotal[addline] + blankx[blankno - 1 -
						       missilex];
		    }
		}
	    }
	    for (var addfaker = 1; addfaker < 7; addfaker++) {
		if (faker[(addline * 6) + addfaker - 6] == 1) {
		    mestotal[addline] = mestotal[addline] + face[patno];
		} else {
		    mestotal[addline] = mestotal[addline] + "       ";
		}
	    }
	    mestotal[addline] = mestotal[addline] + rsmiss;
	}
	spcf1 = cr;
	spcf2 = cr;
	spcf3 = cr;
	if (missiley == (downno + 1)) {
	    spcf1 = blankx[missilex] + "^" + cr;
	}
	if (missiley == (downno + 3)) {
	    spcf2 = blankx[missilex] + "^" + cr;
	}
	if (missiley == (downno + 5)) {
	    spcf3 = blankx[missilex] + "^" + cr;
	}
	lowerlf = "";

	for (var lowerspc = 0; lowerspc < (11 - downno); lowerspc++) {
	    if (missiley == (downno + 7 + lowerspc)) {
		lowerlf = lowerlf + blankx[missilex] + "^" + cr;
	    } else {
		lowerlf = lowerlf + cr;
	    }
	}
	myblank = blankx[mychrx];
	view.text = downlf + mestotal[1] + cr + spcf1
	    + mestotal[2] + cr + spcf2 + mestotal[3] + cr + spcf3 +
	    mestotal[4]
	    + cr + lowerlf + myblank + "" + cr + myblank + "-<!>-";
	timer.start(250, true);
    }
}
