/*
Copyright (c) 2000 Simon Hausmann <hausmann@kde.org>
Copyright (c) 2000 Lars Knoll <knoll@kde.org>
Copyright (c) 1999 Preston Brown <pbrown@kde.org>
Copyright (c) 1999, 2000 Matthias Ettrich <ettrich@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef __dcopc_h__
#define __dcopc_h__

#ifdef __cplusplus
extern "C" {
#endif

#include <X11/ICE/ICElib.h>

#include <dcopc/marshal.h>
#include <dcopc/util.h>

#include <gtk/gtk.h>

#define DCOP_TYPE_CLIENT             (dcop_client_get_type())
#define DCOP_CLIENT(obj)             GTK_CHECK_CAST((obj), DCOP_TYPE_CLIENT, DcopClient)
#define DCOP_CLIENT_CLASS(klass)     GTK_CHECK_CLASS_CAST((klass), DCOP_TYPE_CLIENT, DcopClientClass)
#define DCOP_IS_CLIENT(obj)          GTK_CHECK_TYPE((obj), DCOP_TYPE_CLIENT)
#define DCOP_IS_CLIENT_CLASS(klass)  GTK_CHECK_CLASS_TYPE((klass), DCOP_TYPE_CLIENT)

typedef struct _DcopClient DcopClient;
typedef struct _DcopClientClass DcopClientClass;

struct _DcopClient
{
    GtkObject obj;
    void *priv;
};

struct _DcopClientClass
{
    GtkObjectClass parent_class;

    gboolean (*process) ( DcopClient *client, const gchar *fun, dcop_data *data,
                          gchar **reply_type, dcop_data **reply_data );
};

typedef struct _DcopClientTransaction DcopClientTransaction;

extern GtkType dcop_client_get_type( void );

extern DcopClient *dcop_client_new( void );

void dcop_client_set_server_address( const gchar *addr );

gboolean dcop_client_attach( DcopClient *client );

gboolean dcop_client_detach( DcopClient *client );

gboolean dcop_client_is_attached( DcopClient *client );

const char *dcop_client_register_as( DcopClient *client, const gchar *app_id, gboolean add_pid /* = TRUE */ );

gboolean dcop_client_is_registered( DcopClient *client );

const gchar *dcop_client_app_id( DcopClient *client );

int dcop_client_socket( DcopClient *client );

gboolean dcop_client_send( DcopClient *client,
                           const gchar *rem_app, const gchar *rem_obj, const gchar *rem_fun,
                           dcop_data *data );

gboolean dcop_client_call( DcopClient *client,
                           const gchar *rem_app, const gchar *rem_obj, const gchar *rem_fun,
                           dcop_data *data,
                           gchar **reply_type, dcop_data **reply_data );

DcopClientTransaction *dcop_client_begin_transaction( DcopClient *client );

void dcop_client_end_transaction( DcopClient *client, DcopClientTransaction *transaction, gchar *reply_type, dcop_data *reply_data );

gint32 dcop_client_transaction_id( DcopClient *client );

gboolean dcop_client_is_application_registered( DcopClient *client, const gchar *rem_app );

GList *dcop_client_registered_applications( DcopClient *client );

gboolean dcop_client_receive( DcopClient *client,
                              const gchar *app, const gchar *obj, const gchar *fun,
                              dcop_data *data,
                              gchar **reply_type, dcop_data **reply_data );

gchar *dcop_client_normalize_function_signature( const gchar *fun );

const gchar *dcop_client_sender_id( DcopClient *client );

void dcop_client_set_default_object( DcopClient *client, const gchar *obj_id );

const gchar *dcop_client_default_object( DcopClient *client );

gboolean dcop_client_process ( DcopClient *client, const char *gfun, dcop_data *data,
                               gchar **reply_type, dcop_data **reply_data );

void dcop_client_process_socket_data( DcopClient *client );

const gchar *dcop_client_error_message();

void dcop_client_emit_dcop_signal( DcopClient *client,
                                   const gchar *object, const gchar *signal, dcop_data *data );

gboolean dcop_client_connect_dcop_signal( DcopClient *client,
                                          const gchar *sender, const gchar *sender_obj,
                                          const gchar *signal,
                                          const gchar *receiver_obj, const gchar *slot,
                                          gboolean _volatile );

gboolean dcop_client_disconnect_dcop_signal( DcopClient *client,
                                             const gchar *sender, const gchar *sender_obj,
                                             const gchar *signal,
                                             const gchar *receiver_obj, const gchar *slot );

void dcop_client_set_daemon_mode( DcopClient *client, gboolean daemon );

#ifdef __cplusplus
}
#endif

#endif
