// RUN: %clang_cc1 -fsyntax-only -Wno-unused-value -Wno-conversion -ffreestanding -verify -enable-16bit-types -HV 2018 %s

//
// we use -Wno-unused-value because we generate some no-op expressions to yield errors
// without also putting them in a static assertion
//
// we use -Wno-conversion because many of the assignments result in precision loss
//

// non-standard: consider right-hand-side const as equivalent
//template<typename T>             struct is_same<T, const T> : public true_type{};
// non-standard: consider right-hand-side lvalue as equivalent
//template<typename T>             struct is_same<T, T&>      : public true_type{};

// __decltype is the GCC way of saying 'decltype', but doesn't require C++11
// _Static_assert is the C11 way of saying 'static_assert', but doesn't require C++11
#ifdef VERIFY_FXC
#define _Static_assert(a,b,c) ;
#endif

// To test with the classic compiler, run
// %sdxroot%\tools\x86\fxc.exe /T vs_5_1 scalar-operators-assign.hlsl
// with vs_2_0 (the default) min16float usage produces a complaint that it's not supported

float4 plain(float4 param4 /* : FOO */) /*: FOO */{
    bool        bools       = 0;
    int         ints        = 0;
    uint        uints       = 0;
    dword       dwords      = 0;
    half        halfs       = 0;
    float       floats      = 0;
    double      doubles     = 0;
    min16float  min16floats = 0;
    min10float  min10floats = 0;    min16int    min16ints   = 0;
    min12int    min12ints   = 0;    min16uint   min16uints  = 0;
    int16_t     int16_ts    = 0; /* fxc-error {{X3000: unrecognized identifier 'int16_t'}} fxc-error {{X3000: unrecognized identifier 'int16_ts'}} */
    int32_t     int32_ts    = 0; /* fxc-error {{X3000: unrecognized identifier 'int32_t'}} fxc-error {{X3000: unrecognized identifier 'int32_ts'}} */
    int64_t     int64_ts    = 0; /* fxc-error {{X3000: unrecognized identifier 'int64_t'}} fxc-error {{X3000: unrecognized identifier 'int64_ts'}} */
    uint16_t    uint16_ts   = 0; /* fxc-error {{X3000: unrecognized identifier 'uint16_t'}} fxc-error {{X3000: unrecognized identifier 'uint16_ts'}} */
    uint32_t    uint32_ts   = 0; /* fxc-error {{X3000: unrecognized identifier 'uint32_t'}} fxc-error {{X3000: unrecognized identifier 'uint32_ts'}} */
    uint64_t    uint64_ts   = 0; /* fxc-error {{X3000: unrecognized identifier 'uint64_t'}} fxc-error {{X3000: unrecognized identifier 'uint64_ts'}} */
    float16_t   float16_ts  = 0; /* fxc-error {{X3000: unrecognized identifier 'float16_t'}} fxc-error {{X3000: unrecognized identifier 'float16_ts'}} */
    float32_t   float32_ts  = 0; /* fxc-error {{X3000: unrecognized identifier 'float32_t'}} fxc-error {{X3000: unrecognized identifier 'float32_ts'}} */
    float64_t   float64_ts  = 0; /* fxc-error {{X3000: unrecognized identifier 'float64_t'}} fxc-error {{X3000: unrecognized identifier 'float64_ts'}} */

// TODO: Known errors
// boolean assignment is allowed for &=, |=, and ^= when it should be illegal

/* <py>
primitiveTypes = [
  ("bool", 32, False, False),
  ("int", 32, False, False),
  ("uint", 32, False, True),
  ("half", 16, True, False),
  ("float", 32, True, False),
  ("double", 64, True, False),
  ("min16float", 16, True, False),
  ("min10float",10, True, False),
  ("min16int", 16, False, False),
  ("min12int", 12, False, False),
  ("min16uint", 16, False, True),
  ("int16_t", 16, False, False),
  ("int32_t", 32, False, False),
  ("int64_t", 64, False, False),
  ("uint16_t", 16, False, True),
  ("uint32_t", 32, False, True),
  ("uint64_t", 64, False, True),
  ("float16_t", 16, True, False),
  ("float32_t", 32, True, False),
  ("float64_t", 64, True, False),
]

AssignOperators = [ "=", "+=", "-=", "/=", "%=" ]

BitAssignOperators = [ "<<=", ">>=", "&=", "|=", "^="]

def GenerateAssignStatement(operator, operand1, operand2):
    type1, size1, is_float1, unsigned1 = operand1
    type2, size2, is_float2, unsigned2 = operand2
    if operator in BitAssignOperators:
        if is_float1 or is_float2 or type1 == "bool":
            return "({0}s {1} {2}s);".format(type1, operator, type2)
        return "_Static_assert(std::is_same<{0}, __decltype({1}s {2} {3}s)>::value, \"\");".format(type1, type1, operator, type2)
    # some exceptions for arithmetic assigmnets
    # double modulo
    if operator == "%=" and (type1 == "double" or type2 == "double" or type1 == "float64_t" or type2 == "float64_t"):
        return "({0}s {1} {2}s);".format(type1, operator, type2)
    # bool lvalue
    if type1 == "bool":
        return "({0}s {1} {2}s);".format(type1, operator, type2)
    # min precision division for signed integer
    if (type2 == "min12int" or type2 == "min16int") and operator == "/":
        return "({0}s {1} {2}s);".format(type1, operator, type2)
    return "_Static_assert(std::is_same<{0}, __decltype({1}s {2} {3}s)>::value, \"\");".format(type1, type1, operator, type2)

def GenerateAssignOperators():
    result = []
    for operator in AssignOperators + BitAssignOperators:
        for operand1 in primitiveTypes:
            for operand2 in primitiveTypes:
                result += [GenerateAssignStatement(operator, operand1, operand2)]
    return result
</py>*/
// <py::lines('GENERATED_ASSIGN')>GenerateAssignOperators()</py>
// GENERATED_ASSIGN:BEGIN
(bools = bools);
(bools = ints);
(bools = uints);
(bools = halfs);
(bools = floats);
(bools = doubles);
(bools = min16floats);
(bools = min10floats);
(bools = min16ints);
(bools = min12ints);
(bools = min16uints);
(bools = int16_ts);              /* fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools = int32_ts);              /* fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools = int64_ts);              /* fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools = uint16_ts);             /* fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools = uint32_ts);             /* fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools = uint64_ts);             /* fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools = float16_ts);            /* fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools = float32_ts);            /* fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools = float64_ts);            /* fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints = bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = halfs)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = doubles)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = min16floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = min10floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = uint64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = float16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = float32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints = float64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = halfs)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = doubles)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = min16floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = min10floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = uint64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = float16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = float32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints = float64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = bools)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = halfs)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = doubles)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = min16floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = min10floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = min16ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = min12ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = min16uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = int16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = int32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = int64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = uint16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = uint32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = uint64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = float16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = float32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs = float64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = bools)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = doubles)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = min16floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = min10floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = min16ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = min12ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = min16uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = int16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = int32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = int64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = uint16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = uint32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = uint64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = float16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = float32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats = float64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = bools)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = halfs)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = doubles)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = min16floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = min10floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = min16ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = min12ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = min16uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = int16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = int32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = int64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = uint16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = uint32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = uint64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = float16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = float32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles = float64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = bools)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = halfs)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = min16floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = min10floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = min16ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = min12ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = min16uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = int16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = int32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = int64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = uint16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = uint32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = uint64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = float16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = float32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats = float64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = bools)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = halfs)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = doubles)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = min16floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = min10floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = min16ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = min12ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = min16uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = int16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = int32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = int64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = uint16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = uint32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = uint64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = float16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = float32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats = float64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = bools)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = halfs)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = doubles)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = min16floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = min10floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = min16ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = min12ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = min16uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = uint64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = float16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = float32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints = float64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = bools)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = halfs)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = doubles)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = min16floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = min10floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = min16ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = min12ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = uint64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = float16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = float32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints = float64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = halfs)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = doubles)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = min16floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = min10floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = min16ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = uint64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = float16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = float32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints = float64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = halfs)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = doubles)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = min16floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = min10floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = uint64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = float16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = float32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts = float64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = halfs)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = doubles)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = min16floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = min10floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = uint64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = float16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = float32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts = float64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = halfs)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = doubles)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = min16floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = min10floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = uint64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = float16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = float32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts = float64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = halfs)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = doubles)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = min16floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = min10floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = uint64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = float16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = float32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts = float64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = halfs)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = doubles)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = min16floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = min10floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = uint64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = float16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = float32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts = float64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = halfs)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = doubles)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = min16floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = min10floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = uint64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = float16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = float32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts = float64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = bools)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = halfs)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = doubles)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = min16floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = min10floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = min16ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = min12ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = min16uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = int16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = int32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = int64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = uint16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = uint32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = float16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = float32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts = float64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = bools)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = halfs)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = doubles)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = min16floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = min10floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = min16ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = min12ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = min16uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = int16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = int32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = int64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = uint16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = uint32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = uint64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = float32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts = float64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = bools)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = halfs)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = doubles)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = min16floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = min10floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = min16ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = min12ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = min16uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = int16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = int32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = int64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = uint16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = uint32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = uint64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = float16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts = float64_ts)>::value, "");
(bools += bools);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += ints);                 /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += uints);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += halfs);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += floats);               /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += doubles);              /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += min16floats);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += min10floats);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += min16ints);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += min12ints);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += min16uints);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools += int16_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools += int32_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools += int64_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools += uint16_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools += uint32_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools += uint64_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools += float16_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools += float32_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools += float64_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints += bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += halfs)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += doubles)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += min16floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += min10floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += uint64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += float16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += float32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints += float64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += halfs)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += doubles)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += min16floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += min10floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += uint64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += float16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += float32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints += float64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += bools)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += halfs)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += doubles)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += min16floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += min10floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += min16ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += min12ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += min16uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += int16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += int32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += int64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += uint16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += uint32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += uint64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += float16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += float32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs += float64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += bools)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += doubles)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += min16floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += min10floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += min16ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += min12ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += min16uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += int16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += int32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += int64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += uint16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += uint32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += uint64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += float16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += float32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats += float64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += bools)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += halfs)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += doubles)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += min16floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += min10floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += min16ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += min12ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += min16uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += int16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += int32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += int64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += uint16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += uint32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += uint64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += float16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += float32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles += float64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += bools)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += halfs)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += min16floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += min10floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += min16ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += min12ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += min16uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += int16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += int32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += int64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += uint16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += uint32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += uint64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += float16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += float32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats += float64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += bools)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += halfs)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += doubles)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += min16floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += min10floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += min16ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += min12ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += min16uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += int16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += int32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += int64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += uint16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += uint32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += uint64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += float16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += float32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats += float64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += bools)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += halfs)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += doubles)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += min16floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += min10floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += min16ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += min12ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += min16uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += uint64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += float16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += float32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints += float64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += bools)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += halfs)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += doubles)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += min16floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += min10floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += min16ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += min12ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += uint64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += float16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += float32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints += float64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += halfs)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += doubles)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += min16floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += min10floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += min16ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += uint64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += float16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += float32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints += float64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += halfs)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += doubles)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += min16floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += min10floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += uint64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += float16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += float32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts += float64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += halfs)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += doubles)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += min16floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += min10floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += uint64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += float16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += float32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts += float64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += halfs)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += doubles)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += min16floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += min10floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += uint64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += float16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += float32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts += float64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += halfs)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += doubles)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += min16floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += min10floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += uint64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += float16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += float32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts += float64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += halfs)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += doubles)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += min16floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += min10floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += uint64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += float16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += float32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts += float64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += halfs)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += doubles)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += min16floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += min10floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += uint64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += float16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += float32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts += float64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += bools)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += halfs)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += doubles)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += min16floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += min10floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += min16ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += min12ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += min16uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += int16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += int32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += int64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += uint16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += uint32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += float16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += float32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts += float64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += bools)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += halfs)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += doubles)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += min16floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += min10floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += min16ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += min12ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += min16uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += int16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += int32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += int64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += uint16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += uint32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += uint64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += float32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts += float64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += bools)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += halfs)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += doubles)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += min16floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += min10floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += min16ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += min12ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += min16uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += int16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += int32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += int64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += uint16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += uint32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += uint64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += float16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts += float64_ts)>::value, "");
(bools -= bools);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= ints);                 /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= uints);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= halfs);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= floats);               /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= doubles);              /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= min16floats);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= min10floats);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= min16ints);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= min12ints);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= min16uints);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools -= int16_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools -= int32_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools -= int64_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools -= uint16_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools -= uint32_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools -= uint64_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools -= float16_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools -= float32_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools -= float64_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints -= bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= halfs)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= doubles)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= min16floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= min10floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= uint64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= float16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= float32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints -= float64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= halfs)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= doubles)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= min16floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= min10floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= float16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= float32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints -= float64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= bools)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= halfs)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= doubles)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= min16floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= min10floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= min16ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= min12ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= min16uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= int16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= int32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= int64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= uint16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= uint32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= uint64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= float16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= float32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs -= float64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= bools)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= doubles)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= min16floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= min10floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= min16ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= min12ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= min16uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= int16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= int32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= int64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= uint16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= uint32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= uint64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= float16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= float32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats -= float64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= bools)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= halfs)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= doubles)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= min16floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= min10floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= min16ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= min12ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= min16uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= int16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= int32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= int64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= uint16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= uint32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= uint64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= float16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= float32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles -= float64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= bools)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= halfs)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= min16floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= min10floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= min16ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= min12ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= min16uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= int16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= int32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= int64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= uint64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= float16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= float32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats -= float64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= bools)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= halfs)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= doubles)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= min16floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= min10floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= min16ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= min12ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= min16uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= int16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= int32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= int64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= uint16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= uint32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= uint64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= float16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= float32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats -= float64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= bools)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= halfs)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= doubles)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= min16floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= min10floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= min16ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= min12ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= min16uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= uint64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= float16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= float32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints -= float64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= bools)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= halfs)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= doubles)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= min16floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= min10floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= min16ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= min12ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= uint64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= float16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= float32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints -= float64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= halfs)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= doubles)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= min16floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= min10floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= min16ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= uint64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= float16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= float32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints -= float64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= halfs)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= doubles)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= min16floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= min10floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= uint64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= float16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= float32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts -= float64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= halfs)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= doubles)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= min16floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= min10floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= uint64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= float16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= float32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts -= float64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= halfs)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= doubles)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= min16floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= min10floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= uint64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= float16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= float32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts -= float64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= halfs)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= doubles)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= min16floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= min10floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= float16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= float32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts -= float64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= halfs)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= doubles)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= min16floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= min10floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= float16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= float32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts -= float64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= halfs)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= doubles)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= min16floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= min10floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= float16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= float32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts -= float64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= bools)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= halfs)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= doubles)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= min16floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= min10floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= min16ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= min12ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= min16uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= int16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= int32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= int64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= uint16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= uint32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= float16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= float32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts -= float64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= bools)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= halfs)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= doubles)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= min16floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= min10floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= min16ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= min12ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= min16uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= int16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= int32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= int64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= uint16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= uint32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= uint64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= float32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts -= float64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= bools)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= halfs)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= doubles)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= min16floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= min10floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= min16ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= min12ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= min16uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= int16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= int32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= int64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= uint16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= uint32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= uint64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= float16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts -= float64_ts)>::value, "");
(bools /= bools);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= ints);                 /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= uints);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= halfs);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= floats);               /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= doubles);              /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= min16floats);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= min10floats);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= min16ints);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= min12ints);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= min16uints);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools /= int16_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools /= int32_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools /= int64_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools /= uint16_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools /= uint32_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools /= uint64_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools /= float16_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools /= float32_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools /= float64_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints /= bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= halfs)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= doubles)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= min16floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= min10floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= uint64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= float16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= float32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints /= float64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= halfs)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= doubles)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= min16floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= min10floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= float16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= float32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints /= float64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= bools)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= halfs)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= doubles)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= min16floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= min10floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= min16ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= min12ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= min16uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= int16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= int32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= int64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= uint16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= uint32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= uint64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= float16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= float32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs /= float64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= bools)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= doubles)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= min16floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= min10floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= min16ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= min12ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= min16uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= int16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= int32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= int64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= uint16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= uint32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= uint64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= float16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= float32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats /= float64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= bools)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= halfs)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= doubles)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= min16floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= min10floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= min16ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= min12ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= min16uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= int16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= int32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= int64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= uint16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= uint32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= uint64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= float16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= float32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles /= float64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= bools)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= halfs)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= min16floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= min10floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= min16ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= min12ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= min16uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= int16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= int32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= int64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= uint64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= float16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= float32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats /= float64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= bools)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= halfs)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= doubles)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= min16floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= min10floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= min16ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= min12ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= min16uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= int16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= int32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= int64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= uint16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= uint32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= uint64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= float16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= float32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats /= float64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= bools)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints /= ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= halfs)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= doubles)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= min16floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= min10floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints /= min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints /= min16uints)>::value, "");   
_Static_assert(std::is_same<min16int, __decltype(min16ints /= int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= uint64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= float16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= float32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints /= float64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= bools)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints /= ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= halfs)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= doubles)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= min16floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= min10floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints /= min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints /= min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= uint64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= float16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= float32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints /= float64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= halfs)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= doubles)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= min16floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= min10floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= min16ints)>::value, "");  
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= uint64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= float16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= float32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints /= float64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= halfs)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= doubles)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= min16floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= min10floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= uint64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= float16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= float32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts /= float64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= halfs)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= doubles)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= min16floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= min10floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= uint64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= float16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= float32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts /= float64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= halfs)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= doubles)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= min16floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= min10floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= uint64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= float16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= float32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts /= float64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= halfs)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= doubles)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= min16floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= min10floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= float16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= float32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts /= float64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= halfs)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= doubles)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= min16floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= min10floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= float16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= float32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts /= float64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= halfs)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= doubles)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= min16floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= min10floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= float16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= float32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts /= float64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= bools)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= halfs)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= doubles)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= min16floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= min10floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= min16ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= min12ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= min16uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= int16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= int32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= int64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= uint16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= uint32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= float16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= float32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts /= float64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= bools)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= halfs)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= doubles)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= min16floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= min10floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= min16ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= min12ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= min16uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= int16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= int32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= int64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= uint16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= uint32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= uint64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= float32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts /= float64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= bools)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= halfs)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= doubles)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= min16floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= min10floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= min16ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= min12ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= min16uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= int16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= int32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= int64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= uint16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= uint32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= uint64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= float16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts /= float64_ts)>::value, "");
(bools %= bools);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= ints);                 /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= uints);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= halfs);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= floats);               /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= doubles);              /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= min16floats);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= min10floats);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= min16ints);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= min12ints);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= min16uints);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools %= int16_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools %= int32_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools %= int64_ts);             /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools %= uint16_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools %= uint32_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools %= uint64_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools %= float16_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools %= float32_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools %= float64_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints %= bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= halfs)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= floats)>::value, "");
(ints %= doubles);               /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}} */
_Static_assert(std::is_same<int, __decltype(ints %= min16floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= min10floats)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= uint64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= float16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints %= float32_ts)>::value, "");
(ints %= float64_ts);            /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<uint, __decltype(uints %= bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= halfs)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= floats)>::value, "");
(uints %= doubles);              /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}} */
_Static_assert(std::is_same<uint, __decltype(uints %= min16floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= min10floats)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= float16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints %= float32_ts)>::value, "");
(uints %= float64_ts);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<half, __decltype(halfs %= bools)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= halfs)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= floats)>::value, "");
(halfs %= doubles);              /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs %= min16floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= min10floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= min16ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= min12ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= min16uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= int16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= int32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= int64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= uint16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= uint32_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= uint64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= float16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs %= float32_ts)>::value, "");
(halfs %= float64_ts);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<float, __decltype(floats %= bools)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= floats)>::value, "");
(floats %= doubles);             /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(floats %= min16floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= min10floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= min16ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= min12ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= min16uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= int16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= int32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= int64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= uint16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= uint32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= uint64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= float16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats %= float32_ts)>::value, "");
(floats %= float64_ts);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(doubles %= bools);              /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= ints);               /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= uints);              /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= halfs);              /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= floats);             /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= doubles);            /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= min16floats);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= min10floats);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= min16ints);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= min12ints);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= min16uints);         /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}} */
(doubles %= int16_ts);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(doubles %= int32_ts);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(doubles %= int64_ts);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(doubles %= uint16_ts);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(doubles %= uint32_ts);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(doubles %= uint64_ts);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(doubles %= float16_ts);         /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(doubles %= float32_ts);         /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(doubles %= float64_ts);         /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats %= bools)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= halfs)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= floats)>::value, "");
(min16floats %= doubles);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats %= min16floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= min10floats)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= min16ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= min12ints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= min16uints)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= int16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= int32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= int64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= uint64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= float16_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats %= float32_ts)>::value, "");
(min16floats %= float64_ts);     /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats %= bools)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= halfs)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= floats)>::value, "");
(min10floats %= doubles);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats %= min16floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= min10floats)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= min16ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= min12ints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= min16uints)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= int16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= int32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= int64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= uint16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= uint32_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= uint64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= float16_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats %= float32_ts)>::value, "");
(min10floats %= float64_ts);     /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints %= bools)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints %= ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= halfs)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= floats)>::value, "");
(min16ints %= doubles);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints %= min16floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= min10floats)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints %= min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints %= min16uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= uint64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= float16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints %= float32_ts)>::value, "");
(min16ints %= float64_ts);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints %= bools)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints %= ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= halfs)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= floats)>::value, "");
(min12ints %= doubles);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints %= min16floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= min10floats)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints %= min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints %= min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= uint64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= float16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints %= float32_ts)>::value, "");
(min12ints %= float64_ts);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= halfs)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= floats)>::value, "");
(min16uints %= doubles);         /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= min16floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= min10floats)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= min16ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= uint64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= float16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints %= float32_ts)>::value, "");
(min16uints %= float64_ts);      /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= halfs)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= floats)>::value, "");
(int16_ts %= doubles);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= min16floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= min10floats)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= uint64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= float16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts %= float32_ts)>::value, "");
(int16_ts %= float64_ts);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= halfs)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= floats)>::value, "");
(int32_ts %= doubles);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= min16floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= min10floats)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= uint64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= float16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts %= float32_ts)>::value, "");
(int32_ts %= float64_ts);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= halfs)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= floats)>::value, "");
(int64_ts %= doubles);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= min16floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= min10floats)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= uint64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= float16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts %= float32_ts)>::value, "");
(int64_ts %= float64_ts);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= halfs)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= floats)>::value, "");
(uint16_ts %= doubles);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= min16floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= min10floats)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= float16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts %= float32_ts)>::value, "");
(uint16_ts %= float64_ts);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= halfs)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= floats)>::value, "");
(uint32_ts %= doubles);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= min16floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= min10floats)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= float16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts %= float32_ts)>::value, "");
(uint32_ts %= float64_ts);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= halfs)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= floats)>::value, "");
(uint64_ts %= doubles);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= min16floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= min10floats)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= uint64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= float16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts %= float32_ts)>::value, "");
(uint64_ts %= float64_ts);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= bools)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= halfs)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= floats)>::value, "");
(float16_ts %= doubles);         /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= min16floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= min10floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= min16ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= min12ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= min16uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= int16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= int32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= int64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= uint16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= uint32_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= float16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts %= float32_ts)>::value, "");
(float16_ts %= float64_ts);      /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= bools)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= halfs)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= floats)>::value, "");
(float32_ts %= doubles);         /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= min16floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= min10floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= min16ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= min12ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= min16uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= int16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= int32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= int64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= uint16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= uint32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= uint64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts %= float32_ts)>::value, "");
(float32_ts %= float64_ts);      /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float64_ts %= bools);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= ints);            /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= uints);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= halfs);           /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= floats);          /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= doubles);         /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= min16floats);     /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= min10floats);     /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= min16ints);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= min12ints);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= min16uints);      /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= int16_ts);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= int32_ts);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= int64_ts);        /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= uint16_ts);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= uint32_ts);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= uint64_ts);       /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= float16_ts);      /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= float32_ts);      /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts %= float64_ts);      /* expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(bools <<= bools);               /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools <<= ints);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools <<= uints);               /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools <<= halfs);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools <<= floats);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools <<= doubles);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools <<= min16floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools <<= min10floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools <<= min16ints);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools <<= min12ints);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools <<= min16uints);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools <<= int16_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools <<= int32_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools <<= int64_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools <<= uint16_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools <<= uint32_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools <<= uint64_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools <<= float16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools <<= float32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools <<= float64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints <<= bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= uints)>::value, "");
(ints <<= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints <<= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints <<= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints <<= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints <<= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints <<= min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints <<= uint64_ts)>::value, "");
(ints <<= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(ints <<= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(ints <<= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<uint, __decltype(uints <<= bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= uints)>::value, "");
(uints <<= halfs);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints <<= floats);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints <<= doubles);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints <<= min16floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints <<= min10floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints <<= min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints <<= uint64_ts)>::value, "");
(uints <<= float16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(uints <<= float32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(uints <<= float64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(halfs <<= bools);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= ints);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= uints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= halfs);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= floats);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= doubles);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= min16floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= min10floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= min16ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= min12ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= min16uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs <<= int16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(halfs <<= int32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(halfs <<= int64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(halfs <<= uint16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(halfs <<= uint32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(halfs <<= uint64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(halfs <<= float16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(halfs <<= float32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(halfs <<= float64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(floats <<= bools);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= ints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= uints);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= halfs);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= floats);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= doubles);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= min16floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= min10floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= min16ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= min12ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= min16uints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats <<= int16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(floats <<= int32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(floats <<= int64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(floats <<= uint16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(floats <<= uint32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(floats <<= uint64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(floats <<= float16_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(floats <<= float32_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(floats <<= float64_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(doubles <<= bools);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= ints);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= uints);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= min16ints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= min12ints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= min16uints);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles <<= int16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(doubles <<= int32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(doubles <<= int64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(doubles <<= uint16_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(doubles <<= uint32_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(doubles <<= uint64_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(doubles <<= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(doubles <<= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(doubles <<= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min16floats <<= bools);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= uints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= halfs);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= doubles);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= min16floats);   /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= min10floats);   /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= min16ints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= min12ints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= min16uints);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats <<= int16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min16floats <<= int32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min16floats <<= int64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min16floats <<= uint16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min16floats <<= uint32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min16floats <<= uint64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min16floats <<= float16_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16floats <<= float32_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16floats <<= float64_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min10floats <<= bools);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= uints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= halfs);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= doubles);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= min16floats);   /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= min10floats);   /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= min16ints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= min12ints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= min16uints);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats <<= int16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min10floats <<= int32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min10floats <<= int64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min10floats <<= uint16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min10floats <<= uint32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min10floats <<= uint64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min10floats <<= float16_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min10floats <<= float32_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min10floats <<= float64_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= bools)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= uints)>::value, "");
(min16ints <<= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints <<= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints <<= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints <<= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints <<= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= min16ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= min12ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= min16uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints <<= uint64_ts)>::value, "");
(min16ints <<= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16ints <<= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16ints <<= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= bools)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= uints)>::value, "");
(min12ints <<= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints <<= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints <<= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints <<= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints <<= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= min16ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= min12ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints <<= uint64_ts)>::value, "");
(min12ints <<= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min12ints <<= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min12ints <<= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= uints)>::value, "");
(min16uints <<= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints <<= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints <<= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints <<= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints <<= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= min16ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints <<= uint64_ts)>::value, "");
(min16uints <<= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16uints <<= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16uints <<= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= uints)>::value, "");
(int16_ts <<= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts <<= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts <<= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts <<= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts <<= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts <<= uint64_ts)>::value, "");
(int16_ts <<= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts <<= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts <<= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= uints)>::value, "");
(int32_ts <<= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts <<= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts <<= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts <<= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts <<= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts <<= uint64_ts)>::value, "");
(int32_ts <<= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts <<= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts <<= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= uints)>::value, "");
(int64_ts <<= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts <<= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts <<= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts <<= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts <<= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts <<= uint64_ts)>::value, "");
(int64_ts <<= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts <<= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts <<= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= uints)>::value, "");
(uint16_ts <<= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts <<= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts <<= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts <<= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts <<= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts <<= uint64_ts)>::value, "");
(uint16_ts <<= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts <<= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts <<= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= uints)>::value, "");
(uint32_ts <<= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts <<= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts <<= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts <<= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts <<= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts <<= uint64_ts)>::value, "");
(uint32_ts <<= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts <<= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts <<= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= uints)>::value, "");
(uint64_ts <<= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts <<= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts <<= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts <<= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts <<= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts <<= uint64_ts)>::value, "");
(uint64_ts <<= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts <<= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts <<= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(float16_ts <<= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts <<= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float32_ts <<= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts <<= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float64_ts <<= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts <<= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(bools >>= bools);               /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools >>= ints);                /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools >>= uints);               /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools >>= halfs);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools >>= floats);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools >>= doubles);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools >>= min16floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools >>= min10floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools >>= min16ints);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools >>= min12ints);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools >>= min16uints);          /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools >>= int16_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools >>= int32_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools >>= int64_ts);            /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools >>= uint16_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools >>= uint32_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools >>= uint64_ts);           /* expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools >>= float16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools >>= float32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools >>= float64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints >>= bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= uints)>::value, "");
(ints >>= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints >>= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints >>= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints >>= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints >>= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints >>= min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >>= uint64_ts)>::value, "");
(ints >>= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(ints >>= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(ints >>= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<uint, __decltype(uints >>= bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= uints)>::value, "");
(uints >>= halfs);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints >>= floats);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints >>= doubles);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints >>= min16floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints >>= min10floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints >>= min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >>= uint64_ts)>::value, "");
(uints >>= float16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(uints >>= float32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(uints >>= float64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(halfs >>= bools);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= ints);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= uints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= halfs);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= floats);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= doubles);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= min16floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= min10floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= min16ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= min12ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= min16uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs >>= int16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(halfs >>= int32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(halfs >>= int64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(halfs >>= uint16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(halfs >>= uint32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(halfs >>= uint64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(halfs >>= float16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(halfs >>= float32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(halfs >>= float64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(floats >>= bools);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= ints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= uints);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= halfs);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= floats);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= doubles);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= min16floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= min10floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= min16ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= min12ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= min16uints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats >>= int16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(floats >>= int32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(floats >>= int64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(floats >>= uint16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(floats >>= uint32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(floats >>= uint64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(floats >>= float16_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(floats >>= float32_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(floats >>= float64_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(doubles >>= bools);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= ints);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= uints);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= min16ints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= min12ints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= min16uints);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles >>= int16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(doubles >>= int32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(doubles >>= int64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(doubles >>= uint16_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(doubles >>= uint32_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(doubles >>= uint64_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(doubles >>= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(doubles >>= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(doubles >>= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min16floats >>= bools);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= uints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= halfs);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= doubles);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= min16floats);   /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= min10floats);   /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= min16ints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= min12ints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= min16uints);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats >>= int16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min16floats >>= int32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min16floats >>= int64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min16floats >>= uint16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min16floats >>= uint32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min16floats >>= uint64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min16floats >>= float16_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16floats >>= float32_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16floats >>= float64_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min10floats >>= bools);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= uints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= halfs);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= doubles);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= min16floats);   /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= min10floats);   /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= min16ints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= min12ints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= min16uints);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats >>= int16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min10floats >>= int32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min10floats >>= int64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min10floats >>= uint16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min10floats >>= uint32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min10floats >>= uint64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min10floats >>= float16_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min10floats >>= float32_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min10floats >>= float64_ts);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= bools)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= uints)>::value, "");
(min16ints >>= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints >>= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints >>= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints >>= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints >>= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= min16ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= min12ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= min16uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints >>= uint64_ts)>::value, "");
(min16ints >>= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16ints >>= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16ints >>= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= bools)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= uints)>::value, "");
(min12ints >>= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints >>= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints >>= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints >>= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints >>= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= min16ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= min12ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints >>= uint64_ts)>::value, "");
(min12ints >>= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min12ints >>= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min12ints >>= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= uints)>::value, "");
(min16uints >>= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints >>= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints >>= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints >>= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints >>= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= min16ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints >>= uint64_ts)>::value, "");
(min16uints >>= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16uints >>= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16uints >>= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= uints)>::value, "");
(int16_ts >>= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts >>= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts >>= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts >>= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts >>= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >>= uint64_ts)>::value, "");
(int16_ts >>= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts >>= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts >>= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= uints)>::value, "");
(int32_ts >>= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts >>= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts >>= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts >>= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts >>= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >>= uint64_ts)>::value, "");
(int32_ts >>= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts >>= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts >>= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= uints)>::value, "");
(int64_ts >>= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts >>= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts >>= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts >>= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts >>= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >>= uint64_ts)>::value, "");
(int64_ts >>= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts >>= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts >>= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= uints)>::value, "");
(uint16_ts >>= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts >>= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts >>= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts >>= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts >>= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >>= uint64_ts)>::value, "");
(uint16_ts >>= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts >>= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts >>= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= uints)>::value, "");
(uint32_ts >>= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts >>= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts >>= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts >>= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts >>= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >>= uint64_ts)>::value, "");
(uint32_ts >>= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts >>= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts >>= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= uints)>::value, "");
(uint64_ts >>= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts >>= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts >>= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts >>= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts >>= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >>= uint64_ts)>::value, "");
(uint64_ts >>= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts >>= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts >>= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(float16_ts >>= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts >>= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float32_ts >>= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts >>= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float64_ts >>= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts >>= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(bools &= bools);                /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools &= ints);                 /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools &= uints);                /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools &= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools &= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools &= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools &= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools &= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools &= min16ints);            /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools &= min12ints);            /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools &= min16uints);           /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools &= int16_ts);             /* fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools &= int32_ts);             /* fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools &= int64_ts);             /* fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools &= uint16_ts);            /* fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools &= uint32_ts);            /* fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools &= uint64_ts);            /* fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools &= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools &= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools &= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints &= bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= uints)>::value, "");
(ints &= halfs);                 /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints &= floats);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints &= doubles);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints &= min16floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints &= min10floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints &= min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints &= uint64_ts)>::value, "");
(ints &= float16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(ints &= float32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(ints &= float64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<uint, __decltype(uints &= bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= uints)>::value, "");
(uints &= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints &= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints &= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints &= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints &= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints &= min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints &= uint64_ts)>::value, "");
(uints &= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(uints &= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(uints &= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(halfs &= bools);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= ints);                 /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= uints);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= min16ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= min12ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= min16uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs &= int16_ts);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(halfs &= int32_ts);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(halfs &= int64_ts);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(halfs &= uint16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(halfs &= uint32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(halfs &= uint64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(halfs &= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(halfs &= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(halfs &= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(floats &= bools);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= ints);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= uints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= halfs);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= floats);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= doubles);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= min16floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= min10floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= min16ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= min12ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= min16uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats &= int16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(floats &= int32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(floats &= int64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(floats &= uint16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(floats &= uint32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(floats &= uint64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(floats &= float16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(floats &= float32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(floats &= float64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(doubles &= bools);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= ints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= uints);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= halfs);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= floats);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= doubles);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= min16floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= min10floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= min16ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= min12ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= min16uints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles &= int16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(doubles &= int32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(doubles &= int64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(doubles &= uint16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(doubles &= uint32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(doubles &= uint64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(doubles &= float16_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(doubles &= float32_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(doubles &= float64_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min16floats &= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats &= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min16floats &= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min16floats &= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min16floats &= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min16floats &= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min16floats &= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min16floats &= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16floats &= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16floats &= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min10floats &= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats &= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min10floats &= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min10floats &= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min10floats &= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min10floats &= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min10floats &= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min10floats &= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min10floats &= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min10floats &= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints &= bools)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= uints)>::value, "");
(min16ints &= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints &= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints &= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints &= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints &= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints &= min16ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= min12ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= min16uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints &= uint64_ts)>::value, "");
(min16ints &= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16ints &= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16ints &= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints &= bools)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= uints)>::value, "");
(min12ints &= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints &= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints &= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints &= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints &= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints &= min16ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= min12ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints &= uint64_ts)>::value, "");
(min12ints &= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min12ints &= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min12ints &= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= uints)>::value, "");
(min16uints &= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints &= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints &= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints &= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints &= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= min16ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints &= uint64_ts)>::value, "");
(min16uints &= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16uints &= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16uints &= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= uints)>::value, "");
(int16_ts &= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts &= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts &= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts &= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts &= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts &= uint64_ts)>::value, "");
(int16_ts &= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts &= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts &= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= uints)>::value, "");
(int32_ts &= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts &= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts &= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts &= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts &= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts &= uint64_ts)>::value, "");
(int32_ts &= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts &= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts &= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= uints)>::value, "");
(int64_ts &= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts &= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts &= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts &= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts &= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts &= uint64_ts)>::value, "");
(int64_ts &= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts &= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts &= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= uints)>::value, "");
(uint16_ts &= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts &= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts &= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts &= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts &= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts &= uint64_ts)>::value, "");
(uint16_ts &= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts &= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts &= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= uints)>::value, "");
(uint32_ts &= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts &= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts &= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts &= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts &= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts &= uint64_ts)>::value, "");
(uint32_ts &= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts &= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts &= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= uints)>::value, "");
(uint64_ts &= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts &= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts &= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts &= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts &= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts &= uint64_ts)>::value, "");
(uint64_ts &= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts &= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts &= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(float16_ts &= bools);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= min16ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= min12ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= min16uints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= int16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= int32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= int64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= uint16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= uint32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= uint64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts &= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float32_ts &= bools);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= min16ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= min12ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= min16uints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= int16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= int32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= int64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= uint16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= uint32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= uint64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts &= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float64_ts &= bools);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= min16ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= min12ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= min16uints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= int16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= int32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= int64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= uint16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= uint32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= uint64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts &= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(bools |= bools);                /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools |= ints);                 /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools |= uints);                /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools |= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools |= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools |= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools |= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools |= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools |= min16ints);            /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools |= min12ints);            /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools |= min16uints);           /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools |= int16_ts);             /* fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools |= int32_ts);             /* fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools |= int64_ts);             /* fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools |= uint16_ts);            /* fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools |= uint32_ts);            /* fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools |= uint64_ts);            /* fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools |= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools |= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools |= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints |= bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= uints)>::value, "");
(ints |= halfs);                 /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints |= floats);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints |= doubles);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints |= min16floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints |= min10floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints |= min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints |= uint64_ts)>::value, "");
(ints |= float16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(ints |= float32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(ints |= float64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<uint, __decltype(uints |= bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= uints)>::value, "");
(uints |= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints |= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints |= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints |= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints |= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints |= min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints |= uint64_ts)>::value, "");
(uints |= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(uints |= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(uints |= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(halfs |= bools);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= ints);                 /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= uints);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= min16ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= min12ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= min16uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs |= int16_ts);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(halfs |= int32_ts);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(halfs |= int64_ts);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(halfs |= uint16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(halfs |= uint32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(halfs |= uint64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(halfs |= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(halfs |= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(halfs |= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(floats |= bools);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= ints);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= uints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= halfs);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= floats);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= doubles);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= min16floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= min10floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= min16ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= min12ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= min16uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats |= int16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(floats |= int32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(floats |= int64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(floats |= uint16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(floats |= uint32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(floats |= uint64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(floats |= float16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(floats |= float32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(floats |= float64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(doubles |= bools);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= ints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= uints);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= halfs);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= floats);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= doubles);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= min16floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= min10floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= min16ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= min12ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= min16uints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles |= int16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(doubles |= int32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(doubles |= int64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(doubles |= uint16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(doubles |= uint32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(doubles |= uint64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(doubles |= float16_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(doubles |= float32_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(doubles |= float64_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min16floats |= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats |= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min16floats |= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min16floats |= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min16floats |= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min16floats |= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min16floats |= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min16floats |= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16floats |= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16floats |= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min10floats |= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats |= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min10floats |= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min10floats |= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min10floats |= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min10floats |= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min10floats |= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min10floats |= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min10floats |= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min10floats |= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints |= bools)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= uints)>::value, "");
(min16ints |= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints |= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints |= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints |= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints |= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints |= min16ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= min12ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= min16uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints |= uint64_ts)>::value, "");
(min16ints |= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16ints |= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16ints |= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints |= bools)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= uints)>::value, "");
(min12ints |= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints |= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints |= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints |= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints |= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints |= min16ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= min12ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints |= uint64_ts)>::value, "");
(min12ints |= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min12ints |= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min12ints |= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= uints)>::value, "");
(min16uints |= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints |= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints |= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints |= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints |= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= min16ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints |= uint64_ts)>::value, "");
(min16uints |= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16uints |= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16uints |= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= uints)>::value, "");
(int16_ts |= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts |= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts |= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts |= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts |= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts |= uint64_ts)>::value, "");
(int16_ts |= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts |= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts |= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= uints)>::value, "");
(int32_ts |= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts |= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts |= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts |= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts |= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts |= uint64_ts)>::value, "");
(int32_ts |= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts |= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts |= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= uints)>::value, "");
(int64_ts |= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts |= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts |= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts |= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts |= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts |= uint64_ts)>::value, "");
(int64_ts |= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts |= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts |= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= uints)>::value, "");
(uint16_ts |= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts |= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts |= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts |= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts |= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts |= uint64_ts)>::value, "");
(uint16_ts |= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts |= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts |= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= uints)>::value, "");
(uint32_ts |= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts |= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts |= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts |= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts |= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts |= uint64_ts)>::value, "");
(uint32_ts |= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts |= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts |= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= uints)>::value, "");
(uint64_ts |= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts |= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts |= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts |= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts |= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts |= uint64_ts)>::value, "");
(uint64_ts |= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts |= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts |= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(float16_ts |= bools);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= min16ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= min12ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= min16uints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= int16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= int32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= int64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= uint16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= uint32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= uint64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts |= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float32_ts |= bools);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= min16ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= min12ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= min16uints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= int16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= int32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= int64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= uint16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= uint32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= uint64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts |= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float64_ts |= bools);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= min16ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= min12ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= min16uints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= int16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= int32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= int64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= uint16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= uint32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= uint64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts |= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(bools ^= bools);                /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools ^= ints);                 /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools ^= uints);                /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools ^= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools ^= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools ^= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools ^= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools ^= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(bools ^= min16ints);            /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools ^= min12ints);            /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools ^= min16uints);           /* fxc-error {{X3020: operator cannot be used with a bool lvalue}} */
(bools ^= int16_ts);             /* fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(bools ^= int32_ts);             /* fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(bools ^= int64_ts);             /* fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(bools ^= uint16_ts);            /* fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(bools ^= uint32_ts);            /* fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(bools ^= uint64_ts);            /* fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(bools ^= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(bools ^= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(bools ^= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int, __decltype(ints ^= bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= uints)>::value, "");
(ints ^= halfs);                 /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints ^= floats);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints ^= doubles);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints ^= min16floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(ints ^= min10floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints ^= min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^= uint64_ts)>::value, "");
(ints ^= float16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(ints ^= float32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(ints ^= float64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<uint, __decltype(uints ^= bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= uints)>::value, "");
(uints ^= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints ^= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints ^= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints ^= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(uints ^= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints ^= min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^= uint64_ts)>::value, "");
(uints ^= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(uints ^= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(uints ^= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(halfs ^= bools);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= ints);                 /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= uints);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= halfs);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= floats);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= doubles);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= min16floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= min10floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= min16ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= min12ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= min16uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(halfs ^= int16_ts);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(halfs ^= int32_ts);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(halfs ^= int64_ts);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(halfs ^= uint16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(halfs ^= uint32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(halfs ^= uint64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(halfs ^= float16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(halfs ^= float32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(halfs ^= float64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(floats ^= bools);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= ints);                /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= uints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= halfs);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= floats);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= doubles);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= min16floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= min10floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= min16ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= min12ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= min16uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(floats ^= int16_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(floats ^= int32_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(floats ^= int64_ts);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(floats ^= uint16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(floats ^= uint32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(floats ^= uint64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(floats ^= float16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(floats ^= float32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(floats ^= float64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(doubles ^= bools);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= ints);               /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= uints);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= halfs);              /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= floats);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= doubles);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= min16floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= min10floats);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= min16ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= min12ints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= min16uints);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(doubles ^= int16_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(doubles ^= int32_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(doubles ^= int64_ts);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(doubles ^= uint16_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(doubles ^= uint32_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(doubles ^= uint64_ts);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(doubles ^= float16_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(doubles ^= float32_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(doubles ^= float64_ts);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min16floats ^= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16floats ^= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min16floats ^= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min16floats ^= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min16floats ^= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min16floats ^= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min16floats ^= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min16floats ^= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16floats ^= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16floats ^= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(min10floats ^= bools);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= ints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= uints);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= halfs);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= floats);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= doubles);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= min16floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= min10floats);    /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= min16ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= min12ints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= min16uints);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min10floats ^= int16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(min10floats ^= int32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(min10floats ^= int64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(min10floats ^= uint16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(min10floats ^= uint32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(min10floats ^= uint64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(min10floats ^= float16_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min10floats ^= float32_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min10floats ^= float64_ts);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= bools)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= uints)>::value, "");
(min16ints ^= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints ^= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints ^= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints ^= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16ints ^= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= min16ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= min12ints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= min16uints)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= int16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= int32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= int64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints ^= uint64_ts)>::value, "");
(min16ints ^= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16ints ^= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16ints ^= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= bools)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= uints)>::value, "");
(min12ints ^= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints ^= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints ^= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints ^= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min12ints ^= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= min16ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= min12ints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= min16uints)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= int16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= int32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= int64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints ^= uint64_ts)>::value, "");
(min12ints ^= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min12ints ^= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min12ints ^= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= bools)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= uints)>::value, "");
(min16uints ^= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints ^= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints ^= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints ^= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
(min16uints ^= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= min16ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= min12ints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= min16uints)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= int16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= int32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= int64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^= uint64_ts)>::value, "");
(min16uints ^= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(min16uints ^= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(min16uints ^= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= uints)>::value, "");
(int16_ts ^= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts ^= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts ^= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts ^= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts ^= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^= uint64_ts)>::value, "");
(int16_ts ^= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts ^= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
(int16_ts ^= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int16_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= uints)>::value, "");
(int32_ts ^= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts ^= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts ^= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts ^= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts ^= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^= uint64_ts)>::value, "");
(int32_ts ^= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts ^= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
(int32_ts ^= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int32_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= uints)>::value, "");
(int64_ts ^= halfs);             /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts ^= floats);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts ^= doubles);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts ^= min16floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts ^= min10floats);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^= uint64_ts)>::value, "");
(int64_ts ^= float16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts ^= float32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
(int64_ts ^= float64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'int64_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= uints)>::value, "");
(uint16_ts ^= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts ^= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts ^= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts ^= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts ^= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^= uint64_ts)>::value, "");
(uint16_ts ^= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts ^= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
(uint16_ts ^= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint16_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= uints)>::value, "");
(uint32_ts ^= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts ^= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts ^= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts ^= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts ^= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^= uint64_ts)>::value, "");
(uint32_ts ^= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts ^= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
(uint32_ts ^= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint32_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= uints)>::value, "");
(uint64_ts ^= halfs);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts ^= floats);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts ^= doubles);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts ^= min16floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts ^= min10floats);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^= uint64_ts)>::value, "");
(uint64_ts ^= float16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts ^= float32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(uint64_ts ^= float64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'uint64_ts'}} */
(float16_ts ^= bools);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= min16ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= min12ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= min16uints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= int16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= int32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= int64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= uint16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= uint32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= uint64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float16_ts ^= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float16_ts'}} */
(float32_ts ^= bools);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= min16ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= min12ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= min16uints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= int16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= int32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= int64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= uint16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= uint32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= uint64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float32_ts ^= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float32_ts'}} */
(float64_ts ^= bools);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= ints);            /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= uints);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= halfs);           /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= floats);          /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= doubles);         /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= min16floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= min10floats);     /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= min16ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= min12ints);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= min16uints);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= int16_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= int32_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= int64_ts);        /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= uint16_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= uint32_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= uint64_ts);       /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= float16_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= float32_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
(float64_ts ^= float64_ts);      /* expected-error {{int or unsigned int type required}} fxc-error {{X3004: undeclared identifier 'float64_ts'}} */
// GENERATED_ASSIGN:END


}
