/* mapiterator.c generated by valac 0.52.0, the Vala compiler
 * generated from mapiterator.vala, do not modify */

/* mapiterator.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 * Copyright (C) 2011  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>

static gpointer gee_map_iterator_real_fold (GeeMapIterator* self,
                                     GType a_type,
                                     GBoxedCopyFunc a_dup_func,
                                     GDestroyNotify a_destroy_func,
                                     GeeFoldMapFunc f,
                                     gpointer f_target,
                                     gpointer seed);
static gboolean gee_map_iterator_real_foreach (GeeMapIterator* self,
                                        GeeForallMapFunc f,
                                        gpointer f_target);
static GType gee_map_iterator_get_type_once (void);

/**
 * Advances to the next entry in the iteration.
 *
 * @return ``true`` if the iterator has a next entry
 */
gboolean
gee_map_iterator_next (GeeMapIterator* self)
{
	GeeMapIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->next) {
		return _iface_->next (self);
	}
	return FALSE;
}

/**
 * Checks whether there is a next entry in the iteration.
 *
 * @return ``true`` if the iterator has a next entry
 */
gboolean
gee_map_iterator_has_next (GeeMapIterator* self)
{
	GeeMapIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->has_next) {
		return _iface_->has_next (self);
	}
	return FALSE;
}

/**
 * Returns the current key in the iteration.
 *
 * @return the current key in the iteration
 */
gpointer
gee_map_iterator_get_key (GeeMapIterator* self)
{
	GeeMapIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->get_key) {
		return _iface_->get_key (self);
	}
	return NULL;
}

/**
 * Returns the value associated with the current key in the iteration.
 *
 * @return the value for the current key
 */
gpointer
gee_map_iterator_get_value (GeeMapIterator* self)
{
	GeeMapIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->get_value) {
		return _iface_->get_value (self);
	}
	return NULL;
}

/**
 * Sets the value associated with the current key in the iteration.
 *
 * @param value the new value for the current key
 */
void
gee_map_iterator_set_value (GeeMapIterator* self,
                            gconstpointer value)
{
	GeeMapIteratorIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->set_value) {
		_iface_->set_value (self, value);
	}
}

/**
 * Unsets the current entry in the iteration. The cursor is set in an
 * in-between state. {@link get_key}, {@link get_value}, {@link set_value}
 * and {@link unset} will fail until the next move of the cursor (calling
 * {@link next}).
 */
void
gee_map_iterator_unset (GeeMapIterator* self)
{
	GeeMapIteratorIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->unset) {
		_iface_->unset (self);
	}
}

/**
 * Standard aggregation function.
 *
 * It takes a function, seed and first element, returns the new seed and
 * progress to next element when the operation repeats.
 *
 * Operation moves the iterator to last element in iteration. If iterator
 * points at some element it will be included in iteration.
 */
static gpointer
gee_map_iterator_real_fold (GeeMapIterator* self,
                            GType a_type,
                            GBoxedCopyFunc a_dup_func,
                            GDestroyNotify a_destroy_func,
                            GeeFoldMapFunc f,
                            gpointer f_target,
                            gpointer seed)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gpointer _tmp14_;
	gpointer result = NULL;
	_tmp0_ = gee_map_iterator_get_valid (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gpointer _tmp2_;
		gpointer _tmp3_;
		gpointer _tmp4_;
		gpointer _tmp5_;
		gpointer _tmp6_;
		gpointer _tmp7_;
		_tmp2_ = gee_map_iterator_get_key (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_map_iterator_get_value (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = seed;
		seed = NULL;
		_tmp7_ = f (_tmp3_, _tmp5_, _tmp6_, f_target);
		((seed == NULL) || (a_destroy_func == NULL)) ? NULL : (seed = (a_destroy_func (seed), NULL));
		seed = _tmp7_;
		((_tmp5_ == NULL) || (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_v_destroy_func (self) == NULL)) ? NULL : (_tmp5_ = (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_v_destroy_func (self) (_tmp5_), NULL));
		((_tmp3_ == NULL) || (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_k_destroy_func (self) == NULL)) ? NULL : (_tmp3_ = (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_k_destroy_func (self) (_tmp3_), NULL));
	}
	while (TRUE) {
		gpointer _tmp8_;
		gpointer _tmp9_;
		gpointer _tmp10_;
		gpointer _tmp11_;
		gpointer _tmp12_;
		gpointer _tmp13_;
		if (!gee_map_iterator_next (self)) {
			break;
		}
		_tmp8_ = gee_map_iterator_get_key (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_map_iterator_get_value (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = seed;
		seed = NULL;
		_tmp13_ = f (_tmp9_, _tmp11_, _tmp12_, f_target);
		((seed == NULL) || (a_destroy_func == NULL)) ? NULL : (seed = (a_destroy_func (seed), NULL));
		seed = _tmp13_;
		((_tmp11_ == NULL) || (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_v_destroy_func (self) == NULL)) ? NULL : (_tmp11_ = (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_v_destroy_func (self) (_tmp11_), NULL));
		((_tmp9_ == NULL) || (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_k_destroy_func (self) == NULL)) ? NULL : (_tmp9_ = (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_k_destroy_func (self) (_tmp9_), NULL));
	}
	_tmp14_ = seed;
	seed = NULL;
	result = _tmp14_;
	((seed == NULL) || (a_destroy_func == NULL)) ? NULL : (seed = (a_destroy_func (seed), NULL));
	return result;
}

gpointer
gee_map_iterator_fold (GeeMapIterator* self,
                       GType a_type,
                       GBoxedCopyFunc a_dup_func,
                       GDestroyNotify a_destroy_func,
                       GeeFoldMapFunc f,
                       gpointer f_target,
                       gpointer seed)
{
	GeeMapIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->fold) {
		return _iface_->fold (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
	}
	return NULL;
}

/**
 * Apply function to each element returned by iterator. 
 *
 * Operation moves the iterator to last element in iteration. If iterator
 * points at some element it will be included in iteration.
 */
static gboolean
gee_map_iterator_real_foreach (GeeMapIterator* self,
                               GeeForallMapFunc f,
                               gpointer f_target)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result = FALSE;
	_tmp0_ = gee_map_iterator_get_valid (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gpointer _tmp2_;
		gpointer _tmp3_;
		gpointer _tmp4_;
		gpointer _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = gee_map_iterator_get_key (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_map_iterator_get_value (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = !f (_tmp3_, _tmp5_, f_target);
		((_tmp5_ == NULL) || (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_v_destroy_func (self) == NULL)) ? NULL : (_tmp5_ = (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_v_destroy_func (self) (_tmp5_), NULL));
		((_tmp3_ == NULL) || (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_k_destroy_func (self) == NULL)) ? NULL : (_tmp3_ = (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_k_destroy_func (self) (_tmp3_), NULL));
		if (_tmp6_) {
			result = FALSE;
			return result;
		}
	}
	while (TRUE) {
		gpointer _tmp7_;
		gpointer _tmp8_;
		gpointer _tmp9_;
		gpointer _tmp10_;
		gboolean _tmp11_;
		if (!gee_map_iterator_next (self)) {
			break;
		}
		_tmp7_ = gee_map_iterator_get_key (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_map_iterator_get_value (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = !f (_tmp8_, _tmp10_, f_target);
		((_tmp10_ == NULL) || (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_v_destroy_func (self) == NULL)) ? NULL : (_tmp10_ = (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_v_destroy_func (self) (_tmp10_), NULL));
		((_tmp8_ == NULL) || (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_k_destroy_func (self) == NULL)) ? NULL : (_tmp8_ = (GEE_MAP_ITERATOR_GET_INTERFACE (self)->get_k_destroy_func (self) (_tmp8_), NULL));
		if (_tmp11_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

gboolean
gee_map_iterator_foreach (GeeMapIterator* self,
                          GeeForallMapFunc f,
                          gpointer f_target)
{
	GeeMapIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->foreach) {
		return _iface_->foreach (self, f, f_target);
	}
	return FALSE;
}

gboolean
gee_map_iterator_get_valid (GeeMapIterator* self)
{
	GeeMapIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->get_valid) {
		return _iface_->get_valid (self);
	}
	return FALSE;
}

gboolean
gee_map_iterator_get_mutable (GeeMapIterator* self)
{
	GeeMapIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->get_mutable) {
		return _iface_->get_mutable (self);
	}
	return FALSE;
}

gboolean
gee_map_iterator_get_read_only (GeeMapIterator* self)
{
	GeeMapIteratorIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_MAP_ITERATOR_GET_INTERFACE (self);
	if (_iface_->get_read_only) {
		return _iface_->get_read_only (self);
	}
	return FALSE;
}

static void
gee_map_iterator_default_init (GeeMapIteratorIface * iface,
                               gpointer iface_data)
{
	/**
	 * Determines whether the call to {@link get_key}, {@link get_value} and
	 * {@link set_value} is legal. It is false at the beginning and after
	 * {@link unset} call and true otherwise.
	 */
	g_object_interface_install_property (iface, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Determines whether the call to {@link set_value} is legal assuming the
	 * iterator is valid. The value must not change in runtime hence the user
	 * of iterator may cache it.
	 */
	g_object_interface_install_property (iface, g_param_spec_boolean ("mutable", "mutable", "mutable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Determines whether the call to {@link unset} is legal assuming the
	 * iterator is valid. The value must not change in runtime hence the user
	 * of iterator may cache it.
	 */
	g_object_interface_install_property (iface, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	iface->fold = gee_map_iterator_real_fold;
	iface->foreach = gee_map_iterator_real_foreach;
}

/**
 * An iterator over a map.
 *
 * Gee's iterators are "on-track" iterators. They always point to an item
 * except before the first call to {@link next}, or, when an
 * item has been removed, until the next call to {@link next}.
 *
 * Please note that when the iterator is out of track, neither {@link get_key},
 * {@link get_value}, {@link set_value} nor {@link unset} are defined and all
 * will fail. After the next call to {@link next}, they will
 * be defined again.
 */
static GType
gee_map_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeMapIteratorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_map_iterator_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_map_iterator_type_id;
	gee_map_iterator_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeMapIterator", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_map_iterator_type_id, G_TYPE_OBJECT);
	return gee_map_iterator_type_id;
}

GType
gee_map_iterator_get_type (void)
{
	static volatile gsize gee_map_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_map_iterator_type_id__volatile)) {
		GType gee_map_iterator_type_id;
		gee_map_iterator_type_id = gee_map_iterator_get_type_once ();
		g_once_init_leave (&gee_map_iterator_type_id__volatile, gee_map_iterator_type_id);
	}
	return gee_map_iterator_type_id__volatile;
}

