/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import virtuoso.javax.BaseRowSet;
import virtuoso.javax.OPLMessage_x;

public class OPLJdbcRowSet
extends BaseRowSet {
    private Connection conn;
    private PreparedStatement pstmt;
    private ResultSet rs;
    private boolean doDisconnect = false;

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    private Connection connect() throws SQLException {
        String string = this.getDataSourceName();
        if (string != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(string);
                return dataSource.getConnection(this.getUsername(), this.getPassword());
            }
            catch (NamingException namingException) {
                throw OPLMessage_x.makeException(namingException);
            }
        }
        string = this.getUrl();
        if (string != null) {
            return DriverManager.getConnection(string, this.getUsername(), this.getPassword());
        }
        return null;
    }

    private void setParams(PreparedStatement preparedStatement, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return;
        }
        block14: for (int i = 0; i < objectArray.length; ++i) {
            BaseRowSet.Parameter parameter = (BaseRowSet.Parameter)objectArray[i];
            switch (parameter.jType) {
                case 0: {
                    preparedStatement.setObject(i + 1, parameter.value);
                    continue block14;
                }
                case 1: {
                    preparedStatement.setObject(i + 1, parameter.value, parameter.sqlType);
                    continue block14;
                }
                case 2: {
                    preparedStatement.setObject(i + 1, parameter.value, parameter.sqlType, parameter.scale);
                    continue block14;
                }
                case 3: {
                    preparedStatement.setAsciiStream(i + 1, (InputStream)parameter.value, parameter.length);
                    continue block14;
                }
                case 4: {
                    preparedStatement.setBinaryStream(i + 1, (InputStream)parameter.value, parameter.length);
                    continue block14;
                }
                case 5: {
                    preparedStatement.setUnicodeStream(i + 1, (InputStream)parameter.value, parameter.length);
                    continue block14;
                }
                case 6: {
                    preparedStatement.setCharacterStream(i + 1, (Reader)parameter.value, parameter.length);
                    continue block14;
                }
                case 7: {
                    preparedStatement.setDate(i + 1, (Date)parameter.value, parameter.cal);
                    continue block14;
                }
                case 8: {
                    preparedStatement.setTime(i + 1, (Time)parameter.value, parameter.cal);
                    continue block14;
                }
                case 9: {
                    preparedStatement.setTimestamp(i + 1, (Timestamp)parameter.value, parameter.cal);
                    continue block14;
                }
                case 10: {
                    preparedStatement.setNull(i + 1, parameter.sqlType);
                    continue block14;
                }
                case 11: {
                    preparedStatement.setNull(i + 1, parameter.sqlType, parameter.typeName);
                    continue block14;
                }
                default: {
                    throw OPLMessage_x.makeException(10);
                }
            }
        }
    }

    @Override
    public synchronized void execute() throws SQLException {
        if (this.conn == null) {
            this.conn = this.connect();
            this.doDisconnect = true;
        }
        if (this.conn == null || this.getCommand() == null) {
            throw OPLMessage_x.makeException(11);
        }
        try {
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        this.setParams(preparedStatement, this.getParams());
        try {
            preparedStatement.setMaxRows(this.getMaxRows());
            preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rs = preparedStatement.executeQuery();
        this.notifyListener(3);
    }

    public void execute(Connection connection) throws SQLException {
        this.conn = connection;
        this.execute();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.pstmt != null) {
            this.pstmt.close();
        }
        if (this.conn != null && this.doDisconnect) {
            this.conn.close();
        }
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.check_close();
        this.rs.cancelRowUpdates();
        this.notifyListener(2);
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.check_close();
        boolean bl = this.rs.next();
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.check_close();
        boolean bl = this.rs.previous();
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.check_close();
        boolean bl = this.rs.first();
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.check_close();
        boolean bl = this.rs.last();
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized boolean absolute(int n) throws SQLException {
        this.check_close();
        boolean bl = this.rs.absolute(n);
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized boolean relative(int n) throws SQLException {
        this.check_close();
        boolean bl = this.rs.relative(n);
        this.notifyListener(1);
        return bl;
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.check_close();
        this.rs.beforeFirst();
        this.notifyListener(1);
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.check_close();
        this.rs.afterLast();
        this.notifyListener(1);
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        this.check_close();
        return this.rs.isBeforeFirst();
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this.check_close();
        return this.rs.isAfterLast();
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        this.check_close();
        return this.rs.isFirst();
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        this.check_close();
        return this.rs.isLast();
    }

    @Override
    public synchronized int getRow() throws SQLException {
        this.check_close();
        return this.rs.getRow();
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        this.check_close();
        return this.rs.rowUpdated();
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        this.check_close();
        return this.rs.rowInserted();
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        this.check_close();
        return this.rs.rowDeleted();
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.check_close();
        this.rs.refreshRow();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this.check_close();
        this.rs.insertRow();
        this.notifyListener(2);
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.check_close();
        this.rs.updateRow();
        this.notifyListener(2);
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this.check_close();
        this.rs.deleteRow();
        this.notifyListener(2);
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.check_close();
        this.rs.moveToInsertRow();
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.check_close();
        this.rs.moveToCurrentRow();
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        this.check_close();
        return this.rs.wasNull();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.check_close();
        return this.rs.getWarnings();
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.check_close();
        this.rs.clearWarnings();
    }

    @Override
    public synchronized String getCursorName() throws SQLException {
        this.check_close();
        return this.rs.getCursorName();
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.check_close();
        return this.rs.getMetaData();
    }

    @Override
    public synchronized int findColumn(String string) throws SQLException {
        this.check_close();
        return this.rs.findColumn(string);
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        this.check_close();
        return this.rs.getString(n);
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        this.check_close();
        return this.rs.getBoolean(n);
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        this.check_close();
        return this.rs.getByte(n);
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        this.check_close();
        return this.rs.getShort(n);
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        this.check_close();
        return this.rs.getInt(n);
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        this.check_close();
        return this.rs.getLong(n);
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        this.check_close();
        return this.rs.getFloat(n);
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        this.check_close();
        return this.rs.getDouble(n);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(n);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(n, n2);
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        this.check_close();
        return this.rs.getBytes(n);
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        this.check_close();
        return this.rs.getDate(n);
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        this.check_close();
        return this.rs.getTime(n);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(n);
    }

    @Override
    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.check_close();
        return this.rs.getAsciiStream(n);
    }

    @Override
    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        this.check_close();
        return this.rs.getUnicodeStream(n);
    }

    @Override
    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.check_close();
        return this.rs.getBinaryStream(n);
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        this.check_close();
        return this.rs.getObject(n);
    }

    @Override
    public synchronized String getString(String string) throws SQLException {
        this.check_close();
        return this.rs.getString(string);
    }

    @Override
    public synchronized boolean getBoolean(String string) throws SQLException {
        this.check_close();
        return this.rs.getBoolean(string);
    }

    @Override
    public synchronized byte getByte(String string) throws SQLException {
        this.check_close();
        return this.rs.getByte(string);
    }

    @Override
    public synchronized short getShort(String string) throws SQLException {
        this.check_close();
        return this.rs.getShort(string);
    }

    @Override
    public synchronized int getInt(String string) throws SQLException {
        this.check_close();
        return this.rs.getInt(string);
    }

    @Override
    public synchronized long getLong(String string) throws SQLException {
        this.check_close();
        return this.rs.getLong(string);
    }

    @Override
    public synchronized float getFloat(String string) throws SQLException {
        this.check_close();
        return this.rs.getFloat(string);
    }

    @Override
    public synchronized double getDouble(String string) throws SQLException {
        this.check_close();
        return this.rs.getDouble(string);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(string, n);
    }

    @Override
    public synchronized byte[] getBytes(String string) throws SQLException {
        this.check_close();
        return this.rs.getBytes(string);
    }

    @Override
    public synchronized Date getDate(String string) throws SQLException {
        this.check_close();
        return this.rs.getDate(string);
    }

    @Override
    public synchronized Time getTime(String string) throws SQLException {
        this.check_close();
        return this.rs.getTime(string);
    }

    @Override
    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(string);
    }

    @Override
    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        this.check_close();
        return this.rs.getAsciiStream(string);
    }

    @Override
    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        this.check_close();
        return this.rs.getUnicodeStream(string);
    }

    @Override
    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        this.check_close();
        return this.rs.getBinaryStream(string);
    }

    @Override
    public synchronized Object getObject(String string) throws SQLException {
        this.check_close();
        return this.rs.getObject(string);
    }

    @Override
    public synchronized Reader getCharacterStream(int n) throws SQLException {
        this.check_close();
        return this.rs.getCharacterStream(n);
    }

    @Override
    public synchronized Reader getCharacterStream(String string) throws SQLException {
        this.check_close();
        return this.rs.getCharacterStream(string);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        this.check_close();
        return this.rs.getBigDecimal(string);
    }

    @Override
    public synchronized void updateNull(int n) throws SQLException {
        this.check_close();
        this.rs.updateNull(n);
    }

    @Override
    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        this.check_close();
        this.rs.updateBoolean(n, bl);
    }

    @Override
    public synchronized void updateByte(int n, byte by) throws SQLException {
        this.check_close();
        this.rs.updateByte(n, by);
    }

    @Override
    public synchronized void updateShort(int n, short s) throws SQLException {
        this.check_close();
        this.rs.updateShort(n, s);
    }

    @Override
    public synchronized void updateInt(int n, int n2) throws SQLException {
        this.check_close();
        this.rs.updateInt(n, n2);
    }

    @Override
    public synchronized void updateLong(int n, long l) throws SQLException {
        this.check_close();
        this.rs.updateLong(n, l);
    }

    @Override
    public synchronized void updateFloat(int n, float f) throws SQLException {
        this.check_close();
        this.rs.updateFloat(n, f);
    }

    @Override
    public synchronized void updateDouble(int n, double d) throws SQLException {
        this.check_close();
        this.rs.updateDouble(n, d);
    }

    @Override
    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.check_close();
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    @Override
    public synchronized void updateString(int n, String string) throws SQLException {
        this.check_close();
        this.rs.updateString(n, string);
    }

    @Override
    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        this.check_close();
        this.rs.updateBytes(n, byArray);
    }

    @Override
    public synchronized void updateDate(int n, Date date) throws SQLException {
        this.check_close();
        this.rs.updateDate(n, date);
    }

    @Override
    public synchronized void updateTime(int n, Time time) throws SQLException {
        this.check_close();
        this.rs.updateTime(n, time);
    }

    @Override
    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.check_close();
        this.rs.updateTimestamp(n, timestamp);
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(n, reader, n2);
    }

    @Override
    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        this.check_close();
        this.rs.updateObject(n, object, n2);
    }

    @Override
    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.check_close();
        this.rs.updateObject(n, object);
    }

    @Override
    public synchronized void updateNull(String string) throws SQLException {
        this.check_close();
        this.rs.updateNull(string);
    }

    @Override
    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        this.check_close();
        this.rs.updateBoolean(string, bl);
    }

    @Override
    public synchronized void updateByte(String string, byte by) throws SQLException {
        this.check_close();
        this.rs.updateByte(string, by);
    }

    @Override
    public synchronized void updateShort(String string, short s) throws SQLException {
        this.check_close();
        this.rs.updateShort(string, s);
    }

    @Override
    public synchronized void updateInt(String string, int n) throws SQLException {
        this.check_close();
        this.rs.updateInt(string, n);
    }

    @Override
    public synchronized void updateLong(String string, long l) throws SQLException {
        this.check_close();
        this.rs.updateLong(string, l);
    }

    @Override
    public synchronized void updateFloat(String string, float f) throws SQLException {
        this.check_close();
        this.rs.updateFloat(string, f);
    }

    @Override
    public synchronized void updateDouble(String string, double d) throws SQLException {
        this.check_close();
        this.rs.updateDouble(string, d);
    }

    @Override
    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.check_close();
        this.rs.updateBigDecimal(string, bigDecimal);
    }

    @Override
    public synchronized void updateString(String string, String string2) throws SQLException {
        this.check_close();
        this.rs.updateString(string, string2);
    }

    @Override
    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        this.check_close();
        this.rs.updateBytes(string, byArray);
    }

    @Override
    public synchronized void updateDate(String string, Date date) throws SQLException {
        this.check_close();
        this.rs.updateDate(string, date);
    }

    @Override
    public synchronized void updateTime(String string, Time time) throws SQLException {
        this.check_close();
        this.rs.updateTime(string, time);
    }

    @Override
    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.check_close();
        this.rs.updateTimestamp(string, timestamp);
    }

    @Override
    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(string, inputStream, n);
    }

    @Override
    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(string, inputStream, n);
    }

    @Override
    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(string, reader, n);
    }

    @Override
    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        this.check_close();
        this.rs.updateObject(string, object, n);
    }

    @Override
    public synchronized void updateObject(String string, Object object) throws SQLException {
        this.check_close();
        this.rs.updateObject(string, object);
    }

    @Override
    public synchronized Statement getStatement() throws SQLException {
        this.check_close();
        return this.rs.getStatement();
    }

    @Override
    public synchronized Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        this.check_close();
        return this.rs.getObject(n, map);
    }

    @Override
    public synchronized Ref getRef(int n) throws SQLException {
        this.check_close();
        return this.rs.getRef(n);
    }

    @Override
    public synchronized Blob getBlob(int n) throws SQLException {
        this.check_close();
        return this.rs.getBlob(n);
    }

    @Override
    public synchronized Clob getClob(int n) throws SQLException {
        this.check_close();
        return this.rs.getClob(n);
    }

    @Override
    public synchronized Array getArray(int n) throws SQLException {
        this.check_close();
        return this.rs.getArray(n);
    }

    @Override
    public synchronized Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        this.check_close();
        return this.rs.getObject(string, map);
    }

    @Override
    public synchronized Ref getRef(String string) throws SQLException {
        this.check_close();
        return this.rs.getRef(string);
    }

    @Override
    public synchronized Blob getBlob(String string) throws SQLException {
        this.check_close();
        return this.rs.getBlob(string);
    }

    @Override
    public synchronized Clob getClob(String string) throws SQLException {
        this.check_close();
        return this.rs.getClob(string);
    }

    @Override
    public synchronized Array getArray(String string) throws SQLException {
        this.check_close();
        return this.rs.getArray(string);
    }

    @Override
    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getDate(n, calendar);
    }

    @Override
    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getDate(string, calendar);
    }

    @Override
    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getTime(n, calendar);
    }

    @Override
    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getTime(string, calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(n, calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.check_close();
        return this.rs.getTimestamp(string, calendar);
    }

    @Override
    public synchronized URL getURL(int n) throws SQLException {
        this.check_close();
        return this.rs.getURL(n);
    }

    @Override
    public synchronized URL getURL(String string) throws SQLException {
        this.check_close();
        return this.rs.getURL(string);
    }

    @Override
    public synchronized void updateRef(int n, Ref ref) throws SQLException {
        this.check_close();
        this.rs.updateRef(n, ref);
    }

    @Override
    public synchronized void updateRef(String string, Ref ref) throws SQLException {
        this.check_close();
        this.rs.updateRef(string, ref);
    }

    @Override
    public synchronized void updateBlob(int n, Blob blob) throws SQLException {
        this.check_close();
        this.rs.updateBlob(n, blob);
    }

    @Override
    public synchronized void updateBlob(String string, Blob blob) throws SQLException {
        this.check_close();
        this.rs.updateBlob(string, blob);
    }

    @Override
    public synchronized void updateClob(int n, Clob clob) throws SQLException {
        this.check_close();
        this.rs.updateClob(n, clob);
    }

    @Override
    public synchronized void updateClob(String string, Clob clob) throws SQLException {
        this.check_close();
        this.rs.updateClob(string, clob);
    }

    @Override
    public synchronized void updateArray(int n, Array array) throws SQLException {
        this.check_close();
        this.rs.updateArray(n, array);
    }

    @Override
    public synchronized void updateArray(String string, Array array) throws SQLException {
        this.check_close();
        this.rs.updateArray(string, array);
    }

    @Override
    public synchronized RowId getRowId(int n) throws SQLException {
        this.check_close();
        return this.rs.getRowId(n);
    }

    @Override
    public synchronized RowId getRowId(String string) throws SQLException {
        this.check_close();
        return this.rs.getRowId(string);
    }

    @Override
    public synchronized void updateRowId(int n, RowId rowId) throws SQLException {
        this.check_close();
        this.rs.updateRowId(n, rowId);
    }

    @Override
    public synchronized void updateRowId(String string, RowId rowId) throws SQLException {
        this.check_close();
        this.rs.updateRowId(string, rowId);
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.check_close();
        return this.rs.getHoldability();
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        if (this.rs != null) {
            return this.rs.isClosed();
        }
        return true;
    }

    @Override
    public synchronized void updateNString(int n, String string) throws SQLException {
        this.check_close();
        this.rs.updateNString(n, string);
    }

    @Override
    public synchronized void updateNString(String string, String string2) throws SQLException {
        this.check_close();
        this.rs.updateNString(string, string2);
    }

    @Override
    public synchronized void updateNClob(int n, NClob nClob) throws SQLException {
        this.check_close();
        this.rs.updateNClob(n, nClob);
    }

    @Override
    public synchronized void updateNClob(String string, NClob nClob) throws SQLException {
        this.check_close();
        this.rs.updateNClob(string, nClob);
    }

    @Override
    public synchronized NClob getNClob(int n) throws SQLException {
        this.check_close();
        return this.rs.getNClob(n);
    }

    @Override
    public synchronized NClob getNClob(String string) throws SQLException {
        this.check_close();
        return this.rs.getNClob(string);
    }

    @Override
    public synchronized SQLXML getSQLXML(int n) throws SQLException {
        this.check_close();
        return this.rs.getSQLXML(n);
    }

    @Override
    public synchronized SQLXML getSQLXML(String string) throws SQLException {
        this.check_close();
        return this.rs.getSQLXML(string);
    }

    @Override
    public synchronized void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.check_close();
        this.rs.updateSQLXML(n, sQLXML);
    }

    @Override
    public synchronized void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.check_close();
        this.rs.updateSQLXML(string, sQLXML);
    }

    @Override
    public synchronized String getNString(int n) throws SQLException {
        this.check_close();
        return this.rs.getNString(n);
    }

    @Override
    public synchronized String getNString(String string) throws SQLException {
        this.check_close();
        return this.rs.getNString(string);
    }

    @Override
    public synchronized Reader getNCharacterStream(int n) throws SQLException {
        this.check_close();
        return this.rs.getNCharacterStream(n);
    }

    @Override
    public synchronized Reader getNCharacterStream(String string) throws SQLException {
        this.check_close();
        return this.rs.getNCharacterStream(string);
    }

    @Override
    public synchronized void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.check_close();
        this.rs.updateNCharacterStream(n, reader, l);
    }

    @Override
    public synchronized void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.check_close();
        this.rs.updateNCharacterStream(string, reader, l);
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(n, inputStream, l);
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(n, reader, l);
    }

    @Override
    public synchronized void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(string, inputStream, l);
    }

    @Override
    public synchronized void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(string, inputStream, l);
    }

    @Override
    public synchronized void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(string, reader, l);
    }

    @Override
    public synchronized void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.check_close();
        this.rs.updateBlob(n, inputStream, l);
    }

    @Override
    public synchronized void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.check_close();
        this.rs.updateBlob(string, inputStream, l);
    }

    @Override
    public synchronized void updateClob(int n, Reader reader, long l) throws SQLException {
        this.check_close();
        this.rs.updateClob(n, reader, l);
    }

    @Override
    public synchronized void updateClob(String string, Reader reader, long l) throws SQLException {
        this.check_close();
        this.rs.updateClob(string, reader, l);
    }

    @Override
    public synchronized void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.check_close();
        this.rs.updateNClob(n, reader, l);
    }

    @Override
    public synchronized void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.check_close();
        this.rs.updateNClob(string, reader, l);
    }

    @Override
    public synchronized void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateNCharacterStream(n, reader);
    }

    @Override
    public synchronized void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateNCharacterStream(string, reader);
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(n, inputStream);
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(n, inputStream);
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(n, reader);
    }

    @Override
    public synchronized void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.check_close();
        this.rs.updateAsciiStream(string, inputStream);
    }

    @Override
    public synchronized void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.check_close();
        this.rs.updateBinaryStream(string, inputStream);
    }

    @Override
    public synchronized void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateCharacterStream(string, reader);
    }

    @Override
    public synchronized void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.check_close();
        this.rs.updateBlob(n, inputStream);
    }

    @Override
    public synchronized void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.check_close();
        this.rs.updateBlob(string, inputStream);
    }

    @Override
    public synchronized void updateClob(int n, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateClob(n, reader);
    }

    @Override
    public synchronized void updateClob(String string, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateClob(string, reader);
    }

    @Override
    public synchronized void updateNClob(int n, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateNClob(n, reader);
    }

    @Override
    public synchronized void updateNClob(String string, Reader reader) throws SQLException {
        this.check_close();
        this.rs.updateNClob(string, reader);
    }

    @Override
    public synchronized <T> T unwrap(Class<T> clazz) throws SQLException {
        this.check_close();
        return this.rs.unwrap(clazz);
    }

    @Override
    public synchronized boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.check_close();
        return this.rs.isWrapperFor(clazz);
    }

    private void check_close() throws SQLException {
        if (this.rs == null) {
            throw OPLMessage_x.makeException(7);
        }
    }
}

