/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.sail.rdbms.RdbmsConnectionFactory;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.algebra.factories.BooleanExprFactory;
import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.SqlCastBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlExprBuilder;
import org.openrdf.sail.rdbms.evaluation.SqlRegexBuilder;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;
import org.openrdf.sail.rdbms.mysql.MySqlTable;
import org.openrdf.sail.rdbms.mysql.MySqlValueTable;
import org.openrdf.sail.rdbms.optimizers.SelectQueryOptimizerFactory;
import org.openrdf.sail.rdbms.schema.NamespacesTable;
import org.openrdf.sail.rdbms.schema.RdbmsTable;
import org.openrdf.sail.rdbms.schema.TableFactory;
import org.openrdf.sail.rdbms.schema.ValueTable;
import org.openrdf.sail.rdbms.schema.ValueTableFactory;

public class MySqlConnectionFactory
extends RdbmsConnectionFactory {
    private static final String FEILD_COLLATE = " CHARACTER SET utf8 COLLATE utf8_bin";

    protected TableFactory createTableFactory() {
        return new TableFactory(){

            protected RdbmsTable newTable(String name) {
                return new MySqlTable(name);
            }
        };
    }

    protected ValueTableFactory createValueTableFactory() {
        return new ValueTableFactory(this.createTableFactory()){

            protected ValueTable newValueTable() {
                return new MySqlValueTable();
            }

            public NamespacesTable createNamespacesTable(Connection conn) {
                return new NamespacesTable(this.createTable(conn, "NAMESPACE_PREFIXES")){

                    protected void createTable() throws SQLException {
                        StringBuilder sb = new StringBuilder();
                        sb.append("  prefix VARCHAR(127)");
                        sb.append(MySqlConnectionFactory.FEILD_COLLATE);
                        sb.append(",\n  namespace TEXT ");
                        sb.append(MySqlConnectionFactory.FEILD_COLLATE);
                        sb.append(" NOT NULL\n");
                        this.createTable(sb);
                    }
                };
            }
        };
    }

    protected SelectQueryOptimizerFactory createSelectQueryOptimizerFactory() {
        return new SelectQueryOptimizerFactory(){

            protected BooleanExprFactory createBooleanExprFactory() {
                return new BooleanExprFactory(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void meet(Regex node) throws UnsupportedRdbmsOperatorException {
                        ValueExpr flagsArg = node.getFlagsArg();
                        if (flagsArg == null) {
                            super.meet(node);
                            return;
                        } else {
                            if (!(flagsArg instanceof ValueConstant)) throw SqlExprSupport.unsupported(node);
                            ValueConstant flags = (ValueConstant)flagsArg;
                            if (!flags.getValue().stringValue().equals("i")) throw SqlExprSupport.unsupported(node);
                            super.meet(node);
                        }
                    }
                };
            }
        };
    }

    protected QueryBuilderFactory createQueryBuilderFactory() {
        return new QueryBuilderFactory(){

            public SqlRegexBuilder createSqlRegexBuilder(SqlExprBuilder where) {
                return new SqlRegexBuilder(where, this){

                    protected void appendRegExp(SqlExprBuilder where) {
                        this.appendValue(where);
                        if (!this.flags().getParameters().isEmpty()) {
                            where.append(" COLLATE utf8_general_ci");
                        }
                        where.append(" REGEXP ");
                        this.appendPattern(where);
                    }
                };
            }

            public SqlCastBuilder createSqlCastBuilder(SqlExprBuilder where, int type) {
                return new SqlCastBuilder(where, this, type){

                    protected CharSequence getSqlType(int type) {
                        switch (type) {
                            case 12: {
                                return "CHAR";
                            }
                        }
                        return super.getSqlType(type);
                    }
                };
            }
        };
    }
}

