.TH @g@indxbib @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@indxbib \- make inverted index of bibliographic databases
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2025 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_indxbib_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@indxbib
.RB [ \-w ]
.RB [ \-c\~\c
.IR \%common-words-file ]
.RB [ \-d\~\c
.IR dir ]
.RB [ \-f\~\c
.IR \%list-file ]
.RB [ \-h\~\c
.IR \%min-hash-table-size ]
.RB [ \-i\~\c
.IR \%excluded-fields ]
.RB [ \-k\~\c
.IR \%max-keys-per-record ]
.RB [ \-l\~\c
.IR \%min-key-length ]
.RB [ \-n\~\c
.IR \%threshold ]
.RB [ \-o\~\c
.IR file ]
.RB [ \-t\~\c
.IR \%max-key-length ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.P
.SY @g@indxbib
.B \-\-help
.YS
.
.
.P
.SY @g@indxbib
.B \-v
.YS
.
.SY @g@indxbib
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I @g@indxbib
makes an inverted index of the bibliographic databases in each
.I file
to speed their access by
.MR @g@refer @MAN1EXT@ ,
.MR @g@lookbib @MAN1EXT@ ,
and
.MR lkbib @MAN1EXT@ .
.
The program writes to a temporary file
that it later renames to
.RI file @INDEX_SUFFIX@ .
.
If no
.I file
operands are present
and no
.B \-o
option is given,
.I @g@indxbib
names the index
.IR \%@DEFAULT_INDEX_NAME@@INDEX_SUFFIX@ .
.
.
.PP
Bibliographic databases are divided into records by blank lines.
.
Within a record,
each field starts with a
.B %
character at the beginning of a line.
.
Fields have a one-letter name that follows the
.B %
character.
.
.
.PP
.I @g@indxbib
stores the values set by the
.BR \-c ,
.BR \-l ,
.BR \-n ,
and
.B \-t
options in the index:
programs that search the index interpret them,
discarding and truncating keys appropriately,
and using the original keys to verify
that any record found using the index actually contains the keys.
.
This means that a user of an index need not know whether these
options were used in the creation of the index,
provided that not all the keys to be searched for
would have been discarded during indexing
and that the user supplies at least the part of each key
that would have remained after being truncated during indexing.
.
.I @g@indxbib
also stores the value set by the
.B \-i
option in the index
for use in verifying records found using it.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.TP 8n \" "-d dir" + 2n
.BI \-c\~ common-words-file
Read the list of common words from
.I common-words-file
instead of
.IR \%@COMMON_WORDS_FILE@ .
.
.
.TP
.BI \-d\~ dir
Use
.I dir
as the name of the directory to store in the index,
instead of that returned by
.MR getcwd 2 .
.
Typically,
.I dir
will be a symbolic link whose target is the current working directory.
.
.
.TP
.BI \-f\~ list-file
Read the files to be indexed from
.IR list-file .
.
If
.I list-file
is
.BR \- ,
files will be read from the standard input stream.
.
The
.B \-f
option can be given at most once.
.
.
.TP
.BI \-h\~ min-hash-table-size
Use the first prime number greater than or equal to
the argument for the size of the hash table.
.
Larger values
will usually make searching faster,
but will make the index file larger
and cause
.I @g@indxbib
to use more memory.
.
The default hash table size is 997.
.
.
.TP
.BI \-i\~ excluded-fields
Don't index the contents of fields whose names are in
.IR excluded-fields .
.
Field names are one character each.
.
If this option is not present,
.I @g@indxbib
excludes fields
.BR X ,
.BR Y ,
and
.BR Z .
.
.
.TP
.BI \-k\~ max-keys-per-record
Use no more keys per input record than specified in the argument.
.
If this option is not present,
the maximum is 100.
.
.
.TP
.BI \-l\~ min-key-length
Discard any key whose length in characters is shorter than the value of
the argument.
.
If this option is not present,
the minimum key length
is 3.
.
.
.TP
.BI \-n\~ threshold
Discard the
.I threshold
most common words from the common words file.
.
If this option is not present,
the 100 most common words are discarded.
.
.
.TP
.BI \-o\~ basename
Name the index
.RI basename @INDEX_SUFFIX@ .
.
.
.TP
.BI \-t\~ max-key-length
Truncate keys to
.I max-key-length
in characters.
.
If this option is not present,
keys are truncated to 6 characters.
.
.
.TP
.B \-w
Index whole files.
.
Each file is a separate record.
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I @g@indxbib
exits with
.RB status\~ 0
on successful operation,
.RB status\~ 2
if the program cannot interpret its command-line arguments,
and
.RB status\~ 1
if it encounters an error during operation.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.RI \%file @INDEX_SUFFIX@
index for
.I file
.
.
.TP
.I \%@DEFAULT_INDEX_NAME@@INDEX_SUFFIX@
default index name
.
.
.TP
.I \%@COMMON_WORDS_FILE@
contains the list of common words.
.
The traditional name,
.RI \[lq] eign \[rq],
is an abbreviation of \[lq]English ignored [word list]\[rq].
.
.
.TP
.IR \%indxbib XXXXXX
temporary file
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
\[lq]Some Applications of Inverted Indexes on the Unix System\[rq],
by M.\& E.\& Lesk,
1978,
AT&T Bell Laboratories Computing Science Technical Report No.\& 69.
.
.
.LP
.MR @g@refer @MAN1EXT@ ,
.MR lkbib @MAN1EXT@ ,
.MR @g@lookbib @MAN1EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_indxbib_1_man_C]
.do rr *groff_indxbib_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
