/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.security.CertificateStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class JavawsHttpsCertStore
implements CertificateStore {
    private static String _filename = null;
    private static KeyStore _jwscerts;

    static {
        _filename = ConfigProperties.getInstance().getCacheDir() + File.separator + "javawshttpscerts";
        _jwscerts = null;
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.loading" + new Object[]{_filename});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (_jwscerts == null) {
                        _jwscerts = KeyStore.getInstance("JKS");
                        _jwscerts.load(null, null);
                    }
                    if ((file = new File(_filename)).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        _jwscerts.load(bufferedInputStream, new char[0]);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Debug.ignoredException(privilegedActionException);
        }
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.loaded" + new Object[]{_filename});
        }
    }

    public static void removeJavawsHttpsCert() {
        new File(_filename).delete();
        _jwscerts = null;
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.saving" + new Object[]{_filename});
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(ConfigProperties.getInstance().getCacheDir());
                    file.mkdirs();
                    File file2 = new File(_filename);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    _jwscerts.store(bufferedOutputStream, new char[0]);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            privilegedActionException.printStackTrace();
        }
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.saved" + new Object[]{_filename});
        }
    }

    public static String getJavawsHttpsFilename() {
        return _filename;
    }

    public void add(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.adding");
        }
        if (!this.contains(certificate)) {
            Random random = new Random();
            boolean bl = false;
            String string = null;
            do {
                Certificate certificate2;
                if ((certificate2 = _jwscerts.getCertificate(string = "jwscert" + random.nextLong())) != null) continue;
                bl = true;
            } while (!bl);
            _jwscerts.setCertificateEntry(string, certificate);
            if (Globals.TraceHttpsCert) {
                Debug.println("jwshttpscertstore.cert.added" + new Object[]{string});
            }
        }
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        String string;
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.removing");
        }
        if ((string = _jwscerts.getCertificateAlias(certificate)) != null) {
            _jwscerts.deleteEntry(string);
        }
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.removed" + new Object[]{string});
        }
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.instore");
        }
        String string = null;
        string = _jwscerts.getCertificateAlias(certificate);
        return string != null;
    }

    public boolean verify(Certificate certificate) {
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.canverify");
        }
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        if (Globals.TraceHttpsCert) {
            Debug.println("jwshttpscertstore.cert.iterator");
        }
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = _jwscerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = _jwscerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }
}

