/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.net;

import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.net.CanceledDownloadException;
import com.sun.javaws.net.HttpDownload;
import com.sun.javaws.net.HttpDownloadListener;
import com.sun.javaws.net.HttpRequest;
import com.sun.javaws.net.HttpResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class BasicDownloadLayer
implements HttpDownload {
    private static final int BUF_SIZE = 32768;
    private HttpRequest _httpRequest;

    public BasicDownloadLayer(HttpRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    public void download(HttpResponse httpResponse, File file, HttpDownloadListener httpDownloadListener) throws CanceledDownloadException, IOException {
        int n = httpResponse.getContentLength();
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(0, n);
        }
        if (Globals.TraceDownload) {
            Debug.println("Doing download");
        }
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            bufferedInputStream = httpResponse.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = new byte[32768];
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                if ((n3 += n2) > n && n != 0) {
                    n3 = n;
                }
                if (httpDownloadListener == null) continue;
                httpDownloadListener.downloadProgress(n3, n);
            }
            if (Globals.TraceDownload) {
                Debug.println("Wrote URL " + httpResponse.getRequest() + " to file " + file);
            }
            ((InputStream)bufferedInputStream).close();
            bufferedInputStream = null;
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            if (Globals.TraceDownload) {
                Debug.println("Got exception while downloading resource: " + iOException);
            }
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
                bufferedInputStream = null;
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
                fileOutputStream = null;
            }
            if (file != null) {
                file.delete();
            }
            throw iOException;
        }
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(n, n);
        }
    }

    public void download(URL uRL, File file, HttpDownloadListener httpDownloadListener) throws CanceledDownloadException, IOException {
        HttpResponse httpResponse = this._httpRequest.doGetRequest(uRL);
        this.download(httpResponse, file, httpDownloadListener);
    }
}

