/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.Utility;

public final class CompactIntArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private int[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;

    public int hashCode() {
        int n2 = 0;
        int n3 = Math.min(3, this.values.length / 16);
        for (int i2 = 0; i2 < this.values.length; i2 += n3) {
            n2 = n2 * 37 + this.values[i2];
        }
        return n2;
    }

    public CompactIntArray() {
        this(0);
    }

    public void compact() {
        if (!this.isCompact) {
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.indices.length) {
                this.indices[n5] = -1;
                boolean bl2 = this.blockTouched(n5);
                if (!bl2 && n4 != -1) {
                    this.indices[n5] = n4;
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.hashes[n5] == this.hashes[n7] && Utility.arrayRegionMatches(this.values, n3, this.values, n6, 128)) {
                            this.indices[n5] = (short)n6;
                            break;
                        }
                        ++n7;
                        n6 += 128;
                    }
                    if (this.indices[n5] == -1) {
                        System.arraycopy(this.values, n3, this.values, n6, 128);
                        this.indices[n5] = (short)n6;
                        this.hashes[n7] = this.hashes[n5];
                        ++n2;
                        if (!bl2) {
                            n4 = (short)n6;
                        }
                    }
                }
                ++n5;
                n3 += 128;
            }
            n5 = n2 * 128;
            int[] nArray = new int[n5];
            System.arraycopy(this.values, 0, nArray, 0, n5);
            this.values = nArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    private void expand() {
        if (this.isCompact) {
            int n2;
            this.hashes = new int[512];
            int[] nArray = new int[65536];
            for (n2 = 0; n2 < 65536; ++n2) {
                int n3;
                nArray[n2] = n3 = this.elementAt((char)n2);
                this.touchBlock(n2 >> 7, n3);
            }
            for (n2 = 0; n2 < 512; ++n2) {
                this.indices[n2] = (short)(n2 << 7);
            }
            this.values = nArray;
            this.isCompact = false;
        }
    }

    public int[] getStringArray() {
        return this.values;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public int elementAt(char c2) {
        return this.values[(this.indices[c2 >> 7] & 0xFFFF) + (c2 & 0x7F)];
    }

    public void setElementAt(char n2, char c2, int n3) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i2 = n2; i2 <= c2; ++i2) {
            this.values[i2] = n3;
            this.touchBlock(i2 >> 7, n3);
        }
    }

    public void setElementAt(char c2, int n2) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c2] = n2;
        this.touchBlock(c2 >> 7, n2);
    }

    public CompactIntArray(int n2) {
        int n3;
        this.values = new int[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        for (n3 = 0; n3 < 65536; ++n3) {
            this.values[n3] = n2;
        }
        for (n3 = 0; n3 < 512; ++n3) {
            this.indices[n3] = (short)(n3 << 7);
            this.hashes[n3] = 0;
        }
        this.isCompact = false;
    }

    private final boolean blockTouched(int n2) {
        return this.hashes[n2] != 0;
    }

    private final void touchBlock(int n2, int n3) {
        this.hashes[n2] = this.hashes[n2] + (n3 << 1) | 1;
    }

    public CompactIntArray(short[] sArray, int[] nArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        for (int i2 = 0; i2 < 512; ++i2) {
            short s2 = sArray[i2];
            if (s2 >= 0 && s2 < nArray.length + 128) continue;
            throw new IllegalArgumentException("Index out of bounds.");
        }
        this.indices = sArray;
        this.values = nArray;
        this.isCompact = true;
    }

    public Object clone() {
        try {
            CompactIntArray compactIntArray = (CompactIntArray)super.clone();
            compactIntArray.values = (int[])this.values.clone();
            compactIntArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactIntArray.hashes = (int[])this.hashes.clone();
            }
            return compactIntArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactIntArray compactIntArray = (CompactIntArray)object;
        for (int i2 = 0; i2 < 65536; ++i2) {
            if (this.elementAt((char)i2) == compactIntArray.elementAt((char)i2)) continue;
            return false;
        }
        return true;
    }
}

