/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemForEach;
import org.apache.xalan.templates.ElemSort;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.templates.XUnresolvedVariable;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.KeyManager;
import org.apache.xalan.transformer.MsgMgr;
import org.apache.xalan.transformer.NodeSortKey;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.StackGuard;
import org.apache.xalan.transformer.TransformSnapshot;
import org.apache.xalan.transformer.TransformSnapshotImpl;
import org.apache.xalan.transformer.TransformerHandlerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.ObjectPool;
import org.apache.xml.utils.ObjectStack;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Arg;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.ExtensionsProvider;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SelfIteratorNoPredicate;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class TransformerImpl
extends Transformer
implements Runnable,
DTMWSFilter,
ExtensionsProvider {
    private Boolean m_reentryGuard = new Boolean(true);
    private FileOutputStream m_outputStream = null;
    private boolean m_parserEventsOnMain = true;
    private Thread m_transformThread;
    private String m_urlOfSource = null;
    private Result m_outputTarget = null;
    private OutputProperties m_outputFormat;
    private Serializer m_serializer;
    ContentHandler m_inputContentHandler;
    private ContentHandler m_outputContentHandler = null;
    DocumentBuilder m_docBuilder = null;
    private ObjectPool m_textResultHandlerObjectPool = new ObjectPool("org.apache.xalan.transformer.ResultTreeHandler");
    private ObjectPool m_stringWriterObjectPool = new ObjectPool("java.io.StringWriter");
    private OutputProperties m_textformat = new OutputProperties("text");
    ObjectStack m_currentTemplateElements = new ObjectStack(4096);
    Stack m_currentMatchTemplates = new Stack();
    NodeVector m_currentMatchedNodes = new NodeVector();
    private StylesheetRoot m_stylesheetRoot = null;
    private boolean m_quietConflictWarnings = true;
    private XPathContext m_xcontext;
    private StackGuard m_stackGuard;
    private ResultTreeHandler m_resultTreeHandler;
    private KeyManager m_keyManager = new KeyManager();
    Stack m_attrSetStack = null;
    CountersTable m_countersTable = null;
    BoolStack m_currentTemplateRuleIsNull = new BoolStack();
    private MsgMgr m_msgMgr;
    public static boolean S_DEBUG = false;
    private ErrorListener m_errorHandler = new DefaultErrorHandler();
    private TraceManager m_traceManager = new TraceManager(this);
    private Exception m_exceptionThrown = null;
    private Source m_xmlSource;
    private int m_doc;
    private boolean m_isTransformDone = false;
    private boolean m_hasBeenReset = false;
    private boolean m_shouldReset = true;
    private Stack m_modes = new Stack();
    private ExtensionsTable m_extensionsTable = null;
    private boolean m_hasTransformThreadErrorCatcher = false;
    Vector m_userParams;
    static ThreadControler tpool = new ThreadControler();

    public int getCurrentNode() {
        return this.m_xcontext.getCurrentNode();
    }

    public int getCurrentTemplateElementsCount() {
        return this.m_currentTemplateElements.size();
    }

    public int getMatchedNode() {
        return this.m_currentMatchedNodes.peepTail();
    }

    public int getRecursionLimit() {
        return this.m_stackGuard.getRecursionLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() {
        Boolean bl2 = this.m_reentryGuard;
        synchronized (bl2) {
            VariableStack variableStack = new VariableStack();
            this.m_xcontext.setVarStack(variableStack);
            this.m_userParams = null;
        }
    }

    public void popCurrentMatched() {
        this.m_currentMatchTemplates.pop();
        this.m_currentMatchedNodes.pop();
    }

    public void popCurrentTemplateRuleIsNull() {
        this.m_currentTemplateRuleIsNull.pop();
    }

    public void popElemAttributeSet() {
        this.m_attrSetStack.pop();
    }

    public void popElemTemplateElement() {
        this.m_currentTemplateElements.pop();
    }

    public void popMode() {
        this.m_modes.pop();
    }

    public void reset() {
        if (!this.m_hasBeenReset && this.m_shouldReset) {
            this.m_hasBeenReset = true;
            if (this.m_outputStream != null) {
                try {
                    this.m_outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.m_outputStream = null;
            this.m_countersTable = null;
            this.m_xcontext.reset();
            this.m_xcontext.getVarStack().reset();
            this.resetUserParameters();
            this.m_currentTemplateElements.removeAllElements();
            this.m_currentMatchTemplates.removeAllElements();
            this.m_currentMatchedNodes.removeAllElements();
            this.m_resultTreeHandler = null;
            this.m_outputTarget = null;
            this.m_keyManager = new KeyManager();
            this.m_attrSetStack = null;
            this.m_countersTable = null;
            this.m_currentTemplateRuleIsNull = new BoolStack();
            this.m_xmlSource = null;
            this.m_doc = -1;
            this.m_isTransformDone = false;
            this.m_transformThread = null;
            this.m_xcontext.getSourceTreeManager().reset();
        }
    }

    private void resetUserParameters() {
        try {
            if (null == this.m_userParams) {
                return;
            }
            int n2 = this.m_userParams.size();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                Arg arg = (Arg)this.m_userParams.elementAt(i2);
                QName qName = arg.getQName();
                String string = qName.getNamespace();
                String string2 = qName.getLocalPart();
                this.setParameter(string2, string, arg.getVal().object());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.m_hasBeenReset = false;
        try {
            try {
                try {
                    this.m_isTransformDone = false;
                    this.transformNode(this.m_doc);
                }
                catch (Exception exception) {
                    if (null == this.m_transformThread) throw new RuntimeException(exception.getMessage());
                    this.postExceptionFromThread(exception);
                    Object var3_2 = null;
                    this.m_isTransformDone = true;
                    if (!(this.m_inputContentHandler instanceof TransformerHandlerImpl)) return;
                    ((TransformerHandlerImpl)this.m_inputContentHandler).clearCoRoutine();
                    return;
                }
                Object var3_1 = null;
                this.m_isTransformDone = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_isTransformDone = true;
                if (!(this.m_inputContentHandler instanceof TransformerHandlerImpl)) throw throwable;
                ((TransformerHandlerImpl)this.m_inputContentHandler).clearCoRoutine();
                throw throwable;
            }
            if (!(this.m_inputContentHandler instanceof TransformerHandlerImpl)) return;
            ((TransformerHandlerImpl)this.m_inputContentHandler).clearCoRoutine();
            return;
        }
        catch (Exception exception) {
            if (null == this.m_transformThread) throw new RuntimeException(exception.getMessage());
            this.postExceptionFromThread(exception);
            return;
        }
    }

    public void runTransformThread() {
        tpool.run(this, -1);
    }

    public void stopTransformation() {
    }

    public void waitTransformThread() throws SAXException {
        Thread thread = this.getTransformThread();
        if (null != thread) {
            try {
                Exception exception;
                tpool.waitThread(thread, this);
                if (!this.hasTransformThreadErrorCatcher() && null != (exception = this.getExceptionThrown())) {
                    exception.printStackTrace();
                    throw new SAXException(exception);
                }
                this.setTransformThread(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean currentTemplateRuleIsNull() {
        return !this.m_currentTemplateRuleIsNull.isEmpty() && this.m_currentTemplateRuleIsNull.peek();
    }

    public boolean getQuietConflictWarnings() {
        return this.m_quietConflictWarnings;
    }

    public boolean hasTransformThreadErrorCatcher() {
        return this.m_hasTransformThreadErrorCatcher;
    }

    public boolean isParserEventsOnMain() {
        return this.m_parserEventsOnMain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransformDone() {
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            return this.m_isTransformDone;
        }
    }

    protected void pushGlobalVars(int n2) throws TransformerException {
        XPathContext xPathContext = this.m_xcontext;
        VariableStack variableStack = xPathContext.getVarStack();
        StylesheetRoot stylesheetRoot = this.getStylesheet();
        Vector vector = stylesheetRoot.getVariablesAndParamsComposed();
        int n3 = vector.size();
        variableStack.link(n3);
        while (--n3 >= 0) {
            ElemVariable elemVariable = (ElemVariable)vector.elementAt(n3);
            XUnresolvedVariable xUnresolvedVariable = new XUnresolvedVariable(elemVariable, n2, this, variableStack.getStackFrame(), 0, true);
            if (null != variableStack.elementAt(n3)) continue;
            variableStack.setGlobalVariable(n3, xUnresolvedVariable);
        }
    }

    public void runTransformThread(int n2) {
        Thread thread = tpool.run(this, n2);
        this.setTransformThread(thread);
    }

    public void setRecursionLimit(int n2) {
        this.m_stackGuard.setRecursionLimit(n2);
    }

    public void setSourceTreeDocForThread(int n2) {
        this.m_doc = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformNode(int n2) throws TransformerException {
        this.setExtensionsTable(this.getStylesheet());
        ContentHandler contentHandler = this.m_outputContentHandler;
        synchronized (contentHandler) {
            this.m_hasBeenReset = false;
            XPathContext xPathContext = this.getXPathContext();
            DTM dTM = xPathContext.getDTM(n2);
            try {
                this.pushGlobalVars(n2);
                StylesheetRoot stylesheetRoot = this.getStylesheet();
                int n3 = stylesheetRoot.getGlobalImportCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    StylesheetComposed stylesheetComposed = stylesheetRoot.getGlobalImport(i2);
                    int n4 = stylesheetComposed.getIncludeCountComposed();
                    for (int i3 = -1; i3 < n4; ++i3) {
                        Stylesheet stylesheet = stylesheetComposed.getIncludeComposed(i3);
                        stylesheet.runtimeInit(this);
                        for (ElemTemplateElement elemTemplateElement = stylesheet.getFirstChildElem(); elemTemplateElement != null; elemTemplateElement = elemTemplateElement.getNextSiblingElem()) {
                            elemTemplateElement.runtimeInit(this);
                        }
                    }
                }
                SelfIteratorNoPredicate selfIteratorNoPredicate = new SelfIteratorNoPredicate();
                selfIteratorNoPredicate.setRoot(n2, xPathContext);
                xPathContext.pushContextNodeList(selfIteratorNoPredicate);
                try {
                    this.applyTemplateToNode(null, null, n2);
                }
                finally {
                    xPathContext.popContextNodeList();
                }
                if (null != this.m_resultTreeHandler) {
                    this.m_resultTreeHandler.endDocument();
                }
            }
            catch (Exception exception) {
                Exception exception2;
                Exception exception3;
                while (exception3 instanceof WrappedRuntimeException) {
                    exception2 = ((WrappedRuntimeException)exception3).getException();
                    if (null == exception2) continue;
                    exception3 = exception2;
                }
                if (null != this.m_resultTreeHandler) {
                    try {
                        if (exception3 instanceof SAXParseException) {
                            this.m_resultTreeHandler.fatalError((SAXParseException)exception3);
                        } else if (exception3 instanceof TransformerException) {
                            exception2 = (TransformerException)exception3;
                            SAXSourceLocator sAXSourceLocator = new SAXSourceLocator(((TransformerException)exception2).getLocator());
                            this.m_resultTreeHandler.fatalError(new SAXParseException(exception2.getMessage(), sAXSourceLocator, exception2));
                        } else {
                            this.m_resultTreeHandler.fatalError(new SAXParseException(exception3.getMessage(), new SAXSourceLocator(), exception3));
                        }
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                if (exception3 instanceof TransformerException) {
                    this.m_errorHandler.fatalError((TransformerException)exception3);
                } else if (exception3 instanceof SAXParseException) {
                    this.m_errorHandler.fatalError(new TransformerException(exception3.getMessage(), new SAXSourceLocator((SAXParseException)exception3), exception3));
                } else {
                    this.m_errorHandler.fatalError(new TransformerException(exception3));
                }
            }
            finally {
                this.reset();
            }
        }
    }

    public void pushCurrentTemplateRuleIsNull(boolean bl2) {
        this.m_currentTemplateRuleIsNull.push(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsTransformDone(boolean bl2) {
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            this.m_isTransformDone = bl2;
        }
    }

    public void setQuietConflictWarnings(boolean bl2) {
        this.m_quietConflictWarnings = bl2;
    }

    public void setShouldReset(boolean bl2) {
        this.m_shouldReset = bl2;
    }

    public Exception getExceptionThrown() {
        return this.m_exceptionThrown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postExceptionFromThread(Exception exception) {
        ContentHandler contentHandler = this.getContentHandler();
        this.m_isTransformDone = true;
        this.m_exceptionThrown = exception;
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            this.notifyAll();
        }
    }

    public void setExceptionThrown(Exception exception) {
        this.m_exceptionThrown = exception;
    }

    public static void runTransformThread(Runnable runnable) {
        tpool.run(runnable, -1);
    }

    public String getBaseURLOfSource() {
        return this.m_urlOfSource;
    }

    public void setBaseURLOfSource(String string) {
        this.m_urlOfSource = string;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/trax/features/sax/input".equals(string)) {
            return true;
        }
        if ("http://xml.org/trax/features/dom/input".equals(string)) {
            return true;
        }
        throw new SAXNotRecognizedException(string);
    }

    public boolean getProperty(String string) {
        return false;
    }

    public Thread getTransformThread() {
        return this.m_transformThread;
    }

    public void setTransformThread(Thread thread) {
        this.m_transformThread = thread;
    }

    private void fatalError(Throwable throwable) throws TransformerException {
        if (throwable instanceof SAXParseException) {
            this.m_errorHandler.fatalError(new TransformerException(throwable.getMessage(), new SAXSourceLocator((SAXParseException)throwable)));
        } else {
            this.m_errorHandler.fatalError(new TransformerException(throwable));
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.getOutputFormat().getProperties().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        Boolean bl2 = this.m_reentryGuard;
        synchronized (bl2) {
            if (null != properties) {
                String string = (String)properties.get("method");
                if (null != string) {
                    this.m_outputFormat = new OutputProperties(string);
                } else if (this.m_outputFormat == null) {
                    this.m_outputFormat = new OutputProperties();
                }
            }
            if (null != properties) {
                this.m_outputFormat.copyFrom(properties);
            }
            this.m_outputFormat.copyFrom(this.m_stylesheetRoot.getOutputProperties());
        }
    }

    public void setParameters(Properties properties) {
        this.clearParameters();
        Enumeration enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = properties.getProperty((String)enumeration.nextElement());
            StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", false);
            try {
                String string2;
                String string3 = stringTokenizer.nextToken();
                String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                if (null == string2) {
                    this.setParameter(string3, null, properties.getProperty(string));
                    continue;
                }
                this.setParameter(string2, string3, properties.getProperty(string));
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    public Vector getElementCallstack() {
        Vector vector = new Vector();
        int n2 = this.m_currentTemplateElements.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)this.m_currentTemplateElements.elementAt(i2);
            if (null == elemTemplateElement) continue;
            vector.addElement(elemTemplateElement);
        }
        return vector;
    }

    public Vector getTemplateCallstack() {
        Vector vector = new Vector();
        int n2 = this.m_currentTemplateElements.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)this.m_currentTemplateElements.elementAt(i2);
            if (null == elemTemplateElement || elemTemplateElement.getXSLToken() == 19) continue;
            vector.addElement(elemTemplateElement);
        }
        return vector;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        Boolean bl2 = this.m_reentryGuard;
        synchronized (bl2) {
            if (errorListener == null) {
                throw new IllegalArgumentException(XSLMessages.createMessage("ER_NULL_ERROR_HANDLER", null));
            }
            this.m_errorHandler = errorListener;
        }
    }

    public Result getOutputTarget() {
        return this.m_outputTarget;
    }

    public void transformNode(int n2, Result result) throws TransformerException {
        ContentHandler contentHandler = this.createResultContentHandler(result);
        this.m_outputTarget = result;
        this.setContentHandler(contentHandler);
        this.transformNode(n2);
    }

    public void setOutputTarget(Result result) {
        this.m_outputTarget = result;
    }

    public void setXMLSource(Source source) {
        this.m_xmlSource = source;
    }

    public void transform(Source source) throws TransformerException {
        this.transform(source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(Source source, boolean bl2) throws TransformerException {
        try {
            Object object;
            String string;
            if (this.getXPathContext().getNamespaceContext() == null) {
                this.getXPathContext().setNamespaceContext(this.getStylesheet());
            }
            if (null == (string = source.getSystemId())) {
                string = this.m_stylesheetRoot.getBaseIdentifier();
            }
            if (null == string) {
                object = "";
                try {
                    object = System.getProperty("user.dir");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                string = ((String)object).startsWith(File.separator) ? "file://" + (String)object : "file:///" + (String)object;
                string = string + File.separatorChar + source.getClass().getName();
            }
            this.setBaseURLOfSource(string);
            object = this.m_xcontext.getDTMManager();
            DTM dTM = ((DTMManager)object).getDTM(source, false, this, true, true);
            dTM.setDocumentBaseURI(string);
            boolean bl3 = true;
            try {
                this.transformNode(dTM.getDocument());
            }
            finally {
                if (bl2) {
                    ((DTMManager)object).release(dTM, bl3);
                }
            }
            Exception exception = this.getExceptionThrown();
            if (null != exception) {
                if (exception instanceof TransformerException) {
                    throw (TransformerException)exception;
                }
                if (!(exception instanceof WrappedRuntimeException)) throw new TransformerException(exception);
                this.fatalError(((WrappedRuntimeException)exception).getException());
                return;
            } else {
                if (null == this.m_resultTreeHandler) return;
                this.m_resultTreeHandler.endDocument();
            }
            return;
        }
        catch (WrappedRuntimeException wrappedRuntimeException) {
            Exception exception = wrappedRuntimeException.getException();
            while (exception instanceof WrappedRuntimeException) {
                exception = ((WrappedRuntimeException)exception).getException();
            }
            this.fatalError(exception);
            return;
        }
        catch (SAXParseException sAXParseException) {
            this.fatalError(sAXParseException);
            return;
        }
        catch (SAXException sAXException) {
            this.m_errorHandler.fatalError(new TransformerException(sAXException));
            return;
        }
        finally {
            this.m_hasTransformThreadErrorCatcher = false;
            this.reset();
        }
    }

    public Transformer getTransformer() {
        return this;
    }

    public URIResolver getURIResolver() {
        return this.m_xcontext.getSourceTreeManager().getURIResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURIResolver(URIResolver uRIResolver) {
        Boolean bl2 = this.m_reentryGuard;
        synchronized (bl2) {
            this.m_xcontext.getSourceTreeManager().setURIResolver(uRIResolver);
        }
    }

    public ExtensionsTable getExtensionsTable() {
        return this.m_extensionsTable;
    }

    public Serializer getSerializer() {
        return this.m_serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.m_serializer = serializer;
    }

    public void pushElemAttributeSet(ElemAttributeSet elemAttributeSet) {
        this.m_attrSetStack.push(elemAttributeSet);
    }

    public boolean isRecursiveAttrSet(ElemAttributeSet elemAttributeSet) {
        int n2;
        if (null == this.m_attrSetStack) {
            this.m_attrSetStack = new Stack();
        }
        return !this.m_attrSetStack.empty() && (n2 = this.m_attrSetStack.search(elemAttributeSet)) > -1;
    }

    public ElemTemplate getCurrentTemplate() {
        ElemTemplateElement elemTemplateElement;
        for (elemTemplateElement = this.getCurrentElement(); null != elemTemplateElement && elemTemplateElement.getXSLToken() != 19; elemTemplateElement = elemTemplateElement.getParentElem()) {
        }
        return (ElemTemplate)elemTemplateElement;
    }

    public ElemTemplate getMatchedTemplate() {
        return (ElemTemplate)this.m_currentMatchTemplates.peek();
    }

    public ElemTemplateElement getCurrentElement() {
        return this.m_currentTemplateElements.size() > 0 ? (ElemTemplateElement)this.m_currentTemplateElements.peek() : null;
    }

    public int transformToGlobalRTF(ElemTemplateElement elemTemplateElement) throws TransformerException {
        DTM dTM = this.m_xcontext.getGlobalRTFDTM();
        return this.transformToRTF(elemTemplateElement, dTM);
    }

    public int transformToRTF(ElemTemplateElement elemTemplateElement) throws TransformerException {
        DTM dTM = this.m_xcontext.getRTFDTM();
        return this.transformToRTF(elemTemplateElement, dTM);
    }

    public void pushElemTemplateElement(ElemTemplateElement elemTemplateElement) {
        this.m_currentTemplateElements.push(elemTemplateElement);
    }

    public void setCurrentElement(ElemTemplateElement elemTemplateElement) {
        this.m_currentTemplateElements.setTop(elemTemplateElement);
    }

    public void pushPairCurrentMatched(ElemTemplateElement elemTemplateElement, int n2) {
        this.m_currentMatchTemplates.push(elemTemplateElement);
        this.m_currentMatchedNodes.push(n2);
    }

    public void executeChildTemplates(ElemTemplateElement elemTemplateElement, boolean bl2) throws TransformerException {
        ElemTemplateElement elemTemplateElement2 = elemTemplateElement.getFirstChildElem();
        if (null == elemTemplateElement2) {
            return;
        }
        if (elemTemplateElement.hasTextLitOnly() && TransformerFactoryImpl.m_optimize) {
            char[] cArray = ((ElemTextLiteral)elemTemplateElement2).getChars();
            try {
                this.pushElemTemplateElement(elemTemplateElement2);
                this.m_resultTreeHandler.characters(cArray, 0, cArray.length);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
            finally {
                this.popElemTemplateElement();
            }
            return;
        }
        XPathContext xPathContext = this.m_xcontext;
        xPathContext.pushSAXLocatorNull();
        int n2 = this.m_currentTemplateElements.size();
        this.m_currentTemplateElements.push(null);
        try {
            while (elemTemplateElement2 != null) {
                if (bl2 || elemTemplateElement2.getXSLToken() != 48) {
                    xPathContext.setSAXLocator(elemTemplateElement2);
                    this.m_currentTemplateElements.setElementAt(elemTemplateElement2, n2);
                    elemTemplateElement2.execute(this);
                }
                elemTemplateElement2 = elemTemplateElement2.getNextSiblingElem();
            }
        }
        catch (RuntimeException runtimeException) {
            TransformerException transformerException = new TransformerException(runtimeException);
            transformerException.setLocator(elemTemplateElement2);
            throw transformerException;
        }
        finally {
            this.m_currentTemplateElements.pop();
            xPathContext.popSAXLocator();
        }
    }

    public OutputProperties getOutputFormat() {
        OutputProperties outputProperties = null == this.m_outputFormat ? this.getStylesheet().getOutputComposed() : this.m_outputFormat;
        return outputProperties;
    }

    public void setOutputFormat(OutputProperties outputProperties) {
        this.m_outputFormat = outputProperties;
    }

    public final StylesheetRoot getStylesheet() {
        return this.m_stylesheetRoot;
    }

    public TransformerImpl(StylesheetRoot stylesheetRoot) {
        this.setStylesheet(stylesheetRoot);
        this.setXPathContext(new XPathContext(this));
        this.getXPathContext().setNamespaceContext(stylesheetRoot);
        this.m_stackGuard = new StackGuard(this);
    }

    void setExtensionsTable(StylesheetRoot stylesheetRoot) throws TransformerException {
        try {
            if (stylesheetRoot.getExtensions() != null) {
                this.m_extensionsTable = new ExtensionsTable(stylesheetRoot);
            }
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    public void setStylesheet(StylesheetRoot stylesheetRoot) {
        this.m_stylesheetRoot = stylesheetRoot;
    }

    public TraceManager getTraceManager() {
        return this.m_traceManager;
    }

    public CountersTable getCountersTable() {
        if (null == this.m_countersTable) {
            this.m_countersTable = new CountersTable();
        }
        return this.m_countersTable;
    }

    public KeyManager getKeyManager() {
        return this.m_keyManager;
    }

    public MsgMgr getMsgMgr() {
        if (null == this.m_msgMgr) {
            this.m_msgMgr = new MsgMgr(this);
        }
        return this.m_msgMgr;
    }

    public ResultTreeHandler getResultTreeHandler() {
        return this.m_resultTreeHandler;
    }

    public StackGuard getStackGuard() {
        return this.m_stackGuard;
    }

    public TransformSnapshot getSnapshot() {
        return new TransformSnapshotImpl(this);
    }

    public void executeFromSnapshot(TransformSnapshot transformSnapshot) throws TransformerException {
        ElemTemplate elemTemplate = this.getMatchedTemplate();
        int n2 = this.getMatchedNode();
        this.pushElemTemplateElement(elemTemplate);
        this.m_xcontext.pushCurrentNode(n2);
        this.executeChildTemplates((ElemTemplateElement)elemTemplate, true);
    }

    public void resetToStylesheet(TransformSnapshot transformSnapshot) {
        ((TransformSnapshotImpl)transformSnapshot).apply(this);
    }

    public static void setThreadControler(ThreadControler threadControler) {
        tpool = threadControler;
    }

    public short getShouldStripSpace(int n2, DTM dTM) {
        try {
            WhiteSpaceInfo whiteSpaceInfo = this.m_stylesheetRoot.getWhiteSpaceInfo(this.m_xcontext, n2, dTM);
            if (null == whiteSpaceInfo) {
                return 3;
            }
            return whiteSpaceInfo.getShouldStripSpace() ? (short)2 : 1;
        }
        catch (TransformerException transformerException) {
            return 3;
        }
    }

    public DTMIterator getContextNodeList() {
        try {
            DTMIterator dTMIterator = this.m_xcontext.getContextNodeList();
            return dTMIterator == null ? null : dTMIterator.cloneWithReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ObjectPool getStringWriterPool() {
        return this.m_stringWriterObjectPool;
    }

    public ObjectStack getCurrentTemplateElements() {
        return this.m_currentTemplateElements;
    }

    public QName getMode() {
        return this.m_modes.isEmpty() ? null : (QName)this.m_modes.peek();
    }

    public void pushMode(QName qName) {
        this.m_modes.push(qName);
    }

    public final XPathContext getXPathContext() {
        return this.m_xcontext;
    }

    public void setXPathContext(XPathContext xPathContext) {
        this.m_xcontext = xPathContext;
    }

    public ContentHandler getContentHandler() {
        return this.m_outputContentHandler;
    }

    public ContentHandler getInputContentHandler() {
        return this.getInputContentHandler(false);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException(XSLMessages.createMessage("ER_NULL_CONTENT_HANDLER", null));
        }
        this.m_outputContentHandler = contentHandler;
        if (null == this.m_resultTreeHandler) {
            this.m_resultTreeHandler = new ResultTreeHandler(this, contentHandler);
        } else {
            this.m_resultTreeHandler.setContentHandler(contentHandler);
        }
    }

    public ContentHandler getInputContentHandler(boolean bl2) {
        if (null == this.m_inputContentHandler) {
            this.m_inputContentHandler = new TransformerHandlerImpl(this, bl2, this.m_urlOfSource);
        }
        return this.m_inputContentHandler;
    }

    public DeclHandler getInputDeclHandler() {
        if (this.m_inputContentHandler instanceof DeclHandler) {
            return (DeclHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public LexicalHandler getInputLexicalHandler() {
        if (this.m_inputContentHandler instanceof LexicalHandler) {
            return (LexicalHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public Object getParameter(String string) {
        try {
            QName qName = QName.getQNameFromString(string);
            if (null == this.m_userParams) {
                return null;
            }
            int n2 = this.m_userParams.size();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                Arg arg = (Arg)this.m_userParams.elementAt(i2);
                if (!arg.getQName().equals(qName)) continue;
                return arg.getVal().object();
            }
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public void setParameter(String string, Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", false);
        try {
            String string2;
            String string3 = stringTokenizer.nextToken();
            String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            if (null == this.m_userParams) {
                this.m_userParams = new Vector();
            }
            if (null == string2) {
                this.replaceOrPushUserParam(new QName(string3), XObject.create(object, this.getXPathContext()));
                this.setParameter(string3, null, object);
            } else {
                this.replaceOrPushUserParam(new QName(string3, string2), XObject.create(object, this.getXPathContext()));
                this.setParameter(string2, string3, object);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void setProperty(String string, Object object) {
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        String string2 = null;
        OutputProperties outputProperties = this.getOutputFormat();
        string2 = outputProperties.getProperty(string);
        if (null == string2 && !outputProperties.isLegalPropertyKey(string)) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{string}));
        }
        return string2;
    }

    public String getOutputPropertyNoDefault(String string) throws IllegalArgumentException {
        String string2 = null;
        OutputProperties outputProperties = this.getOutputFormat();
        string2 = (String)outputProperties.getProperties().get(string);
        if (null == string2 && !outputProperties.isLegalPropertyKey(string)) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{string}));
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        Boolean bl2 = this.m_reentryGuard;
        synchronized (bl2) {
            if (null == this.m_outputFormat) {
                this.m_outputFormat = (OutputProperties)this.getStylesheet().getOutputComposed().clone();
            }
            if (!this.m_outputFormat.isLegalPropertyKey(string)) {
                throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{string}));
            }
            this.m_outputFormat.setProperty(string, string2);
        }
    }

    public boolean elementAvailable(String string, String string2) throws TransformerException {
        return this.getExtensionsTable().elementAvailable(string, string2);
    }

    public boolean functionAvailable(String string, String string2) throws TransformerException {
        return this.getExtensionsTable().functionAvailable(string, string2);
    }

    /*
     * Loose catch block
     */
    public String transformToString(ElemTemplateElement elemTemplateElement) throws TransformerException {
        Object object;
        StringWriter stringWriter;
        ResultTreeHandler resultTreeHandler;
        block12: {
            ElemTemplateElement elemTemplateElement2 = elemTemplateElement.getFirstChildElem();
            if (null == elemTemplateElement2) {
                return "";
            }
            if (elemTemplateElement.hasTextLitOnly() && TransformerFactoryImpl.m_optimize) {
                return ((ElemTextLiteral)elemTemplateElement2).getNodeValue();
            }
            resultTreeHandler = this.m_resultTreeHandler;
            stringWriter = (StringWriter)this.m_stringWriterObjectPool.getInstance();
            this.m_resultTreeHandler = (ResultTreeHandler)this.m_textResultHandlerObjectPool.getInstance();
            Serializer serializer = this.m_resultTreeHandler.getSerializer();
            try {
                if (null == serializer) {
                    serializer = SerializerFactory.getSerializer(this.m_textformat.getProperties());
                    this.m_resultTreeHandler.setSerializer(serializer);
                    serializer.setWriter(stringWriter);
                    object = serializer.asContentHandler();
                    this.m_resultTreeHandler.init(this, (ContentHandler)object);
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
            this.m_resultTreeHandler.startDocument();
            this.executeChildTemplates(elemTemplateElement, true);
            this.m_resultTreeHandler.endDocument();
            object = stringWriter.toString();
            Object var9_8 = null;
            stringWriter.getBuffer().setLength(0);
            try {
                stringWriter.close();
                break block12;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                break block12;
                catch (SAXException sAXException) {
                    throw new TransformerException(sAXException);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                stringWriter.getBuffer().setLength(0);
                try {
                    stringWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_stringWriterObjectPool.freeInstance(stringWriter);
                this.m_textResultHandlerObjectPool.freeInstance(this.m_resultTreeHandler);
                this.m_resultTreeHandler.reset();
                this.m_resultTreeHandler = resultTreeHandler;
                throw throwable;
            }
        }
        this.m_stringWriterObjectPool.freeInstance(stringWriter);
        this.m_textResultHandlerObjectPool.freeInstance(this.m_resultTreeHandler);
        this.m_resultTreeHandler.reset();
        this.m_resultTreeHandler = resultTreeHandler;
        return object;
    }

    public Vector processSortKeys(ElemForEach elemForEach, int n2) throws TransformerException {
        Vector vector = null;
        XPathContext xPathContext = this.m_xcontext;
        int n3 = elemForEach.getSortElemCount();
        if (n3 > 0) {
            vector = new Vector();
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            boolean bl2;
            ElemSort elemSort = elemForEach.getSortElem(i2);
            if (S_DEBUG) {
                this.getTraceManager().fireTraceEvent(elemSort);
            }
            String string = null != elemSort.getLang() ? elemSort.getLang().evaluate(xPathContext, n2, elemForEach) : null;
            String string2 = elemSort.getDataType().evaluate(xPathContext, n2, elemForEach);
            if (string2.indexOf(":") >= 0) {
                System.out.println("TODO: Need to write the hooks for QNAME sort data type");
            } else if (!string2.equalsIgnoreCase("text") && !string2.equalsIgnoreCase("number")) {
                elemForEach.error("ER_ILLEGAL_ATTRIBUTE_VALUE", new Object[]{"data-type", string2});
            }
            boolean bl3 = null != string2 && string2.equals("number");
            String string3 = elemSort.getOrder().evaluate(xPathContext, n2, elemForEach);
            if (!string3.equalsIgnoreCase("ascending") && !string3.equalsIgnoreCase("descending")) {
                elemForEach.error("ER_ILLEGAL_ATTRIBUTE_VALUE", new Object[]{"order", string3});
            }
            boolean bl4 = null != string3 && string3.equals("descending");
            AVT aVT = elemSort.getCaseOrder();
            if (null != aVT) {
                String string4 = aVT.evaluate(xPathContext, n2, elemForEach);
                if (!string4.equalsIgnoreCase("upper-first") && !string4.equalsIgnoreCase("lower-first")) {
                    elemForEach.error("ER_ILLEGAL_ATTRIBUTE_VALUE", new Object[]{"case-order", string4});
                }
                bl2 = null != string4 && string4.equals("upper-first");
            } else {
                bl2 = false;
            }
            vector.addElement(new NodeSortKey(this, elemSort.getSelect(), bl3, bl4, string, bl2, elemForEach));
            if (!S_DEBUG) continue;
            this.getTraceManager().fireTraceEndEvent(elemSort);
        }
        return vector;
    }

    public void transform(Source source, Result result) throws TransformerException {
        this.transform(source, result, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Source source, Result result, boolean bl2) throws TransformerException {
        Boolean bl3 = this.m_reentryGuard;
        synchronized (bl3) {
            ContentHandler contentHandler = this.createResultContentHandler(result);
            this.m_outputTarget = result;
            this.setContentHandler(contentHandler);
            this.transform(source, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTemplateToNode(ElemTemplateElement elemTemplateElement, ElemTemplate elemTemplate, int n2) throws TransformerException {
        DTM dTM = this.m_xcontext.getDTM(n2);
        short s2 = dTM.getNodeType(n2);
        boolean bl2 = false;
        boolean bl3 = false;
        if (null == elemTemplate) {
            int n3;
            int n4 = 0;
            boolean bl4 = elemTemplateElement == null ? false : (bl3 = elemTemplateElement.getXSLToken() == 72);
            if (bl3) {
                n3 = elemTemplateElement.getStylesheetComposed().getImportCountComposed() - 1;
                n4 = elemTemplateElement.getStylesheetComposed().getEndImportCountComposed();
            } else {
                n3 = -1;
            }
            if (bl3 && n3 == -1) {
                elemTemplate = null;
            } else {
                XPathContext xPathContext = this.m_xcontext;
                try {
                    xPathContext.pushNamespaceContext(elemTemplateElement);
                    QName qName = this.getMode();
                    elemTemplate = bl3 ? this.m_stylesheetRoot.getTemplateComposed(xPathContext, n2, qName, n3, n4, this.m_quietConflictWarnings, dTM) : this.m_stylesheetRoot.getTemplateComposed(xPathContext, n2, qName, this.m_quietConflictWarnings, dTM);
                }
                finally {
                    xPathContext.popNamespaceContext();
                }
            }
            if (null == elemTemplate) {
                switch (s2) {
                    case 1: 
                    case 11: {
                        elemTemplate = this.m_stylesheetRoot.getDefaultRule();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        elemTemplate = this.m_stylesheetRoot.getDefaultTextRule();
                        bl2 = true;
                        break;
                    }
                    case 9: {
                        elemTemplate = this.m_stylesheetRoot.getDefaultRootRule();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        try {
            block28: {
                try {
                    this.pushElemTemplateElement(elemTemplate);
                    this.m_xcontext.pushCurrentNode(n2);
                    this.pushPairCurrentMatched(elemTemplate, n2);
                    if (!bl3) {
                        NodeSetDTM nodeSetDTM = new NodeSetDTM(n2, this.m_xcontext.getDTMManager());
                        this.m_xcontext.pushContextNodeList(nodeSetDTM);
                    }
                    if (bl2) {
                        switch (s2) {
                            case 3: 
                            case 4: {
                                ClonerToResultTree.cloneToResultTree(n2, s2, dTM, this.getResultTreeHandler(), false);
                                break;
                            }
                            case 2: {
                                dTM.dispatchCharactersEvents(n2, this.getResultTreeHandler(), false);
                            }
                        }
                        break block28;
                    }
                    if (S_DEBUG) {
                        this.getTraceManager().fireTraceEvent(elemTemplate);
                    }
                    this.m_xcontext.setSAXLocator(elemTemplate);
                    this.m_xcontext.getVarStack().link(elemTemplate.m_frameSize);
                    this.executeChildTemplates((ElemTemplateElement)elemTemplate, true);
                    if (!S_DEBUG) break block28;
                    this.getTraceManager().fireTraceEndEvent(elemTemplate);
                }
                catch (SAXException sAXException) {
                    throw new TransformerException(sAXException);
                }
            }
            Object var14_15 = null;
            this.m_xcontext.getVarStack().unlink();
            this.m_xcontext.popCurrentNode();
            if (!bl3) {
                this.m_xcontext.popContextNodeList();
                this.popCurrentMatched();
            }
            this.popElemTemplateElement();
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.m_xcontext.getVarStack().unlink();
            this.m_xcontext.popCurrentNode();
            if (!bl3) {
                this.m_xcontext.popContextNodeList();
                this.popCurrentMatched();
            }
            this.popElemTemplateElement();
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transformToRTF(ElemTemplateElement elemTemplateElement, DTM dTM) throws TransformerException {
        int n2;
        XPathContext xPathContext = this.m_xcontext;
        ContentHandler contentHandler = dTM.getContentHandler();
        ResultTreeHandler resultTreeHandler = this.m_resultTreeHandler;
        ResultTreeHandler resultTreeHandler2 = this.m_resultTreeHandler = new ResultTreeHandler(this, contentHandler);
        try {
            resultTreeHandler2.startDocument();
            resultTreeHandler2.flushPending();
            try {
                this.executeChildTemplates(elemTemplateElement, true);
                resultTreeHandler2.flushPending();
                n2 = dTM.getDocument();
            }
            finally {
                resultTreeHandler2.endDocument();
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        finally {
            this.m_resultTreeHandler = resultTreeHandler;
        }
        return n2;
    }

    private void replaceOrPushUserParam(QName qName, XObject xObject) {
        int n2 = this.m_userParams.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            Arg arg = (Arg)this.m_userParams.elementAt(i2);
            if (!arg.getQName().equals(qName)) continue;
            this.m_userParams.setElementAt(new Arg(qName, xObject, true), i2);
            return;
        }
        this.m_userParams.addElement(new Arg(qName, xObject, true));
    }

    public ContentHandler createResultContentHandler(Result result) throws TransformerException {
        return this.createResultContentHandler(result, this.getOutputFormat());
    }

    public void executeChildTemplates(ElemTemplateElement elemTemplateElement, ContentHandler contentHandler) throws TransformerException {
        ResultTreeHandler resultTreeHandler = this.getResultTreeHandler();
        ContentHandler contentHandler2 = resultTreeHandler.getContentHandler();
        ContentHandler contentHandler3 = this.getContentHandler();
        try {
            this.getResultTreeHandler().flushPending();
            this.setContentHandler(contentHandler);
            this.executeChildTemplates(elemTemplateElement, true);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        finally {
            this.setContentHandler(contentHandler3);
            resultTreeHandler.setContentHandler(contentHandler2);
        }
    }

    public void setParameter(String string, String string2, Object object) {
        VariableStack variableStack = this.getXPathContext().getVarStack();
        QName qName = new QName(string2, string);
        XObject xObject = XObject.create(object, this.getXPathContext());
        StylesheetRoot stylesheetRoot = this.m_stylesheetRoot;
        Vector vector = stylesheetRoot.getVariablesAndParamsComposed();
        int n2 = vector.size();
        while (--n2 >= 0) {
            ElemVariable elemVariable = (ElemVariable)vector.elementAt(n2);
            if (elemVariable.getXSLToken() != 41 || !elemVariable.getName().equals(qName)) continue;
            variableStack.setGlobalVariable(n2, xObject);
        }
    }

    public ContentHandler createResultContentHandler(Result result, OutputProperties outputProperties) throws TransformerException {
        ContentHandler contentHandler = null;
        Node node = null;
        if (result instanceof DOMResult) {
            Document document;
            short s2;
            node = ((DOMResult)result).getNode();
            if (null != node) {
                s2 = node.getNodeType();
                document = 9 == s2 ? (Document)node : node.getOwnerDocument();
            } else {
                document = DOMHelper.createDocument();
                node = document;
                s2 = node.getNodeType();
                ((DOMResult)result).setNode(node);
            }
            contentHandler = 11 == s2 ? new DOMBuilder(document, (DocumentFragment)node) : new DOMBuilder(document, node);
        } else if (result instanceof SAXResult) {
            contentHandler = ((SAXResult)result).getHandler();
            if (null == contentHandler) {
                throw new IllegalArgumentException("handler can not be null for a SAXResult");
            }
        } else if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            String string = outputProperties.getProperty("method");
            try {
                Serializer serializer = SerializerFactory.getSerializer(outputProperties.getProperties());
                if (null != streamResult.getWriter()) {
                    serializer.setWriter(streamResult.getWriter());
                } else if (null != streamResult.getOutputStream()) {
                    serializer.setOutputStream(streamResult.getOutputStream());
                } else if (null != streamResult.getSystemId()) {
                    String string2 = streamResult.getSystemId();
                    if (string2.startsWith("file:///")) {
                        string2 = string2.substring(8).indexOf(":") > 0 ? string2.substring(8) : string2.substring(7);
                    }
                    this.m_outputStream = new FileOutputStream(string2);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException(XSLMessages.createMessage("ER_NO_OUTPUT_SPECIFIED", null));
                }
                contentHandler = serializer.asContentHandler();
                this.setSerializer(serializer);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new TransformerException(unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        } else {
            throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_TRANSFORM_TO_RESULT_TYPE", new Object[]{result.getClass().getName()}));
        }
        return contentHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeChildTemplates(ElemTemplateElement elemTemplateElement, Node node, QName qName, ContentHandler contentHandler) throws TransformerException {
        XPathContext xPathContext = this.m_xcontext;
        try {
            if (null != qName) {
                this.pushMode(qName);
            }
            xPathContext.pushCurrentNode(xPathContext.getDTMHandleFromNode(node));
            this.executeChildTemplates(elemTemplateElement, contentHandler);
            Object var7_6 = null;
            xPathContext.popCurrentNode();
            if (null != qName) {
                this.popMode();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            xPathContext.popCurrentNode();
            if (null != qName) {
                this.popMode();
            }
            throw throwable;
        }
    }

    public Object extFunction(String string, String string2, Vector vector, Object object) throws TransformerException {
        return this.getExtensionsTable().extFunction(string, string2, vector, object, this.getXPathContext().getExpressionContext());
    }

    public static class ThreadControler {
        public void waitThread(Thread thread, Runnable runnable) throws InterruptedException {
            thread.join();
        }

        public Thread run(Runnable runnable, int n2) {
            Thread thread = new Thread(runnable);
            thread.start();
            return thread;
        }
    }
}

