/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.SerializationTester;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.TooManyListenersException;
import javax.swing.Timer;

public class DropTarget
implements DropTargetListener,
Serializable {
    private static final long serialVersionUID = -6283860791671019047L;
    private DropTargetContext dropTargetContext = this.createDropTargetContext();
    private Component component;
    private transient ComponentPeer componentPeer;
    private transient ComponentPeer nativePeer;
    int actions = 3;
    boolean active = true;
    private transient DropTargetAutoScroller autoScroller;
    private transient DropTargetListener dtListener;
    private transient FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();

    public int getDefaultActions() {
        return this.actions;
    }

    public DropTarget() throws HeadlessException {
        this(null, 3, null, true, null);
    }

    protected void clearAutoscroll() {
        if (this.autoScroller != null) {
            this.autoScroller.stop();
            this.autoScroller = null;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    void doSetDefaultActions(int n2) {
        this.actions = n2;
    }

    public void setDefaultActions(int n2) {
        this.getDropTargetContext().setTargetActions(n2 & 0x40000003);
    }

    public synchronized void setActive(boolean bl2) {
        if (bl2 != this.active) {
            this.active = bl2;
        }
        if (!this.active) {
            this.clearAutoscroll();
        }
    }

    public synchronized Component getComponent() {
        return this.component;
    }

    public synchronized void setComponent(Component component) {
        block6: {
            if (this.component == component || this.component != null && this.component.equals(component)) {
                return;
            }
            ComponentPeer componentPeer = null;
            Component component2 = this.component;
            if (component2 != null) {
                this.clearAutoscroll();
                this.component = null;
                if (this.componentPeer != null) {
                    componentPeer = this.componentPeer;
                    this.removeNotify(this.componentPeer);
                }
                component2.setDropTarget(null);
            }
            if ((this.component = component) != null) {
                try {
                    component.setDropTarget(this);
                }
                catch (Exception exception) {
                    if (component2 == null) break block6;
                    component2.setDropTarget(this);
                    this.addNotify(componentPeer);
                }
            }
        }
    }

    protected void initializeAutoscrolling(Point point) {
        if (this.component == null || !(this.component instanceof Autoscroll)) {
            return;
        }
        this.autoScroller = this.createDropTargetAutoScroller(this.component, point);
    }

    protected void updateAutoscroll(Point point) {
        if (this.autoScroller != null) {
            this.autoScroller.updateLocation(point);
        }
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public void setFlavorMap(FlavorMap flavorMap) {
        this.flavorMap = flavorMap == null ? SystemFlavorMap.getDefaultFlavorMap() : flavorMap;
    }

    protected DropTargetContext createDropTargetContext() {
        return new DropTargetContext(this);
    }

    public DropTargetContext getDropTargetContext() {
        return this.dropTargetContext;
    }

    public synchronized void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null) {
            this.dtListener.dragEnter(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.getDropTargetContext().setTargetActions(0);
        }
        this.initializeAutoscrolling(dropTargetDragEvent.getLocation());
    }

    public synchronized void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null && this.active) {
            this.dtListener.dragOver(dropTargetDragEvent);
        }
        this.updateAutoscroll(dropTargetDragEvent.getLocation());
    }

    public synchronized void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null) {
            this.dtListener.dropActionChanged(dropTargetDragEvent);
        }
        this.updateAutoscroll(dropTargetDragEvent.getLocation());
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.clearAutoscroll();
        if (this.dtListener != null && this.active) {
            this.dtListener.drop(dropTargetDropEvent);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public synchronized void dragExit(DropTargetEvent dropTargetEvent) {
        if (!this.active) {
            return;
        }
        if (this.dtListener != null && this.active) {
            this.dtListener.dragExit(dropTargetEvent);
        }
        this.clearAutoscroll();
    }

    public synchronized void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (dropTargetListener == null) {
            return;
        }
        if (this.equals(dropTargetListener)) {
            throw new IllegalArgumentException("DropTarget may not be its own Listener");
        }
        if (this.dtListener != null) {
            throw new TooManyListenersException();
        }
        this.dtListener = dropTargetListener;
    }

    public synchronized void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener != null && this.dtListener != null) {
            if (this.dtListener.equals(dropTargetListener)) {
                this.dtListener = null;
            } else {
                throw new IllegalArgumentException("listener mismatch");
            }
        }
    }

    public void addNotify(ComponentPeer componentPeer) {
        if (componentPeer == this.componentPeer) {
            return;
        }
        this.componentPeer = componentPeer;
        for (Component component = this.component; component != null && componentPeer instanceof LightweightPeer; component = component.getParent()) {
            componentPeer = component.getPeer();
        }
        if (componentPeer instanceof DropTargetPeer) {
            this.nativePeer = componentPeer;
            ((DropTargetPeer)((Object)componentPeer)).addDropTarget(this);
        } else {
            this.nativePeer = null;
        }
    }

    public void removeNotify(ComponentPeer componentPeer) {
        if (this.nativePeer != null) {
            ((DropTargetPeer)((Object)this.nativePeer)).removeDropTarget(this);
        }
        this.nativePeer = null;
        this.componentPeer = null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        try {
            this.dropTargetContext = (DropTargetContext)getField.get("dropTargetContext", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.dropTargetContext == null) {
            this.dropTargetContext = this.createDropTargetContext();
        }
        this.component = (Component)getField.get("component", null);
        this.actions = getField.get("actions", 3);
        this.active = getField.get("active", true);
        try {
            this.dtListener = (DropTargetListener)getField.get("dtListener", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.dtListener = (DropTargetListener)objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializationTester.test(this.dtListener) ? this.dtListener : null);
    }

    public DropTarget(Component component, int n2, DropTargetListener dropTargetListener) throws HeadlessException {
        this(component, n2, dropTargetListener, true);
    }

    public DropTarget(Component component, int n2, DropTargetListener dropTargetListener, boolean bl2) throws HeadlessException {
        this(component, n2, dropTargetListener, bl2, null);
    }

    public DropTarget(Component component, DropTargetListener dropTargetListener) throws HeadlessException {
        this(component, 3, dropTargetListener, true, null);
    }

    public DropTarget(Component component, int n2, DropTargetListener dropTargetListener, boolean bl2, FlavorMap flavorMap) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.component = component;
        this.setDefaultActions(n2);
        if (dropTargetListener != null) {
            try {
                this.addDropTargetListener(dropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
        if (component != null) {
            component.setDropTarget(this);
            this.setActive(bl2);
        }
        if (flavorMap != null) {
            this.flavorMap = flavorMap;
        }
    }

    protected DropTargetAutoScroller createDropTargetAutoScroller(Component component, Point point) {
        return new DropTargetAutoScroller(component, point);
    }

    protected static class DropTargetAutoScroller
    implements ActionListener {
        private Component component;
        private Autoscroll autoScroll;
        private Timer timer;
        private Point locn;
        private Point prev;
        private Rectangle outer = new Rectangle();
        private Rectangle inner = new Rectangle();
        private int hysteresis = 10;

        protected void stop() {
            this.timer.stop();
        }

        private void updateRegion() {
            Insets insets = this.autoScroll.getAutoscrollInsets();
            Dimension dimension = this.component.getSize();
            if (dimension.width != this.outer.width || dimension.height != this.outer.height) {
                this.outer.reshape(0, 0, dimension.width, dimension.height);
            }
            if (this.inner.x != insets.left || this.inner.y != insets.top) {
                this.inner.setLocation(insets.left, insets.top);
            }
            int n2 = dimension.width - (insets.left + insets.right);
            int n3 = dimension.height - (insets.top + insets.bottom);
            if (n2 != this.inner.width || n3 != this.inner.height) {
                this.inner.setSize(n2, n3);
            }
        }

        protected synchronized void updateLocation(Point point) {
            this.prev = this.locn;
            this.locn = point;
            if (Math.abs(this.locn.x - this.prev.x) > this.hysteresis || Math.abs(this.locn.y - this.prev.y) > this.hysteresis) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            this.updateRegion();
            if (this.outer.contains(this.locn) && !this.inner.contains(this.locn)) {
                this.autoScroll.autoscroll(this.locn);
            }
        }

        protected DropTargetAutoScroller(Component component, Point point) {
            this.component = component;
            this.autoScroll = (Autoscroll)((Object)this.component);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Integer n2 = new Integer(100);
            Integer n3 = new Integer(100);
            try {
                n2 = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n3 = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer = new Timer(n3, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(n2);
            this.locn = point;
            this.prev = point;
            try {
                this.hysteresis = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer.start();
        }
    }
}

