/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2001 Spencer Kimball, Peter Mattis, and others
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIMP_DRAWABLE_TRANSFORM_UTILS_H__
#define __GIMP_DRAWABLE_TRANSFORM_UTILS_H__


void   gimp_drawable_transform_matrix_rotate        (gint         x1,
                                                     gint         y1,
                                                     gint         x2,
                                                     gint         y2,
                                                     gdouble      angle,
                                                     GimpMatrix3 *result);
void   gimp_drawable_transform_matrix_rotate_center (gdouble      cx,
                                                     gdouble      cy,
                                                     gdouble      angle,
                                                     GimpMatrix3 *result);
void   gimp_drawable_transform_matrix_scale         (gint         x1,
                                                     gint         y1,
                                                     gint         x2,
                                                     gint         y2,
                                                     gdouble      tx1,
                                                     gdouble      ty1,
                                                     gdouble      tx2,
                                                     gdouble      ty2,
                                                     GimpMatrix3 *result);
void   gimp_drawable_transform_matrix_shear         (gint         x1,
                                                     gint         y1,
                                                     gint         x2,
                                                     gint         y2,
                                                     GimpOrientationType  orientation,
                                                     gdouble      amount,
                                                     GimpMatrix3 *result);
void   gimp_drawable_transform_matrix_perspective   (gint         x1,
                                                     gint         y1,
                                                     gint         x2,
                                                     gint         y2,
                                                     gdouble      tx1,
                                                     gdouble      ty1,
                                                     gdouble      tx2,
                                                     gdouble      ty2,
                                                     gdouble      tx3,
                                                     gdouble      ty3,
                                                     gdouble      tx4,
                                                     gdouble      ty5,
                                                     GimpMatrix3 *result);


#endif  /*  __GIMP_DRAWABLE_TRANSFORM_SHEAR_H__  */
