/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __PAN_SOCKET_H__
#define __PAN_SOCKET_H__

#include <time.h>
#include <glib/gtypes.h>
#include <pan/base/pan-object.h>

#define PAN_SOCKET(a) ((PanSocket *)a)

typedef struct _PanSocket           PanSocket;

/**
***  PROTECTED
**/

void         pan_socket_constructor          (PanSocket            * sock,
                                              PanObjectDestructor    dtor,
                                              const char           * server_name,
                                              const char           * server_address,
                                              int                    port);

void         pan_socket_destructor           (PanObject            * sock);

/**
***  PUBLIC - Life Cycle
**/

PanSocket*   pan_socket_new                  (const char           * server_name,
                                              const char           * server_address,
                                              int                    port);

void         pan_socket_set_nntp_auth        (PanSocket            * socket,
                                              gboolean               need_auth,
                                              const char           * username,
                                              const char           * password);
/**
***  PUBLIC - I/O
**/

int          pan_socket_putline              (PanSocket            * sock,
                                              const char           * line);

int          pan_socket_putline_va           (PanSocket            * sock,
                                              const char           * fmt,
                                              ...);

int          pan_socket_getline              (PanSocket            * sock,
                                              const char          ** setme);

void         pan_socket_flush                (PanSocket            * sock);

/**
***  STATISTICS
**/

time_t       pan_socket_get_statistics_start_time (const PanSocket  * sock);

double       pan_socket_get_xfer_rate_KBps  (const PanSocket      * sock);

void         pan_socket_reset_statistics    (PanSocket            * sock);

gulong       pan_socket_get_total_xfer_K    (void);

/**
***
**/

gboolean     pan_socket_needs_auth          (const PanSocket      * sock);

const char*  pan_socket_get_username        (const PanSocket      * sock);

const char*  pan_socket_get_password        (const PanSocket      * sock);

const char*  pan_socket_get_server_name     (const PanSocket      * sock);

const char*  pan_socket_get_current_group   (const PanSocket      * sock);

void         pan_socket_set_current_group   (PanSocket            * sock,
                                             const char           * groupname);

void         pan_socket_set_error_flag      (PanSocket            * sock,
                                             gboolean               err_state);

gboolean     pan_socket_get_error_flag      (const PanSocket      * sock);

time_t       pan_socket_get_last_action_time  (const PanSocket    * sock);

void         pan_socket_set_last_action_time  (PanSocket          * sock,
                                               time_t               action_time);


#endif /* __PAN_SOCKET_H__ */
